<?xml version="1.0" encoding="UTF-8"?>
<!--

 Copyright © 2009 Intel Corporation. All rights reserved.

 The information contained herein is the exclusive property of
 Intel Corporation and may not be disclosed, examined, or reproduced in
 whole or in part without explicit written authorization from the Company.

-->
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:boolean="http://www.w3.org/2001/XMLSchema#boolean"
  xmlns:int="http://www.w3.org/2001/XMLSchema#int"
  xmlns:str="http://exslt.org/strings" str:keep_str_namespace=""
  xmlns:exsl="http://exslt.org/common" exsl:keep_exsl_namespace=""
  xmlns:func="http://exslt.org/functions"
  extension-element-prefixes="func"
  xmlns:fnc="urn:functions">
  <xsl:import href="config://include/gpu_common_functions.inc"/>
  <xsl:output indent="yes" method="xml"/>
  <xsl:template match="/">
  <queryLibrary>
    <xsl:variable name="universalCollectorUsed">
      <xsl:choose>
        <xsl:when test="exsl:ctx('gpuFormatVersion', 0) = 1 and exsl:ctx('gsimClockDuration', 0) = 0">true</xsl:when>
        <xsl:otherwise>false</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="gpuPerformanceMode" select="exsl:ctx('gpuPerformanceMode', '')"/>
    <xsl:variable name="gpuPlatform" select="exsl:ctx('gpuPlatform', '')"/>
    <xsl:variable name="samplerMultiplier">
      <xsl:choose>
        <xsl:when test="$gpuPerformanceMode='IVB_GT2'">2</xsl:when>
        <xsl:when test="$gpuPerformanceMode='IVB_GT1'">1</xsl:when>
        <xsl:when test="$gpuPerformanceMode='IVB_GT2_TO_GT1_L'">1</xsl:when>
        <xsl:when test="$gpuPerformanceMode='IVB_GT2_TO_GT1_U'">1</xsl:when>
        <xsl:when test="$gpuPerformanceMode='HSW_GTH'">2</xsl:when>
        <xsl:when test="$gpuPerformanceMode='HSW_GTH_PERF'">2</xsl:when>
        <xsl:when test="$gpuPerformanceMode='HSW_GTH_TO_GT2'">2</xsl:when>
        <xsl:when test="$gpuPerformanceMode='HSW_GTH_TO_GT1_U'">1</xsl:when>
        <xsl:when test="$gpuPerformanceMode='HSW_GTH_TO_GT1_L'">1</xsl:when>
        <xsl:when test="$gpuPerformanceMode='HSW_GTM'">2</xsl:when>
        <xsl:when test="$gpuPerformanceMode='HSW_GTM_TO_GT1_U'">1</xsl:when>
        <xsl:when test="$gpuPerformanceMode='HSW_GTM_TO_GT1_L'">1</xsl:when>
        <xsl:when test="$gpuPerformanceMode='VLV_2'">1</xsl:when>
        <xsl:otherwise>1</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="memoryMultiplier">
      <xsl:choose>
        <xsl:when test="$gpuPerformanceMode='HSW_GTH'">2</xsl:when>
        <xsl:when test="$gpuPerformanceMode='HSW_GTH_PERF'">2</xsl:when>
        <xsl:otherwise>1</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="gpuPrefix" select="exsl:ctx('gpuDisplayMetricPrefix', 'GPU')"/>
    <xsl:variable name="gpuTilePrefix" select="exsl:ctx('gpuDisplayPrefix', 'GPU')"/>
    <xsl:variable name="gpuPrefixMessage" select="concat('%', $gpuPrefix)"/>
    <xsl:variable name="alu2Name" select="fnc:get_alu2_name()"/>
    <infoQuery id="GPUGTPinInstructionType" displayName="%GPUGTPinInstructionType">
      <dbPath>gpu_gtpin_data::dd_sample.callsite.code_loc.asm.instr.type</dbPath>
      <displayDbPathSuffix>name</displayDbPathSuffix>
      <displayAttributes>
        <boolean:hideZeroDataOnExpansion>true</boolean:hideZeroDataOnExpansion>
      </displayAttributes>
    </infoQuery>
    <infoQuery id="GPUGTPinEventType" displayName="%UncoreEventType">
      <dbPath>gpu_gtpin_data::dd_sample.event_type.name</dbPath>
      <displayDbPathSuffix>value</displayDbPathSuffix>
      <displayAttributes>
        <boolean:unitDistinctQuery>true</boolean:unitDistinctQuery>
      </displayAttributes>
    </infoQuery>
    <countQuery id="GPUGTPinEventCount" displayName="%UncoreEventCount">
      <instanceDbTable>gpu_gtpin_data::dd_sample</instanceDbTable>
      <instanceBandTable>dd_gpu_node_gtpin</instanceBandTable>
      <displayAttributes>
        <selfFormat>count</selfFormat>
        <totalFormat>countAndBar</totalFormat>
        <boolean:allowCollapse>false</boolean:allowCollapse>
        <boolean:detailedFormulaDisplayRepresentation>false</boolean:detailedFormulaDisplayRepresentation>
      </displayAttributes>
    </countQuery>
    <instanceCountQuery id="GPUGTPinInstanceCount" displayName="%GpuComputeTaskCount">
      <instanceDbTable>gpu_gtpin_data</instanceDbTable>
      <instanceBandTable>dd_gpu_node_gtpin</instanceBandTable>
    </instanceCountQuery>
    <derivedQuery id="GPUGpuCoreClocksMetricDerived" displayName="GPU Core Clocks" description="The total number of GPU core clocks elapsed during the measurement.">
      <valueEval><![CDATA[ query("/GPUGpuCoreClocksMetric") * $EuCoresTotalCount ]]></valueEval>
      <valueType>int</valueType>
    </derivedQuery>
    <derivedQuery id="GPUGTPinCycles" displayName="%GPUGTPinCycles">
      <description>%GPUGTPinCyclesDesc</description>
      <valueEval><![CDATA[ query("/GPUGTPinEventCount/GPUGTPinEventType[GPU_CYCLES]") ]]></valueEval>
      <valueType>int</valueType>
    </derivedQuery>
    <derivedQuery id="GPUGTPinMemReadLatency" displayName="%GPUGTPinMemReadLatency">
      <description>%GPUGTPinMemReadLatencyDesc</description>
      <valueEval><![CDATA[ query("/GPUGTPinEventCount/GPUGTPinEventType[GPU_CYCLES.MEM_READ]") / query("/GPUGTPinEventCount/GPUGTPinEventType[GPU_INSTRUCTION_EXECUTED.MEM_READ]") ]]></valueEval>
      <valueType>int</valueType>
    </derivedQuery>
    <derivedQuery id="GPUGTPinSyncLatency" displayName="%GPUGTPinSyncLatency">
      <description>%GPUGTPinSyncLatencyDesc</description>
      <valueEval><![CDATA[ query("/GPUGTPinEventCount/GPUGTPinEventType[GPU_CYCLES.SYNC]") / query("/GPUGTPinEventCount/GPUGTPinEventType[GPU_INSTRUCTION_EXECUTED.SYNC]") ]]></valueEval>
      <valueType>int</valueType>
    </derivedQuery>
    <derivedQuery id="GPUGTPinInstLatencyExpanded" displayName="%GPUGTPinInstLatency">
      <description>%GPUGTPinInstLatencyDesc</description>
      <valueEval><![CDATA[ (query("/GPUGTPinEventCount/GPUGTPinEventType[GPU_CYCLES.MEM_READ]") + query("/GPUGTPinEventCount/GPUGTPinEventType[GPU_CYCLES.SYNC]")) / (query("/GPUGTPinEventCount/GPUGTPinEventType[GPU_INSTRUCTION_EXECUTED.MEM_READ]") + query("/GPUGTPinEventCount/GPUGTPinEventType[GPU_INSTRUCTION_EXECUTED.SYNC]")) ]]></valueEval>
      <valueType>int</valueType>
      <displayAttributes>
        <boolean:expand>true</boolean:expand>
        <boolean:allowCollapse>true</boolean:allowCollapse>
      </displayAttributes>
      <expand>
        <vectorQuery id="GPUGTPinInstLatencyVector">
          <queryRef>/GPUGTPinMemReadLatency</queryRef>
          <queryRef>/GPUGTPinSyncLatency</queryRef>
        </vectorQuery>
      </expand>
    </derivedQuery>
    <derivedQuery id="GPUGTPinInstLatency" displayName="%GPUGTPinInstLatency">
      <queryInherit>/GPUGTPinInstLatencyExpanded</queryInherit>
      <displayAttributes>
        <boolean:expand>false</boolean:expand>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUGTPinInstructionCount" displayName="%GPUGTPinInstructionCount">
      <valueEval><![CDATA[ query("/GPUGTPinEventCount/GPUGTPinEventType[GPU_INSTRUCTION_EXECUTED]") ]]></valueEval>
      <valueType>count</valueType>
    </derivedQuery>
    <derivedQuery id="GPUGTPinMaaInstructionCount" displayName="%GPUGTPinMaaInstructionCount">
      <valueEval><![CDATA[ query("/GPUGTPinEventCount/GPUGTPinEventType[GPU_MEMORY_ANALYSIS.INSTRUCTION_EXECUTED]") ]]></valueEval>
      <valueType>count</valueType>
      <displayAttributes>
        <selfFormat>count</selfFormat>
        <totalFormat>count</totalFormat>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUGTPinMaaSimdUtil" displayName="%GPUGTPinMaaSimdUtil">
      <valueEval><![CDATA[ query("/GPUGTPinMaaInstructionCount") ? query("/GPUGTPinEventCount/GPUGTPinEventType[GPU_MEMORY_ANALYSIS.SIMD_LANES_COUNT]") / query("/GPUGTPinMaaInstructionCount") : $NULL ]]></valueEval>
      <valueType>double</valueType>
      <displayAttributes>
        <selfFormat>count</selfFormat>
        <totalFormat>count</totalFormat>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUGTPinMaaCacheLinesCount" displayName="%GPUGTPinMaaCacheLinesCount">
      <valueEval><![CDATA[ query("/GPUGTPinEventCount/GPUGTPinEventType[GPU_MEMORY_ANALYSIS.CACHE_LINES_COUNT]") ]]></valueEval>
      <valueType>count</valueType>
      <displayAttributes>
        <selfFormat>count</selfFormat>
        <totalFormat>count</totalFormat>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUGTPinMaaNotAlignCount" displayName="%GPUGTPinMaaNotAlignCount">
      <valueEval><![CDATA[ query("/GPUGTPinMaaInstructionCount") ? query("/GPUGTPinEventCount/GPUGTPinEventType[GPU_MEMORY_ANALYSIS.NOT_ALIGNED_COUNT]") / query("/GPUGTPinMaaInstructionCount") : $NULL ]]></valueEval>
      <valueType>ratio</valueType>
      <displayAttributes>
        <selfFormat>count</selfFormat>
        <totalFormat>count</totalFormat>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUGTPinMaaStrideSumm">
      <valueEval><![CDATA[ query("/GPUGTPinEventCount/GPUGTPinEventType[GPU_MEMORY_ANALYSIS.STRIDE_SUMM]") ]]></valueEval>
      <valueType>ratio</valueType>
      <displayAttributes>
        <selfFormat>count</selfFormat>
        <totalFormat>count</totalFormat>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUGTPinMaaStrideRandom" displayName="%GPUGTPinMaaStrideRandom">
      <valueEval><![CDATA[ query("/GPUGTPinMaaStrideSumm") ? query("/GPUGTPinEventCount/GPUGTPinEventType[GPU_MEMORY_ANALYSIS.STRIDE_RANDOM_COUNT]") / query("/GPUGTPinMaaStrideSumm") : $NULL ]]></valueEval>
      <valueType>ratio</valueType>
      <displayAttributes>
        <selfFormat>count</selfFormat>
        <totalFormat>count</totalFormat>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUGTPinMaaStride0" displayName="%GPUGTPinMaaStride0">
      <valueEval><![CDATA[ query("/GPUGTPinMaaStrideSumm") ? query("/GPUGTPinEventCount/GPUGTPinEventType[GPU_MEMORY_ANALYSIS.STRIDE_0_COUNT]") / query("/GPUGTPinMaaStrideSumm") : $NULL ]]></valueEval>
      <valueType>ratio</valueType>
      <displayAttributes>
        <selfFormat>count</selfFormat>
        <totalFormat>count</totalFormat>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUGTPinMaaStride1" displayName="%GPUGTPinMaaStride1">
      <valueEval><![CDATA[ query("/GPUGTPinMaaStrideSumm") ? query("/GPUGTPinEventCount/GPUGTPinEventType[GPU_MEMORY_ANALYSIS.STRIDE_1_COUNT]") / query("/GPUGTPinMaaStrideSumm") : $NULL ]]></valueEval>
      <valueType>ratio</valueType>
      <displayAttributes>
        <selfFormat>count</selfFormat>
        <totalFormat>count</totalFormat>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUGTPinMaaStride2" displayName="%GPUGTPinMaaStride2">
      <valueEval><![CDATA[ query("/GPUGTPinMaaStrideSumm") ? query("/GPUGTPinEventCount/GPUGTPinEventType[GPU_MEMORY_ANALYSIS.STRIDE_2_COUNT]") / query("/GPUGTPinMaaStrideSumm") : $NULL ]]></valueEval>
      <valueType>ratio</valueType>
      <displayAttributes>
        <selfFormat>count</selfFormat>
        <totalFormat>count</totalFormat>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUGTPinMaaStrided" displayName="%GPUGTPinMaaStrided">
      <valueEval><![CDATA[ query("/GPUGTPinMaaStrideSumm") ? ( 1 - query("/GPUGTPinMaaStrideRandom") - query("/GPUGTPinMaaStride0") - query("/GPUGTPinMaaStride1") - query("/GPUGTPinMaaStride2") ) : $NULL ]]></valueEval>
      <valueType>ratio</valueType>
      <displayAttributes>
        <selfFormat>count</selfFormat>
        <totalFormat>count</totalFormat>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUGTPinInstructionStaticMask" displayName="%GPUGTPinInstructionStaticMask">
      <valueEval><![CDATA[ query("/GPUGTPinEventCount/GPUGTPinEventType[GPU_INSTRUCTION.EXEC_MASK]") ]]></valueEval>
      <valueType>count</valueType>
      <displayAttributes>
        <selfFormat>count</selfFormat>
        <totalFormat>count</totalFormat>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUGTPinInstructionExecMask" displayName="%GPUGTPinInstructionExecMask">
      <valueEval><![CDATA[ query("/GPUGTPinEventCount/GPUGTPinEventType[GPU_INSTRUCTION_EXECUTED.EXEC_MASK]") ]]></valueEval>
      <valueType>count</valueType>
      <displayAttributes>
        <selfFormat>count</selfFormat>
        <totalFormat>count</totalFormat>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUGTPinInstructionSimdUtilization" displayName="%GPUGTPinInstructionSimdUtilization">
      <description>%GPUGTPinInstructionSimdUtilizationDesc</description>
      <valueEval><![CDATA[ ( query("/GPUGTPinInstructionStaticMask") ? query("/GPUGTPinInstructionExecMask") / query("/GPUGTPinInstructionStaticMask") : $NULL ) ]]></valueEval>
      <valueType>ratio</valueType>
      <displayAttributes>
        <boolean:vtNullAsZero>false</boolean:vtNullAsZero>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUGTPinInstructionCountInCountAndBarFormat">
      <queryInherit>/GPUGTPinInstructionCount</queryInherit>
      <displayAttributes>
        <selfFormat>countAndBar</selfFormat>
        <totalFormat>countAndBar</totalFormat>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUGTPinOperationInt16Executed">
      <valueEval><![CDATA[ query("/GPUGTPinEventCount/GPUGTPinEventType[GPU_OPERATIONS_EXECUTED.INT16]") ]]></valueEval>
      <valueType>count</valueType>
    </derivedQuery>
    <derivedQuery id="GPUGTPinOperationInt32Executed">
      <valueEval><![CDATA[ query("/GPUGTPinEventCount/GPUGTPinEventType[GPU_OPERATIONS_EXECUTED.INT32]") ]]></valueEval>
      <valueType>count</valueType>
    </derivedQuery>
    <derivedQuery id="GPUGTPinOperationInt64Executed">
      <valueEval><![CDATA[ query("/GPUGTPinEventCount/GPUGTPinEventType[GPU_OPERATIONS_EXECUTED.INT64]") ]]></valueEval>
      <valueType>count</valueType>
    </derivedQuery>
    <derivedQuery id="GPUGTPinOperationHpExecuted">
      <valueEval><![CDATA[ query("/GPUGTPinEventCount/GPUGTPinEventType[GPU_OPERATIONS_EXECUTED.FLOAT_HP]") ]]></valueEval>
      <valueType>count</valueType>
    </derivedQuery>
    <derivedQuery id="GPUGTPinOperationSpExecuted">
      <valueEval><![CDATA[ query("/GPUGTPinEventCount/GPUGTPinEventType[GPU_OPERATIONS_EXECUTED.FLOAT_SP]") ]]></valueEval>
      <valueType>count</valueType>
      <displayAttributes>
        <boolean:unitDistinctQuery>true</boolean:unitDistinctQuery>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUGTPinOperationDpExecuted">
      <valueEval><![CDATA[ query("/GPUGTPinEventCount/GPUGTPinEventType[GPU_OPERATIONS_EXECUTED.FLOAT_DP]") ]]></valueEval>
      <valueType>count</valueType>
    </derivedQuery>
    <derivedQuery id="GPUGTPinOperations16bitExecuted">
      <valueEval><![CDATA[ ( query("/GPUGTPinOperationInt16Executed") + query("/GPUGTPinOperationHpExecuted") ) ]]></valueEval>
      <valueType>count</valueType>
    </derivedQuery>
    <derivedQuery id="GPUGTPinOperations32bitExecuted">
      <valueEval><![CDATA[ ( query("/GPUGTPinOperationInt32Executed") + query("/GPUGTPinOperationSpExecuted") ) ]]></valueEval>
      <valueType>count</valueType>
    </derivedQuery>
    <derivedQuery id="GPUGTPinOperations64bitExecuted">
      <valueEval><![CDATA[ ( query("/GPUGTPinOperationInt64Executed") + query("/GPUGTPinOperationDpExecuted") ) ]]></valueEval>
      <valueType>count</valueType>
    </derivedQuery>
    <derivedQuery id="GPUGTPinInstructionMix">
      <queryInherit>/GPUGTPinInstructionCountInCountAndBarFormat/GPUGTPinInstructionType</queryInherit>
      <description>%GPUGTPinInstructionMixDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUGTPinCyclesInPercentFormat" displayName="%GPUGTPinCycles">
      <queryInherit>/GPUGTPinCycles</queryInherit>
      <displayAttributes>
        <selfFormat>percentAndBar</selfFormat>
        <totalFormat>percentAndBar</totalFormat>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUGTPinDataAvailableForComputeTask">
      <valueType>bool</valueType>
      <valueEval><![CDATA[ ( (queryOptional("/GPUGTPinCycles") > 0) || (queryOptional("/GPUGTPinInstructionCount") > 0) || (queryOptional("/GPUGTPinMaaInstructionCount) > 0  ) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUGTPinComputeTaskTimeSummary" displayName="%GpuComputingTaskTimeTotal">
      <queryInherit>/GPUComputeTaskTimeDerived</queryInherit>
      <valueEval><![CDATA[ (query("/GPUGTPinDataAvailableForComputeTask") ? query("/GPUComputeTaskTimeDerived") : $NULL) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUGTPinComputeTaskDurationSummary" displayName="%GpuComputeTaskDuration">
      <queryInherit>/GPUComputeTaskDuration</queryInherit>
      <valueEval><![CDATA[ (query("/GPUGTPinDataAvailableForComputeTask") ? query("/GPUComputeTaskDuration") : $NULL) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUGTPinComputeTaskCountSummary" displayName="%GpuComputeTaskCount">
      <queryInherit>/GPUComputeTaskCountDerived</queryInherit>
      <valueEval><![CDATA[ (query("/GPUGTPinDataAvailableForComputeTask") ? query("/GPUComputeTaskCountDerived") : $NULL) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUSamplingDataAvailableForComputeTask">
      <valueType>bool</valueType>
      <valueEval><![CDATA[ (queryOptional("/GPUSamplingEventCount") > 0) && (query("/GPUComputeTaskCount") > 0) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUSamplingComputeTaskTimeSummary" displayName="%GpuComputingTaskTimeTotal">
      <queryInherit>/GPUComputeTaskTimeDerived</queryInherit>
      <valueEval><![CDATA[ (query("/GPUSamplingDataAvailableForComputeTask") ? query("/GPUComputeTaskTimeDerived") : $NULL) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUSamplingComputeTaskDurationSummary" displayName="%GpuComputeTaskDuration">
      <queryInherit>/GPUComputeTaskDuration</queryInherit>
      <valueEval><![CDATA[ (query("/GPUSamplingDataAvailableForComputeTask") ? query("/GPUComputeTaskDuration") : $NULL) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUSamplingComputeTaskCountSummary" displayName="%GpuComputeTaskCount">
      <queryInherit>/GPUComputeTaskCountDerived</queryInherit>
      <valueEval><![CDATA[ (query("/GPUSamplingDataAvailableForComputeTask") ? query("/GPUComputeTaskCountDerived") : $NULL) ]]></valueEval>
    </derivedQuery>
    <xsl:variable name="GPUStallSamplingReasons">
        <item name="Tdr" eventName="%GPUTdr" displayName="%GPUTdr" description="%GPUTdrStallSamplingReasonDescription"/>
        <item name="Control" eventName="%GPUControl" displayName="%GPUControl" description="%GPUControlStallSamplingReasonDescription"/>
        <item name="DistOrAcc" eventName="%GPUDistOrAcc" displayName="%GPUDistOrAcc" description="%GPUDistOrAccStallSamplingReasonDescription"/>
        <item name="InstFetch" eventName="%GPUInstructionFetch" displayName="%GPUInstructionFetch" description="%GPUInstFetchStallSamplingReasonDescription"/>
        <item name="Pipe" eventName="%GPUPipeStall" displayName="%GPUPipeStall" description="%GPUPipeStallSamplingReasonDescription"/>
        <item name="Sbid" eventName="%GPUSbid" displayName="%GPUSbid" description="%GPUSbidStallSamplingReasonDescription"/>
        <item name="Send" eventName="%GPUSend" displayName="%GPUSend" description="%GPUSendStallSamplingReasonDescription"/>
        <item name="Sync" eventName="%GPUSync" displayName="%GPUSync" description="%GPUSyncStallSamplingReasonDescription"/>
        <item name="Other" eventName="%GPUOther" displayName="%GPUOther" description="%GPUOtherStallSamplingReasonDescription"/>
    </xsl:variable>
    <xsl:for-each select="exsl:node-set($GPUStallSamplingReasons)/item">
      <derivedQuery id="GPUSampling{@name}EventCountSummary" displayName="{@displayName}">
        <description><xsl:value-of select="@description"/></description>
        <valueEval>
          <xsl:text><![CDATA[ %#(query("/GPUSamplingDataAvailableForComputeTask") ? query("/GPUSamplingEventCount/GPUSamplingEventType[]]></xsl:text>
          <xsl:value-of select="@eventName"/>
          <xsl:text><![CDATA[]") / queryAll("/GPUSamplingEventCount", true) : $NULL) ]]></xsl:text>
        </valueEval>
        <valueType>string</valueType>
      </derivedQuery>
    </xsl:for-each>
    <derivedQuery id="GPUComputeTaskTimeSummary" displayName="%GpuComputingTaskTimeTotal">
      <queryInherit>/GPUComputeTaskTimeDerived</queryInherit>
      <valueEval><![CDATA[ (query("/GPUComputeTaskTimeDerived/GPUComputeTaskPurpose[%ComputeComputingTaskPurpose]")) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUComputeTaskDurationSummary" displayName="%GpuComputeTaskDuration">
      <queryInherit>/GPUComputeTaskDuration</queryInherit>
      <valueEval><![CDATA[ (query("/GPUComputeTaskDuration/GPUComputeTaskPurpose[%ComputeComputingTaskPurpose]")) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUComputeTaskCountGrid" displayName="%GpuComputeTaskCount">
      <queryInherit>/GPUComputeTaskCountDerived</queryInherit>
      <valueEval><![CDATA[ (query("/GPUComputeTaskCountDerived/GPUComputeTaskPurpose[%ComputeComputingTaskPurpose]") + query("/GPUComputeTaskCountDerived/GPUComputeTaskPurpose[%SynchronizationComputingTaskPurpose]") ) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUComputeTaskCountSummary" displayName="%GpuComputeTaskCount">
      <queryInherit>/GPUComputeTaskCountDerived</queryInherit>
      <valueEval><![CDATA[ (query("/GPUComputeTaskCountDerived/GPUComputeTaskPurpose[%ComputeComputingTaskPurpose]") ) ]]></valueEval>
    </derivedQuery>
    <countQuery id="GPUMediaEventCount" displayName="%UncoreGpuMediaEventCount">
      <instanceDbTable>gpu_media_data::dd_sample</instanceDbTable>
      <instanceBandTable>dd_gpu_node</instanceBandTable>
      <displayAttributes>
        <selfFormat>count</selfFormat>
        <boolean:allowCollapse>false</boolean:allowCollapse>
        <timelineObjectType>interval</timelineObjectType>
      </displayAttributes>
    </countQuery>
    <infoQuery id="GPUMediaEventType" displayName="%UncoreGpuMediaEventType">
      <dbPath>gpu_media_data::dd_sample.uncore_event_type</dbPath>
      <displayDbPathSuffix>name</displayDbPathSuffix>
    </infoQuery>
    <countQuery id="GPUEventCountRaw" displayName="%UncoreGpuEventCount">
      <instanceDbTable>gpu_data::dd_sample</instanceDbTable>
      <instanceBandTable>dd_gpu_node</instanceBandTable>
      <displayAttributes>
        <selfFormat>count</selfFormat>
        <boolean:allowCollapse>false</boolean:allowCollapse>
        <timelineObjectType>interval</timelineObjectType>
      </displayAttributes>
    </countQuery>
    <infoQuery id="GPUEventTypeRaw" displayName="%UncoreGpuEventType">
      <dbPath>gpu_data::dd_sample.uncore_event_type</dbPath>
      <displayDbPathSuffix>name</displayDbPathSuffix>
      <displayAttributes>
        <boolean:unitDistinctQuery>true</boolean:unitDistinctQuery>
        <boolean:hideZeroDataOnExpansion>true</boolean:hideZeroDataOnExpansion>
      </displayAttributes>
    </infoQuery>
    <countQuery id="GPUEventCount" displayName="%UncoreGpuEventCount">
      <instanceDbTable>gpu_data::dd_sample</instanceDbTable>
      <instanceBandTable>dd_gpu_node</instanceBandTable>
      <displayAttributes>
        <selfFormat>count</selfFormat>
        <boolean:allowCollapse>false</boolean:allowCollapse>
        <timelineObjectType>interval</timelineObjectType>
      </displayAttributes>
      <joinGroupInstanceDbTable>gpu_compute_task_data</joinGroupInstanceDbTable>
    </countQuery>
    <countQuery id="GPUSamplingCount" displayName="%UncoreGpuEventCount">
      <instanceDbTable>gpu_sampling_data::dd_sample</instanceDbTable>
      <instanceBandTable>gpu_sampling_grouper</instanceBandTable>
    </countQuery>
    <infoQuery id="GPUEventType" displayName="%UncoreGpuEventType">
      <dbPath>gpu_data::dd_sample.uncore_event_type</dbPath>
      <displayDbPathSuffix>name</displayDbPathSuffix>
      <confidenceTemplate><![CDATA[ ( ( ( query("/GPUSampleCount") > 5 ) ) ) ]]></confidenceTemplate>
    </infoQuery>
    <derivedQuery id="GPUTimeAllCoresCumulative" displayName="%{$gpuPrefix}Time">
      <helpKeyword>configs.gputime_gputimedescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ (query("/GPUEUActiveBase") + query("/GPUEUStalledBase")) ]]></valueEval>
      <description>%GPUTimeDescription</description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelinePenWidth>1</timelinePenWidth>
        <timelineGraphColor>0,0,0</timelineGraphColor>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
      <maxEval>$logicalGPUCount</maxEval>
    </derivedQuery>
    <derivedQuery id="GPUGpuTime" displayName="%GPUGpuTime">
      <description>%GPUGpuTimeDescription</description>
      <xsl:choose>
        <xsl:when test="exsl:is_non_empty_table_exist('dma_packet_data') or
                        exsl:is_non_empty_table_exist('gpu_scheduler_data')">
          <valueEval><![CDATA[ queryOptional("/GPUDXTime") + queryOptional("/GPUSchedTime") ]]></valueEval>
        </xsl:when>
        <xsl:otherwise>
          <valueEval><![CDATA[ (query("/GPUUsageElapsedTimeWhenBusy")) ]]></valueEval>
        </xsl:otherwise>
      </xsl:choose>
      <valueType>time</valueType>
    </derivedQuery>
    <xsl:variable name="commonDoc" select="document('config://collector/include/common.xsl')"/>
    <xsl:variable name="countGPUBusyByOccupancy" select="string($commonDoc//common/variables/countGPUBusyByOccupancy)"/>
    <derivedQuery id="GPUGpuBusyBase" displayName="%GPUBusy">
      <helpKeyword>configs.gpubusy_gpubusydescription</helpKeyword>
      <valueType>ratio</valueType>
      <xsl:choose>
        <xsl:when test="$countGPUBusyByOccupancy">
          <valueEval><![CDATA[ ( query("/GPUEuThreadOccupancyMetric") > 0.0 ) ? 1.0 : 0.0 ]]></valueEval>
        </xsl:when>
        <xsl:otherwise>
          <queryInherit>/GPUGpuBusyMetric</queryInherit>
        </xsl:otherwise>
      </xsl:choose>
      <description>%GPUBusyDescription</description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>250,180,0</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
      <maxEval>$logicalGPUCount</maxEval>
    </derivedQuery>
    <derivedQuery id="GPURenderEngineBusyBase" displayName="%GPURenderEngineBusy">
      <helpKeyword>configs.gpurenderenginebusy_gpurenderenginebusydescription</helpKeyword>
      <valueType>ratio</valueType>
      <queryInherit>/GPUCOMMAND_PARSER_RENDER_ENGINE_BUSYMetric</queryInherit>
      <description>%GPURenderEngineBusyDescription</description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>231, 200, 76</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUComputeEngineBusyBase" displayName="%GPUComputeEngineBusy">
      <helpKeyword>configs.gpucomputeenginebusy_gpucomputeenginebusydescription</helpKeyword>
      <valueType>ratio</valueType>
      <queryInherit>/GPUCOMMAND_PARSER_COMPUTE_ENGINE_BUSYMetric</queryInherit>
      <description>%GPUComputeEngineBusyDescription</description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>57, 111, 44</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUCopyEngineBusyBase" displayName="%GPUCopyEngineBusy">
      <helpKeyword>configs.gpucopyenginebusy_gpucopyenginebusydescription</helpKeyword>
      <valueType>ratio</valueType>
      <queryInherit>/GPUCOMMAND_PARSER_COPY_ENGINE_BUSYMetric</queryInherit>
      <description>%GPUCopyEngineBusyDescription</description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>146, 47, 158</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUCopyEngineReadsBase" displayName="%GPUCopyEngineReads">
      <valueType>int</valueType>
      <queryInherit>/GPUCOPY_ENGINE_READ_REQUESTMetric</queryInherit>
      <displayAttributes>
        <timeScalems>1000</timeScalems>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>78,169,79</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUCopyEngineWritesBase" displayName="%GPUCopyEngineWrites">
      <valueType>int</valueType>
      <queryInherit>/GPUCOPY_ENGINE_WRITE_REQUESTMetric</queryInherit>
      <displayAttributes>
        <timeScalems>1000</timeScalems>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>78,119,79</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUCopyEngineStallBase" displayName="%GPUCopyEngineStall">
      <valueType>ratio</valueType>
      <queryInherit>/GPUCOPY_ENGINE_REQUEST_STALLMetric</queryInherit>
      <description>%GPUL3StallDescription</description>
      <confidenceEval><![CDATA[ (query("/GPUSampleCount/GPUEventType[COPY_ENGINE_REQUEST_STALL]") > 5) ]]></confidenceEval>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>230,60,60</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <diagramObjectId>CopyEngineStallSlot</diagramObjectId>
      </displayAttributes>
      <maxEval>1</maxEval>
    </derivedQuery>
    <derivedQuery id="GPUCommandParserFlushBase" displayName="%GPUCommandParserFlush">
      <valueType>int</valueType>
      <queryInherit>/GPUCOMMAND_PARSER_FLUSH_COUNTMetric</queryInherit>
      <displayAttributes>
        <timeScalems>1000</timeScalems>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>117,219,203</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUEUSharedStallBase" displayName="%GPUEUSharedStall">
      <valueType>ratio</valueType>
      <queryInherit>/GPUXVE_SHARED_FUNCTION_ACCESS_HOLDMetric</queryInherit>
      <description>%GPUEUSharedStallDescription</description>
      <confidenceEval><![CDATA[ (query("/GPUSampleCount/GPUEventType[XVE_SHARED_FUNCTION_ACCESS_HOLD]") > 5) ]]></confidenceEval>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>230,60,60</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <diagramObjectId>EUSharedStallSlot</diagramObjectId>
      </displayAttributes>
      <maxEval>1</maxEval>
    </derivedQuery>
    <derivedQuery id="GPUEUSharedStall" displayName="%GPUEUSharedStall">
      <queryInherit>/GPUEUSharedStallBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUEUActiveBase/ConditionalXVE_SHARED_FUNCTION_ACCESS_HOLDSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <joinGroupInstanceDbTable>gpu_compute_task_data</joinGroupInstanceDbTable>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUEUActiveBase" displayName="%{$gpuPrefix}EUActiveShort">
      <helpKeyword>configs.gpueuactive_gpueuactivedescription</helpKeyword>
      <valueType>ratio</valueType>
      <xsl:choose>
        <xsl:when test="$universalCollectorUsed='true'">
          <queryInherit>/GPUEuActiveMetric</queryInherit>
        </xsl:when>
        <xsl:otherwise>
          <xsl:choose>
            <xsl:when test="exsl:ctx('gsimClockDuration', 0) > 0">
              <valueEval><![CDATA[ query("/gSimGPUEventCount/gSimGPUEventType[EuActive]") / query("/gSimGPUEventCountWeighted/gSimGPUEventType[EuActive]") / 10000]]></valueEval>
            </xsl:when>
            <xsl:otherwise>
              <valueEval><![CDATA[ query("/GPUEventCount/GPUEventType[Aggregated Core Array Active]") / ($gpuEuCount * query("/GPUEventCount/GPUEventType[GPU CS Core Clockticks]")) ]]></valueEval>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:otherwise>
      </xsl:choose>
      <description><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>EUActiveDescription</xsl:text></description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>0,170,0</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <boolean:vtNullAsZero>false</boolean:vtNullAsZero>
      </displayAttributes>
      <maxEval>1</maxEval>
    </derivedQuery>
    <derivedQuery id="GPU_EU_ACTIVE_Base" displayName="%{$gpuPrefix}EUActiveShort">
      <helpKeyword>configs.gpueuactive_gpueuactivedescription</helpKeyword>
      <valueType>ratio</valueType>
      <xsl:choose>
        <xsl:when test="exsl:is_value_exist('dd_uncore_event_type', 'name', 'EU_ACTIVE_CYCLES')">
          <queryInherit>/GPUEU_ACTIVE_CYCLESMetric</queryInherit>
        </xsl:when>
        <xsl:otherwise>
          <queryInherit>/GPUEU_ACTIVEMetric</queryInherit>
        </xsl:otherwise>
      </xsl:choose>
      <description><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>EUActiveDescription</xsl:text></description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>0,170,0</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <boolean:vtNullAsZero>false</boolean:vtNullAsZero>
      </displayAttributes>
      <maxEval>1</maxEval>
    </derivedQuery>
    <derivedQuery id="GPUEUActive" displayName="%{$gpuPrefix}EUActive">
      <queryInherit>/GPUEUActiveBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUEUActiveBase/ConditionalEuActiveSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <joinGroupInstanceDbTable>gpu_compute_task_data</joinGroupInstanceDbTable>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPU_EU_ACTIVE" displayName="%{$gpuPrefix}EUActive">
      <queryInherit>/GPU_EU_ACTIVE_Base</queryInherit>
      <joinGroupInstanceDbTable>gpu_compute_task_data</joinGroupInstanceDbTable>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUHPCEUActive" displayName="%{$gpuPrefix}EUActiveShort">
      <queryInherit>/GPUEuActiveWhenBusyCountingAvgOverTiles</queryInherit>
    </derivedQuery>
    <xsl:if test="exsl:ctx('gpuCounters','none') = 'render-basic'">
      <derivedQuery id="GPUPsEuActiveBase" displayName="%{$gpuPrefix}PsEuActive">
        <valueType>ratio</valueType>
        <queryInherit>/GPUPsEuActiveMetric</queryInherit>
        <displayAttributes>
          <timelineFormat>line</timelineFormat>
          <timelineGraphColor>0,170,0</timelineGraphColor>
          <timelinePenWidth>1</timelinePenWidth>
          <minimumResolutionms>0</minimumResolutionms>
        </displayAttributes>
      </derivedQuery>
      <derivedQuery id="GPUPsEuStallBase" displayName="%{$gpuPrefix}PsEuStall">
        <valueType>ratio</valueType>
        <queryInherit>/GPUPsEuStallMetric</queryInherit>
        <displayAttributes>
          <timelineFormat>line</timelineFormat>
          <timelineGraphColor>170,0,0</timelineGraphColor>
          <timelinePenWidth>1</timelinePenWidth>
          <minimumResolutionms>0</minimumResolutionms>
        </displayAttributes>
      </derivedQuery>
      <derivedQuery id="GPUVsEuStallBase" displayName="%{$gpuPrefix}VsEuStall">
        <valueType>ratio</valueType>
        <queryInherit>/GPUVsEuStallMetric</queryInherit>
        <displayAttributes>
          <timelineFormat>line</timelineFormat>
          <timelineGraphColor>170,0,0</timelineGraphColor>
          <timelinePenWidth>1</timelinePenWidth>
          <minimumResolutionms>0</minimumResolutionms>
        </displayAttributes>
      </derivedQuery>
      <derivedQuery id="GPUVsEuActiveBase" displayName="%{$gpuPrefix}VsEuActive">
        <valueType>ratio</valueType>
        <queryInherit>/GPUVsEuActiveMetric</queryInherit>
        <displayAttributes>
          <timelineFormat>line</timelineFormat>
          <timelineGraphColor>0,170,0</timelineGraphColor>
          <timelinePenWidth>1</timelinePenWidth>
          <minimumResolutionms>0</minimumResolutionms>
        </displayAttributes>
      </derivedQuery>
      <derivedQuery id="GPUSamplesKilledInPsBase" displayName="%GPUSamplesKilledInPs">
        <valueType>count</valueType>
        <queryInherit>/GPUSamplesKilledInPsMetric</queryInherit>
        <displayAttributes>
          <timelineFormat>line</timelineFormat>
          <timelineGraphColor>186,85,211</timelineGraphColor>
          <timelinePenWidth>1</timelinePenWidth>
          <minimumResolutionms>0</minimumResolutionms>
        </displayAttributes>
      </derivedQuery>
      <derivedQuery id="GPUSamplesWrittenBase" displayName="%GPUSamplesWritten">
        <valueType>count</valueType>
        <queryInherit>/GPUSamplesWrittenMetric</queryInherit>
        <displayAttributes>
          <timelineFormat>line</timelineFormat>
          <timelineGraphColor>255,215,0</timelineGraphColor>
          <timelinePenWidth>1</timelinePenWidth>
          <minimumResolutionms>0</minimumResolutionms>
        </displayAttributes>
      </derivedQuery>
      <derivedQuery id="GPUSamplesBlendedBase" displayName="%GPUSamplesBlended">
        <valueType>count</valueType>
        <queryInherit>/GPUSamplesBlendedMetric</queryInherit>
        <displayAttributes>
          <timelineFormat>line</timelineFormat>
          <timelineGraphColor>65,105,224</timelineGraphColor>
          <timelinePenWidth>1</timelinePenWidth>
          <minimumResolutionms>0</minimumResolutionms>
        </displayAttributes>
      </derivedQuery>
    </xsl:if>
    <derivedQuery id="GPUEUStalledBase" displayName="%{$gpuPrefix}EUStalledShort">
      <helpKeyword>configs.gpueustalled_gpueustalleddescription</helpKeyword>
      <valueType>ratio</valueType>
      <xsl:choose>
        <xsl:when test="$universalCollectorUsed='true'">
          <queryInherit>/GPUEuStallMetric</queryInherit>
        </xsl:when>
        <xsl:otherwise>
          <xsl:choose>
            <xsl:when test="exsl:ctx('gsimClockDuration', 0) > 0">
              <valueEval><![CDATA[ query("/gSimGPUEventCount/gSimGPUEventType[EuStalled]") / query("/gSimGPUEventCountWeighted/gSimGPUEventType[EuStalled]") / 10000]]></valueEval>
            </xsl:when>
            <xsl:otherwise>
              <valueEval><![CDATA[ query("/GPUEventCount/GPUEventType[Aggregated Core Array Stalled]") / ($gpuEuCount * query("/GPUEventCount/GPUEventType[GPU CS Core Clockticks]")) ]]></valueEval>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:otherwise>
      </xsl:choose>
      <description><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>EUStalledDescription</xsl:text></description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>170,0,0</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <boolean:vtNullAsZero>false</boolean:vtNullAsZero>
      </displayAttributes>
      <maxEval>1</maxEval>
    </derivedQuery>
    <derivedQuery id="GPU_EU_STALLED_Base" displayName="%{$gpuPrefix}EUStalledShort">
      <helpKeyword>configs.gpueustalled_gpueustalleddescription</helpKeyword>
      <valueType>ratio</valueType>
      <xsl:choose>
        <xsl:when test="exsl:is_value_exist('dd_uncore_event_type', 'name', 'EU_STALL_CYCLES')">
          <queryInherit>/GPUEU_STALL_CYCLESMetric</queryInherit>
        </xsl:when>
        <xsl:otherwise>
          <queryInherit>/GPUEU_STALLMetric</queryInherit>
        </xsl:otherwise>
      </xsl:choose>
      <description><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>EUStalledDescription</xsl:text></description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>170,0,0</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <boolean:vtNullAsZero>false</boolean:vtNullAsZero>
      </displayAttributes>
      <maxEval>1</maxEval>
    </derivedQuery>
    <derivedQuery id="GPUEUStalled" displayName="%{$gpuPrefix}EUStalled">
      <queryInherit>/GPUEUStalledBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUEUStalledBase/ConditionalEuStallSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <issueEval><![CDATA[ (query("/GPUEUStalled") > 0.2) * (query("/GPUComputeTaskTime") > 0) ]]></issueEval>
      <issueText><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>EUStalledIssueText</xsl:text></issueText>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPU_EU_STALLED" displayName="%{$gpuPrefix}EUStalled">
      <queryInherit>/GPU_EU_STALLED_Base</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPU_EU_STALLED_Base/ConditionalEuStallSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <issueEval><![CDATA[ (query("/GPU_EU_STALLED") > 0.2) * (query("/GPUComputeTaskTime") > 0) ]]></issueEval>
      <issueText><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>EUStalledIssueText</xsl:text></issueText>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUHPCEUStalled" displayName="%{$gpuPrefix}EUStalledShort">
      <queryInherit>/GPUEuStallWhenBusyCountingAvgOverTiles</queryInherit>
      <issueEval><![CDATA[ (query("/GPUHPCEUStalled") > 0.2) * (query("/GPUEUAvgUtilizationWhenBusyCountingAvgOverTiles") < 0.8) ]]></issueEval>
      <issueText><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>EUStalledIssueText</xsl:text></issueText>
    </derivedQuery>
    <derivedQuery id="GPUEUIdleBase" displayName="%{$gpuPrefix}EUIdleShort">
      <helpKeyword>configs.gpueuidle_gpueuidledescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ (query("/GPUEUActiveBase") + query("/GPUEUStalledBase")) <= 1 ? ((query("/GPUEUActiveBase") + query("/GPUEUStalledBase")) >=0 ? 1 - (query("/GPUEUActiveBase") + query("/GPUEUStalledBase")) : (query("/GPUEUActiveBase") + query("/GPUEUStalledBase"))) : 0.0 ]]></valueEval>
      <description><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>EUIdleDescription</xsl:text></description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>180,180,180</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
      <maxEval>1</maxEval>
    </derivedQuery>
    <derivedQuery id="GPU_EU_IDLE_Base" displayName="%{$gpuPrefix}EUIdleShort">
      <helpKeyword>configs.gpueuidle_gpueuidledescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ (query("/GPU_EU_ACTIVE_Base") + query("/GPU_EU_STALLED_Base")) <= 1 ? ((query("/GPU_EU_ACTIVE_Base") + query("/GPU_EU_STALLED_Base")) >=0 ? 1 - (query("/GPU_EU_ACTIVE_Base") + query("/GPU_EU_STALLED_Base")) : (query("/GPU_EU_ACTIVE_Base") + query("/GPU_EU_STALLED_Base"))) : 0.0 ]]></valueEval>
      <description><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>EUIdleDescription</xsl:text></description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>180,180,180</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
      <maxEval>1</maxEval>
    </derivedQuery>
    <derivedQuery id="GPUEUIdle" displayName="%{$gpuPrefix}EUIdle">
        <queryInherit>/GPUEUIdleBase</queryInherit>
        <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
          <valueEval><![CDATA[ ( query("/GPUEUIdleBase/ConditionalEuActiveSamplesExist[%True]") ) ]]></valueEval>
        </xsl:if>
      <issueEval><![CDATA[ (query("/GPUEUIdle") > 0.05) * (query("/GPUComputeTaskTime") > 0) ]]></issueEval>
      <issueText><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>EUIdleIssueText</xsl:text></issueText>
      <xsl:choose>
        <xsl:when test="exsl:ctx('gsimClockDuration', 0) > 0">
          <confidenceEval><![CDATA[ (query("/gsimGPUSampleCount/gSimGPUEventType[EuActive]") > 5) ]]></confidenceEval>
        </xsl:when>
        <xsl:otherwise>
          <confidenceEval><![CDATA[ (query("/GPUSampleCount/GPUEventType[EuActive]") > 5) ]]></confidenceEval>
        </xsl:otherwise>
      </xsl:choose>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPU_EU_IDLE" displayName="%{$gpuPrefix}EUIdle">
        <queryInherit>/GPU_EU_IDLE_Base</queryInherit>
        <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
          <valueEval><![CDATA[ ( query("/GPU_EU_IDLE_Base/ConditionalEuIdleSamplesExist[%True]") ) ]]></valueEval>
        </xsl:if>
      <issueEval><![CDATA[ (query("/GPU_EU_IDLE") > 0.05) * (query("/GPUComputeTaskTime") > 0) ]]></issueEval>
      <issueText><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>EUIdleIssueText</xsl:text></issueText>
    </derivedQuery>
    <derivedQuery id="GPUHPCEUIdle" displayName="%{$gpuPrefix}EUIdleShort">
      <queryInherit>/GPUEuIdleWhenBusyCountingAvgOverTiles</queryInherit>
      <issueEval><![CDATA[ (query("/GPUHPCEUIdle") > 0.05) * (query("/GPUEUAvgUtilizationWhenBusyCountingAvgOverTiles") < 0.8) ]]></issueEval>
      <issueText><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>EUIdleIssueText</xsl:text></issueText>
    </derivedQuery>
    <derivedQuery id="GPUEUStateGridSection" displayName="%{$gpuPrefix}EUState">
      <queryInherit>/GPUHPCEUActive</queryInherit>
      <displayAttributes>
        <boolean:expand>true</boolean:expand>
        <boolean:allowCollapse>false</boolean:allowCollapse>
      </displayAttributes>
      <expand>
        <vectorQuery id="GPUEUStateGroupExpanded">
          <queryRef>/GPUHPCEUActive</queryRef>
          <queryRef>/GPUHPCEUStalled</queryRef>
          <queryRef>/GPUHPCEUIdle</queryRef>
        </vectorQuery>
      </expand>
    </derivedQuery>
    <derivedQuery id="IsGPUBusy">
      <valueType>double</valueType>
      <valueEval><![CDATA[ (query("/GPUGpuBusyBase") > 0 ? 1 : 0) ]]></valueEval>
    </derivedQuery>
    <infoQuery id="ConditionalGPUBusyData">
      <dbPath>conditional_gpu_data::dd_conditional_metric.is_gpu_busy</dbPath>
      <displayDbPathSuffix>name</displayDbPathSuffix>
    </infoQuery>
    <infoQuery id="ConditionalGPUBusyDataGrouping" displayName="%PacketStageNew">
      <dbPath>conditional_gpu_data::dd_conditional_metric.is_gpu_busy</dbPath>
      <displayDbPathSuffix>grouping_name</displayDbPathSuffix>
    </infoQuery>
    <derivedQuery id="GPUEUNotActiveBase">
      <valueType>ratio</valueType>
      <xsl:choose>
        <xsl:when test="exsl:ctx('gsimClockDuration', 0) > 0">
          <valueEval><![CDATA[ 1 - query("/GPUEUActiveBase")]]></valueEval>
        </xsl:when>
        <xsl:otherwise>
      <valueEval><![CDATA[ (query("/GPUEUStalledBase") + query("/GPUEUIdleBase")) ]]></valueEval>
        </xsl:otherwise>
      </xsl:choose>
    </derivedQuery>
    <derivedQuery id="GPUEUNotActiveExtBase">
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ (query("/GPU_EU_STALLED_Base") + query("/GPU_EU_IDLE_Base")) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="IsGPUBusyAndEuStallSamplesExist">
      <valueType>double</valueType>
      <valueEval><![CDATA[ (((query("/GPUGpuBusyBase") > 0) && (query("/IsEuStallSamplesExist") > 0)) ? 1 : 0) ]]></valueEval>
    </derivedQuery>
    <infoQuery id="ConditionalGPUBusyAndEuStallSamplesExist">
      <dbPath>conditional_gpu_data::dd_conditional_metric.is_GPUBusyAndEuStall_exist</dbPath>
      <displayDbPathSuffix>name</displayDbPathSuffix>
    </infoQuery>
    <derivedQuery id="GPUEUNotActiveWhenBusyIssue">
      <valueType>bool</valueType>
      <valueEval><![CDATA[ (query("/GPUEUNotActiveWhenBusy") > 0.2) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUEUNotActiveExtWhenBusyIssue">
      <valueType>bool</valueType>
      <valueEval><![CDATA[ (query("/GPUEUNotActiveExtWhenBusy") > 0.2) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUEUNotActiveGSim" displayName="%{$gpuPrefix}EUNotActiveWhenBusy">
      <helpKeyword>configs.gpueunotactivewhenbusy_gpueunotactivewhenbusydescription</helpKeyword>
      <valueType>ratio</valueType>
      <queryInherit>/GPUEUNotActiveBase</queryInherit>
      <description><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>EUNotActiveWhenBusyDescription</xsl:text></description>
      <issueEval><![CDATA[ query("/GPUEUNotActiveBase") > 0.2 ]]></issueEval>
      <issueText><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>EUNotActiveWhenBusyIssueText</xsl:text></issueText>
      <unitOfMeasureQueryId>GPUElapsedTimeWhenBusyForUnit</unitOfMeasureQueryId>
    </derivedQuery>
    <derivedQuery id="GPUEUNotActiveWhenBusy" displayName="%{$gpuPrefix}EUNotActiveWhenBusy">
      <helpKeyword>configs.gpueunotactivewhenbusy_gpueunotactivewhenbusydescription</helpKeyword>
      <valueType>ratio</valueType>
      <xsl:choose>
        <xsl:when test="fnc:is_universal_collector_in_multirun_mode()">
          <valueEval><![CDATA[ (query("/GPUEUNotActiveBase/ConditionalGPUBusyAndEuStallSamplesExist[%True]")) ]]></valueEval>
        </xsl:when>
        <xsl:otherwise>
          <xsl:choose>
            <xsl:when test="exsl:ctx('gsimClockDuration', 0) > 0">
              <queryInherit>/GPUEUNotActiveBase</queryInherit>
            </xsl:when>
            <xsl:otherwise>
              <valueEval><![CDATA[ (query("/GPUEUNotActiveBase/ConditionalGPUBusyData[%True]")) ]]></valueEval>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:otherwise>
      </xsl:choose>
      <description><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>EUNotActiveWhenBusyDescription</xsl:text></description>
      <issueEval><![CDATA[ query("/GPUEUNotActiveWhenBusyIssue") ]]></issueEval>
      <issueText><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>EUNotActiveWhenBusyIssueText</xsl:text></issueText>
      <xsl:if test="not (exsl:ctx('gsimClockDuration', 0))">
        <confidenceEval><![CDATA[ ((query("/GPUSampleCount/GPUEventType[EuIdle]") > 5) || (query("/GPUSampleCount/GPUEventType[EuStall]") > 5)) ]]></confidenceEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
      <unitOfMeasureQueryId>GPUElapsedTimeWhenBusyForUnit</unitOfMeasureQueryId>
    </derivedQuery>
    <derivedQuery id="GPUEUNotActiveExtWhenBusy" displayName="%{$gpuPrefix}EUNotActiveWhenBusy">
      <helpKeyword>configs.gpueunotactivewhenbusy_gpueunotactivewhenbusydescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ (query("/GPUEUNotActiveExtBase/ConditionalGPUBusyData[%True]")) ]]></valueEval>
      <description><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>EUNotActiveWhenBusyDescription</xsl:text></description>
      <issueEval><![CDATA[ query("/GPUEUNotActiveExtWhenBusyIssue") ]]></issueEval>
      <issueText><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>EUNotActiveWhenBusyIssueText</xsl:text></issueText>
      <unitOfMeasureQueryId>GPUElapsedTimeWhenBusyForUnit</unitOfMeasureQueryId>
    </derivedQuery>
    <derivedQuery id="GPUEUNotActiveWhenBusyInKernel" displayName="%{$gpuPrefix}EUNotActiveWhenBusy">
      <helpKeyword>configs.gpueunotactivewhenbusy_gpueunotactivewhenbusydescription</helpKeyword>
      <valueType>ratio</valueType>
      <xsl:choose>
        <xsl:when test="fnc:is_universal_collector_in_multirun_mode()">
          <valueEval><![CDATA[ (query("/GPUEUNotActiveBase/ConditionalGPUBusyAndEuStallSamplesExist[%True]")) ]]></valueEval>
        </xsl:when>
        <xsl:otherwise>
          <xsl:choose>
            <xsl:when test="exsl:ctx('gsimClockDuration', 0) > 0">
              <queryInherit>/GPUEUNotActiveBase</queryInherit>
            </xsl:when>
            <xsl:otherwise>
              <valueEval><![CDATA[ (query("/GPUEUNotActiveBase/ConditionalGPUBusyData[%True]")) ]]></valueEval>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:otherwise>
      </xsl:choose>
      <description><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>EUNotActiveWhenBusyDescription</xsl:text></description>
      <issueEval><![CDATA[ query("/GPUEUNotActiveWhenBusyIssue") ]]></issueEval>
      <issueText><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>EUNotActiveWhenBusyIssueText</xsl:text></issueText>
      <xsl:if test="not (exsl:ctx('gsimClockDuration', 0))">
        <confidenceEval><![CDATA[ ((query("/GPUSampleCount/GPUEventType[EuIdle]") > 5) || (query("/GPUSampleCount/GPUEventType[EuStall]") > 5)) ]]></confidenceEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUEUNotActiveExtWhenBusyInKernel" displayName="%{$gpuPrefix}EUNotActiveWhenBusy">
      <helpKeyword>configs.gpueunotactivewhenbusy_gpueunotactivewhenbusydescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ (query("/GPUEUNotActiveExtBase/ConditionalGPUBusyData[%True]")) ]]></valueEval>
      <description><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>EUNotActiveWhenBusyDescription</xsl:text></description>
      <issueEval><![CDATA[ query("/GPUEUNotActiveExtWhenBusyIssue") ]]></issueEval>
      <issueText><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>EUNotActiveWhenBusyIssueText</xsl:text></issueText>
    </derivedQuery>
    <derivedQuery id="IsGPUBusyAndEuThreadOccupancySamplesExist">
      <valueType>double</valueType>
      <valueEval><![CDATA[ (((query("/GPUGpuBusyBase") > 0) && (query("/IsEuThreadOccupancySamplesExist") > 0)) ? 1 : 0) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUEUActiveWhenBusy">
      <queryInherit>/GPUEUActive</queryInherit>
      <valueEval><![CDATA[(query("/GPUEUActiveBase/ConditionalGPUBusyData[%True]"))]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUEUStalledWhenBusy">
      <queryInherit>/GPUEUStalled</queryInherit>
      <valueEval><![CDATA[(query("/GPUEUStalledBase/ConditionalGPUBusyData[%True]"))]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUEUIdleWhenBusy">
      <queryInherit>/GPUEUIdle</queryInherit>
      <valueEval><![CDATA[(query("/GPUEUIdleBase/ConditionalGPUBusyData[%True]"))]]></valueEval>
    </derivedQuery>
    <timeQuery id="GPUUsageElapsedTime">
      <instanceDbTable>conditional_gpu_data::dd_conditional_metric</instanceDbTable>
      <displayAttributes>
        <selfFormat>time</selfFormat>
        <totalFormat>timeAndBar</totalFormat>
        <sortType>descending</sortType>
      </displayAttributes>
      <instanceBandTable>dd_gpu_node</instanceBandTable>
    </timeQuery>
    <derivedQuery id="GPUUsageElapsedTimeWhenBusy">
      <valueType>time</valueType>
      <valueEval><![CDATA[ (query("/GPUUsageElapsedTime/ConditionalGPUBusyData[%True]")) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUTimePrettyPrinted" displayName="%Time">
      <description>%GPUHPCActiveTimeDescription</description>
      <queryInherit>/GPUUtilization</queryInherit>
      <valueType>string</valueType>
      <valueEval><![CDATA[ %#(query("/GPUUsageElapsedTimeWhenBusy") / query("/GPUElapsedTime")) + " (" + t#query("/GPUUsageElapsedTimeWhenBusy") + ")" ]]></valueEval>
      <unitOfMeasureQueryId>GPUElapsedTimeForUnit</unitOfMeasureQueryId>
    </derivedQuery>
    <derivedQuery id="GPUUsageForHPCPC" displayName="%GPUHPCActiveTime">
      <queryInherit>/GPUUtilization</queryInherit>
      <valueEval><![CDATA[query("/GPUUsageElapsedTimeWhenBusy") / query("/GPUElapsedTime")]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUEUAvgUtilization" displayName="%GPUHPCEUAvgUtilization">
      <queryInherit>/GPUEUActive</queryInherit>
      <valueEval><![CDATA[query("/GPUEUActiveWhenBusy")]]></valueEval>
      <issueEval><![CDATA[ query("/GPUEUAvgUtilization") < 0.8]]></issueEval>
      <issueText><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>EUNotActiveWhenBusyIssueText</xsl:text></issueText>
    </derivedQuery>
    <derivedQuery id="GPUEuAvgCpiRate" displayName="%{$gpuPrefix}HPCEuAvgCpiRate">
      <queryInherit>/GPUEuAvgIpcRate</queryInherit>
      <description>%GPUHPCEuAvgCpiRateDescription</description>
      <valueEval><![CDATA[ 1 / ( query("/GPUEuAvgIpcRate") ) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUEuAlternativeIpcRate">
      <queryInherit>/GPUEuAvgIpcRate</queryInherit>
      <valueEval><![CDATA[ ( query("/GPUEventCount/GPUEventType[Fpu0Active]") + query("/GPUEventCount/GPUEventType[Fpu1Active]") ) / ($gpuEuCoresTotalCount * query("/GPUEventCount/GPUEventType[GpuCoreClocks]") ) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUEuAlternativeCpiRate" displayName="%{$gpuPrefix}HPCEuAltAvgCpiRate">
      <queryInherit>/GPUEuAvgCpiRate</queryInherit>
      <description><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>HPCEuAltAvgCpiRateDescription</xsl:text></description>
      <valueEval><![CDATA[ 1 / query("/GPUEuAlternativeIpcRate") ]]></valueEval>
    </derivedQuery>
    <infoQuery id="ConditionalGPUBusyAndEuThreadOccupancySamplesExist">
      <dbPath>conditional_gpu_data::dd_conditional_metric.is_GPUBusyAndEuThreadOccupancy_exist</dbPath>
      <displayDbPathSuffix>name</displayDbPathSuffix>
    </infoQuery>
    <derivedQuery id="GPUThreadOccupancyWhenBusyIssue">
      <valueType>bool</valueType>
      <valueEval><![CDATA[ (query("/GPUThreadOccupancyWhenBusy") < 0.9) && (query("/GPUEUNotActiveBase") > 0.2) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUThreadOccupancyExtWhenBusyIssue">
      <valueType>bool</valueType>
      <valueEval><![CDATA[ (query("/GPUThreadOccupancyExtWhenBusy") < 0.9) && (query("/GPUEUNotActiveExtBase") > 0.2) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="OccupancyThreadsLowIssue">
      <valueType>bool</valueType>
      <valueEval>
        <![CDATA[ (query("/GPUPeakThreadsOccupancyBase") < 0.9) && (query("/GPUComputeTaskPurpose") == "%ComputeComputingTaskPurpose")]]>
      </valueEval>
    </derivedQuery>
    <derivedQuery id="OccupancySLMLowIssue">
      <valueType>bool</valueType>
      <valueEval>
        <![CDATA[ (query("/GPUPeakSLMOccupancy") < 0.9) && (query("/GPUComputeTaskPurpose") == "%ComputeComputingTaskPurpose") ]]>
      </valueEval>
    </derivedQuery>
    <derivedQuery id="OccupancyBarrierLowIssue">
      <valueType>bool</valueType>
      <valueEval>
        <![CDATA[ (query("/GPUPeakBarrierOccupancy") < 0.9) && (query("/GPUComputeTaskPurpose") == "%ComputeComputingTaskPurpose")]]>
      </valueEval>
    </derivedQuery>
    <derivedQuery id="GPUPeakOccupancyIssues">
      <valueType>string</valueType>
      <valueEval><![CDATA[ "%GPULowPeakOccupancyIssue" ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUThreadOccupancyWhenBusy" displayName="%GPUThreadOccupancyWhenBusy">
      <helpKeyword>configs.gputhreadoccupancywhenbusy_gputhreadoccupancywhenbusydescription</helpKeyword>
      <valueType>ratio</valueType>
      <xsl:choose>
        <xsl:when test="fnc:is_universal_collector_in_multirun_mode()">
          <valueEval><![CDATA[ (query("/GPUEuThreadOccupancyBase/ConditionalGPUBusyAndEuThreadOccupancySamplesExist[%True]")) ]]></valueEval>
        </xsl:when>
        <xsl:otherwise>
          <valueEval><![CDATA[ (query("/GPUEuThreadOccupancyBase/ConditionalGPUBusyData[%True]")) ]]></valueEval>
        </xsl:otherwise>
      </xsl:choose>
      <description>%GPUThreadOccupancyWhenBusyDescription</description>
      <issueEval><![CDATA[ query("/GPUThreadOccupancyWhenBusyIssue") ]]></issueEval>
      <issueText>%GPUThreadOccupancyWhenBusyIssueText</issueText>
      <confidenceText>%NotEnoughSamples</confidenceText>
      <unitOfMeasureQueryId>GPUPeakForUnit</unitOfMeasureQueryId>
    </derivedQuery>
    <derivedQuery id="GPUThreadOccupancyExtWhenBusy" displayName="%GPUThreadOccupancyWhenBusy">
      <helpKeyword>configs.gputhreadoccupancywhenbusy_gputhreadoccupancywhenbusydescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ (query("/GPU_EU_THREAD_OCCUPANCY_Base/ConditionalGPUBusyData[%True]")) ]]></valueEval>
      <description>%GPUThreadOccupancyWhenBusyDescription</description>
      <issueEval><![CDATA[ query("/GPUThreadOccupancyExtWhenBusyIssue") ]]></issueEval>
      <issueText>%GPUThreadOccupancyWhenBusyIssueText</issueText>
      <unitOfMeasureQueryId>GPUPeakForUnit</unitOfMeasureQueryId>
    </derivedQuery>
    <derivedQuery id="GPUThreadOccupancyWhenBusyInKernel" displayName="%GPUThreadOccupancyWhenBusy">
      <helpKeyword>configs.gputhreadoccupancywhenbusy_gputhreadoccupancywhenbusydescription</helpKeyword>
      <valueType>ratio</valueType>
      <xsl:choose>
        <xsl:when test="fnc:is_universal_collector_in_multirun_mode()">
          <valueEval><![CDATA[ (query("/GPUEuThreadOccupancyBase/ConditionalGPUBusyAndEuThreadOccupancySamplesExist[%True]")) ]]></valueEval>
        </xsl:when>
        <xsl:otherwise>
          <valueEval><![CDATA[ (query("/GPUEuThreadOccupancyBase/ConditionalGPUBusyData[%True]")) ]]></valueEval>
        </xsl:otherwise>
      </xsl:choose>
      <description>%GPUThreadOccupancyWhenBusyDescriptionInKernel</description>
      <issueEval><![CDATA[ query("/GPUThreadOccupancyWhenBusyIssue") ]]></issueEval>
      <issueText>%GPUThreadOccupancyWhenBusyIssueText</issueText>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUThreadOccupancyExtWhenBusyInKernel" displayName="%GPUThreadOccupancyWhenBusy">
      <helpKeyword>configs.gputhreadoccupancywhenbusy_gputhreadoccupancywhenbusydescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ (query("/GPU_EU_THREAD_OCCUPANCY_Base/ConditionalGPUBusyData[%True]")) ]]></valueEval>
      <description>%GPUThreadOccupancyWhenBusyDescriptionInKernel</description>
      <issueEval><![CDATA[ query("/GPUThreadOccupancyExtWhenBusyIssue") ]]></issueEval>
      <issueText>%GPUThreadOccupancyWhenBusyIssueText</issueText>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUOccupancyThreshold">
      <queryInherit>/GPUThreadOccupancyWhenBusyInKernel</queryInherit>
      <valueEval><![CDATA[ 0.9 * query("/GPUPeakOccupancyWhenLowOccupancy") ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUOccupancyThresholdSummary">
      <queryInherit>/GPUThreadOccupancyWhenBusyInKernel</queryInherit>
      <valueEval><![CDATA[ 0.9 * query("/GPUPeakOccupancyBase") ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUPeakOccupancyThreshold">
      <queryInherit>/GPUThreadOccupancyWhenBusyInKernel</queryInherit>
      <valueEval><![CDATA[ 0.9 ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUOccupancyExtThreshold">
      <queryInherit>/GPUThreadOccupancyExtWhenBusyInKernel</queryInherit>
      <valueEval><![CDATA[ 0.9 * query("/GPUPeakOccupancyExtWhenLowOccupancy") ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUPeakOccupancyExtThreshold">
      <queryInherit>/GPUThreadOccupancyExtWhenBusyInKernel</queryInherit>
      <valueEval><![CDATA[ 0.9 ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="IsGPUBusyAndSamplerBusySamplesExist">
      <valueType>double</valueType>
      <valueEval><![CDATA[ (((query("/GPUGpuBusyBase") > 0) && (query("/IsSamplersBusySamplesExist") > 0)) ? 1 : 0) ]]></valueEval>
    </derivedQuery>
    <infoQuery id="ConditionalGPUBusyAndSamplerBusySamplesExist">
      <dbPath>conditional_gpu_data::dd_conditional_metric.is_GPUBusyAndSamplerBusy_exist</dbPath>
      <displayDbPathSuffix>name</displayDbPathSuffix>
    </infoQuery>
    <derivedQuery id="GPUSamplerBusyWhenBusyIssue">
      <valueType>bool</valueType>
      <valueEval><![CDATA[ (query("/GPUSamplerBusyWhenBusy") > 0.95) && (query("/GPUEUNotActiveBase") > 0.2) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUSamplerBusyWhenBusy" displayName="%GPUSamplerBusyWhenBusy">
      <helpKeyword>configs.gpusamplerbusywhenbusy_gpusamplerbusywhenbusydescription</helpKeyword>
      <valueType>ratio</valueType>
      <xsl:choose>
        <xsl:when test="fnc:is_universal_collector_in_multirun_mode()">
          <valueEval><![CDATA[ (query("/GPUSamplerBusyBase/ConditionalGPUBusyAndSamplerBusySamplesExist[%True]")) ]]></valueEval>
        </xsl:when>
        <xsl:otherwise>
          <valueEval><![CDATA[ (query("/GPUSamplerBusyBase/ConditionalGPUBusyData[%True]")) ]]></valueEval>
        </xsl:otherwise>
      </xsl:choose>
      <description><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>SamplerBusyWhenBusyDescription</xsl:text></description>
      <issueEval><![CDATA[ query("/GPUSamplerBusyWhenBusyIssue") ]]></issueEval>
      <issueText><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>SamplerBusyWhenBusyIssueText</xsl:text></issueText>
      <confidenceText>%NotEnoughSamples</confidenceText>
      <unitOfMeasureQueryId>GPUPeakForUnit</unitOfMeasureQueryId>
    </derivedQuery>
    <derivedQuery id="GPUSamplerBusyWhenBusyInKernel" displayName="%GPUSamplerBusyWhenBusy">
      <helpKeyword>configs.gpusamplerbusywhenbusy_gpusamplerbusywhenbusydescription</helpKeyword>
      <valueType>ratio</valueType>
      <xsl:choose>
        <xsl:when test="fnc:is_universal_collector_in_multirun_mode()">
          <valueEval><![CDATA[ (query("/GPUSamplerBusyBase/ConditionalGPUBusyAndSamplerBusySamplesExist[%True]")) ]]></valueEval>
        </xsl:when>
        <xsl:otherwise>
          <valueEval><![CDATA[ (query("/GPUSamplerBusyBase/ConditionalGPUBusyData[%True]")) ]]></valueEval>
        </xsl:otherwise>
      </xsl:choose>
      <description><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>SamplerBusyWhenBusyDescriptionInKernel</xsl:text></description>
      <issueEval><![CDATA[ query("/GPUSamplerBusyWhenBusyIssue") ]]></issueEval>
      <issueText><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>SamplerBusyWhenBusyIssueText</xsl:text></issueText>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUWorkGroupInvocationCount">
      <valueType>int</valueType>
      <valueEval><![CDATA[ query("/GPUComputeGlobalSize") / query("/GPUComputeLocalSize") ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUThreadsPerWorkGroupDouble">
      <valueType>double</valueType>
      <valueEval><![CDATA[ query("/GPUComputeLocalSize") / query("/GPUComputeSimdWidth") ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUThreadsPerWorkGroupInt">
      <valueType>int</valueType>
      <valueEval><![CDATA[ query("/GPUComputeLocalSize") div query("/GPUComputeSimdWidth") ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUThreadsPerWorkGroup">
      <valueType>int</valueType>
      <valueEval><![CDATA[ (query("/GPUThreadsPerWorkGroupDouble") > query("/GPUThreadsPerWorkGroupInt")) ? (query("/GPUThreadsPerWorkGroupInt") + 1) : query("/GPUThreadsPerWorkGroupInt") ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPURequestedThreadCount">
      <valueType>int</valueType>
      <valueEval><![CDATA[ query("/GPUThreadsPerWorkGroup") * query("/GPUWorkGroupInvocationCount") ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUMaxThreadsPerSubslice">
      <valueType>int</valueType>
      <valueEval><![CDATA[ query("/GPUEUCountPerSubslice") * query("/GPUMaxEUThreadCount") ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUBarriersPerSublice">
      <valueType>int</valueType>
      <valueEval><![CDATA[ query("/GPUArchitecture") > 13 ? (query("/GPUArchitecture") < 17 ? 64 : 128) : 32 ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUThreadCount">
      <valueType>int</valueType>
      <valueEval><![CDATA[ query("/GPUEUCount") * query("/GPUMaxEUThreadCount") ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUTotalActiveThreads">
      <valueType>int</valueType>
      <valueEval><![CDATA[ (query("/GPUThreadCount") > query("/GPURequestedThreadCount")) ? query("/GPURequestedThreadCount") : query("/GPUThreadCount") ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUTotalActiveThreadsRatio" displayName="%GPUPeakActiveThreadsRatioShort">
      <valueType>double</valueType>
      <valueEval><![CDATA[ query("/GPUTotalActiveThreads") / query("/GPUThreadCount") ]]></valueEval>
      <description>%GPUPeakActiveThreadsRatioDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUThreadsPerWorkGroupRatio" displayName="%GPUPeakThreadsPerWorkGroupRatioShort">
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ query("/GPUThreadsPerWorkGroupDouble") / query("/GPUThreadsPerWorkGroup") ]]></valueEval>
      <description>%GPUPeakThreadsPerWorkGroupRatioDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUPeakThreadsOccupancyBase">
      <valueEval><![CDATA[ query("/GPUTotalActiveThreadsRatio") ]]></valueEval>
      <valueType>ratio</valueType>
    </derivedQuery>
    <derivedQuery id="GPUSLMSizeRequested">
      <valueEval><![CDATA[ query("/GPUComputeLocalMemSize") ? query("/GPUComputeLocalMemSize") : 1 ]]></valueEval>
      <valueType>int</valueType>
    </derivedQuery>
    <derivedQuery id="GPUThreadsWorkgroupSLMLimit">
      <valueEval><![CDATA[ ( (query("/GPUSLMSizeRequested") > 1) ? (query("/GPUSLMSize") / query("/GPUSLMSizeRequested") * query("/GPUThreadsPerWorkGroup")) : query("/GPUMaxThreadsPerSubslice") )]]></valueEval>
      <valueType>double</valueType>
    </derivedQuery>
    <derivedQuery id="GPUPeakSLMOccupancyBase">
      <valueEval><![CDATA[ query("/GPUThreadsWorkgroupSLMLimit") / query("/GPUMaxThreadsPerSubslice")]]></valueEval>
      <valueType>double</valueType>
    </derivedQuery>
    <derivedQuery id="GPUPeakSLMOccupancy">
      <valueEval><![CDATA[ ( (query("/GPUPeakSLMOccupancyBase") > 1) ? 1 : query("/GPUPeakSLMOccupancyBase") )]]></valueEval>
      <description>%GPUPeakSLMOccupancyDescription</description>
      <valueType>ratio</valueType>
    </derivedQuery>
    <derivedQuery id="GPUThreadsWorkgroupBarrierLimit">
      <valueEval><![CDATA[ ( query("/GPUComputeBarrierUsage") ? (query("/GPUBarriersPerSublice") * query("/GPUThreadsPerWorkGroup")) : query("/GPUMaxThreadsPerSubslice") )]]></valueEval>
      <valueType>int</valueType>
    </derivedQuery>
    <derivedQuery id="GPUPeakBarrierOccupancyBase">
      <valueEval><![CDATA[ query("/GPUThreadsWorkgroupBarrierLimit") / query("/GPUMaxThreadsPerSubslice")]]></valueEval>
      <valueType>double</valueType>
    </derivedQuery>
    <derivedQuery id="GPUPeakBarrierOccupancy">
      <valueEval><![CDATA[ ( (query("/GPUPeakBarrierOccupancyBase") > 1) ? 1 : query("/GPUPeakBarrierOccupancyBase") )]]></valueEval>
      <description>%GPUPeakBarrierOccupancyDescription</description>
      <valueType>ratio</valueType>
    </derivedQuery>
   <derivedQuery id="GPUPeakThreadsSLMOccupancy">
      <valueEval><![CDATA[ (query("/GPUPeakSLMOccupancyBase") < query("/GPUTotalActiveThreadsRatio") ? query("/GPUPeakSLMOccupancyBase") : query("/GPUTotalActiveThreadsRatio") )]]></valueEval>
      <valueType>double</valueType>
    </derivedQuery>
   <derivedQuery id="GPUPeakOccupancyBase">
      <valueEval><![CDATA[ (query("/GPUPeakBarrierOccupancy") < query("/GPUPeakThreadsSLMOccupancy") ? query("/GPUPeakBarrierOccupancy") : query("/GPUPeakThreadsSLMOccupancy") )]]></valueEval>
      <description>%GPUPeakOccupancyDescription</description>
      <valueType>double</valueType>
    </derivedQuery>
    <derivedQuery id="GPUPeakOccupancyBaseSummary" displayName="%{$gpuPrefix}PeakOccupancyShort">
      <queryInherit>/GPUPeakOccupancyBase</queryInherit>
      <description>%GPUPeakOccupancyDescription</description>
      <valueType>ratio</valueType>
    </derivedQuery>
    <derivedQuery id="GPUThreadOccupancyWhenBusyInKernelCTWhenLowOccupancy" displayName="%GPUThreadOccupancyWhenBusy">
      <queryInherit>/GPUThreadOccupancyWhenBusyInKernel</queryInherit>
      <valueEval><![CDATA[ (query("/GPUThreadOccupancyWhenBusyIssue") ? query("/GPUThreadOccupancyWhenBusyInKernel/GPUComputeTaskPurpose[%ComputeComputingTaskPurpose]") : $NULL) ]]></valueEval>
      <description>%GPUThreadOccupancyWhenBusyDescriptionInKernel</description>
      <issues>
        <issue>
          <issueEval><![CDATA[ query("/GPUThreadOccupancyWhenBusyInKernelCTWhenLowOccupancy") < 0.9 ]]></issueEval>
          <issueText>%GPUThreadOccupancyWhenBusyIssueInKernelText</issueText>
        </issue>
      </issues>
    </derivedQuery>
    <derivedQuery id="GPUPeakThreadsPerWorkGroupRatioWhenLowOccupancy" displayName="%GPUPeakThreadsPerWorkGroupRatioShort">
      <queryInherit>/GPUThreadsPerWorkGroupRatio</queryInherit>
      <valueEval><![CDATA[ (query("/GPUThreadOccupancyWhenBusyIssue") ? query("/GPUThreadsPerWorkGroupRatio") : $NULL) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUPeakActiveThreadsRatioWhenLowOccupancy" displayName="%GPUPeakActiveThreadsRatioShort">
      <queryInherit>/GPUTotalActiveThreadsRatio</queryInherit>
      <valueEval><![CDATA[ (query("/GPUThreadOccupancyWhenBusyIssue") ? query("/GPUTotalActiveThreadsRatio") : $NULL) ]]></valueEval>
      <valueType>ratio</valueType>
    </derivedQuery>
    <derivedQuery id="GPUPeakActiveThreadsOptimalGlobalSize">
      <queryInherit>/GPUThreadCount</queryInherit>
      <valueEval><![CDATA[ query("/GPUThreadCount") * query("/GPUComputeSimdWidth")  ]]></valueEval>
      <valueType>int</valueType>
    </derivedQuery>
    <derivedQuery id="GPUPeakActiveThreadsRatioWhenLowOccupancyParameterized">
      <queryInherit>/GPUPeakActiveThreadsRatioWhenLowOccupancy</queryInherit>
      <xsl:variable name="recommendation">
        "With a Global Size of " + s#query("/GPUComputeGlobalDim") + " working items, you can occupy " + c#query("/GPUTotalActiveThreads") + " of " + c#query("/GPUThreadCount") + " thread slots."
      </xsl:variable>
      <xsl:variable name="optimum">
        " The optimal number of working items is " + c#query("/GPUPeakActiveThreadsOptimalGlobalSize" )+ "."
      </xsl:variable>
      <displayEval>
        <xsl:text>(query("/GPUPeakActiveThreadsRatioWhenLowOccupancy")  == 1) ? (</xsl:text><xsl:value-of select="$recommendation"/><xsl:text>) : (</xsl:text><xsl:value-of select="$recommendation"/><xsl:text>+</xsl:text><xsl:value-of select="$optimum"/><xsl:text>)</xsl:text>
      </displayEval>
      <issues>
        <issue>
          <issueEval><![CDATA[ query("/GPUPeakActiveThreadsRatioWhenLowOccupancy") < 0.9 ]]></issueEval>
          <issueText>stub</issueText>
        </issue>
      </issues>
      <valueType>string</valueType>
    </derivedQuery>
    <derivedQuery id="GPUPeakSLMOptimalSLMSize">
      <queryInherit>/GPUSLMSize</queryInherit>
      <valueEval><![CDATA[ query("/GPUSLMSize") / query("/GPUMaxThreadsPerSubslice") * query("/GPUThreadsPerWorkGroup")  ]]></valueEval>
      <valueType>int</valueType>
    </derivedQuery>
    <derivedQuery id="GPUPeakSLMOccupancyWhenLowOccupancy" displayName="%GPUPeakSLMOccupancyShort">
      <queryInherit>/GPUPeakSLMOccupancy</queryInherit>
      <valueEval><![CDATA[ (query("/GPUThreadOccupancyWhenBusyIssue") ? query("/GPUPeakSLMOccupancy") : $NULL) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUPeakSLMOccupancyWhenLowOccupancyParameterized">
      <queryInherit>/GPUPeakSLMOccupancyWhenLowOccupancy</queryInherit>
      <xsl:variable name="recommendation">
        "With an SLM per workgroup size of " + c#query("/GPUComputeLocalMemSize") + " bytes, you can occupy " + c#query("/GPUThreadsWorkgroupSLMLimit") + " of " + c#query("/GPUMaxThreadsPerSubslice") + " thread slots on a subslice."
      </xsl:variable>
      <xsl:variable name="optimum">
        " The optimal SLM size is " + c#query("/GPUPeakSLMOptimalSLMSize") + " bytes."
      </xsl:variable>
      <displayEval>
        <xsl:text>(query("/GPUPeakSLMOccupancyWhenLowOccupancy")  == 1) ? (</xsl:text><xsl:value-of select="$recommendation"/><xsl:text>) : (</xsl:text><xsl:value-of select="$recommendation"/><xsl:text>+</xsl:text><xsl:value-of select="$optimum"/><xsl:text>)</xsl:text>
      </displayEval>
      <issues>
        <issue>
          <issueEval><![CDATA[ query("/GPUPeakSLMOccupancyWhenLowOccupancy") < 0.9 ]]></issueEval>
          <issueText>stub</issueText>
        </issue>
      </issues>
      <valueType>string</valueType>
    </derivedQuery>
    <derivedQuery id="GPUPeakBarrierOccupancyWhenLowOccupancy" displayName="%GPUPeakBarrierOccupancyShort">
      <queryInherit>/GPUPeakBarrierOccupancy</queryInherit>
      <valueEval><![CDATA[ (query("/GPUThreadOccupancyWhenBusyIssue") ? query("/GPUPeakBarrierOccupancy") : $NULL) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUPeakBarrierOccupancyWhenLowOccupancyParameterized">
      <queryInherit>/GPUPeakBarrierOccupancyWhenLowOccupancy</queryInherit>
      <issues>
        <issue>
          <issueEval><![CDATA[ query("/GPUPeakBarrierOccupancyWhenLowOccupancy") < 0.9 ]]></issueEval>
          <issueText>stub</issueText>
        </issue>
      </issues>
      <displayEval><![CDATA[ "With barrier synchronization, you can occupy " + c#query("/GPUThreadsWorkgroupBarrierLimit") + " of " + c#query("/GPUMaxThreadsPerSubslice") + " thread slots on a subslice."]]></displayEval>
    </derivedQuery>
    <derivedQuery id="GPUPeakOccupancyWhenLowOccupancy" displayName="%{$gpuPrefix}PeakOccupancyShort">
      <queryInherit>/GPUPeakOccupancyBase</queryInherit>
      <valueEval><![CDATA[ (query("/GPUThreadOccupancyWhenBusyIssue") ? query("/GPUPeakOccupancyBase") : $NULL) ]]></valueEval>
      <valueType>ratio</valueType>
      <issues>
        <issue>
          <issueEval><![CDATA[ query("/GPUPeakOccupancyWhenLowOccupancy") < 0.9 ]]></issueEval>
          <issueText>%GPULowPeakOccupancyIssue</issueText>
        </issue>
      </issues>
    </derivedQuery>
    <derivedQuery id="GPUComputeTaskTimeWhenLowOccupancy" displayName="%GpuComputingTaskTimeTotal">
      <queryInherit>/GPUComputeTaskTimeDerived</queryInherit>
      <valueEval><![CDATA[ (query("/GPUComputeGlobalDimSummary") ? (query("/GPUThreadOccupancyWhenBusyIssue") ? query("/GPUComputeTaskTimeDerived") : $NULL) : ((query("/GPUComputeGlobalDimSummary") == "") ? $NULL : query("/GPUComputeTaskTimeDerived"))) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="IsGPUComputeTaskWithOccupancyIssues" displayName="%GpuComputingTaskTimeTotal">
      <valueEval><![CDATA[ (query("/GPUComputeGlobalDimSummary") ? (query("/GPUThreadOccupancyWhenBusyIssue") ? query("/GPUComputeTaskTimeDerived") : $NULL) : ((query("/GPUComputeGlobalDimSummary") == "") ? $NULL : query("/GPUComputeTaskTimeDerived"))) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUComputeGlobalDimWhenLowOccupancy" displayName="%ComputingGlobalSize">
      <queryInherit>/GPUComputeGlobalDimSummary</queryInherit>
      <valueEval><![CDATA[ (query("/GPUThreadOccupancyWhenBusyIssue") ? query("/GPUComputeGlobalDimSummary") : $NULL) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUComputeLocalDimWhenLowOccupancy" displayName="%ComputingLocalSize">
      <queryInherit>/GPUComputeLocalDimSummary</queryInherit>
      <valueEval><![CDATA[ (query("/GPUThreadOccupancyWhenBusyIssue") ? query("/GPUComputeLocalDimSummary") : $NULL) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUComputeSimdWidthWhenLowOccupancy" displayName="%ComputingSimdWidth">
      <queryInherit>/GPUComputeSimdWidthSummary</queryInherit>
      <valueEval><![CDATA[ (query("/GPUThreadOccupancyWhenBusyIssue") ? query("/GPUComputeSimdWidthSummary") : $NULL) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUThreadOccupancyExtWhenBusyInKernelCTWhenLowOccupancy" displayName="%GPUThreadOccupancyWhenBusy">
      <queryInherit>/GPUThreadOccupancyExtWhenBusyInKernel</queryInherit>
      <valueEval><![CDATA[ (query("/GPUThreadOccupancyExtWhenBusyIssue") ? query("/GPUThreadOccupancyExtWhenBusyInKernel/GPUComputeTaskPurpose[%ComputeComputingTaskPurpose]") : $NULL) ]]></valueEval>
      <description>%GPUThreadOccupancyWhenBusyDescriptionInKernel</description>
      <issues>
        <issue>
          <issueEval><![CDATA[ query("/GPUThreadOccupancyExtWhenBusyInKernelCTWhenLowOccupancy") < 0.9 ]]></issueEval>
          <issueText>%GPUThreadOccupancyWhenBusyIssueInKernelText</issueText>
        </issue>
      </issues>
    </derivedQuery>
    <derivedQuery id="GPUPeakThreadsPerWorkGroupRatioExtWhenLowOccupancy" displayName="%GPUPeakThreadsPerWorkGroupRatioShort">
      <queryInherit>/GPUThreadsPerWorkGroupRatio</queryInherit>
      <valueEval><![CDATA[ (query("/GPUThreadOccupancyExtWhenBusyIssue") ? query("/GPUThreadsPerWorkGroupRatio") : $NULL) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUPeakActiveThreadsRatioExtWhenLowOccupancy" displayName="%GPUPeakActiveThreadsRatioShort">
      <queryInherit>/GPUTotalActiveThreadsRatio</queryInherit>
      <valueEval><![CDATA[ (query("/GPUThreadOccupancyExtWhenBusyIssue") ? query("/GPUTotalActiveThreadsRatio") : $NULL) ]]></valueEval>
      <valueType>ratio</valueType>
    </derivedQuery>
    <derivedQuery id="GPUPeakActiveThreadsRatioExtWhenLowOccupancyParameterized">
      <queryInherit>/GPUPeakActiveThreadsRatioExtWhenLowOccupancy</queryInherit>
      <xsl:variable name="recommendation">
        "With a Global Size of " + s#query("/GPUComputeGlobalDim") + " working items, you can occupy " + c#query("/GPUTotalActiveThreads") + " of " + c#query("/GPUThreadCount") + " thread slots."      </xsl:variable>
      <xsl:variable name="optimum">
        " The optimal number of working items is " + c#query("/GPUPeakActiveThreadsOptimalGlobalSize" )+ "."
      </xsl:variable>
      <displayEval>
        <xsl:text>(query("/GPUPeakActiveThreadsRatioExtWhenLowOccupancy")  == 1) ? (</xsl:text><xsl:value-of select="$recommendation"/><xsl:text>) : (</xsl:text><xsl:value-of select="$recommendation"/><xsl:text>+</xsl:text><xsl:value-of select="$optimum"/><xsl:text>)</xsl:text>
      </displayEval>
      <issues>
        <issue>
          <issueEval><![CDATA[ query("/GPUPeakActiveThreadsRatioExtWhenLowOccupancy") < 0.9 ]]></issueEval>
          <issueText>stub</issueText>
        </issue>
      </issues>
      <valueType>string</valueType>
    </derivedQuery>
    <derivedQuery id="GPUPeakSLMOccupancyExtWhenLowOccupancy" displayName="%GPUPeakSLMOccupancyShort">
      <queryInherit>/GPUPeakSLMOccupancy</queryInherit>
      <valueEval><![CDATA[ (query("/GPUThreadOccupancyExtWhenBusyIssue") ? query("/GPUPeakSLMOccupancy") : $NULL) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUPeakSLMOccupancyExtWhenLowOccupancyParameterized">
      <queryInherit>/GPUPeakSLMOccupancyExtWhenLowOccupancy</queryInherit>
      <xsl:variable name="recommendation">
        "With an SLM per workgroup size of " + c#query("/GPUComputeLocalMemSize") + " bytes, you can occupy " + c#query("/GPUThreadsWorkgroupSLMLimit") + " of " + c#query("/GPUMaxThreadsPerSubslice") + " thread slots on a subslice."      </xsl:variable>
      <xsl:variable name="optimum">
        " The optimal SLM size is " + c#query("/GPUPeakSLMOptimalSLMSize") + " bytes."
      </xsl:variable>
      <displayEval>
        <xsl:text>(query("/GPUPeakSLMOccupancyExtWhenLowOccupancy")  == 1) ? (</xsl:text><xsl:value-of select="$recommendation"/><xsl:text>) : (</xsl:text><xsl:value-of select="$recommendation"/><xsl:text>+</xsl:text><xsl:value-of select="$optimum"/><xsl:text>)</xsl:text>
      </displayEval>
      <issues>
        <issue>
          <issueEval><![CDATA[ query("/GPUPeakSLMOccupancyExtWhenLowOccupancy") < 0.9 ]]></issueEval>
          <issueText>stub</issueText>
        </issue>
      </issues>
      <valueType>string</valueType>
    </derivedQuery>
    <derivedQuery id="GPUPeakBarrierOccupancyExtWhenLowOccupancy" displayName="%GPUPeakBarrierOccupancyShort">
      <queryInherit>/GPUPeakBarrierOccupancy</queryInherit>
      <valueEval><![CDATA[ (query("/GPUThreadOccupancyExtWhenBusyIssue") ? query("/GPUPeakBarrierOccupancy") : $NULL) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUPeakBarrierOccupancyExtWhenLowOccupancyParameterized">
      <queryInherit>/GPUPeakBarrierOccupancyExtWhenLowOccupancy</queryInherit>
      <issues>
        <issue>
          <issueEval><![CDATA[ query("/GPUPeakBarrierOccupancyExtWhenLowOccupancy") < 0.9 ]]></issueEval>
          <issueText>stub</issueText>
        </issue>
      </issues>
      <displayEval><![CDATA[ "With barrier synchronization, you can occupy " + c#query("/GPUThreadsWorkgroupBarrierLimit") + " of " + c#query("/GPUMaxThreadsPerSubslice") + " thread slots on a subslice."]]></displayEval>
    </derivedQuery>
    <derivedQuery id="GPUPeakOccupancyExtWhenLowOccupancy" displayName="%{$gpuPrefix}PeakOccupancyShort">
      <queryInherit>/GPUPeakOccupancyBase</queryInherit>
      <valueEval><![CDATA[ (query("/GPUThreadOccupancyExtWhenBusyIssue") ? query("/GPUPeakOccupancyBase") : $NULL) ]]></valueEval>
      <valueType>ratio</valueType>
      <issues>
        <issue>
          <issueEval><![CDATA[ query("/GPUPeakOccupancyExtWhenLowOccupancy") < 0.9 ]]></issueEval>
          <issueText>%GPULowPeakOccupancyIssue</issueText>
        </issue>
      </issues>
    </derivedQuery>
    <derivedQuery id="GPUComputeTaskTimeExtWhenLowOccupancy" displayName="%GpuComputingTaskTimeTotal">
      <queryInherit>/GPUComputeTaskTimeDerived</queryInherit>
      <valueEval><![CDATA[ (query("/GPUComputeGlobalDimSummary") ? (query("/GPUThreadOccupancyExtWhenBusyIssue") ? query("/GPUComputeTaskTimeDerived") : $NULL) : ((query("/GPUComputeGlobalDimSummary") == "") ? $NULL : query("/GPUComputeTaskTimeDerived"))) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="IsGPUComputeTaskExtWithOccupancyIssues" displayName="%GpuComputingTaskTimeTotal">
      <valueEval><![CDATA[ (query("/GPUComputeGlobalDimSummary") ? (query("/GPUThreadOccupancyExtWhenBusyIssue") ? query("/GPUComputeTaskTimeDerived") : $NULL) : ((query("/GPUComputeGlobalDimSummary") == "") ? $NULL : query("/GPUComputeTaskTimeDerived"))) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUComputeGlobalDimExtWhenLowOccupancy" displayName="%ComputingGlobalSize">
      <queryInherit>/GPUComputeGlobalDimSummary</queryInherit>
      <valueEval><![CDATA[ (query("/GPUThreadOccupancyExtWhenBusyIssue") ? query("/GPUComputeGlobalDimSummary") : $NULL) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUComputeLocalDimExtWhenLowOccupancy" displayName="%ComputingLocalSize">
      <queryInherit>/GPUComputeLocalDimSummary</queryInherit>
      <valueEval><![CDATA[ (query("/GPUThreadOccupancyExtWhenBusyIssue") ? query("/GPUComputeLocalDimSummary") : $NULL) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUComputeSimdWidthExtWhenLowOccupancy" displayName="%ComputingSimdWidth">
      <queryInherit>/GPUComputeSimdWidthSummary</queryInherit>
      <valueEval><![CDATA[ (query("/GPUThreadOccupancyExtWhenBusyIssue") ? query("/GPUComputeSimdWidthSummary") : $NULL) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUComputeTaskTimeWhenSamplerOverutilized" displayName="%GpuComputingTaskTimeTotal">
      <queryInherit>/GPUComputeTaskTimeDerived</queryInherit>
      <valueEval><![CDATA[ (query("/GPUComputeGlobalDimSummary") ? (query("/GPUSamplerBusyWhenBusyIssue") ? query("/GPUComputeTaskTimeDerived") : $NULL) : ((query("/GPUComputeGlobalDimSummary") == "") ? $NULL : query("/GPUComputeTaskTimeDerived"))) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUL3BandwidthWhenBusy" displayName="%GpuL3Bound">
      <valueType>ratio</valueType>
      <xsl:choose>
        <xsl:when test="fnc:is_universal_collector_in_multirun_mode()">
          <valueEval><![CDATA[ (query("/GPUL3ShaderBDWMaxRatio/ConditionalL3ShaderThroughputSamplesExist[%True]")) ]]></valueEval>
        </xsl:when>
        <xsl:otherwise>
          <valueEval><![CDATA[ (query("/GPUL3ShaderBDWMaxRatio/ConditionalGPUBusyData[%True]")) ]]></valueEval>
        </xsl:otherwise>
      </xsl:choose>
      <issueEval><![CDATA[ query("/GPUL3BandwidthWhenBusyIssue") ]]></issueEval>
      <confidenceEval><![CDATA[ (query("/GPUSampleCount/GPUEventType[L3ShaderThroughput]") > 5) ]]></confidenceEval>
      <description>%GpuL3BoundDescription</description>
      <issueText><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>L3BoundIssueText</xsl:text></issueText>
      <confidenceText>%GPUMetricConfidenceText</confidenceText>
      <unitOfMeasureQueryId>GPUPeakForUnit</unitOfMeasureQueryId>
    </derivedQuery>
    <derivedQuery id="GPUL3ReadBandwidthWhenBusy" displayName="%GpuL3Bound">
      <valueType>ratio</valueType>
      <xsl:choose>
        <xsl:when test="fnc:is_universal_collector_in_multirun_mode()">
          <valueEval><![CDATA[ (query("/GPUL3ShaderReadBDWMaxRatio/ConditionalL3_BYTE_READSamplesExist[%True]")) ]]></valueEval>
        </xsl:when>
        <xsl:otherwise>
          <valueEval><![CDATA[ (query("/GPUL3ShaderReadBDWMaxRatio/ConditionalGPUBusyData[%True]")) ]]></valueEval>
        </xsl:otherwise>
      </xsl:choose>
      <issueEval><![CDATA[ query("/GPUL3ReadBandwidthWhenBusyIssue") ]]></issueEval>
      <confidenceEval><![CDATA[ (query("/GPUSampleCount/GPUEventType[L3_BYTE_READ]") > 5) ]]></confidenceEval>
      <description>%GpuL3BoundDescription</description>
      <issueText><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>L3BoundIssueText</xsl:text></issueText>
      <confidenceText>%GPUMetricConfidenceText</confidenceText>
      <unitOfMeasureQueryId>GPUPeakForUnit</unitOfMeasureQueryId>
    </derivedQuery>
    <derivedQuery id="GPUL3WriteBandwidthWhenBusy" displayName="%GpuL3Bound">
      <valueType>ratio</valueType>
      <xsl:choose>
        <xsl:when test="fnc:is_universal_collector_in_multirun_mode()">
          <valueEval><![CDATA[ (query("/GPUL3ShaderWriteBDWMaxRatio/ConditionalL3_BYTE_WRITESamplesExist[%True]")) ]]></valueEval>
        </xsl:when>
        <xsl:otherwise>
          <valueEval><![CDATA[ (query("/GPUL3ShaderWriteBDWMaxRatio/ConditionalGPUBusyData[%True]")) ]]></valueEval>
        </xsl:otherwise>
      </xsl:choose>
      <issueEval><![CDATA[ query("/GPUL3WriteBandwidthWhenBusyIssue") ]]></issueEval>
      <confidenceEval><![CDATA[ (query("/GPUSampleCount/GPUEventType[L3_BYTE_WRITE]") > 5) ]]></confidenceEval>
      <description>%GpuL3BoundDescription</description>
      <issueText><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>L3BoundIssueText</xsl:text></issueText>
      <confidenceText>%GPUMetricConfidenceText</confidenceText>
      <unitOfMeasureQueryId>GPUPeakForUnit</unitOfMeasureQueryId>
    </derivedQuery>
    <derivedQuery id="GPUL3ReadWriteBandwidthWhenBusy" displayName="%GpuL3Bound">
      <valueType>ratio</valueType>
      <xsl:choose>
        <xsl:when test="fnc:is_universal_collector_in_multirun_mode()">
          <valueEval><![CDATA[ (query("/GPUL3ShaderReadWriteBDWMaxRatio/ConditionalL3_BYTE_WRITESamplesExist[%True]")) ]]></valueEval>
        </xsl:when>
        <xsl:otherwise>
          <valueEval><![CDATA[ (query("/GPUL3ShaderReadWriteBDWMaxRatio/ConditionalGPUBusyData[%True]")) ]]></valueEval>
        </xsl:otherwise>
      </xsl:choose>
      <issueEval><![CDATA[ query("/GPUL3ReadWriteBandwidthWhenBusyIssue") ]]></issueEval>
      <confidenceEval><![CDATA[ (query("/GPUSampleCount/GPUEventType[L3_BYTE_WRITE]") > 5) ]]></confidenceEval>
      <description>%GpuL3BoundDescription</description>
      <issueText><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>L3BoundIssueText</xsl:text></issueText>
      <confidenceText>%GPUMetricConfidenceText</confidenceText>
      <unitOfMeasureQueryId>GPUPeakForUnit</unitOfMeasureQueryId>
    </derivedQuery>
    <derivedQuery id="GPUL3ReadWriteBandwidthWhenBusyAggregation">
      <queryInherit>/GPUL3ReadWriteBandwidthWhenBusy</queryInherit>
    </derivedQuery>
    <derivedQuery id="GPUL3BandwidthWhenBusyInKernel" displayName="%GpuL3Bound">
      <valueType>ratio</valueType>
      <xsl:choose>
        <xsl:when test="fnc:is_universal_collector_in_multirun_mode()">
          <valueEval><![CDATA[ (query("/GPUL3ShaderBDWMaxRatio/ConditionalL3ShaderThroughputSamplesExist[%True]")) ]]></valueEval>
        </xsl:when>
        <xsl:otherwise>
          <valueEval><![CDATA[ (query("/GPUL3ShaderBDWMaxRatio/ConditionalGPUBusyData[%True]")) ]]></valueEval>
        </xsl:otherwise>
      </xsl:choose>
      <issueEval><![CDATA[ query("/GPUL3BandwidthWhenBusyIssue") ]]></issueEval>
      <description>%GpuL3BoundDescriptionInKernel</description>
      <issueText><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>L3BoundIssueText</xsl:text></issueText>
      <confidenceEval><![CDATA[ (query("/GPUSampleCount/GPUEventType[L3ShaderThroughput]") > 5) ]]></confidenceEval>
      <confidenceText>%GPUMetricConfidenceText</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUL3ReadBandwidthWhenBusyInKernel" displayName="%GpuL3Bound">
      <valueType>ratio</valueType>
      <xsl:choose>
        <xsl:when test="fnc:is_universal_collector_in_multirun_mode()">
          <valueEval><![CDATA[ (query("/GPUL3ShaderReadBDWMaxRatio/ConditionalL3_BYTE_READSamplesExist[%True]")) ]]></valueEval>
        </xsl:when>
        <xsl:otherwise>
          <valueEval><![CDATA[ (query("/GPUL3ShaderReadBDWMaxRatio/ConditionalGPUBusyData[%True]")) ]]></valueEval>
        </xsl:otherwise>
      </xsl:choose>
      <issueEval><![CDATA[ query("/GPUL3ReadBandwidthWhenBusyIssue") ]]></issueEval>
      <description>%GpuL3BoundDescriptionInKernel</description>
      <issueText><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>L3BoundIssueText</xsl:text></issueText>
      <confidenceEval><![CDATA[ (query("/GPUSampleCount/GPUEventType[L3_BYTE_READ]") > 5) ]]></confidenceEval>
      <confidenceText>%GPUMetricConfidenceText</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUL3WriteBandwidthWhenBusyInKernel" displayName="%GpuL3Bound">
      <valueType>ratio</valueType>
      <xsl:choose>
        <xsl:when test="fnc:is_universal_collector_in_multirun_mode()">
          <valueEval><![CDATA[ (query("/GPUL3ShaderWriteBDWMaxRatio/ConditionalL3_BYTE_WRITESamplesExist[%True]")) ]]></valueEval>
        </xsl:when>
        <xsl:otherwise>
          <valueEval><![CDATA[ (query("/GPUL3ShaderWriteBDWMaxRatio/ConditionalGPUBusyData[%True]")) ]]></valueEval>
        </xsl:otherwise>
      </xsl:choose>
      <issueEval><![CDATA[ query("/GPUL3WriteBandwidthWhenBusyIssue") ]]></issueEval>
      <description>%GpuL3BoundDescriptionInKernel</description>
      <issueText><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>L3BoundIssueText</xsl:text></issueText>
      <confidenceEval><![CDATA[ (query("/GPUSampleCount/GPUEventType[L3_BYTE_WRITE]") > 5) ]]></confidenceEval>
      <confidenceText>%GPUMetricConfidenceText</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUL3ReadWriteBandwidthWhenBusyInKernel" displayName="%GpuL3Bound">
      <valueType>ratio</valueType>
      <xsl:choose>
        <xsl:when test="fnc:is_universal_collector_in_multirun_mode()">
          <valueEval><![CDATA[ (query("/GPUL3ShaderReadWriteBDWMaxRatio/ConditionalL3_BYTE_WRITESamplesExist[%True]")) ]]></valueEval>
        </xsl:when>
        <xsl:otherwise>
          <valueEval><![CDATA[ (query("/GPUL3ShaderReadWriteBDWMaxRatio/ConditionalGPUBusyData[%True]")) ]]></valueEval>
        </xsl:otherwise>
      </xsl:choose>
      <issueEval><![CDATA[ query("/GPUL3ReadWriteBandwidthWhenBusyIssue") ]]></issueEval>
      <description>%GpuL3BoundDescriptionInKernel</description>
      <issueText><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>L3BoundIssueText</xsl:text></issueText>
      <confidenceEval><![CDATA[ (query("/GPUSampleCount/GPUEventType[L3_BYTE_WRITE]") > 5) ]]></confidenceEval>
      <confidenceText>%GPUMetricConfidenceText</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUL3BandwidthWhenBusyIssue">
      <valueType>bool</valueType>
      <valueEval><![CDATA[ ((query("/GPUL3BandwidthWhenBusy") > 0.6) && (query("/GPUEUNotActiveBase") > 0.2)) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUL3ReadBandwidthWhenBusyIssue">
      <valueType>bool</valueType>
      <valueEval><![CDATA[ ((query("/GPUL3ReadBandwidthWhenBusy") > 0.6) && (query("/GPUEUNotActiveBase") > 0.2)) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUL3WriteBandwidthWhenBusyIssue">
      <valueType>bool</valueType>
      <valueEval><![CDATA[ ((query("/GPUL3WriteBandwidthWhenBusy") > 0.6) && (query("/GPUEUNotActiveBase") > 0.2)) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUL3ReadWriteBandwidthWhenBusyIssue">
      <valueType>bool</valueType>
      <valueEval><![CDATA[ ((query("/GPUL3ReadWriteBandwidthWhenBusy") > 0.6) && (query("/GPUEUNotActiveBase") > 0.2)) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUFPUIssue">
      <valueType>bool</valueType>
      <valueEval><![CDATA[ ((query("/GPUEuFpuBothActive") > 0.8) && (query("/GPUEUNotActiveBase") < 0.2)) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUFPUEmIssue">
      <valueType>bool</valueType>
      <valueEval><![CDATA[ ((query("/GPUEuFpuEmActive") > 0.8) && (query("/GPUEUNotActiveBase") < 0.2)) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUFPUSysIssue">
      <valueType>bool</valueType>
      <valueEval><![CDATA[ ((query("/GPUEuFpuSysActive") > 0.8) && (query("/GPUEUNotActiveBase") < 0.2)) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUComputeTaskTimeWhenHighL3Bandwidth" displayName="%GpuComputingTaskTimeTotal">
      <queryInherit>/GPUComputeTaskTimeDerived</queryInherit>
      <valueEval><![CDATA[ (query("/GPUComputeGlobalDimSummary") ? (query("/GPUL3BandwidthWhenBusyIssue") ? query("/GPUComputeTaskTimeDerived") : $NULL) : ((query("/GPUComputeGlobalDimSummary") == "") ? $NULL : query("/GPUComputeTaskTimeDerived"))) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUComputeTaskTimeWhenHighL3ReadWriteBandwidth" displayName="%GpuComputingTaskTimeTotal">
      <queryInherit>/GPUComputeTaskTimeDerived</queryInherit>
      <valueEval><![CDATA[ (query("/GPUComputeGlobalDimSummary") ? (query("/GPUL3ReadWriteBandwidthWhenBusyIssue") ? query("/GPUComputeTaskTimeDerived") : $NULL) : ((query("/GPUComputeGlobalDimSummary") == "") ? $NULL : query("/GPUComputeTaskTimeDerived"))) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUComputeTaskTimeWhenGPUEuFpuBothActive" displayName="%GpuComputingTaskTimeTotal">
      <queryInherit>/GPUComputeTaskTimeDerived</queryInherit>
      <valueEval><![CDATA[ (query("/GPUComputeGlobalDimSummary") ? (query("/GPUFPUIssue") ? query("/GPUComputeTaskTimeDerived") : $NULL) : ((query("/GPUComputeGlobalDimSummary") == "") ? $NULL : query("/GPUComputeTaskTimeDerived"))) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUComputeTaskTimeWhenGPUEuFpuEmActive" displayName="%GpuComputingTaskTimeTotal">
      <queryInherit>/GPUComputeTaskTimeDerived</queryInherit>
      <valueEval><![CDATA[ (query("/GPUComputeGlobalDimSummary") ? (query("/GPUFPUEmIssue") ? query("/GPUComputeTaskTimeDerived") : $NULL) : ((query("/GPUComputeGlobalDimSummary") == "") ? $NULL : query("/GPUComputeTaskTimeDerived"))) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUComputeTaskTimeWhenGPUEuFpuSysActive" displayName="%GpuComputingTaskTimeTotal">
      <queryInherit>/GPUComputeTaskTimeDerived</queryInherit>
      <valueEval><![CDATA[ (query("/GPUComputeGlobalDimSummary") ? (query("/GPUFPUSysIssue") ? query("/GPUComputeTaskTimeDerived") : $NULL) : ((query("/GPUComputeGlobalDimSummary") == "") ? $NULL : query("/GPUComputeTaskTimeDerived"))) ]]></valueEval>
    </derivedQuery>
      <derivedQuery displayName="%GPUElapsedTimeForUnit" id="GPUElapsedTimeForUnit">
    </derivedQuery>
    <derivedQuery displayName="%GPUElapsedTimeWhenBusyForUnit" id="GPUElapsedTimeWhenBusyForUnit">
    </derivedQuery>
    <derivedQuery displayName="%GPUPeakForUnit" id="GPUPeakForUnit">
    </derivedQuery>
    <derivedQuery id="GPUDRAMBandwidthBoundUncore">
      <queryInherit>/GeMetricBasePercentage</queryInherit>
      <valueEval><![CDATA[ ( query("/HighDRAMBandwidthUtilizationElapsedTime") / query("/GPUElapsedTime") ) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUDRAMBoundWhenBusy" displayName="%GPUDRAMBoundWhenBusy">
      <valueEval><![CDATA[ (query("/GPUDRAMBandwidthBoundUncore/ConditionalGPUBusyData[%True]")) ]]></valueEval>
      <useGlobalGrouper>true</useGlobalGrouper>
      <issueEval><![CDATA[ query("/GPUDRAMBoundWhenBusyIssue") ]]></issueEval>
      <description>%GPUDRAMBoundWhenBusyDescription</description>
      <issueText>%GPUDRAMBoundWhenBusyIssueText</issueText>
      <valueType>ratio</valueType>
      <unitOfMeasureQueryId>GPUElapsedTimeForUnit</unitOfMeasureQueryId>
    </derivedQuery>
    <derivedQuery id="GPUDRAMBoundWhenBusyInKernel" displayName="%GPUDRAMBoundWhenBusy">
      <valueEval><![CDATA[ (query("/GPUDRAMBandwidthBoundUncore/ConditionalGPUBusyData[%True]")) ]]></valueEval>
      <useGlobalGrouper>true</useGlobalGrouper>
      <issueEval><![CDATA[ query("/GPUDRAMBoundWhenBusyIssue") ]]></issueEval>
      <description>%GPUDRAMBoundWhenBusyDescription</description>
      <issueText>%GPUDRAMBoundWhenBusyIssueText</issueText>
      <valueType>ratio</valueType>
    </derivedQuery>
    <derivedQuery id="GPUDRAMBoundWhenBusyIssue">
      <valueType>bool</valueType>
      <valueEval><![CDATA[ ((query("/GPUDRAMBoundWhenBusy") > 0.1) && (query("/GPUEUNotActiveBase") > 0.2)) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUComputeTaskTimeWhenHighDRAMBandwidth" displayName="%GpuComputingTaskTimeTotal">
      <queryInherit>/GPUComputeTaskTimeDerived</queryInherit>
      <valueEval><![CDATA[ (query("/GPUComputeGlobalDimSummary") ? (query("/GPUDRAMBoundWhenBusyIssue") ? query("/GPUComputeTaskTimeDerived") : $NULL) : ((query("/GPUComputeGlobalDimSummary") == "") ? $NULL : query("/GPUComputeTaskTimeDerived"))) ]]></valueEval>
    </derivedQuery>
    <infoQuery id="GPUCoreFrequency" displayName="%GPUCoreFrequency">
      <valueType>frequency</valueType>
      <dbPath>gpu_freq_data::dd_gpu_freq</dbPath>
      <displayDbPathSuffix>freq_hz</displayDbPathSuffix>
      <description>%GPUCoreFrequencyDescription</description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>20,20,20</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <instanceBandTableForDataQuery>dd_gpu_node</instanceBandTableForDataQuery>
      </displayAttributes>
    </infoQuery>
    <infoQuery id="GPUMediaFrequency" displayName="%GPUMediaFrequency">
      <valueType>frequency</valueType>
      <dbPath>gpu_media_freq_data::dd_gpu_freq</dbPath>
      <displayDbPathSuffix>freq_hz</displayDbPathSuffix>
      <description>%GPUMediaFrequencyDescription</description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>20,20,20</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <instanceBandTableForDataQuery>dd_gpu_node</instanceBandTableForDataQuery>
      </displayAttributes>
    </infoQuery>
    <derivedQuery id="GPUCSThreadIssuedCountBase" displayName="%GPUCSThreadIssuedCount">
      <helpKeyword>configs.gpucsthreadissuedcount_gpucsthreadissuedcountdescription</helpKeyword>
      <queryInherit>/GPUCsThreadsMetric</queryInherit>
      <valueType>count</valueType>
      <description><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>CSThreadIssuedCountDescription</xsl:text></description>
    </derivedQuery>
    <derivedQuery id="GPUCSThreadIssuedCountIssue">
      <valueType>bool</valueType>
      <valueEval><![CDATA[ ( (query("/GPUCSThreadIssuedCount") / (query("/GPUComputeTaskTime") ) ) > 20000000 ) * (query("/GPUEUStalled") > 0.1) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUCSThreadIssuedCount" displayName="%GPUCSThreadIssuedCount">
      <queryInherit>/GPUCSThreadIssuedCountBase</queryInherit>
        <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
          <valueEval><![CDATA[ ( query("/GPUCSThreadIssuedCountBase/ConditionalCsThreadsSamplesExist[%True]") ) ]]></valueEval>
        </xsl:if>
      <issueEval><![CDATA[ query("/GPUCSThreadIssuedCountIssue") ]]></issueEval>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUCSThreadIssuedBase" displayName="%GPUCSThreadIssued">
      <helpKeyword>configs.gpucsthreadissued_gpucsthreadissueddescription</helpKeyword>
      <valueType>count</valueType>
      <valueEval><![CDATA[ query("/GPUCSThreadIssuedCountBase") ]]></valueEval>
      <description><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>CSThreadIssuedDescription</xsl:text></description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>20,20,20</timelineGraphColor>
        <timeScalems>1000</timeScalems>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <timelineValueFormat>LargeNumber</timelineValueFormat>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUCSThreadIssuedRateIssue">
      <valueType>bool</valueType>
      <valueEval><![CDATA[ ( (query("/GPUCSThreadIssuedCount") / (query("/GPUElapsedTime") ) ) > 20000000 ) * (query("/GPUEUStalled") > 0.1) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUCSThreadIssuedRate" displayName="%GPUCSThreadIssued">
      <helpKeyword>configs.gpucsthreadissued_gpucsthreadissueddescription</helpKeyword>
      <valueType>double</valueType>
      <valueEval><![CDATA[ ( query("/GPUCSThreadIssuedCount") / (query("/GPUElapsedTime") ) ) ]]></valueEval>
      <description><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>CSThreadIssuedDescription</xsl:text></description>
      <issueEval><![CDATA[ query("/GPUCSThreadIssuedRateIssue") ]]></issueEval>
      <issueText>%GPUCSThreadIssuedIssueText</issueText>
      <confidenceText>%NotEnoughSamples</confidenceText>
      <displayAttributes>
        <selfFormat>LargeNumber</selfFormat>
        <totalFormat>LargeNumber</totalFormat>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUGPGPUDispatchBase" displayName="%GPUGPGPUDispatch">
      <helpKeyword>configs.gpugpgpudispatch_gpugpgpudispatchdescription</helpKeyword>
      <valueType>ratio</valueType>
      <queryInherit>/GPUGPGPU_DISPATCHMetric</queryInherit>
      <description>%GPUGPGPUDispatchDescription</description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>20,20,20</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <boolean:vtNullAsZero>false</boolean:vtNullAsZero>
      </displayAttributes>
      <maxEval>1</maxEval>
    </derivedQuery>
    <derivedQuery id="GPUGPGPUDispatch" displayName="%GPUGPGPUDispatch">
      <queryInherit>/GPUGPGPUDispatchBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUGPGPUDispatchBase/ConditionalGPGPU_DISPATCHSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <joinGroupInstanceDbTable>gpu_compute_task_data</joinGroupInstanceDbTable>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUSamplerBusyBase" displayName="%GPUSamplerBusy">
      <helpKeyword>configs.gpusamplerbusy_gpusamplerbusydescription</helpKeyword>
      <valueType>ratio</valueType>
      <queryInherit>/GPUSamplersBusyMetric</queryInherit>
      <description>%GPUSamplerBusyDescription</description>
      <confidenceEval><![CDATA[ (query("/GPUSampleCount/GPUEventType[SAMPLER_ACTIVE]") > 5) ]]></confidenceEval>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>60,60,60</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <diagramObjectId>SamplerBusySlot</diagramObjectId>
      </displayAttributes>
      <maxEval>1</maxEval>
    </derivedQuery>
    <derivedQuery id="GPUSamplerBusy" displayName="%GPUSamplerBusy">
      <queryInherit>/GPUSamplerBusyBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUSamplerBusyBase/ConditionalSamplersBusySamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <issueEval><![CDATA[ (query("/GPUSamplerBusy") > 0.98) * (query("/GPUComputeTaskTime") > 0) ]]></issueEval>
      <issueText>%GPUSamplerBusyIssueText</issueText>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUSamplerInputBase" displayName="%GPUSamplerInput">
      <helpKeyword>configs.gpusamplerbusy_gpusamplerinputdescription</helpKeyword>
      <valueType>ratio</valueType>
      <queryInherit>/GPUSAMPLER_INPUT_AVAILABLEMetric</queryInherit>
      <description>%GPUSamplerInputDescription</description>
      <confidenceEval><![CDATA[ (query("/GPUSampleCount/GPUEventType[SAMPLER_INPUT_AVAILABLE]") > 5) ]]></confidenceEval>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>100,10,10</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <diagramObjectId>SamplerInputSlot</diagramObjectId>
      </displayAttributes>
      <maxEval>1</maxEval>
    </derivedQuery>
    <derivedQuery id="GPUSamplerInput" displayName="%GPUSamplerInput">
      <queryInherit>/GPUSamplerInputBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUSamplerInputBase/ConditionalSAMPLER_INPUT_AVAILABLESamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUSamplerOutputBase" displayName="%GPUSamplerOutput">
      <helpKeyword>configs.gpusamplerbusy_gpusamplerouyputdescription</helpKeyword>
      <valueType>ratio</valueType>
      <queryInherit>/GPUSAMPLER_OUTPUT_READYMetric</queryInherit>
      <description>%GPUSamplerOutputDescription</description>
      <confidenceEval><![CDATA[ (query("/GPUSampleCount/GPUEventType[SAMPLER_OUTPUT_READY]") > 5) ]]></confidenceEval>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>10,100,10</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <diagramObjectId>SamplerOutputSlot</diagramObjectId>
      </displayAttributes>
      <maxEval>1</maxEval>
    </derivedQuery>
    <derivedQuery id="GPUSamplerOutput" displayName="%GPUSamplerOutput">
      <queryInherit>/GPUSamplerOutputBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUSamplerOutputBase/ConditionalSAMPLER_OUTPUT_READYSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUSamplerBottleneckBase" displayName="%GPUSamplerBottleneck">
      <helpKeyword>configs.gpusamplerbottleneck_gpusamplerbottleneckdescription</helpKeyword>
      <valueType>ratio</valueType>
      <queryInherit>/GPUSamplerBottleneckMetric</queryInherit>
      <description><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>SamplerBottleneckDescription</xsl:text></description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>170,0,0</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <diagramObjectId>SamplerBottleneckSlot</diagramObjectId>
      </displayAttributes>
      <maxEval>1</maxEval>
    </derivedQuery>
    <derivedQuery id="GPUSamplerBottleneck" displayName="%GPUSamplerBottleneck">
      <queryInherit>/GPUSamplerBottleneckBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUSamplerBottleneckBase/ConditionalSamplerBottleneckSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <issueEval><![CDATA[ (query("/GPUSamplerBottleneck") > 0.01) * (query("/GPUComputeTaskTime") > 0) ]]></issueEval>
      <issueText>%GPUSamplerBottleneckIssueText</issueText>
      <xsl:if test="not (exsl:ctx('gsimClockDuration', 0))">
        <confidenceEval><![CDATA[ (query("/GPUSampleCount/GPUEventType[SamplerBottleneck]") > 5) ]]></confidenceEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUL3SamplerThroughputGB" displayName="%GPUL3SamplerThroughputShort">
      <helpKeyword>configs.gpul3samplerthroughput_gpul3samplerthroughputdescription</helpKeyword>
      <valueType>double</valueType>
      <queryInherit>/GPUL3SamplerThroughputMetric</queryInherit>
      <xsl:if test="exsl:ctx('gsimClockDuration', 0) > 0">
        <valueEval>
          <![CDATA[ query("/gSimGPUEventCount/gSimGPUEventType[SamplerInputRequests]") * 64 / 1000000000 ]]>
        </valueEval>
      </xsl:if>
      <description>%GPUL3SamplerThroughputDescription</description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>207,236,183</timelineGraphColor>
        <timeScalems>1000</timeScalems>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUL3SamplerThroughputB" displayName="%GPUL3SamplerThroughputShort">
      <queryInherit>/GPUL3SamplerThroughputGB</queryInherit>
      <valueType>memory</valueType>
      <valueEval>
        <![CDATA[ (query("/GPUL3SamplerThroughputGB") * 1000000000) ]]>
      </valueEval>
    </derivedQuery>
    <derivedQuery id="GPUL3SamplerBandwidthBase" displayName="%GPUL3SamplerThroughput">
      <helpKeyword>configs.gpul3samplerthroughput_gpul3samplerthroughputdescription</helpKeyword>
      <valueType>double</valueType>
      <boolean:valueSummable>false</boolean:valueSummable>
      <valueEval><![CDATA[ (query("/GPUL3SamplerThroughputGB") / query("/GPUElapsedTime")) ]]></valueEval>
      <xsl:choose>
        <xsl:when test="exsl:ctx('gsimClockDuration', 0) > 0">
          <description>%GPUL3SamplerThroughputDescriptionGSim</description>
        </xsl:when>
        <xsl:otherwise>
      <description>%GPUL3SamplerThroughputDescription</description>
        </xsl:otherwise>
      </xsl:choose>
    </derivedQuery>
    <derivedQuery id="GPUL3SamplerBandwidth" displayName="%GPUL3SamplerThroughput">
      <queryInherit>/GPUL3SamplerBandwidthBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUL3SamplerBandwidthBase/ConditionalSamplerL1MissesSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
      <percentBases>
        <queryRef>/GPUL3SamplerBDWAbsMax</queryRef>
      </percentBases>
    </derivedQuery>
    <derivedQuery id="GPUL3SamplerBandwidthB" displayName="%GPUL3SamplerThroughputFlex">
      <queryInherit>/GPUL3SamplerBandwidth</queryInherit>
      <valueType>bandwidth</valueType>
      <valueEval>
        <![CDATA[ (query("/GPUL3SamplerBandwidth") * 1000000000) ]]>
      </valueEval>
    </derivedQuery>
    <derivedQuery id="GPUL3SamplerBDWMax" displayName="%GPUL3SamplerThroughputMaxGB">
      <valueType>double</valueType>
      <valueEval><![CDATA[ (query("/GPUL3SamplerThroughputMetricMaxValue") / query("/GPUElapsedTime") / 1000000000 ) ]]></valueEval>
      <description>%"GPUL3SamplerBDWMaxDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUL3SamplerBDWAbsMax" displayName="%GPUL3SamplerThroughputMaxGB">
      <valueType>double</valueType>
      <queryInherit>/GPUL3SamplerThroughputMetricAbsMaxValue</queryInherit>
      <description>%"GPUL3SamplerBDWMaxDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUL3SamplerBDWMaxRatio" displayName="%GPUBDWRatioUniversalName">
      <helpKeyword>configs.gpubdwratiouniversalname_gpubdwratiouniversaldescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ ( query("/GPUL3SamplerBandwidth") / query("/GPUL3SamplerBDWMax") ) ]]></valueEval>
      <description>%GPUBDWRatioUniversalDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUL3SamplerBDWAbsMaxRatio" displayName="%GPUBDWRatioUniversalName">
      <helpKeyword>configs.gpubdwratiouniversalname_gpubdwratiouniversaldescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ ( query("/GPUL3SamplerBandwidth") / query("/GPUL3SamplerBDWAbsMax") ) ]]></valueEval>
      <description>%GPUBDWRatioUniversalDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUSamplerL3ReadGB" displayName="%GPUL3SamplerThroughputShort">
      <helpKeyword>configs.gpul3samplerthroughput_gpul3samplerreaddescription</helpKeyword>
      <valueType>double</valueType>
      <queryInherit>/GPUSAMPLER_L3_BYTE_READMetric</queryInherit>
      <description>%GPUL3SamplerReadDescription</description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>207,236,183</timelineGraphColor>
        <timeScalems>1000</timeScalems>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUSamplerL3ReadB" displayName="%GPUL3SamplerThroughputShort">
      <queryInherit>/GPUSamplerL3ReadGB</queryInherit>
      <valueType>memory</valueType>
      <valueEval>
        <![CDATA[ (query("/GPUSamplerL3ReadGB") * 1000000000) ]]>
      </valueEval>
    </derivedQuery>
    <derivedQuery id="GPUSamplerL3ReadBandwidthBase" displayName="%GPUL3SamplerThroughput">
      <helpKeyword>configs.gpul3samplerthroughput_gpul3samplerreadthroughputdescription</helpKeyword>
      <valueType>double</valueType>
      <boolean:valueSummable>false</boolean:valueSummable>
      <valueEval><![CDATA[ (query("/GPUSamplerL3ReadGB") / query("/GPUElapsedTime")) ]]></valueEval>
      <description>%GPUL3SamplerReadThroughputDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUSamplerL3ReadBandwidth" displayName="%GPUL3SamplerThroughput">
      <queryInherit>/GPUSamplerL3ReadBandwidthBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUSamplerL3ReadBandwidthBase/ConditionalSAMPLER_L3_READSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUSamplerL3ReadBandwidthB" displayName="%GPUL3SamplerThroughputFlex">
      <queryInherit>/GPUSamplerL3ReadBandwidth</queryInherit>
      <valueType>bandwidth</valueType>
      <valueEval>
        <![CDATA[ (query("/GPUSamplerL3ReadBandwidth") * 1000000000) ]]>
      </valueEval>
    </derivedQuery>
    <derivedQuery id="GPUSamplerL3ReadBDWAbsMax" displayName="%GPUL3SamplerThroughputMaxGB">
      <valueType>double</valueType>
      <queryInherit>/GPUSAMPLER_L3_READMetricAbsMaxValue</queryInherit>
      <description>%GPUL3SamplerBDWMaxDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUSamplerL3ReadBDWAbsMaxRatio" displayName="%GPUBDWRatioUniversalName">
      <helpKeyword>configs.gpubdwratiouniversalname_gpubdwratiouniversaldescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ ( query("/GPUSamplerL3ReadBandwidth") / query("/GPUSamplerL3ReadBDWAbsMax") ) ]]></valueEval>
      <description>%GPUBDWRatioUniversalDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUSamplerL1Access" displayName="%GPUSamplerL1Access">
      <valueType>count</valueType>
      <queryInherit>/GPUSAMPLER_TEXTURE_CACHE_ACCESSMetric</queryInherit>
    </derivedQuery>
    <derivedQuery id="GPUSamplerL1Miss" displayName="%GPUSamplerL1Miss">
      <helpKeyword>configs.gpusamplerl1miss_gpusmplerl1missdescription</helpKeyword>
      <valueType>count</valueType>
      <valueEval><![CDATA[ query("/GPUSAMPLER_TEXTURE_CACHE_MISSMetric") ]]></valueEval>
      <description>%GPUSamplerL1MissDescription</description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>47,71,47</timelineGraphColor>
        <timeScalems>1000</timeScalems>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUSamplerL1MissRatioBase" displayName="%GPUSamplerL1MissRatio">
      <helpKeyword>configs.gpusamplerl1missratio_gpusamplerl1missratiodescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ ( query("/GPUSamplerL1Miss") / (query("/GPUSamplerL1Access")) ) ]]></valueEval>
      <description>%GPUSamplerL1MissRatioDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUSamplerL1MissRatio" displayName="%GPUSamplerL1MissRatio">
      <queryInherit>/GPUSamplerL1MissRatioBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUSamplerL1MissRatioBase/ConditionalSAMPLER_TEXTURE_CACHE_MISSSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
    </derivedQuery>
    <derivedQuery id="GPUICacheL3Access" displayName="%GPUICacheL3Access">
      <valueType>count</valueType>
      <queryInherit>/GPUICACHE_L3_READMetric</queryInherit>
    </derivedQuery>
    <derivedQuery id="GPUICacheL3Miss" displayName="%GPUICacheL3Miss">
      <helpKeyword>configs.gpuicachel3miss_gpuicachel3missdescription</helpKeyword>
      <valueType>count</valueType>
      <valueEval><![CDATA[ (query("/GPUICACHE_L3_READMetric") - query("/GPUICACHE_L3_HITMetric"))]]></valueEval>
      <description>%GPUICacheL3MissDescription</description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>47,71,47</timelineGraphColor>
        <timeScalems>1000</timeScalems>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUICacheL3MissRatioBase" displayName="%GPUICacheL3MissRatio">
      <helpKeyword>configs.gpuicachel3missratio_gpuicachel3missratiodescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ ( query("/GPUICacheL3Miss") / (query("/GPUICacheL3Access")) ) ]]></valueEval>
      <description>%GPUICacheL3MissRatioDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUICacheL3MissRatio" displayName="%GPUICacheL3MissRatio">
      <queryInherit>/GPUICacheL3MissRatioBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUICacheL3MissRatioBase/ConditionalICACHE_L3_HITSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
    </derivedQuery>
    <derivedQuery id="GPUSamplerL3Access" displayName="%GPUSamplerL3Access">
      <valueType>count</valueType>
      <queryInherit>/GPUSAMPLER_L3_READMetric</queryInherit>
    </derivedQuery>
    <derivedQuery id="GPUSamplerL3Miss" displayName="%GPUSamplerL3Miss">
      <helpKeyword>configs.gpusamplerl3miss_gpusmplerl3missdescription</helpKeyword>
      <valueType>count</valueType>
      <valueEval><![CDATA[ (query("/GPUSAMPLER_L3_READMetric") - query("/GPUSAMPLER_L3_HITMetric"))]]></valueEval>
      <description>%GPUSamplerL3MissDescription</description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>47,71,47</timelineGraphColor>
        <timeScalems>1000</timeScalems>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUSamplerL3MissRatioBase" displayName="%GPUSamplerL3MissRatio">
      <helpKeyword>configs.gpusamplerl3missratio_gpusamplerl3missratiodescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ ( query("/GPUSamplerL3Miss") / (query("/GPUSamplerL3Access")) ) ]]></valueEval>
      <description>%GPUSamplerL3MissRatioDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUSamplerL3MissRatio" displayName="%GPUSamplerL3MissRatio">
      <queryInherit>/GPUSamplerL3MissRatioBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUSamplerL3MissRatioBase/ConditionalSAMPLER_L3_HITSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
    </derivedQuery>
    <derivedQuery id="GPUL3InputBase" displayName="%GPUL3Input">
      <helpKeyword>configs.gpul3busy_gpul3inputdescription</helpKeyword>
      <valueType>ratio</valueType>
      <queryInherit>/GPUL3_INPUT_AVAILABLEMetric</queryInherit>
      <description>%GPUL3InputDescription</description>
      <confidenceEval><![CDATA[ (query("/GPUSampleCount/GPUEventType[L3_INPUT_AVAILABLE]") > 5) ]]></confidenceEval>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>100,10,10</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <diagramObjectId>L3InputSlot</diagramObjectId>
      </displayAttributes>
      <maxEval>1</maxEval>
    </derivedQuery>
    <derivedQuery id="GPUL3Input" displayName="%GPUL3Input">
      <queryInherit>/GPUL3InputBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUL3InputBase/ConditionalL3_INPUT_AVAILABLESamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUL3OutputBase" displayName="%GPUL3Output">
      <helpKeyword>configs.gpul3output_gpul3outputdescription</helpKeyword>
      <valueType>ratio</valueType>
      <queryInherit>/GPUL3_OUTPUT_READYMetric</queryInherit>
      <description>%GPUL3OutputDescription</description>
      <confidenceEval><![CDATA[ (query("/GPUSampleCount/GPUEventType[L3_OUTPUT_READY]") > 5) ]]></confidenceEval>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>10,100,10</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <diagramObjectId>SamplerOutputSlot</diagramObjectId>
      </displayAttributes>
      <maxEval>1</maxEval>
    </derivedQuery>
    <derivedQuery id="GPUL3Output" displayName="%GPUL3Output">
      <queryInherit>/GPUL3OutputBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUL3OutputBase/ConditionalL3_OUTPUT_READYSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPULSCInputBase" displayName="%GPULSCInput">
      <helpKeyword>configs.gpulscinput_gpulscinputdescription</helpKeyword>
      <valueType>ratio</valueType>
      <queryInherit>/GPULOAD_STORE_CACHE_INPUT_AVAILABLEMetric</queryInherit>
      <description>%GPULSCInputDescription</description>
      <confidenceEval><![CDATA[ (query("/GPUSampleCount/GPUEventType[LOAD_STORE_CACHE_INPUT_AVAILABLE]") > 5) ]]></confidenceEval>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>100,10,10</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <diagramObjectId>LSCInputSlot</diagramObjectId>
      </displayAttributes>
      <maxEval>1</maxEval>
    </derivedQuery>
    <derivedQuery id="GPUL3BusyBase" displayName="%GPUL3Busy">
      <helpKeyword>configs.gpul3busy_gpul3busydescription</helpKeyword>
      <valueType>ratio</valueType>
      <queryInherit>/GPUL3_BUSYMetric</queryInherit>
      <description>%GPUL3BusyDescription</description>
      <confidenceEval><![CDATA[ (query("/GPUSampleCount/GPUEventType[L3_BUSY]") > 5) ]]></confidenceEval>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>60,170,60</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <diagramObjectId>L3BusySlot</diagramObjectId>
      </displayAttributes>
      <maxEval>1</maxEval>
    </derivedQuery>
    <derivedQuery id="GPUL3Busy" displayName="%GPUL3Busy">
      <queryInherit>/GPUL3BusyBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUL3BusyBase/ConditionalL3_BUSYSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUL3StallBase" displayName="%GPUL3Stall">
      <helpKeyword>configs.gpul3stall_gpul3stalldescription</helpKeyword>
      <valueType>ratio</valueType>
      <queryInherit>/GPUL3_STALLMetric</queryInherit>
      <description>%GPUL3StallDescription</description>
      <confidenceEval><![CDATA[ (query("/GPUSampleCount/GPUEventType[L3_STALL]") > 5) ]]></confidenceEval>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>230,60,60</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <diagramObjectId>L3StallSlot</diagramObjectId>
      </displayAttributes>
      <maxEval>1</maxEval>
    </derivedQuery>
    <derivedQuery id="GPUL3Stall" displayName="%GPUL3Stall">
      <queryInherit>/GPUL3StallBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUL3StallBase/ConditionalL3_STALLSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUL3SQFullBase" displayName="%GPUL3SQFull">
      <helpKeyword>configs.gpul3sqfull_gpul3sqfulldescription</helpKeyword>
      <valueType>ratio</valueType>
      <queryInherit>/GPUL3_SUPERQ_FULLMetric</queryInherit>
      <description>%GPUL3SQFullDescription</description>
      <confidenceEval><![CDATA[ (query("/GPUSampleCount/GPUEventType[L3_SUPERQ_FULL]") > 5) ]]></confidenceEval>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>60,60,60</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <diagramObjectId>L3SQFullSlot</diagramObjectId>
      </displayAttributes>
      <maxEval>1</maxEval>
    </derivedQuery>
    <derivedQuery id="GPUL3SQFull" displayName="%GPUL3SQFull">
      <queryInherit>/GPUL3SQFullBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUL3SQFullBase/ConditionalL3_SUPERQ_FULLSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPULSCInput" displayName="%GPULSCInput">
      <queryInherit>/GPULSCInputBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPULSCInputBase/ConditionalLOAD_STORE_CACHE_INPUT_AVAILABLESamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPULSCOutputBase" displayName="%GPULSCOutput">
      <helpKeyword>configs.gpulscoutput_gpulscoutputdescription</helpKeyword>
      <valueType>ratio</valueType>
      <queryInherit>/GPULOAD_STORE_CACHE_OUTPUT_READYMetric</queryInherit>
      <description>%GPULSCOutputDescription</description>
      <confidenceEval><![CDATA[ (query("/GPUSampleCount/GPUEventType[LOAD_STORE_CACHE_OUTPUT_READY]") > 5) ]]></confidenceEval>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>10,100,10</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <diagramObjectId>LSCOutputSlot</diagramObjectId>
      </displayAttributes>
      <maxEval>1</maxEval>
    </derivedQuery>
    <derivedQuery id="GPULSCOutput" displayName="%GPULSCOutput">
      <queryInherit>/GPULSCOutputBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPULSCOutputBase/ConditionalLOAD_STORE_CACHE_OUTPUT_READYSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPULSCL3Access" displayName="%GPULSCL3Access">
      <valueType>count</valueType>
      <queryInherit>/GPULOAD_STORE_CACHE_L3_READMetric</queryInherit>
      <valueEval><![CDATA[ ( query("/GPULOAD_STORE_CACHE_L3_READMetric") + query("/GPULOAD_STORE_CACHE_L3_WRITEMetric")) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPULSCL3Miss" displayName="%GPULSCL3Miss">
      <helpKeyword>configs.gpulscl3miss_gpulscl3missdescription</helpKeyword>
      <valueType>count</valueType>
      <valueEval><![CDATA[ (query("/GPULSCL3Access") - query("/GPULOAD_STORE_CACHE_L3_HITMetric"))]]></valueEval>
      <description>%GPULSCL3MissDescription</description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>47,71,47</timelineGraphColor>
        <timeScalems>1000</timeScalems>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPULSCL3MissRatioBase" displayName="%GPULSCL3MissRatio">
      <helpKeyword>configs.gpulscl3missratio_gpulscl3missratiodescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ ( query("/GPULSCL3Miss") / (query("/GPULSCL3Access")) ) ]]></valueEval>
      <description>%GPULSCL3MissRatioDescription</description>
    </derivedQuery>
    <derivedQuery id="GPULSCL3MissRatio" displayName="%GPULSCL3MissRatio">
      <queryInherit>/GPULSCL3MissRatioBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPULSCL3MissRatioBase/ConditionalLOAD_STORE_CACHE_L3_HITSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
    </derivedQuery>
    <derivedQuery id="GPUL3ShaderThroughputGB" displayName="%GPUL3ShaderThroughputShort">
      <helpKeyword>configs.gpul3shaderthroughput_gpul3shaderthroughputdescription</helpKeyword>
      <valueType>double</valueType>
      <queryInherit>/GPUL3ShaderThroughputMetric</queryInherit>
      <description><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>L3ShaderThroughputDescription</xsl:text></description>
      <issues>
        <issue>
          <issueEval><![CDATA[ query("/GPUL3BandwidthWhenBusyIssue") ]]></issueEval>
          <issueText><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>L3BoundIssueText</xsl:text></issueText>
        </issue>
      </issues>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>78,119,79</timelineGraphColor>
        <timeScalems>1000</timeScalems>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUL3ShaderReadThroughputGB" displayName="%GPUL3ShaderReadThroughputShort">
      <helpKeyword>configs.gpul3shaderreadthroughput_gpul3shaderreadthroughputdescription</helpKeyword>
      <queryInherit>/GPUL3_BYTE_READMetric</queryInherit>
      <valueType>double</valueType>
      <description>%GPUXEL3ShaderReadThroughputDescription</description>
      <issues>
        <issue>
          <issueEval><![CDATA[ query("/GPUL3ReadBandwidthWhenBusyIssue") ]]></issueEval>
          <issueText><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>L3BoundIssueText</xsl:text></issueText>
        </issue>
      </issues>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>78,169,79</timelineGraphColor>
        <timeScalems>1000</timeScalems>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUL3ShaderWriteThroughputGB" displayName="%GPUL3ShaderWriteThroughputShort">
      <helpKeyword>configs.gpul3shaderwritethroughput_gpul3shaderwritethroughputdescription</helpKeyword>
      <queryInherit>/GPUL3_BYTE_WRITEMetric</queryInherit>
      <valueType>double</valueType>
      <description>%GPUXEL3ShaderWriteThroughputDescription</description>
      <issues>
        <issue>
          <issueEval><![CDATA[ query("/GPUL3WriteBandwidthWhenBusyIssue") ]]></issueEval>
          <issueText><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>L3BoundIssueText</xsl:text></issueText>
        </issue>
      </issues>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>78,119,79</timelineGraphColor>
        <timeScalems>1000</timeScalems>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUL3ShaderThroughputB" displayName="%GPUL3ShaderThroughputShort">
      <queryInherit>/GPUL3ShaderThroughputGB</queryInherit>
      <valueType>memory</valueType>
      <valueEval>
        <![CDATA[ (query("/GPUL3ShaderThroughputGB") * 1000000000) ]]>
      </valueEval>
    </derivedQuery>
    <derivedQuery id="GPUL3ShaderReadThroughputB" displayName="%GPUL3ShaderReadThroughputShort">
      <queryInherit>/GPUL3ShaderReadThroughputGB</queryInherit>
      <valueType>memory</valueType>
      <valueEval>
        <![CDATA[ (query("/GPUL3ShaderReadThroughputGB") * 1000000000.0) ]]>
      </valueEval>
    </derivedQuery>
    <derivedQuery id="GPUL3ShaderWriteThroughputB" displayName="%GPUL3ShaderWriteThroughputShort">
      <queryInherit>/GPUL3ShaderWriteThroughputGB</queryInherit>
      <valueType>memory</valueType>
      <valueEval>
        <![CDATA[ (query("/GPUL3ShaderWriteThroughputGB") * 1000000000.0) ]]>
      </valueEval>
    </derivedQuery>
    <derivedQuery id="GPUL3ShaderBandwidthBase" displayName="%GPUL3ShaderThroughput">
      <helpKeyword>configs.gpul3shaderthroughput_gpul3shaderthroughputdescription</helpKeyword>
      <valueType>double</valueType>
      <boolean:valueSummable>false</boolean:valueSummable>
      <valueEval><![CDATA[ (query("/GPUL3ShaderThroughputGB") / query("/GPUElapsedTime")) ]]></valueEval>
      <description><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>L3ShaderThroughputDescription</xsl:text></description>
      <displayAttributes>
        <boolean:vtNullAsZero>false</boolean:vtNullAsZero>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUL3ShaderReadBandwidthBase" displayName="%GPUL3ShaderReadThroughput">
      <helpKeyword>configs.gpul3shaderreadthroughput_gpul3shaderreadthroughputdescription</helpKeyword>
      <valueType>double</valueType>
      <boolean:valueSummable>false</boolean:valueSummable>
      <valueEval><![CDATA[ (query("/GPUL3ShaderReadThroughputGB") / query("/GPUElapsedTime")) ]]></valueEval>
      <description>%GPUXEL3ShaderReadThroughputDescription</description>
      <displayAttributes>
        <boolean:vtNullAsZero>false</boolean:vtNullAsZero>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUL3ShaderWriteBandwidthBase" displayName="%GPUL3ShaderWriteThroughput">
      <helpKeyword>configs.gpul3shaderwritethroughput_gpul3shaderwritethroughputdescription</helpKeyword>
      <valueType>double</valueType>
      <boolean:valueSummable>false</boolean:valueSummable>
      <valueEval><![CDATA[ (query("/GPUL3ShaderWriteThroughputGB") / query("/GPUElapsedTime")) ]]></valueEval>
      <description>%GPUXEL3ShaderWriteThroughputDescription</description>
      <displayAttributes>
        <boolean:vtNullAsZero>false</boolean:vtNullAsZero>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUL3ShaderBandwidth" displayName="%GPUL3ShaderThroughput">
      <queryInherit>/GPUL3ShaderBandwidthBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUL3ShaderBandwidthBase/ConditionalL3ShaderThroughputSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceEval><![CDATA[ (query("/GPUSampleCount/GPUEventType[L3ShaderThroughput]") > 5) ]]></confidenceEval>
      <confidenceText>%NotEnoughSamples</confidenceText>
      <issues>
        <issue>
          <issueEval><![CDATA[ query("/GPUL3BandwidthWhenBusyIssue") ]]></issueEval>
          <issueText><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>L3BoundIssueText</xsl:text></issueText>
        </issue>
      </issues>
      <percentBases>
        <queryRef>/GPUL3ShaderBDWAbsMax</queryRef>
      </percentBases>
    </derivedQuery>
    <derivedQuery id="GPUL3ShaderReadBandwidth" displayName="%GPUL3ShaderReadThroughput">
      <queryInherit>/GPUL3ShaderReadBandwidthBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUL3ShaderReadBandwidthBase/ConditionalL3_BYTE_READSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceEval><![CDATA[ (query("/GPUSampleCount/GPUEventType[L3_BYTE_READ]") > 5) ]]></confidenceEval>
      <confidenceText>%NotEnoughSamples</confidenceText>
      <issues>
        <issue>
          <issueEval><![CDATA[ query("/GPUL3ReadBandwidthWhenBusyIssue") ]]></issueEval>
          <issueText><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>L3BoundIssueText</xsl:text></issueText>
        </issue>
      </issues>
      <percentBases>
        <queryRef>/GPUL3ShaderReadBDWAbsMax</queryRef>
      </percentBases>
    </derivedQuery>
    <derivedQuery id="GPUL3ShaderWriteBandwidth" displayName="%GPUL3ShaderWriteThroughput">
      <queryInherit>/GPUL3ShaderWriteBandwidthBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUL3ShaderWriteBandwidthBase/ConditionalL3_BYTE_WRITESamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceEval><![CDATA[ (query("/GPUSampleCount/GPUEventType[L3_BYTE_WRITE]") > 5) ]]></confidenceEval>
      <confidenceText>%NotEnoughSamples</confidenceText>
      <issues>
        <issue>
          <issueEval><![CDATA[ query("/GPUL3WriteBandwidthWhenBusyIssue") ]]></issueEval>
          <issueText><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>L3BoundIssueText</xsl:text></issueText>
        </issue>
      </issues>
      <percentBases>
        <queryRef>/GPUL3ShaderWriteBDWAbsMax</queryRef>
      </percentBases>
    </derivedQuery>
    <derivedQuery id="GPUL3ShaderBandwidthB" displayName="%GPUL3ShaderThroughputFlex">
      <queryInherit>/GPUL3ShaderBandwidth</queryInherit>
      <valueType>bandwidth</valueType>
      <valueEval>
        <![CDATA[ (query("/GPUL3ShaderBandwidth") * 1000000000) ]]>
      </valueEval>
    </derivedQuery>
    <derivedQuery id="GPUL3ShaderReadBandwidthB" displayName="%GPUL3ShaderReadThroughputFlex">
      <queryInherit>/GPUL3ShaderReadBandwidth</queryInherit>
      <valueType>bandwidth</valueType>
      <valueEval>
        <![CDATA[ (query("/GPUL3ShaderReadBandwidth") * 1000000000) ]]>
      </valueEval>
    </derivedQuery>
    <derivedQuery id="GPUL3ShaderWriteBandwidthB" displayName="%GPUL3ShaderWriteThroughputFlex">
      <queryInherit>/GPUL3ShaderWriteBandwidth</queryInherit>
      <valueType>bandwidth</valueType>
      <valueEval>
        <![CDATA[ (query("/GPUL3ShaderWriteBandwidth") * 1000000000) ]]>
      </valueEval>
    </derivedQuery>
    <derivedQuery id="GPUL3ShaderBDWMax" displayName="%GPUL3ShaderThroughputMetricMaxGB">
      <helpKeyword>configs.gpul3shaderthroughput_gpul3shaderthroughputdescription</helpKeyword>
      <valueType>double</valueType>
      <valueEval><![CDATA[ (query("/GPUL3ShaderThroughputMetricMaxValue") / query("/GPUElapsedTime") / 1000000000 ) ]]></valueEval>
      <description><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>L3ShaderThroughputMetricMaxGBDescription</xsl:text></description>
    </derivedQuery>
    <derivedQuery id="GPUL3ShaderBDWAbsMax" displayName="%GPUL3ShaderThroughputMetricMaxGB">
      <helpKeyword>configs.gpul3shaderthroughput_gpul3shaderthroughputdescription</helpKeyword>
      <valueType>double</valueType>
      <queryInherit>/GPUL3ShaderThroughputMetricAbsMaxValue</queryInherit>
      <description><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>L3ShaderThroughputMetricMaxGBDescription</xsl:text></description>
    </derivedQuery>
    <derivedQuery id="GPUL3ShaderReadBDWMax" displayName="%GPUL3ShaderReadThroughputMetricMaxGB">
      <helpKeyword>configs.gpul3shaderreadthroughput_gpul3shaderreadthroughputdescription</helpKeyword>
      <valueType>double</valueType>
      <valueEval><![CDATA[ (query("/GPUL3_BYTE_READMetricMaxValue") / query("/GPUElapsedTime") / 1000000000 ) ]]></valueEval>
      <description>%GPUXEL3ShaderReadThroughputMetricMaxGBDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUL3ShaderReadBDWAbsMax" displayName="%GPUL3ShaderReadThroughputMetricMaxGB">
      <helpKeyword>configs.gpul3shaderreadthroughput_gpul3shaderreadthroughputdescription</helpKeyword>
      <valueType>double</valueType>
      <queryInherit>/GPUL3_BYTE_READMetricAbsMaxValue</queryInherit>
      <description>%GPUXEL3ShaderReadThroughputMetricMaxGBDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUL3ShaderWriteBDWMax" displayName="%GPUL3ShaderWriteThroughputMetricMaxGB">
      <helpKeyword>configs.gpul3shaderwritethroughput_gpul3shaderwritethroughputdescription</helpKeyword>
      <valueType>double</valueType>
      <valueEval><![CDATA[ (query("/GPUL3_BYTE_WRITEMetricMaxValue") / query("/GPUElapsedTime") / 1000000000 ) ]]></valueEval>
      <description>%GPUXEL3ShaderWriteThroughputMetricMaxGBDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUL3ShaderWriteBDWAbsMax" displayName="%GPUL3ShaderWriteThroughputMetricMaxGB">
      <helpKeyword>configs.gpul3shaderwritethroughput_gpul3shaderwritethroughputdescription</helpKeyword>
      <valueType>double</valueType>
      <queryInherit>/GPUL3_BYTE_WRITEMetricAbsMaxValue</queryInherit>
      <description>%GPUXEL3ShaderWriteThroughputMetricMaxGBDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUL3ShaderBDWMaxRatio" displayName="%GPUBDWRatioUniversalName">
      <helpKeyword>configs.gpubdwratiouniversalname_gpubdwratiouniversaldescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ ( query("/GPUL3ShaderBandwidth") / query("/GPUL3ShaderBDWMax") ) ]]></valueEval>
      <description>%GPUBDWRatioUniversalDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUL3ShaderBDWAbsMaxRatio" displayName="%GPUBDWRatioUniversalName">
      <helpKeyword>configs.gpubdwratiouniversalname_gpubdwratiouniversaldescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ ( query("/GPUL3ShaderBandwidth") / query("/GPUL3ShaderBDWAbsMax") ) ]]></valueEval>
      <description>%GPUBDWRatioUniversalDescription</description>
      <issues>
        <issue>
          <issueEval><![CDATA[ query("/GPUL3BandwidthWhenBusyIssue") ]]></issueEval>
          <issueText><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>L3BoundIssueText</xsl:text></issueText>
        </issue>
      </issues>
    </derivedQuery>
    <derivedQuery id="GPUL3ShaderReadBDWMaxRatio" displayName="%GPUBDWRatioUniversalName">
      <helpKeyword>configs.gpubdwratiouniversalname_gpubdwratiouniversaldescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ ( query("/GPUL3ShaderReadBandwidth") / query("/GPUL3ShaderReadBDWMax") ) ]]></valueEval>
      <description>%GPUBDWRatioUniversalDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUL3ShaderReadBDWAbsMaxRatio" displayName="%GPUBDWRatioUniversalName">
      <helpKeyword>configs.gpubdwratiouniversalname_gpubdwratiouniversaldescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ ( query("/GPUL3ShaderReadBandwidth") / query("/GPUL3ShaderReadBDWAbsMax") ) ]]></valueEval>
      <description>%GPUBDWRatioUniversalDescription</description>
      <issues>
        <issue>
          <issueEval><![CDATA[ query("/GPUL3ReadBandwidthWhenBusyIssue") ]]></issueEval>
          <issueText><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>L3BoundIssueText</xsl:text></issueText>
        </issue>
      </issues>
    </derivedQuery>
    <derivedQuery id="GPUL3ShaderWriteBDWMaxRatio" displayName="%GPUBDWRatioUniversalName">
      <helpKeyword>configs.gpubdwratiouniversalname_gpubdwratiouniversaldescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ ( query("/GPUL3ShaderWriteBandwidth") / query("/GPUL3ShaderWriteBDWMax") ) ]]></valueEval>
      <description>%GPUBDWRatioUniversalDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUL3ShaderWriteBDWAbsMaxRatio" displayName="%GPUBDWRatioUniversalName">
      <helpKeyword>configs.gpubdwratiouniversalname_gpubdwratiouniversaldescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ ( query("/GPUL3ShaderWriteBandwidth") / query("/GPUL3ShaderWriteBDWAbsMax") ) ]]></valueEval>
      <description>%GPUBDWRatioUniversalDescription</description>
      <issues>
        <issue>
          <issueEval><![CDATA[ query("/GPUL3WriteBandwidthWhenBusyIssue") ]]></issueEval>
          <issueText><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>L3BoundIssueText</xsl:text></issueText>
        </issue>
      </issues>
    </derivedQuery>
    <derivedQuery id="GPUL3ShaderReadWriteBDWMaxRatio" displayName="%GPUBDWRatioUniversalName">
      <helpKeyword>configs.gpubdwratiouniversalname_gpubdwratiouniversaldescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ ( ( query("/GPUL3ShaderReadBandwidth") + query("/GPUL3ShaderWriteBandwidth") ) / ( query("/GPUL3ShaderReadBDWMax") + query("/GPUL3ShaderWriteBDWMax") ) ) ]]></valueEval>
      <description>%GPUBDWRatioUniversalDescription</description>
    </derivedQuery>
    <derivedQuery id="GPULSCReadGB" displayName="%BandwidthRead">
      <queryInherit>/GPULOAD_STORE_CACHE_BYTE_READMetric</queryInherit>
      <valueType>double</valueType>
      <description>%GPULSCReadDescription</description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>78,169,79</timelineGraphColor>
        <timeScalems>1000</timeScalems>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPULSCReadB" displayName="%BandwidthRead">
      <queryInherit>/GPULSCReadGB</queryInherit>
      <valueType>memory</valueType>
      <valueEval>
        <![CDATA[ (query("/GPULSCReadGB") * 1000000000) ]]>
      </valueEval>
    </derivedQuery>
    <derivedQuery id="GPULSCReadBandwidthBase" displayName="%GPULSCRead">
      <helpKeyword>configs.gpuloadstorecacheread_gpuloadstorecachereaddescription</helpKeyword>
      <valueType>double</valueType>
      <boolean:valueSummable>false</boolean:valueSummable>
      <valueEval><![CDATA[ (query("/GPULSCReadGB") / query("/GPUElapsedTime")) ]]></valueEval>
      <description>%GPULSCReadDescription</description>
      <displayAttributes>
        <boolean:vtNullAsZero>false</boolean:vtNullAsZero>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPULSCReadBandwidth" displayName="%GPULSCRead">
      <queryInherit>/GPULSCReadBandwidthBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPULSCReadBandwidthBase/ConditionalLOAD_STORE_CACHE_BYTE_READSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
      <percentBases>
        <queryRef>/GPULSCReadBDWAbsMax</queryRef>
      </percentBases>
    </derivedQuery>
    <derivedQuery id="GPULSCReadBandwidthB" displayName="%GPULSCReadFlex">
      <queryInherit>/GPULSCReadBandwidth</queryInherit>
      <valueType>bandwidth</valueType>
      <valueEval>
        <![CDATA[ (query("/GPULSCReadBandwidth") * 1000000000) ]]>
      </valueEval>
    </derivedQuery>
    <derivedQuery id="GPULSCReadBDWMax" displayName="%GPULSCReadBDWMax">
      <helpKeyword>configs.gpuloadstorecacheread_gpuloadstorecachereaddescription</helpKeyword>
      <valueType>double</valueType>
      <valueEval><![CDATA[ (query("/GPULOAD_STORE_CACHE_BYTE_READMetricMaxValue") / query("/GPUElapsedTime") / 1000000000 ) ]]></valueEval>
      <description>%GPULSCReadBDWMaxDescription</description>
    </derivedQuery>
    <derivedQuery id="GPULSCReadBDWAbsMax" displayName="%GPULSCReadBDWMax">
      <helpKeyword>configs.gpuloadstorecacheread_gpuloadstorecachereaddescription</helpKeyword>
      <valueType>double</valueType>
      <queryInherit>/GPULOAD_STORE_CACHE_BYTE_READMetricAbsMaxValue</queryInherit>
      <description>%GPULSCReadBDWMaxDescription</description>
    </derivedQuery>
    <derivedQuery id="GPULSCReadMaxRatio" displayName="%GPUBDWRatioUniversalName">
      <helpKeyword>configs.gpubdwratiouniversalname_gpureadbdwratiouniversaldescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ (query("/GPULSCReadBandwidth") / query("/GPULSCReadBDWMax") ) ]]></valueEval>
      <description>%GPUReadBDWRatioUniversalDescription</description>
    </derivedQuery>
    <derivedQuery id="GPULSCReadAbsMaxRatio" displayName="%GPUBDWRatioUniversalName">
      <helpKeyword>configs.gpubdwratiouniversalname_gpureadbdwratiouniversaldescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ (query("/GPULSCReadBandwidth") / query("/GPULSCReadBDWAbsMax") ) ]]></valueEval>
      <description>%GPUReadBDWRatioUniversalDescription</description>
    </derivedQuery>
    <derivedQuery id="GPULSCWriteGB" displayName="%BandwidthWrite">
      <queryInherit>/GPULOAD_STORE_CACHE_BYTE_WRITEMetric</queryInherit>
      <valueType>double</valueType>
      <description>%GPULSCWriteDescription</description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>78,119,79</timelineGraphColor>
        <timeScalems>1000</timeScalems>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPULSCWriteB" displayName="%BandwidthWrite">
      <queryInherit>/GPULSCWriteGB</queryInherit>
      <valueType>memory</valueType>
      <valueEval>
        <![CDATA[ (query("/GPULSCWriteGB") * 1000000000) ]]>
      </valueEval>
    </derivedQuery>
    <derivedQuery id="GPULSCWriteBandwidthBase" displayName="%GPULSCWrite">
      <helpKeyword>configs.gpuloadstorecacheread_gpuloadstorecachereaddescription</helpKeyword>
      <valueType>double</valueType>
      <boolean:valueSummable>false</boolean:valueSummable>
      <valueEval><![CDATA[ (query("/GPULSCWriteGB") / query("/GPUElapsedTime")) ]]></valueEval>
      <description>%GPULSCWriteDescription</description>
      <displayAttributes>
        <boolean:vtNullAsZero>false</boolean:vtNullAsZero>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPULSCWriteBandwidth" displayName="%GPULSCWrite">
      <queryInherit>/GPULSCWriteBandwidthBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPULSCWriteBandwidthBase/ConditionalLOAD_STORE_CACHE_BYTE_WRITESamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
      <percentBases>
        <queryRef>/GPULSCWriteBDWAbsMax</queryRef>
      </percentBases>
    </derivedQuery>
    <derivedQuery id="GPULSCWriteBandwidthB" displayName="%GPULSCWriteFlex">
      <queryInherit>/GPULSCWriteBandwidth</queryInherit>
      <valueType>bandwidth</valueType>
      <valueEval>
        <![CDATA[ (query("/GPULSCWriteBandwidth") * 1000000000) ]]>
      </valueEval>
    </derivedQuery>
    <derivedQuery id="GPULSCWriteBDWMax" displayName="%GPULSCWriteBDWMax">
      <helpKeyword>configs.gpuloadstorecacheread_gpuloadstorecachereaddescription</helpKeyword>
      <valueType>double</valueType>
      <valueEval><![CDATA[ (query("/GPULOAD_STORE_CACHE_BYTE_WRITEMetricMaxValue") / query("/GPUElapsedTime") / 1000000000 ) ]]></valueEval>
      <description>%GPULSCWriteBDWMaxDescription</description>
    </derivedQuery>
    <derivedQuery id="GPULSCWriteBDWAbsMax" displayName="%GPULSCWriteBDWMax">
      <helpKeyword>configs.gpuloadstorecachewrite_gpuloadstorecachewritedescription</helpKeyword>
      <valueType>double</valueType>
      <queryInherit>/GPULOAD_STORE_CACHE_BYTE_WRITEMetricAbsMaxValue</queryInherit>
      <description>%GPULSCWriteBDWMaxDescription</description>
    </derivedQuery>
    <derivedQuery id="GPULSCWriteMaxRatio" displayName="%GPUBDWRatioUniversalName">
      <helpKeyword>configs.gpubdwratiouniversalname_gpureadbdwratiouniversaldescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ (query("/GPULSCWriteBandwidth") / query("/GPULSCWriteBDWMax") ) ]]></valueEval>
      <description>%GPUWriteBDWRatioUniversalDescription</description>
    </derivedQuery>
    <derivedQuery id="GPULSCWriteAbsMaxRatio" displayName="%GPUBDWRatioUniversalName">
      <helpKeyword>configs.gpubdwratiouniversalname_gpureadbdwratiouniversaldescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ (query("/GPULSCWriteBandwidth") / query("/GPULSCWriteBDWAbsMax") ) ]]></valueEval>
      <description>%GPUWriteBDWRatioUniversalDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUDataportReadGB" displayName="%BandwidthRead">
      <queryInherit>/GPUDATAPORT_BYTE_READMetric</queryInherit>
      <valueType>double</valueType>
      <description>%GPUDataportReadDescription</description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>78,169,79</timelineGraphColor>
        <timeScalems>1000</timeScalems>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUDataportReadB" displayName="%BandwidthRead">
      <queryInherit>/GPUDataportReadGB</queryInherit>
      <valueType>memory</valueType>
      <valueEval>
        <![CDATA[ (query("/GPUDataportReadGB") * 1000000000) ]]>
      </valueEval>
    </derivedQuery>
    <derivedQuery id="GPUDataportReadBandwidthBase" displayName="%GPUDataportRead">
      <helpKeyword>configs.gpudataportread_gpudataportreaddescription</helpKeyword>
      <valueType>double</valueType>
      <boolean:valueSummable>false</boolean:valueSummable>
      <valueEval><![CDATA[ (query("/GPUDataportReadGB") / query("/GPUElapsedTime")) ]]></valueEval>
      <description>%GPUDataportReadDescription</description>
      <displayAttributes>
        <boolean:vtNullAsZero>false</boolean:vtNullAsZero>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUDataportReadBandwidth" displayName="%GPUDataportRead">
      <queryInherit>/GPUDataportReadBandwidthBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUDataportReadBandwidthBase/ConditionalDATAPORT_BYTE_READSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
      <percentBases>
        <queryRef>/GPUDataportReadBDWAbsMax</queryRef>
      </percentBases>
    </derivedQuery>
    <derivedQuery id="GPUDataportReadBandwidthB" displayName="%GPUDataportReadFlex">
      <queryInherit>/GPUDataportReadBandwidth</queryInherit>
      <valueType>bandwidth</valueType>
      <valueEval>
        <![CDATA[ (query("/GPUDataportReadBandwidth") * 1000000000) ]]>
      </valueEval>
    </derivedQuery>
    <derivedQuery id="GPUDataportReadBDWMax" displayName="%GPUDataportReadBDWMax">
      <helpKeyword>configs.gpudataportread_gpudataportreaddescription</helpKeyword>
      <valueType>double</valueType>
      <valueEval><![CDATA[ (query("/GPUDATAPORT_BYTE_READMetricMaxValue") / query("/GPUElapsedTime") / 1000000000 ) ]]></valueEval>
      <description>%GPUDataportReadBDWMaxDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUDataportReadBDWAbsMax" displayName="%GPUDataportReadBDWMax">
      <helpKeyword>configs.gpudataporteread_gpudataportreaddescription</helpKeyword>
      <valueType>double</valueType>
      <queryInherit>/GPUDATAPORT_BYTE_READMetricAbsMaxValue</queryInherit>
      <description>%GPUDataportReadBDWMaxDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUDataportReadMaxRatio" displayName="%GPUBDWRatioUniversalName">
      <helpKeyword>configs.gpubdwratiouniversalname_gpureadbdwratiouniversaldescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ (query("/GPUDataportReadBandwidth") / query("/GPUDataportReadBDWMax") ) ]]></valueEval>
      <description>%GPUReadBDWRatioUniversalDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUDataportReadBDWAbsMaxRatio" displayName="%GPUBDWRatioUniversalName">
      <helpKeyword>configs.gpubdwratiouniversalname_gpureadbdwratiouniversaldescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ (query("/GPUDataportReadBandwidth") / query("/GPUDataportReadBDWAbsMax") ) ]]></valueEval>
      <description>%GPUReadBDWRatioUniversalDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUDataportWriteGB" displayName="%BandwidthWrite">
      <queryInherit>/GPUDATAPORT_BYTE_WRITEMetric</queryInherit>
      <valueType>double</valueType>
      <description>%GPUDataportWriteDescription</description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>78,119,79</timelineGraphColor>
        <timeScalems>1000</timeScalems>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUDataportWriteB" displayName="%BandwidthWrite">
      <queryInherit>/GPUDataportWriteGB</queryInherit>
      <valueType>memory</valueType>
      <valueEval>
        <![CDATA[ (query("/GPUDataportWriteGB") * 1000000000) ]]>
      </valueEval>
    </derivedQuery>
    <derivedQuery id="GPUDataportWriteBandwidthBase" displayName="%GPUDataportWrite">
      <helpKeyword>configs.gpudataportread_gpudataportreaddescription</helpKeyword>
      <valueType>double</valueType>
      <boolean:valueSummable>false</boolean:valueSummable>
      <valueEval><![CDATA[ (query("/GPUDataportWriteGB") / query("/GPUElapsedTime")) ]]></valueEval>
      <description>%GPUDataportWriteDescription</description>
      <displayAttributes>
        <boolean:vtNullAsZero>false</boolean:vtNullAsZero>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUDataportWriteBandwidth" displayName="%GPUDataportWrite">
      <queryInherit>/GPUDataportWriteBandwidthBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUDataportWriteBandwidthBase/ConditionalDATAPORT_BYTE_WRITESamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
      <percentBases>
        <queryRef>/GPUDataportWriteBDWAbsMax</queryRef>
      </percentBases>
    </derivedQuery>
    <derivedQuery id="GPUDataportWriteBandwidthB" displayName="%GPUDataportWriteFlex">
      <queryInherit>/GPUDataportWriteBandwidth</queryInherit>
      <valueType>bandwidth</valueType>
      <valueEval>
        <![CDATA[ (query("/GPUDataportWriteBandwidth") * 1000000000) ]]>
      </valueEval>
    </derivedQuery>
    <derivedQuery id="GPUDataportWriteBDWMax" displayName="%GPUDataportWriteBDWMax">
      <helpKeyword>configs.gpudataportread_gpudataportreaddescription</helpKeyword>
      <valueType>double</valueType>
      <valueEval><![CDATA[ (query("/GPUDATAPORT_BYTE_WRITEMetricMaxValue") / query("/GPUElapsedTime") / 1000000000 ) ]]></valueEval>
      <description>%GPUDataportWriteBDWMaxDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUDataportWriteBDWAbsMax" displayName="%GPUDataportWriteBDWMax">
      <helpKeyword>configs.gpudataportwrite_gpudataportwritedescription</helpKeyword>
      <valueType>double</valueType>
      <queryInherit>/GPUDATAPORT_BYTE_WRITEMetricAbsMaxValue</queryInherit>
      <description>%GPUDataportWriteBDWMaxDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUDataportWriteMaxRatio" displayName="%GPUBDWRatioUniversalName">
      <helpKeyword>configs.gpubdwratiouniversalname_gpureadbdwratiouniversaldescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ (query("/GPUDataportWriteBandwidth") / query("/GPULSCWriteBDWMax") ) ]]></valueEval>
      <description>%GPUWriteBDWRatioUniversalDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUDataportWriteBDWAbsMaxRatio" displayName="%GPUBDWRatioUniversalName">
      <helpKeyword>configs.gpubdwratiouniversalname_gpureadbdwratiouniversaldescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ (query("/GPUDataportWriteBandwidth") / query("/GPUDataportWriteBDWAbsMax") ) ]]></valueEval>
      <description>%GPUWriteBDWRatioUniversalDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUEuThreadOccupancyBase" displayName="%{$gpuPrefix}EuThreadOccupancy">
      <helpKeyword>configs.gpueuthreadoccupancy_gpueuthreadoccupancydescription</helpKeyword>
      <valueType>ratio</valueType>
      <xsl:choose>
        <xsl:when test="exsl:ctx('gsimClockDuration', 0) > 0">
          <valueEval>
            <![CDATA[ query("/gSimGPUEventCount/gSimGPUEventType[ThreadsActive]") /
            query("/gSimGPUEventCountWeighted/gSimGPUEventType[ThreadsActive]") / $gsimThreadCount]]>
          </valueEval>
        </xsl:when>
        <xsl:otherwise>
          <queryInherit>/GPUEuThreadOccupancyMetric</queryInherit>
        </xsl:otherwise>
      </xsl:choose>
      <description><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>EuThreadOccupancyDescription</xsl:text></description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>0,170,0</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <boolean:vtNullAsZero>false</boolean:vtNullAsZero>
      </displayAttributes>
      <maxEval>1</maxEval>
    </derivedQuery>
    <derivedQuery id="GPU_EU_THREAD_OCCUPANCY_Base" displayName="%{$gpuPrefix}EuThreadOccupancy">
      <helpKeyword>configs.gpueuthreadoccupancy_gpueuthreadoccupancydescription</helpKeyword>
      <valueType>ratio</valueType>
      <queryInherit>/GPUEU_THREADS_OCCUPANCY_ALLMetric</queryInherit>
      <description><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>EuThreadOccupancyDescription</xsl:text></description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>0,170,0</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <boolean:vtNullAsZero>false</boolean:vtNullAsZero>
      </displayAttributes>
      <maxEval>1</maxEval>
    </derivedQuery>
    <derivedQuery id="GPUEuThreadOccupancy" displayName="%{$gpuPrefix}EuThreadOccupancy">
      <queryInherit>/GPUEuThreadOccupancyBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUEuThreadOccupancyBase/ConditionalEuThreadOccupancySamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <issues>
        <issue>
          <issueEval><![CDATA[ query("/GPUThreadOccupancyWhenBusyIssue") && query("/OccupancyThreadsLowIssue") && query("/IsGPUComputeTaskWithOccupancyIssues") ]]></issueEval>
          <issueText>%GPULowWorkSizeIssue</issueText>
        </issue>
        <issue>
          <issueEval><![CDATA[ query("/GPUThreadOccupancyWhenBusyIssue") && query("/OccupancySLMLowIssue") && query("/IsGPUComputeTaskWithOccupancyIssues") ]]></issueEval>
          <issueText>%GPUHighSLMIssue</issueText>
        </issue>
        <issue>
          <issueEval><![CDATA[ query("/GPUThreadOccupancyWhenBusyIssue") && query("/OccupancyBarrierLowIssue") && query("/IsGPUComputeTaskWithOccupancyIssues") ]]></issueEval>
          <issueText>%GPUHighBarrierIssue</issueText>
        </issue>
      </issues>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPU_EU_THREAD_OCCUPANCY" displayName="%{$gpuPrefix}EuThreadOccupancy">
      <queryInherit>/GPU_EU_THREAD_OCCUPANCY_Base</queryInherit>
      <issues>
        <issue>
          <issueEval><![CDATA[ query("/GPUThreadOccupancyExtWhenBusyIssue") && query("/OccupancyThreadsLowIssue") && query("/IsGPUComputeTaskExtWithOccupancyIssues") ]]></issueEval>
          <issueText>%GPULowWorkSizeIssue</issueText>
        </issue>
        <issue>
          <issueEval><![CDATA[ query("/GPUThreadOccupancyExtWhenBusyIssue") && query("/OccupancySLMLowIssue") && query("/IsGPUComputeTaskExtWithOccupancyIssues") ]]></issueEval>
          <issueText>%GPUHighSLMIssue</issueText>
        </issue>
        <issue>
          <issueEval><![CDATA[ query("/GPUThreadOccupancyExtWhenBusyIssue") && query("/OccupancyBarrierLowIssue") && query("/IsGPUComputeTaskExtWithOccupancyIssues") ]]></issueEval>
          <issueText>%GPUHighBarrierIssue</issueText>
        </issue>
      </issues>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUEuAvgIpcRateBase" displayName="%{$gpuPrefix}EuAvgIpcRate">
      <helpKeyword>configs.gpueuavgipcrate_gpueuavgipcratedescription</helpKeyword>
      <valueType>double</valueType>
      <queryInherit>/GPUEuAvgIpcRateMetric</queryInherit>
      <description>%GPUEuAvgIpcRateDescription</description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>0,170,0</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <maxEval>2</maxEval>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUEuAvgIpcRate" displayName="%{$gpuPrefix}EuAvgIpcRate">
      <queryInherit>/GPUEuAvgIpcRateBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUEuAvgIpcRateBase/ConditionalEuAvgIpcRateSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <xsl:if test="not (exsl:ctx('gsimClockDuration', 0))">
        <confidenceEval><![CDATA[ (query("/GPUSampleCount/GPUEventType[EuAvgIpcRate]") > 5) ]]></confidenceEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUHPCEuAvgIpcRate" displayName="%{$gpuPrefix}EuAvgIpcRateShort">
      <queryInherit>/GPUEuAvgIpcRate</queryInherit>
    </derivedQuery>
    <derivedQuery id="GPUEuFpuBothActiveBase" displayName="%{$gpuPrefix}EuFpuBothActive">
      <helpKeyword>configs.gpueufpubothactive_gpueufpubothactivedescription</helpKeyword>
      <valueType>ratio</valueType>
      <xsl:choose>
        <xsl:when test="exsl:ctx('gsimClockDuration', 0) > 0">
          <valueEval><![CDATA[ query("/gSimGPUEventCount/gSimGPUEventType[BothFPUActive]") / query("/gSimGPUEventCountWeighted/gSimGPUEventType[BothFPUActive]") / 10000]]></valueEval>
        </xsl:when>
        <xsl:otherwise>
          <queryInherit>/GPUEuFpuBothActiveMetric</queryInherit>
        </xsl:otherwise>
      </xsl:choose>
      <description>%GPUEuFpuBothActiveDescription</description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>0,64,255</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
      <maxEval>1</maxEval>
    </derivedQuery>
    <derivedQuery id="GPUEuFpuBothActive" displayName="%GPUEuFpuBothActive">
      <queryInherit>/GPUEuFpuBothActiveBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUEuFpuBothActiveBase/ConditionalEuFpuBothActiveSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <issueEval><![CDATA[ query("/GPUFPUIssue") ]]></issueEval>
      <issueText>%FPUIssueText</issueText>
      <confidenceText>%NotEnoughSamples</confidenceText>
      <unitOfMeasureQueryId>GPUElapsedTimeWhenBusyForUnit</unitOfMeasureQueryId>
    </derivedQuery>
    <derivedQuery id="GPUEuFpuEmActiveBase" displayName="%{$gpuPrefix}EuFpuEmActive">
      <valueType>ratio</valueType>
      <xsl:choose>
        <xsl:when test="contains(exsl:ctx('gpuCounters', ''), 'euactivity8') and exsl:is_value_exist('dd_uncore_event_type', 'name', 'EuFpuEmActive')">
          <queryInherit>/GPUEuFpuSysActiveMetric</queryInherit>
        </xsl:when>
        <xsl:otherwise>
          <queryInherit>/GPUEuFpuEmActiveMetric</queryInherit>
        </xsl:otherwise>
      </xsl:choose>
      <description>%GPUEuFpuEmActiveDescription</description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>255,64,0</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
      <maxEval>1</maxEval>
    </derivedQuery>
    <derivedQuery id="GPUEuFpuSysActiveBase" displayName="%{$gpuPrefix}EuFpu{$alu2Name}Active">
      <valueType>ratio</valueType>
      <xsl:choose>
        <xsl:when test="contains(exsl:ctx('gpuCounters', ''), 'euactivity8') and not(exsl:is_value_exist('dd_uncore_event_type', 'name', 'EuSysFpuActive'))">
          <queryInherit>/GPUEuFpuEmActiveMetric</queryInherit>
        </xsl:when>
        <xsl:otherwise>
          <queryInherit>/GPUEuFpuSysActiveMetric</queryInherit>
        </xsl:otherwise>
      </xsl:choose>
      <description><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>EuFpu</xsl:text>
        <xsl:value-of select="$alu2Name"/>
        <xsl:text>ActiveDescription</xsl:text></description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>0,64,255</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
      <maxEval>1</maxEval>
    </derivedQuery>
    <derivedQuery id="GPUEuFpuEmActive" displayName="%{$gpuPrefix}EuFpuEmActive">
      <queryInherit>/GPUEuFpuEmActiveBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUEuFpuEmActiveBase/ConditionalEuFpuEmActiveSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <issueEval><![CDATA[ query("/GPUFPUEmIssue") ]]></issueEval>
      <issueText>%FPUEmIssueText</issueText>
      <confidenceText>%NotEnoughSamples</confidenceText>
      <unitOfMeasureQueryId>GPUElapsedTimeWhenBusyForUnit</unitOfMeasureQueryId>
    </derivedQuery>
    <derivedQuery id="GPUEuFpuSysActive" displayName="%{$gpuPrefix}EuFpu{$alu2Name}Active">
      <queryInherit>/GPUEuFpuSysActiveBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUEuFpuSysActiveBase/ConditionalEuFpuSysActiveSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <issueEval><![CDATA[ query("/GPUFPUSysIssue") ]]></issueEval>
      <issueText>%FPUSysIssueText</issueText>
      <confidenceText>%NotEnoughSamples</confidenceText>
      <unitOfMeasureQueryId>GPUElapsedTimeWhenBusyForUnit</unitOfMeasureQueryId>
    </derivedQuery>
    <derivedQuery id="GPUEuMultipleActiveBase" displayName="%GPUXEEuMultipleActive">
      <valueType>ratio</valueType>
      <queryInherit>/GPUXVE_MULTIPLE_PIPE_ACTIVEMetric</queryInherit>
      <description>%GPUXEEuMultipleActiveDescription</description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>0,255,64</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
      <maxEval>1</maxEval>
    </derivedQuery>
    <derivedQuery id="GPUEuMultipleActive" displayName="%GPUXEEuMulptipleActive">
      <queryInherit>/GPUEuMultipleActiveBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUEuMultipleActiveBase/ConditionalXVE_MULTIPLE_PIPE_ACTIVESamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
      <unitOfMeasureQueryId>GPUElapsedTimeWhenBusyForUnit</unitOfMeasureQueryId>
    </derivedQuery>
    <derivedQuery id="IsGPUBusyAndEuFpuBothActiveSamplesExist">
      <valueType>double</valueType>
      <valueEval><![CDATA[ (((query("/GPUGpuBusyBase") > 0) && (query("/IsEuFpuBothActiveSamplesExist") > 0)) ? 1 : 0) ]]></valueEval>
    </derivedQuery>
    <infoQuery id="ConditionalGPUBusyAndEuFpuBothActiveSamplesExist">
      <dbPath>conditional_gpu_data::dd_conditional_metric.is_GPUBusyAndEuFpuBothActive_exist</dbPath>
      <displayDbPathSuffix>name</displayDbPathSuffix>
    </infoQuery>
    <derivedQuery id="IsGPUBusyAndEuFpuEmActiveSamplesExist">
      <valueType>double</valueType>
      <valueEval><![CDATA[ (((query("/GPUGpuBusyBase") > 0) && (query("/IsEuFpuEmActiveSamplesExist") > 0)) ? 1 : 0) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="IsGPUBusyAndEuFpuSysActiveSamplesExist">
      <valueType>double</valueType>
      <valueEval><![CDATA[ (((query("/GPUGpuBusyBase") > 0) && (query("/IsEuFpuSysActiveSamplesExist") > 0)) ? 1 : 0) ]]></valueEval>
    </derivedQuery>
    <infoQuery id="ConditionalGPUBusyAndEuFpuEmActiveSamplesExist">
      <dbPath>conditional_gpu_data::dd_conditional_metric.is_GPUBusyAndEuFpuEmActive_exist</dbPath>
      <displayDbPathSuffix>name</displayDbPathSuffix>
    </infoQuery>
    <infoQuery id="ConditionalGPUBusyAndEuFpuSysActiveSamplesExist">
      <dbPath>conditional_gpu_data::dd_conditional_metric.is_GPUBusyAndEuFpuSysActive_exist</dbPath>
      <displayDbPathSuffix>name</displayDbPathSuffix>
    </infoQuery>
    <derivedQuery id="GPUEuFpuBothActiveInKernel" displayName="%{$gpuPrefix}EuFpuBothActive">
      <queryInherit>/GPUEuFpuBothActiveBase</queryInherit>
      <description>%GPUEuFpuBothActiveDescription</description>
      <xsl:choose>
        <xsl:when test="fnc:is_universal_collector_in_multirun_mode()">
          <valueEval><![CDATA[ ( query("/GPUEuFpuBothActiveBase/ConditionalGPUBusyAndEuFpuBothActiveSamplesExist[%True]") ) ]]></valueEval>
        </xsl:when>
        <xsl:otherwise>
          <xsl:if test="not (exsl:ctx('gsimClockDuration', 0))">
            <valueEval><![CDATA[ ( query("/GPUEuFpuBothActiveBase/ConditionalGPUBusyData[%True]") ) ]]></valueEval>
          </xsl:if>
        </xsl:otherwise>
      </xsl:choose>
      <issueEval><![CDATA[ query("/GPUFPUIssue") ]]></issueEval>
      <issueText>%FPUIssueText</issueText>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUEuFpuEmActiveInKernel" displayName="%{$gpuPrefix}EuFpuEmActive">
      <queryInherit>/GPUEuFpuEmActiveBase</queryInherit>
      <description>%GPUEuFpuEmActiveDescription</description>
      <xsl:choose>
        <xsl:when test="fnc:is_universal_collector_in_multirun_mode()">
          <valueEval><![CDATA[ ( query("/GPUEuFpuEmActiveBase/ConditionalGPUBusyAndEuFpuEmActiveSamplesExist[%True]") ) ]]></valueEval>
        </xsl:when>
        <xsl:otherwise>
          <xsl:if test="not (exsl:ctx('gsimClockDuration', 0))">
            <valueEval><![CDATA[ ( query("/GPUEuFpuEmActiveBase/ConditionalGPUBusyData[%True]") ) ]]></valueEval>
          </xsl:if>
        </xsl:otherwise>
      </xsl:choose>
      <issueEval><![CDATA[ query("/GPUFPUEmIssue") ]]></issueEval>
      <issueText>%FPUEmIssueText</issueText>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUEuFpuSysActiveInKernel" displayName="%{$gpuPrefix}EuFpu{$alu2Name}Active">
      <queryInherit>/GPUEuFpuSysActiveBase</queryInherit>
      <description><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>EuFpu</xsl:text>
        <xsl:value-of select="$alu2Name"/>
        <xsl:text>ActiveDescription</xsl:text></description>
      <xsl:choose>
        <xsl:when test="fnc:is_universal_collector_in_multirun_mode()">
          <valueEval><![CDATA[ ( query("/GPUEuFpuSysActiveBase/ConditionalGPUBusyAndEuFpuSysActiveSamplesExist[%True]") ) ]]></valueEval>
        </xsl:when>
        <xsl:otherwise>
          <xsl:if test="not (exsl:ctx('gsimClockDuration', 0))">
            <valueEval><![CDATA[ ( query("/GPUEuFpuSysActiveBase/ConditionalGPUBusyData[%True]") ) ]]></valueEval>
          </xsl:if>
        </xsl:otherwise>
      </xsl:choose>
      <issueEval><![CDATA[ query("/GPUFPUSysIssue") ]]></issueEval>
      <issueText>%FPUIssueText</issueText>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUEuSendActiveBase" displayName="%{$gpuPrefix}EuSendActive">
      <helpKeyword>configs.gpueusendactive_gpueusendactivedescription</helpKeyword>
      <valueType>ratio</valueType>
      <queryInherit>/GPUEuSendActiveMetric</queryInherit>
      <description><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>EuSendActiveDescription</xsl:text></description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>0,128,255</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <maxEval>1</maxEval>
        <diagramObjectId>EuSendActiveSlot</diagramObjectId>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUEuControlActiveBase" displayName="%{$gpuPrefix}EuControlActive">
      <helpKeyword>configs.gpueucontrolactive_gpueucontrolactivedescription</helpKeyword>
      <valueType>ratio</valueType>
      <queryInherit>/GPUControlActiveMetric</queryInherit>
      <description><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>EuControlActiveDescription</xsl:text></description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>255,0,0</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <maxEval>1</maxEval>
        <diagramObjectId>EuControlActiveSlot</diagramObjectId>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUSendActiveBase" displayName="%{$gpuPrefix}EuSendActive">
      <helpKeyword>configs.gpueusendactive_gpueusendactivedescription</helpKeyword>
      <valueType>ratio</valueType>
      <queryInherit>/GPUSendActiveMetric</queryInherit>
      <description><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>EuSendActiveDescription</xsl:text></description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>0,128,255</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <maxEval>1</maxEval>
        <diagramObjectId>EuSendActiveSlot</diagramObjectId>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUEuSendActive" displayName="%{$gpuPrefix}EuSendActive">
      <queryInherit>/GPUEuSendActiveBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUEuSendActiveBase/ConditionalEuSendActiveSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUEuControlActive" displayName="%{$gpuPrefix}EuControlActive">
      <queryInherit>/GPUEuControlActiveBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUEuControlActiveBase/ConditionalEuControlActiveSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUSendInstructionsBase" displayName="%{$gpuPrefix}EuSendInstructions">
      <helpKeyword>configs.gpueusendactive_gpueusendactivedescription</helpKeyword>
      <queryInherit>/GPUEU_INST_EXECUTED_SEND_ALLMetric</queryInherit>
      <description><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>EuSendInstructionsDescription</xsl:text></description>
      <valueType>count</valueType>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>0,128,255</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <maxEval>1</maxEval>
        <diagramObjectId>EuSendActiveSlot</diagramObjectId>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUControlInstructionsBase" displayName="%{$gpuPrefix}EuControlInstructions">
      <helpKeyword>configs.gpueucontrolactive_gpueucontrolactivedescription</helpKeyword>
      <queryInherit>/GPUEU_INST_EXECUTED_CONTROL_ALLMetric</queryInherit>
      <description><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>EuControlInstructionsDescription</xsl:text></description>
      <valueType>count</valueType>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>255,0,0</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <maxEval>1</maxEval>
        <diagramObjectId>EuControlActiveSlot</diagramObjectId>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUBitconvInstructionsBase" displayName="%GPUXEEuBitconvInstructions">
      <helpKeyword>configs.gpueubitconvactive_gpueubitconvactivedescription</helpKeyword>
      <queryInherit>/GPUXVE_INST_EXECUTED_BITCONVMetric</queryInherit>
      <description>%GPUXEEuBitconvInstructionsDescription</description>
      <valueType>count</valueType>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>170,170,170</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <maxEval>1</maxEval>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUBarrierInstructionsBase" displayName="%GPUXEEuBarrierInstructions">
      <helpKeyword>configs.gpueubarrieractive_gpueubarrieractivedescription</helpKeyword>
      <queryInherit>/GPUXVE_INST_EXECUTED_BARRIERMetric</queryInherit>
      <description>%GPUXEEuBarrierInstructionsDescription</description>
      <valueType>count</valueType>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>100,50,0</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <maxEval>1</maxEval>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUMathInstructionsBase" displayName="%GPUXEEuMathInstructions">
      <helpKeyword>configs.gpueumathactive_gpueumathactivedescription</helpKeyword>
      <queryInherit>/GPUXVE_INST_EXECUTED_MATHMetric</queryInherit>
      <description>%GPUXEEuMathInstructionsDescription</description>
      <valueType>count</valueType>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>20,20,170</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <maxEval>1</maxEval>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUInt16InstructionsBase" displayName="%GPUXEEuInt16Instructions">
      <helpKeyword>configs.gpueuint16active_gpueuint16activedescription</helpKeyword>
      <queryInherit>/GPUXVE_INST_EXECUTED_INT16Metric</queryInherit>
      <description>%GPUXEEuInt16InstructionsDescription</description>
      <valueType>count</valueType>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>100,50,0</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <maxEval>1</maxEval>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUInt32InstructionsBase" displayName="%GPUXEEuInt32Instructions">
      <helpKeyword>configs.gpueuint32active_gpueuint32activedescription</helpKeyword>
      <queryInherit>/GPUXVE_INST_EXECUTED_INT32Metric</queryInherit>
      <description>%GPUXEEuInt32InstructionsDescription</description>
      <valueType>count</valueType>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>100,50,0</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <maxEval>1</maxEval>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUInt64InstructionsBase" displayName="%GPUXEEuInt64Instructions">
      <helpKeyword>configs.gpueuint64active_gpueuint64activedescription</helpKeyword>
      <queryInherit>/GPUXVE_INST_EXECUTED_INT64Metric</queryInherit>
      <description>%GPUXEEuInt64InstructionsDescription</description>
      <valueType>count</valueType>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>100,50,0</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <maxEval>1</maxEval>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUFp32InstructionsBase" displayName="%GPUXEEuFp32Instructions">
      <helpKeyword>configs.gpueufp32active_gpueufp32activedescription</helpKeyword>
      <queryInherit>/GPUXVE_INST_EXECUTED_FP32Metric</queryInherit>
      <description>%GPUXEEuFp32InstructionsDescription</description>
      <valueType>count</valueType>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>100,50,0</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <maxEval>1</maxEval>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUFp16InstructionsBase" displayName="%GPUXEEuFp16Instructions">
      <helpKeyword>configs.gpueufp16active_gpueufp16activedescription</helpKeyword>
      <queryInherit>/GPUXVE_INST_EXECUTED_FP16Metric</queryInherit>
      <description>%GPUXEEuFp16InstructionsDescription</description>
      <valueType>count</valueType>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>100,50,0</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <maxEval>1</maxEval>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUFp64InstructionsBase" displayName="%GPUXEEuFp64Instructions">
      <helpKeyword>configs.gpueufp64active_gpueufp64activedescription</helpKeyword>
      <queryInherit>/GPUXVE_INST_EXECUTED_FP64Metric</queryInherit>
      <description>%GPUXEEuFp64InstructionsDescription</description>
      <valueType>count</valueType>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>100,50,0</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <maxEval>1</maxEval>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUXmxFp16InstructionsBase" displayName="%GPUXEEuXmxFp16Instructions">
      <helpKeyword>configs.gpueuxmxfp16active_gpueuxmxfp16activedescription</helpKeyword>
      <queryInherit>/GPUXVE_INST_EXECUTED_XMX_FP16Metric</queryInherit>
      <description>%GPUXEEuXmxFp16InstructionsDescription</description>
      <valueType>count</valueType>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>100,50,0</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <maxEval>1</maxEval>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUXmxBf16InstructionsBase" displayName="%GPUXEEuXmxBf16Instructions">
      <helpKeyword>configs.gpueuxmxbf16active_gpueuxmxbf16activedescription</helpKeyword>
      <queryInherit>/GPUXVE_INST_EXECUTED_XMX_BF16Metric</queryInherit>
      <description>%GPUXEEuXmxBf16InstructionsDescription</description>
      <valueType>count</valueType>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>100,50,0</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <maxEval>1</maxEval>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUXmxInt8InstructionsBase" displayName="%GPUXEEuXmxInt8Instructions">
      <helpKeyword>configs.gpueuxmxbint8active_gpueuxmxint8activedescription</helpKeyword>
      <queryInherit>/GPUXVE_INST_EXECUTED_XMX_INT8Metric</queryInherit>
      <description>%GPUXEEuXmxInt8InstructionsDescription</description>
      <valueType>count</valueType>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>100,50,0</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <maxEval>1</maxEval>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUXmxInt4InstructionsBase" displayName="%GPUXEEuXmxInt4Instructions">
      <helpKeyword>configs.gpueuxmxbint4active_gpueuxmxint4activedescription</helpKeyword>
      <queryInherit>/GPUXVE_INST_EXECUTED_XMX_INT4Metric</queryInherit>
      <description>%GPUXEEuXmxInt4InstructionsDescription</description>
      <valueType>count</valueType>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>100,50,0</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <maxEval>1</maxEval>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUXmxInt2InstructionsBase" displayName="%GPUXEEuXmxInt2Instructions">
      <helpKeyword>configs.gpueuxmxbint2active_gpueuxmxint2activedescription</helpKeyword>
      <queryInherit>/GPUXVE_INST_EXECUTED_XMX_INT2Metric</queryInherit>
      <description>%GPUXEEuXmxInt2InstructionsDescription</description>
      <valueType>count</valueType>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>100,50,0</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <maxEval>1</maxEval>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUEuSysActiveBase" displayName="%{$gpuPrefix}Eu{$alu2Name}Active">
      <helpKeyword>configs.gpueusysactive_gpueusysactivedescription</helpKeyword>
      <valueType>ratio</valueType>
      <xsl:choose>
        <xsl:when test="contains(exsl:ctx('gpuCounters', ''), 'euactivity8') and not(exsl:is_value_exist('dd_uncore_event_type', 'name', 'SysActive'))">
          <queryInherit>/GPUEmActiveMetric</queryInherit>
        </xsl:when>
        <xsl:otherwise>
          <queryInherit>/GPUSysActiveMetric</queryInherit>
        </xsl:otherwise>
      </xsl:choose>
      <description><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>Eu</xsl:text>
        <xsl:value-of select="$alu2Name"/>
        <xsl:text>ActiveDescription</xsl:text></description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>0,0,0</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <maxEval>1</maxEval>
        <diagramObjectId>EuSysActiveSlot</diagramObjectId>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUEuSysInstructionsBase" displayName="%{$gpuPrefix}Eu{$alu2Name}Instructions">
      <helpKeyword>configs.gpueusysactive_gpueusysactivedescription</helpKeyword>
      <queryInherit>/GPUEU_INST_EXECUTED_SYSTOLIC_ALLMetric</queryInherit>
      <description><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>Eu</xsl:text><xsl:value-of select="$alu2Name"/><xsl:text>InstructionsDescription</xsl:text></description>
      <valueType>count</valueType>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>0,0,0</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <maxEval>1</maxEval>
        <diagramObjectId>EuSysActiveSlot</diagramObjectId>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUEuEmActiveBase" displayName="%{$gpuPrefix}EuEmActive">
      <helpKeyword>configs.gpueuemactive_gpueuemactivedescription</helpKeyword>
      <valueType>ratio</valueType>
      <xsl:choose>
        <xsl:when test="contains(exsl:ctx('gpuCounters', ''), 'euactivity8') and exsl:is_value_exist('dd_uncore_event_type', 'name', 'EmActive')">
          <queryInherit>/GPUSysActiveMetric</queryInherit>
        </xsl:when>
        <xsl:otherwise>
          <queryInherit>/GPUEmActiveMetric</queryInherit>
        </xsl:otherwise>
      </xsl:choose>
      <queryInherit>/GPUEmActiveMetric</queryInherit>
      <description><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>EuEmActiveDescription</xsl:text></description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>255,128,0</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <maxEval>1</maxEval>
        <diagramObjectId>EuEmActiveSlot</diagramObjectId>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUEuEmInstructionsBase" displayName="%{$gpuPrefix}EuEmInstructions">
      <helpKeyword>configs.gpueuemactive_gpueuemactivedescription</helpKeyword>
      <queryInherit>/GPUEU_INST_EXECUTED_ALU1_ALLMetric</queryInherit>
      <description><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>EuEmInstructionsDescription</xsl:text></description>
      <valueType>count</valueType>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>255,128,0</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <maxEval>1</maxEval>
        <diagramObjectId>EuEmActiveSlot</diagramObjectId>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUEuFpuActiveBase" displayName="%{$gpuPrefix}EuFpuActive">
      <helpKeyword>configs.gpueufpuactive_gpueufpuactivedescription</helpKeyword>
      <valueType>ratio</valueType>
      <queryInherit>/GPUEuFpuActiveMetric</queryInherit>
      <description><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>EuFpuActiveDescription</xsl:text></description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>0,128,64</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <maxEval>1</maxEval>
        <diagramObjectId>EuFpuActiveSlot</diagramObjectId>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUFpuActiveBase" displayName="%{$gpuPrefix}EuFpuActive">
      <helpKeyword>configs.gpueufpuactive_gpueufpuactivedescription</helpKeyword>
      <valueType>ratio</valueType>
      <queryInherit>/GPUFpuActiveMetric</queryInherit>
      <description><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>EuFpuActiveDescription</xsl:text></description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>0,128,64</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <maxEval>1</maxEval>
        <diagramObjectId>EuFpuActiveSlot</diagramObjectId>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUEuFpuInstructionsBase" displayName="%{$gpuPrefix}EuFpuInstructions">
      <helpKeyword>configs.gpueufpuactive_gpueufpuactivedescription</helpKeyword>
      <queryInherit>/GPUEU_INST_EXECUTED_ALU0_ALLMetric</queryInherit>
      <description><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>EuFpuInstructionsDescription</xsl:text></description>
      <valueType>count</valueType>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>0,128,64</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <maxEval>1</maxEval>
        <diagramObjectId>EuFpuActiveSlot</diagramObjectId>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUStallInstfetchBase" displayName="%GPUXEEuStallInstfetch">
      <helpKeyword>configs.gpueustallinstfetch_gpueustallinstfetchdescription</helpKeyword>
      <queryInherit>/GPUXVE_STALL_INSTFETCHMetric</queryInherit>
      <description>%GPUXEEuStallInstfetchDescription</description>
      <valueType>ratio</valueType>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>255,128,0</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <maxEval>1</maxEval>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUStallBarrierBase" displayName="%GPUXEEuStallBarrier">
      <helpKeyword>configs.gpueustallbarrier_gpueustallbarrierdescription</helpKeyword>
      <queryInherit>/GPUXVE_STALL_BARRIERMetric</queryInherit>
      <description>%GPUXEEuStallBarrierDescription</description>
      <valueType>ratio</valueType>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>100,50,0</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <maxEval>1</maxEval>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUStallSbidBase" displayName="%GPUXEEuStallSbid">
      <helpKeyword>configs.gpueustallsbid_gpueustallsbiddescription</helpKeyword>
      <queryInherit>/GPUXVE_STALL_SBIDMetric</queryInherit>
      <description>%GPUXEEuStallSbidDescription</description>
      <valueType>ratio</valueType>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>255,0,0</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <maxEval>1</maxEval>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUStallAluwrBase" displayName="%GPUXEEuStallAluwr">
      <helpKeyword>configs.gpueustallaluwr_gpueustallaluwrdescription</helpKeyword>
      <queryInherit>/GPUXVE_STALL_ALUWRMetric</queryInherit>
      <description>%GPUXEEuStallAluwrDescription</description>
      <valueType>ratio</valueType>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>20,20,170</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <maxEval>1</maxEval>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUStallSendwrBase" displayName="%GPUXEEuStallSendwr">
      <helpKeyword>configs.gpueustallsendwr_gpueustallsendwrdescription</helpKeyword>
      <queryInherit>/GPUXVE_STALL_SENDWRMetric</queryInherit>
      <description>%GPUXEEuStallSendwrDescription</description>
      <valueType>ratio</valueType>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>0,0,0</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <maxEval>1</maxEval>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUStallPipeBase" displayName="%GPUXEEuStallPipe">
      <helpKeyword>configs.gpueustallpipe_gpueustallpipedescription</helpKeyword>
      <queryInherit>/GPUXVE_STALL_PIPESTALLMetric</queryInherit>
      <description>%GPUXEEuStallPipeDescription</description>
      <valueType>ratio</valueType>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>0,128,64</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <maxEval>1</maxEval>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUStallControlBase" displayName="%GPUXEEuStallControl">
      <helpKeyword>configs.gpueustallcontrol_gpueustallcontroldescription</helpKeyword>
      <queryInherit>/GPUXVE_STALL_CONTROLMetric</queryInherit>
      <description>%GPUXEEuStallControlDescription</description>
      <valueType>ratio</valueType>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>0,128,255</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <maxEval>1</maxEval>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUStallOtherBase" displayName="%GPUXEEuStallOther">
      <helpKeyword>configs.gpueustallother_gpueustallotherdescription</helpKeyword>
      <queryInherit>/GPUXVE_STALL_OTHERMetric</queryInherit>
      <description>%GPUXEEuStallOtherDescription</description>
      <valueType>ratio</valueType>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>170,170,170</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <maxEval>1</maxEval>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUSendActive" displayName="%{$gpuPrefix}EuSendActive">
      <queryInherit>/GPUSendActiveBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUSendActiveBase/ConditionalSendActiveSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUEuSysActive" displayName="%{$gpuPrefix}Eu{$alu2Name}ActiveShort">
      <queryInherit>/GPUEuSysActiveBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUEuSysActiveBase/ConditionalSysActiveSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUEuEmActive" displayName="%{$gpuPrefix}EuEmActiveShort">
      <queryInherit>/GPUEuEmActiveBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUEuEmActiveBase/ConditionalEmActiveSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUSendInstructions" displayName="%{$gpuPrefix}EuSendInstructions">
      <queryInherit>/GPUSendInstructionsBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUSendInstructionsBase/ConditionalEU_INST_EXECUTED_SEND_ALLSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUBitconvInstructions" displayName="%GPUXEEuBitconvInstructions">
      <queryInherit>/GPUBitconvInstructionsBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUBitconvInstructionsBase/ConditionalXVE_INST_EXECUTED_BITCONVSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUBarrierInstructions" displayName="%GPUXEEuBarrierInstructions">
      <queryInherit>/GPUBarrierInstructionsBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUBarrierInstructionsBase/ConditionalXVE_INST_EXECUTED_BARRIERSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUMathInstructions" displayName="%GPUXEEuMathInstructions">
      <queryInherit>/GPUMathInstructionsBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUMathInstructionsBase/ConditionalXVE_INST_EXECUTED_MATHSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUInt16Instructions" displayName="%GPUXEEuInt16Instructions">
      <queryInherit>/GPUInt16InstructionsBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUInt16InstructionsBase/ConditionalXVE_INST_EXECUTED_INT16SamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUInt32Instructions" displayName="%GPUXEEuInt32Instructions">
      <queryInherit>/GPUInt32InstructionsBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUInt32InstructionsBase/ConditionalXVE_INST_EXECUTED_INT32SamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUInt64Instructions" displayName="%GPUXEEuInt64Instructions">
      <queryInherit>/GPUInt64InstructionsBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUInt64InstructionsBase/ConditionalXVE_INST_EXECUTED_INT64SamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUFp16Instructions" displayName="%GPUXEEuFp16Instructions">
      <queryInherit>/GPUFp16InstructionsBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUFp16InstructionsBase/ConditionalXVE_INST_EXECUTED_FP16SamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUFp32Instructions" displayName="%GPUXEEuFp32Instructions">
      <queryInherit>/GPUFp32InstructionsBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUFp32InstructionsBase/ConditionalXVE_INST_EXECUTED_FP32SamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUFp64Instructions" displayName="%GPUXEEuFp64Instructions">
      <queryInherit>/GPUFp64InstructionsBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUFp64InstructionsBase/ConditionalXVE_INST_EXECUTED_FP64SamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUXmxFp16Instructions" displayName="%GPUXEEuXmxFp16Instructions">
      <queryInherit>/GPUXmxFp16InstructionsBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUXmxFp16InstructionsBase/ConditionalXVE_INST_EXECUTED_XMX_FP16SamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUXmxBf16Instructions" displayName="%GPUXEEuXmxBf16Instructions">
      <queryInherit>/GPUXmxBf16InstructionsBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUXmxBf16InstructionsBase/ConditionalXVE_INST_EXECUTED_XMX_BF16SamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUXmxInt8Instructions" displayName="%GPUXEEuXmxInt8Instructions">
      <queryInherit>/GPUXmxInt8InstructionsBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUXmxInt8InstructionsBase/ConditionalXVE_INST_EXECUTED_XMX_INT8SamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUXmxInt4Instructions" displayName="%GPUXEEuXmxInt4Instructions">
      <queryInherit>/GPUXmxInt4InstructionsBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUXmxInt4InstructionsBase/ConditionalXVE_INST_EXECUTED_XMX_INT4SamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUXmxInt2Instructions" displayName="%GPUXEEuXmxInt2Instructions">
      <queryInherit>/GPUXmxInt2InstructionsBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUXmxInt2InstructionsBase/ConditionalXVE_STALL_INSTFETCHSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUControlInstructions" displayName="%{$gpuPrefix}EuControlInstructions">
      <queryInherit>/GPUControlInstructionsBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUControlInstructionsBase/ConditionalEU_INST_EXECUTED_CONTROL_ALLSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUEuSysInstructions" displayName="%{$gpuPrefix}Eu{$alu2Name}InstructionsShort">
      <queryInherit>/GPUEuSysInstructionsBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUEuSysInstructionsBase/ConditionalEU_INST_EXECUTED_SYSTOLIC_ALLSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUEuEmInstructions" displayName="%{$gpuPrefix}EuEmActiveShort">
      <queryInherit>/GPUEuEmInstructionsBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUEuEmInstructionsBase/ConditionalEU_INST_EXECUTED_ALU1_ALLSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUEuFpuActive" displayName="%{$gpuPrefix}EuFpuActiveShort">
      <queryInherit>/GPUEuFpuActiveBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUEuFpuActiveBase/ConditionalEuFpuActiveSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUFpuActive" displayName="%{$gpuPrefix}EuFpuActiveShort">
      <queryInherit>/GPUFpuActiveBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUFpuActiveBase/ConditionalFpuActiveSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUEuFpuInstructions" displayName="%{$gpuPrefix}EuFpuInstructionsShort">
      <queryInherit>/GPUEuFpuInstructionsBase</queryInherit>
        <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUEuFpuInstructionsBase/ConditionalEU_INST_EXECUTED_ALU0_ALLSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUStallInstfetch" displayName="%GPUXEEuStallInstfetch">
      <queryInherit>/GPUStallInstfetchBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUStallInstfetchBase/ConditionalXVE_STALL_INSTFETCHSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUStallBarrier" displayName="%GPUXEEuStallBarrier">
      <queryInherit>/GPUStallBarrierBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUStallBarrierBase/ConditionalXVE_STALL_BARRIERSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUStallSbid" displayName="%GPUXEEuStallBarrier">
      <queryInherit>/GPUStallSbidBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUStallSbidBase/ConditionalXVE_STALL_SBIDSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUStallAluwr" displayName="%GPUXEEuStallAluwr">
      <queryInherit>/GPUStallAluwrBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUStallAluwrBase/ConditionalXVE_STALL_ALUWRSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUStallSendwr" displayName="%GPUXEEuStallSendwr">
      <queryInherit>/GPUStallSendwrBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUStallSendwrBase/ConditionalXVE_STALL_SENDWRSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUStallPipe" displayName="%GPUXEEuStallPipe">
      <queryInherit>/GPUStallPipeBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUStallPipeBase/ConditionalXVE_STALL_PIPESTALLSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUStallControl" displayName="%GPUXEEuStallControl">
      <queryInherit>/GPUStallControlBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUStallControlBase/ConditionalXVE_STALL_CONTROLSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUStallOther" displayName="%GPUXEEuStallOther">
      <queryInherit>/GPUStallOtherBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUStallOtherBase/ConditionalXVE_STALL_OTHERSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUTypedReadCoalRatioBase" displayName="%GPUTypedReadCoalRatio">
      <helpKeyword>configs.gputypedreadcoalratio_gpucoalratiouniversaldescription</helpKeyword>
      <valueType>ratio</valueType>
      <queryInherit>/GPUTypedReadsPerCacheLineMetric</queryInherit>
      <description>%GPUCoalRatioUniversalDescription</description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>0,64,255</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUTypedReadCoalRatio" displayName="%GPUTypedReadCoalRatio">
      <queryInherit>/GPUTypedReadCoalRatioBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUTypedReadCoalRatioBase/ConditionalTypedReadsPerCacheLineSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <xsl:if test="not (exsl:ctx('gsimClockDuration', 0))">
        <confidenceEval><![CDATA[ (query("/GPUSampleCount/GPUEventType[TypedReadsPerCacheLine]") > 5) ]]></confidenceEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUTypedWriteCoalRatioBase" displayName="%GPUTypedWriteCoalRatio">
      <helpKeyword>configs.gputypedwritecoalratio_gpucoalratiouniversaldescription</helpKeyword>
      <valueType>ratio</valueType>
      <queryInherit>/GPUTypedWritesPerCacheLineMetric</queryInherit>
      <description>%GPUCoalRatioUniversalDescription</description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>255,102,255</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
      <maxEval>1</maxEval>
    </derivedQuery>
    <derivedQuery id="GPUTypedWriteCoalRatio" displayName="%GPUTypedWriteCoalRatio">
      <queryInherit>/GPUTypedWriteCoalRatioBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUTypedWriteCoalRatioBase/ConditionalTypedWritesPerCacheLineSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <xsl:if test="not (exsl:ctx('gsimClockDuration', 0))">
        <confidenceEval><![CDATA[ (query("/GPUSampleCount/GPUEventType[TypedWritesPerCacheLine]") > 5) ]]></confidenceEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUUntypedReadCoalRatioBase" displayName="%GPUUntypedReadCoalRatio">
      <helpKeyword>configs.gpuuntypedreadcoalratio_gpucoalratiouniversaldescription</helpKeyword>
      <valueType>ratio</valueType>
      <queryInherit>/GPUUntypedReadsPerCacheLineMetric</queryInherit>
      <description>%GPUCoalRatioUniversalDescription</description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>0,64,128</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
      <maxEval>1</maxEval>
    </derivedQuery>
    <derivedQuery id="GPUUntypedReadCoalRatio" displayName="%GPUUntypedReadCoalRatio">
      <queryInherit>/GPUUntypedReadCoalRatioBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUUntypedReadCoalRatioBase/ConditionalUntypedReadsPerCacheLineSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <xsl:if test="not (exsl:ctx('gsimClockDuration', 0))">
        <confidenceEval><![CDATA[ (query("/GPUSampleCount/GPUEventType[UntypedReadsPerCacheLine]") > 5) ]]></confidenceEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUUntypedWriteCoalRatioBase" displayName="%GPUUntypedWriteCoalRatio">
      <helpKeyword>configs.gpuuntypedwritecoalratio_gpucoalratiouniversaldescription</helpKeyword>
      <valueType>ratio</valueType>
      <queryInherit>/GPUUntypedWritesPerCacheLineMetric</queryInherit>
      <description>%GPUCoalRatioUniversalDescription</description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>204,0,153</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
      <maxEval>1</maxEval>
    </derivedQuery>
    <derivedQuery id="GPUUntypedWriteCoalRatio" displayName="%GPUUntypedWriteCoalRatio">
      <queryInherit>/GPUUntypedWriteCoalRatioBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUUntypedWriteCoalRatioBase/ConditionalUntypedWritesPerCacheLineSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <xsl:if test="not (exsl:ctx('gsimClockDuration', 0))">
        <confidenceEval><![CDATA[ (query("/GPUSampleCount/GPUEventType[UntypedWritesPerCacheLine]") > 5) ]]></confidenceEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUShaderBarriers" displayName="%GPUShaderBarriers">
      <valueType>int</valueType>
      <queryInherit>/GPUShaderBarriersMetric</queryInherit>
      <displayAttributes>
        <timeScalems>1000</timeScalems>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>170,0,0</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUShaderAtomics" displayName="%GPUShaderAtomics">
      <valueType>int</valueType>
      <queryInherit>/GPUShaderAtomicsMetric</queryInherit>
      <displayAttributes>
        <timeScalems>1000</timeScalems>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>250,102,102</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUSLMAtomicsBase" displayName="%GPUSLMAtomics">
      <valueType>int</valueType>
      <queryInherit>/GPUXVE_SLM_ATOMIC_MESSAGE_COUNTMetric</queryInherit>
      <displayAttributes>
        <timeScalems>1000</timeScalems>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>250,102,102</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUSLMAtomics" displayName="%GPUSLMAtomics">
      <valueType>int</valueType>
      <queryInherit>/GPUSLMAtomicsBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUSLMAtomicsBase/ConditionalXVE_SLM_ATOMIC_MESSAGE_COUNTSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
      <description>%GPUSLMAtomicDescription</description>
    </derivedQuery>
    <derivedQuery id="GPULSCAtomicsBase" displayName="%GPULSCAtomics">
      <valueType>int</valueType>
      <queryInherit>/GPUXVE_LOAD_STORE_CACHE_ATOMIC_MESSAGE_COUNTMetric</queryInherit>
      <displayAttributes>
        <timeScalems>1000</timeScalems>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>250,102,102</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPULSCAtomics" displayName="%GPULSCAtomics">
      <valueType>int</valueType>
      <queryInherit>/GPULSCAtomicsBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPULSCAtomicsBase/ConditionalXVE_LOAD_STORE_CACHE_ATOMIC_MESSAGE_COUNTSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
      <description>%GPULSCAtomicDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUSLMFenceBase" displayName="%GPUSLMFence">
      <valueType>int</valueType>
      <queryInherit>/GPUXVE_SLM_FENCE_MESSAGE_COUNTMetric</queryInherit>
      <displayAttributes>
        <timeScalems>1000</timeScalems>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>250,102,102</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUSLMFence" displayName="%GPUSLMFence">
      <valueType>int</valueType>
      <queryInherit>/GPUSLMFenceBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUSLMFenceBase/ConditionalXVE_SLM_FENCE_MESSAGE_COUNTSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
      <description>%GPUSLMFenceDescription</description>
    </derivedQuery>
    <derivedQuery id="GPULSCFenceBase" displayName="%GPULSCFence">
      <valueType>int</valueType>
      <queryInherit>/GPUXVE_LOAD_STORE_CACHE_FENCE_MESSAGE_COUNTMetric</queryInherit>
      <displayAttributes>
        <timeScalems>1000</timeScalems>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>250,102,102</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPULSCFence" displayName="%GPULSCFence">
      <valueType>int</valueType>
      <queryInherit>/GPULSCFenceBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPULSCFenceBase/ConditionalXVE_LOAD_STORE_CACHE_FENCE_MESSAGE_COUNTSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
      <description>%GPUSLMFenceDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUL3AtomicsBase" displayName="%GPUL3Atomics">
      <valueType>int</valueType>
      <queryInherit>/GPUL3_ATOMIC_ACCESSMetric</queryInherit>
      <displayAttributes>
        <timeScalems>1000</timeScalems>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>250,102,102</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUL3Atomics" displayName="%GPUL3Atomics">
      <valueType>int</valueType>
      <queryInherit>/GPULSCAtomicsBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPULSCAtomicsBase/ConditionalL3_ATOMIC_ACCESSSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
      <description>%GPUL3AtomicDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUSLMBankConflictBase" displayName="%GPUSLMBankConflict">
      <valueType>int</valueType>
      <queryInherit>/GPUSLM_BANK_CONFLICT_COUNTMetric</queryInherit>
      <displayAttributes>
        <timeScalems>1000</timeScalems>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>250,102,102</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUSLMBankConflict" displayName="%GPUSLMBankConflict">
      <valueType>int</valueType>
      <queryInherit>/GPUSLMBankConflictBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUSLMBankConflictBase/ConditionalSLM_BANK_CONFLICT_COUNTSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
      <description>%GPUSLMBankConflictDescription</description>
    </derivedQuery>
    <derivedQuery id="GPULSCPartialWritesBase" displayName="%GPULSCPartialWrites">
      <valueType>int</valueType>
      <queryInherit>/GPULOAD_STORE_CACHE_PARTIAL_WRITE_COUNTMetric</queryInherit>
      <displayAttributes>
        <timeScalems>1000</timeScalems>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>250,102,102</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPULSCPartialWrites" displayName="%GPULSCPartialWrites">
      <valueType>int</valueType>
      <queryInherit>/GPULSCPartialWritesBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPULSCPartialWritesBase/ConditionalLOAD_STORE_CACHE_PARTIAL_WRITE_COUNTSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
      <description>%GPULSCPartialWritesDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUTLBMissBase" displayName="%GPUTLBMiss">
      <valueType>int</valueType>
      <queryInherit>/GPUTLB_MISSMetric</queryInherit>
      <displayAttributes>
        <timeScalems>1000</timeScalems>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>250,102,102</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUTLBMiss" displayName="%GPUTLBMissCount">
      <valueType>int</valueType>
      <queryInherit>/GPUTLBMissBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUTLBMissBase/ConditionalTLB_MISSSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
      <description>%GPUTLBMissDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUUntypedMemoryReadGB" displayName="%BandwidthRead">
      <helpKeyword>configs.gpuuntypedmemoryread_gpuuntypedmemoryreaddescription</helpKeyword>
      <valueType>double</valueType>
      <xsl:choose>
        <xsl:when test="$universalCollectorUsed='true'">
          <queryInherit>/GPUUntypedBytesReadMetric</queryInherit>
        </xsl:when>
        <xsl:otherwise>
          <xsl:variable name="text">
            <xsl:choose>
              <xsl:when test="$gpuPlatform='IVB' or $gpuPlatform='HSW'">
                (query("/GPUEventCount/GPUEventType[Untyped Dataport Memory Reads Slice 0]") + query("/GPUEventCount/GPUEventType[Untyped Dataport Memory Reads Slice 1]")) * {$memoryMultiplier} * 64 / 1000000000
              </xsl:when>
              <xsl:when test="$gpuPlatform='VLV'">
                (query("/GPUEventCount/GPUEventType[Untyped Dataport Memory Reads Slice 0]")) * {$memoryMultiplier} * 64 / 1000000000
              </xsl:when>
            </xsl:choose>
          </xsl:variable>
          <valueEval>
            <xsl:value-of select="str:replace($text, '{$memoryMultiplier}', string($memoryMultiplier))"/>
          </valueEval>
        </xsl:otherwise>
      </xsl:choose>
      <description>%GPUUntypedMemoryReadDescription</description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>#75dbcb</timelineGraphColor>
        <timeScalems>1000</timeScalems>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUUntypedMemoryReadB" displayName="%BandwidthRead">
      <queryInherit>/GPUUntypedMemoryReadGB</queryInherit>
      <valueType>memory</valueType>
      <valueEval>
        <![CDATA[ (query("/GPUUntypedMemoryReadGB") * 1000000000) ]]>
      </valueEval>
    </derivedQuery>
    <derivedQuery id="GPUUntypedMemoryReadBandwidthBase" displayName="%GPUUntypedMemoryRead">
      <helpKeyword>configs.gpuuntypedmemoryread_gpuuntypedmemoryreaddescription</helpKeyword>
      <valueType>double</valueType>
      <boolean:valueSummable>false</boolean:valueSummable>
      <valueEval><![CDATA[ (query("/GPUUntypedMemoryReadGB") / query("/GPUElapsedTime")) ]]></valueEval>
      <description>%GPUUntypedMemoryReadDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUUntypedMemoryReadBandwidth" displayName="%GPUUntypedMemoryRead">
      <queryInherit>/GPUUntypedMemoryReadBandwidthBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUUntypedMemoryReadBandwidthBase/ConditionalUntypedBytesReadSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
      <percentBases>
        <queryRef>/GPUUntypedMemoryReadBDWAbsMaxGB</queryRef>
      </percentBases>
    </derivedQuery>
    <derivedQuery id="GPUUntypedMemoryReadBandwidthB" displayName="%GPUUntypedMemoryReadFlex">
      <queryInherit>/GPUUntypedMemoryReadBandwidth</queryInherit>
      <valueType>bandwidth</valueType>
      <valueEval>
        <![CDATA[ (query("/GPUUntypedMemoryReadBandwidth") * 1000000000) ]]>
      </valueEval>
    </derivedQuery>
    <derivedQuery id="GPUUntypedMemoryReadBDWMaxGB" displayName="%GPUUntypedMemoryReadBDWMaxGB">
      <helpKeyword>configs.gpuuntypedmemoryread_gpuuntypedmemoryreaddescription</helpKeyword>
      <valueType>double</valueType>
      <valueEval><![CDATA[ (query("/GPUUntypedBytesReadMetricMaxValue") / ( query("/GPUElapsedTime") * 1000000000 ) ) ]]></valueEval>
      <description>%GPUUntypedMemoryReadBDWMaxGBDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUUntypedMemoryReadBDWAbsMaxGB" displayName="%GPUUntypedMemoryReadBDWMaxGB">
      <helpKeyword>configs.gpuuntypedmemoryread_gpuuntypedmemoryreaddescription</helpKeyword>
      <valueType>double</valueType>
      <queryInherit>/GPUUntypedBytesReadMetricAbsMaxValue</queryInherit>
      <description>%GPUUntypedMemoryReadBDWMaxGBDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUUntypedMemoryReadBDWMaxRatio" displayName="%GPUBDWRatioUniversalName">
      <helpKeyword>configs.gpubdwratiouniversalname_gpureadbdwratiouniversaldescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ (query("/GPUUntypedMemoryReadBandwidth") /  query("/GPUUntypedMemoryReadBDWMaxGB")   ) ]]></valueEval>
      <description>%GPUReadBDWRatioUniversalDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUUntypedMemoryReadBDWAbsMaxRatio" displayName="%GPUBDWRatioUniversalName">
      <helpKeyword>configs.gpubdwratiouniversalname_gpureadbdwratiouniversaldescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ (query("/GPUUntypedMemoryReadBandwidth") /  query("/GPUUntypedMemoryReadBDWAbsMaxGB")   ) ]]></valueEval>
      <description>%GPUReadBDWRatioUniversalDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUUntypedMemoryWriteGB" displayName="%BandwidthWrite">
      <helpKeyword>configs.gpuuntypedmemorywrite_gpuuntypedmemorywritedescription</helpKeyword>
      <valueType>double</valueType>
      <queryInherit>/GPUUntypedBytesWrittenMetric</queryInherit>
      <description>%GPUUntypedMemoryWriteDescription</description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>#3765c1</timelineGraphColor>
        <timeScalems>1000</timeScalems>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUUntypedMemoryWriteB" displayName="%BandwidthWrite">
      <queryInherit>/GPUUntypedMemoryWriteGB</queryInherit>
      <valueType>memory</valueType>
      <valueEval>
        <![CDATA[ (query("/GPUUntypedMemoryWriteGB") * 1000000000) ]]>
      </valueEval>
    </derivedQuery>
    <derivedQuery id="GPUUntypedMemoryWriteBandwidthBase" displayName="%GPUUntypedMemoryWrite">
      <helpKeyword>configs.gpuuntypedmemorywrite_gpuuntypedmemorywritedescription</helpKeyword>
      <valueType>double</valueType>
      <boolean:valueSummable>false</boolean:valueSummable>
      <valueEval><![CDATA[ (query("/GPUUntypedMemoryWriteGB") / query("/GPUElapsedTime")) ]]></valueEval>
      <description>%GPUUntypedMemoryWriteDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUUntypedMemoryWriteBandwidth" displayName="%GPUUntypedMemoryWrite">
      <queryInherit>/GPUUntypedMemoryWriteBandwidthBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUUntypedMemoryWriteBandwidthBase/ConditionalUntypedBytesWrittenSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
      <percentBases>
        <queryRef>/GPUUntypedMemoryWriteBDWAbsMaxGB</queryRef>
      </percentBases>
    </derivedQuery>
    <derivedQuery id="GPUUntypedMemoryWriteBandwidthB" displayName="%GPUUntypedMemoryWriteFlex">
      <queryInherit>/GPUUntypedMemoryWriteBandwidth</queryInherit>
      <valueType>bandwidth</valueType>
      <valueEval>
        <![CDATA[ (query("/GPUUntypedMemoryWriteBandwidth") * 1000000000) ]]>
      </valueEval>
    </derivedQuery>
    <derivedQuery id="GPUUntypedMemoryWriteBDWMaxGB" displayName="%GPUUntypedMemoryWriteBDWMaxGB">
      <helpKeyword>configs.gpuuntypedmemorywrite_gpuuntypedmemorywritedescription</helpKeyword>
      <valueType>double</valueType>
      <valueEval><![CDATA[ (query("/GPUUntypedBytesWrittenMetricMaxValue") / ( query("/GPUElapsedTime") * 1000000000 ) ) ]]></valueEval>
      <description>%GPUUntypedMemoryWriteBDWMaxGBDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUUntypedMemoryWriteBDWAbsMaxGB" displayName="%GPUUntypedMemoryWriteBDWMaxGB">
      <helpKeyword>configs.gpuuntypedmemorywrite_gpuuntypedmemorywritedescription</helpKeyword>
      <valueType>double</valueType>
      <queryInherit>/GPUUntypedBytesWrittenMetricAbsMaxValue</queryInherit>
      <description>%GPUUntypedMemoryWriteBDWMaxGBDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUUntypedMemoryWriteBDWMaxRatio" displayName="%GPUBDWRatioUniversalName">
      <helpKeyword>configs.gpubdwratiouniversalname_gpuwritebdwratiouniversaldescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ (query("/GPUUntypedMemoryWriteBandwidth") /  query("/GPUUntypedMemoryWriteBDWMaxGB")   ) ]]></valueEval>
      <description>%GPUWriteBDWRatioUniversalDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUUntypedMemoryWriteBDWAbsMaxRatio" displayName="%GPUBDWRatioUniversalName">
      <helpKeyword>configs.gpubdwratiouniversalname_gpuwritebdwratiouniversaldescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ (query("/GPUUntypedMemoryWriteBandwidth") /  query("/GPUUntypedMemoryWriteBDWAbsMaxGB")   ) ]]></valueEval>
      <description>%GPUWriteBDWRatioUniversalDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUSharedLocalMemoryReadGB" displayName="%BandwidthRead">
      <helpKeyword>configs.gpusharedlocalmemoryread_gpusharedlocalmemoryreaddescription</helpKeyword>
      <valueType>double</valueType>
      <xsl:choose>
        <xsl:when test="exsl:ctx('gsimClockDuration', 0) > 0">
          <xsl:variable name="text">
            (query("/gSimGPUEventCount/gSimGPUEventType[SLMRead12]") + query("/gSimGPUEventCount/gSimGPUEventType[SLMRead9]")) * 128 / 1000000000
          </xsl:variable>
          <valueEval>
            <xsl:value-of select="str:replace($text, '{$memoryMultiplier}', string($memoryMultiplier))"/>
          </valueEval>
        </xsl:when>
        <xsl:otherwise>
          <queryInherit>/GPUSlmBytesReadMetric</queryInherit>
      </xsl:otherwise>
      </xsl:choose>
      <description>%GPUSharedLocalMemoryReadDescription</description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>#75dbcb</timelineGraphColor>
        <timeScalems>1000</timeScalems>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUSharedLocalMemoryReadB" displayName="%BandwidthRead">
      <queryInherit>/GPUSharedLocalMemoryReadGB</queryInherit>
      <valueType>memory</valueType>
      <valueEval>
        <![CDATA[ (query("/GPUSharedLocalMemoryReadGB") * 1000000000) ]]>
      </valueEval>
    </derivedQuery>
    <derivedQuery id="GPUSharedLocalMemoryReadBandwidthBase" displayName="%GPUSharedLocalMemoryRead">
      <helpKeyword>configs.gpusharedlocalmemoryread_gpusharedlocalmemoryreaddescription</helpKeyword>
      <valueType>double</valueType>
      <boolean:valueSummable>false</boolean:valueSummable>
      <valueEval><![CDATA[ (query("/GPUSharedLocalMemoryReadGB") / query("/GPUElapsedTime")) ]]></valueEval>
      <description>%GPUSharedLocalMemoryReadDescription</description>
      <displayAttributes>
        <boolean:vtNullAsZero>false</boolean:vtNullAsZero>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUSharedLocalMemoryReadBandwidth" displayName="%GPUSharedLocalMemoryRead">
      <queryInherit>/GPUSharedLocalMemoryReadBandwidthBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUSharedLocalMemoryReadBandwidthBase/ConditionalSlmBytesReadSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <xsl:if test="exsl:ctx('gsimClockDuration', 0) > 0">
        <confidenceEval><![CDATA[ ( (query("/gsimGPUSampleCount/gSimGPUEventType[SLMRead12]") > 5) || (query("/gsimGPUSampleCount/gSimGPUEventType[SLMRead9]") > 5) ) ]]></confidenceEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
      <percentBases>
        <queryRef>/GPUSLMReadBDWAbsMax</queryRef>
      </percentBases>
    </derivedQuery>
    <derivedQuery id="GPUSharedLocalMemoryReadBandwidthB" displayName="%GPUSharedLocalMemoryReadFlex">
      <queryInherit>/GPUSharedLocalMemoryReadBandwidth</queryInherit>
      <valueType>bandwidth</valueType>
      <valueEval>
        <![CDATA[ (query("/GPUSharedLocalMemoryReadBandwidth") * 1000000000) ]]>
      </valueEval>
    </derivedQuery>
    <derivedQuery id="GPUSLMReadBDWMax" displayName="%GPUSLMReadBDWMax">
      <helpKeyword>configs.gpusharedlocalmemoryread_gpusharedlocalmemoryreaddescription</helpKeyword>
      <valueType>double</valueType>
      <valueEval><![CDATA[ (query("/GPUSlmBytesReadMetricMaxValue") / query("/GPUElapsedTime") / 1000000000 ) ]]></valueEval>
      <description><xsl:value-of select="$gpuPrefixMessage"/>GPUSLMReadBDWMaxDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUSLMReadBDWAbsMax" displayName="%GPUSLMReadBDWMax">
      <helpKeyword>configs.gpusharedlocalmemoryread_gpusharedlocalmemoryreaddescription</helpKeyword>
      <valueType>double</valueType>
      <xsl:choose>
        <xsl:when test="exsl:ctx('gsimClockDuration', 0) > 0">
          <valueEval><![CDATA[ $gsimFrequency * $gsimSubSlicesCount * 128 / 1000000000 ]]></valueEval>
        </xsl:when>
        <xsl:otherwise>
          <queryInherit>/GPUSlmBytesReadMetricAbsMaxValue</queryInherit>
        </xsl:otherwise>
      </xsl:choose>
      <description>%GPUGPUSLMReadBDWMaxDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUSLMReadMaxRatio" displayName="%GPUBDWRatioUniversalName">
      <helpKeyword>configs.gpubdwratiouniversalname_gpureadbdwratiouniversaldescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ (query("/GPUSharedLocalMemoryReadBandwidth") / query("/GPUSLMReadBDWMax") ) ]]></valueEval>
      <description>%GPUReadBDWRatioUniversalDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUSLMReadAbsMaxRatio" displayName="%GPUBDWRatioUniversalName">
      <helpKeyword>configs.gpubdwratiouniversalname_gpureadbdwratiouniversaldescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ (query("/GPUSharedLocalMemoryReadBandwidth") / query("/GPUSLMReadBDWAbsMax") ) ]]></valueEval>
      <description>%GPUReadBDWRatioUniversalDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUSharedLocalMemoryWriteGB" displayName="%BandwidthWrite">
      <helpKeyword>configs.gpusharedlocalmemorywrite_gpusharedlocalmemorywritedescription</helpKeyword>
      <valueType>double</valueType>
      <xsl:choose>
      <xsl:when test="exsl:ctx('gsimClockDuration', 0) > 0">
        <xsl:variable name="text">
          (query("/gSimGPUEventCount/gSimGPUEventType[SLMWrite12]") + query("/gSimGPUEventCount/gSimGPUEventType[SLMWrite9]")) * {$memoryMultiplier} * 64 / 1000000000
        </xsl:variable>
        <valueEval>
          <xsl:value-of select="str:replace($text, '{$memoryMultiplier}', string($memoryMultiplier))"/>
        </valueEval>
      </xsl:when>
      <xsl:otherwise>
        <queryInherit>/GPUSlmBytesWrittenMetric</queryInherit>
      </xsl:otherwise>
      </xsl:choose>
      <description>%GPUSharedLocalMemoryWriteDescription</description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>#3765c1</timelineGraphColor>
        <timeScalems>1000</timeScalems>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUSharedLocalMemoryWriteB" displayName="%BandwidthWrite">
      <queryInherit>/GPUSharedLocalMemoryWriteGB</queryInherit>
      <valueType>memory</valueType>
      <valueEval>
        <![CDATA[ (query("/GPUSharedLocalMemoryWriteGB") * 1000000000) ]]>
      </valueEval>
    </derivedQuery>
    <derivedQuery id="GPUSharedLocalMemoryWriteBandwidthBase" displayName="%GPUSharedLocalMemoryWrite">
      <helpKeyword>configs.gpusharedlocalmemorywrite_gpusharedlocalmemorywritedescription</helpKeyword>
      <valueType>double</valueType>
      <boolean:valueSummable>false</boolean:valueSummable>
      <valueEval><![CDATA[ (query("/GPUSharedLocalMemoryWriteGB") / query("/GPUElapsedTime") ) ]]></valueEval>
      <description>%GPUSharedLocalMemoryWriteDescription</description>
      <displayAttributes>
        <boolean:vtNullAsZero>false</boolean:vtNullAsZero>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUSharedLocalMemoryWriteBandwidth" displayName="%GPUSharedLocalMemoryWrite">
      <queryInherit>/GPUSharedLocalMemoryWriteBandwidthBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUSharedLocalMemoryWriteBandwidthBase/ConditionalSlmBytesWrittenSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <xsl:if test="exsl:ctx('gsimClockDuration', 0) > 0">
        <confidenceEval><![CDATA[ ( (query("/gsimGPUSampleCount/gSimGPUEventType[SLMWrite12]") > 5) || (query("/gsimGPUSampleCount/gSimGPUEventType[SLMWrite9]") > 5) ) ]]></confidenceEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
      <percentBases>
        <queryRef>/GPUSLMWriteBDWAbsMax</queryRef>
      </percentBases>
    </derivedQuery>
    <derivedQuery id="GPUSharedLocalMemoryWriteBandwidthB" displayName="%GPUSharedLocalMemoryWriteFlex">
      <queryInherit>/GPUSharedLocalMemoryWriteBandwidth</queryInherit>
      <valueType>bandwidth</valueType>
      <valueEval>
        <![CDATA[ (query("/GPUSharedLocalMemoryWriteBandwidth") * 1000000000) ]]>
      </valueEval>
    </derivedQuery>
    <derivedQuery id="GPUSLMWriteBDWMax" displayName="%GPUSLMWriteBDWMax">
      <valueType>double</valueType>
      <valueEval><![CDATA[ (query("/GPUSlmBytesWrittenMetricMaxValue") / query("/GPUElapsedTime") / 1000000000 ) ]]></valueEval>
      <description>%GPUSLMWriteBDWMaxDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUSLMWriteBDWAbsMax" displayName="%GPUSLMWriteBDWMax">
      <valueType>double</valueType>
      <xsl:choose>
        <xsl:when test="exsl:ctx('gsimClockDuration', 0) > 0">
          <valueEval><![CDATA[ $gsimFrequency * $gsimSubSlicesCount * 128 / 1000000000 ]]></valueEval>
        </xsl:when>
        <xsl:otherwise>
          <queryInherit>/GPUSlmBytesWrittenMetricAbsMaxValue</queryInherit>
        </xsl:otherwise>
      </xsl:choose>
      <description>%GPUSLMWriteBDWMaxDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUSLMWriteMaxRatio" displayName="%GPUBDWRatioUniversalName">
      <helpKeyword>configs.gpubdwratiouniversalname_gpuwritebdwratiouniversaldescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ (query("/GPUSharedLocalMemoryWriteBandwidth") / query("/GPUSLMWriteBDWMax") ) ]]></valueEval>
      <description>%GPUWriteBDWRatioUniversalDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUSLMWriteAbsMaxRatio" displayName="%GPUBDWRatioUniversalName">
      <helpKeyword>configs.gpubdwratiouniversalname_gpuwritebdwratiouniversaldescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ (query("/GPUSharedLocalMemoryWriteBandwidth") / query("/GPUSLMWriteBDWAbsMax") ) ]]></valueEval>
      <description>%GPUWriteBDWRatioUniversalDescription</description>
    </derivedQuery>
  <xsl:for-each select="str:split(exsl:ctx('gpuAdapterNameList', ''), ';')">
    <xsl:variable name="currentGPUInfo" select="str:split(., '|')"/>
      <xsl:variable name="currentGPUBDF">
          <xsl:value-of select="concat('_', str:replace(str:replace(string($currentGPUInfo[1]), '.', '_'), ':', '_'), '_')" />
      </xsl:variable>
    <derivedQuery id="GPUMemoryReadGB{$currentGPUBDF}" displayName="%BandwidthRead">
      <helpKeyword>configs.gpumemoryread_gpumemoryreaddescription</helpKeyword>
      <valueType>double</valueType>
      <xsl:variable name="dgfxEventName" select="concat('GPU_MEMORY_BYTE_READ', $currentGPUBDF)"/>
      <queryInherit>
        <xsl:value-of select="concat('/GPU', $currentGPUBDF, 'GtiReadThroughputMetric')"/>
      </queryInherit>
      <xsl:choose>
        <xsl:when test="exsl:is_value_exist('dd_uncore_event_type', 'name', $dgfxEventName)">
          <description>%GPUMemoryReadDiscreteDescription</description>
        </xsl:when>
        <xsl:otherwise>
          <description>%GPUMemoryReadDescription</description>
        </xsl:otherwise>
      </xsl:choose>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>#75dbcb</timelineGraphColor>
        <timeScalems>1000</timeScalems>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
    </derivedQuery>
   <derivedQuery id="GPUMemoryWriteGB{$currentGPUBDF}" displayName="%BandwidthWrite">
     <helpKeyword>configs.gpumemorywrite_gpumemorywritedescription</helpKeyword>
     <valueType>double</valueType>
     <xsl:variable name="dgfxEventName" select="concat('GPU_MEMORY_BYTE_WRITE', $currentGPUBDF)"/>z
     <queryInherit>
       <xsl:value-of select="concat('/GPU', $currentGPUBDF, 'GtiWriteThroughputMetric')"/>
     </queryInherit>
     <xsl:choose>
       <xsl:when test="exsl:is_value_exist('dd_uncore_event_type', 'name', $dgfxEventName)">
         <description>%GPUMemoryWriteDiscreteDescription</description>
       </xsl:when>
       <xsl:otherwise>
         <description>%GPUMemoryWriteDescription</description>
       </xsl:otherwise>
      </xsl:choose>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>#3765c1</timelineGraphColor>
        <timeScalems>1000</timeScalems>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUStackToStackReceiveGB{$currentGPUBDF}" displayName="%BandwidthReceive">
      <helpKeyword>configs.stacktostackreceive_stacktostackreceivedescription</helpKeyword>
      <valueType>double</valueType>
      <queryInherit>
        <xsl:text>/GPU</xsl:text>
        <xsl:value-of select="$currentGPUBDF"/>
        <xsl:text>STACK_TO_STACK_RECEIVEMetric</xsl:text>
        </queryInherit>
      <description>%GPUStackToStackReceiveDescription</description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>#75dbcb</timelineGraphColor>
        <timeScalems>1000</timeScalems>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUStackToStackTransmitGB{$currentGPUBDF}" displayName="%BandwidthTransmit">
      <helpKeyword>configs.stacktostacktransmit_stacktostacktransmitdescription</helpKeyword>
      <valueType>double</valueType>
      <queryInherit>
        <xsl:text>/GPU</xsl:text>
        <xsl:value-of select="$currentGPUBDF"/>
        <xsl:text>STACK_TO_STACK_TRANSMITMetric</xsl:text>
        </queryInherit>
      <description>%GPUStackToStackTransmitDescription</description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>#3765c1</timelineGraphColor>
        <timeScalems>1000</timeScalems>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUL3SamplerThroughputGB{$currentGPUBDF}" displayName="%GPUL3SamplerThroughputShort">
      <helpKeyword>configs.gpul3samplerthroughput_gpul3samplerthroughputdescription</helpKeyword>
      <valueType>double</valueType>
      <queryInherit>
        <xsl:text>/GPU</xsl:text>
        <xsl:value-of select="$currentGPUBDF"/>
         <xsl:text>L3SamplerThroughputMetric</xsl:text>
      </queryInherit>
      <xsl:if test="exsl:ctx('gsimClockDuration', 0) > 0">
        <valueEval>
          <![CDATA[ query("/gSimGPUEventCount/gSimGPUEventType[SamplerInputRequests]") * 64 / 1000000000 ]]>
        </valueEval>
      </xsl:if>
      <description>%GPUL3SamplerThroughputDescription</description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>207,236,183</timelineGraphColor>
        <timeScalems>1000</timeScalems>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUL3ShaderThroughputGB{$currentGPUBDF}" displayName="%GPUL3ShaderThroughputShort">
      <helpKeyword>configs.gpul3shaderthroughput_gpul3shaderthroughputdescription</helpKeyword>
      <valueType>double</valueType>
      <queryInherit>
        <xsl:text>/GPU</xsl:text>
        <xsl:value-of select="$currentGPUBDF"/>
        <xsl:text>L3ShaderThroughputMetric</xsl:text>
      </queryInherit>
      <description><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>L3ShaderThroughputDescription</xsl:text></description>
      <issues>
        <issue>
          <issueEval><![CDATA[ query("/GPUL3BandwidthWhenBusyIssue") ]]></issueEval>
          <issueText><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>L3BoundIssueText</xsl:text></issueText>
        </issue>
      </issues>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>78,119,79</timelineGraphColor>
        <timeScalems>1000</timeScalems>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUL3ShaderReadThroughputGB{$currentGPUBDF}" displayName="%GPUL3ShaderReadThroughputShort">
      <helpKeyword>configs.gpul3shaderreadthroughput_gpul3shaderreadthroughputdescription</helpKeyword>
      <valueType>double</valueType>
      <queryInherit>
        <xsl:text>/GPU</xsl:text>
        <xsl:value-of select="$currentGPUBDF"/>
        <xsl:text>L3_BYTE_READMetric</xsl:text>
      </queryInherit>
      <description>%GPUXEL3ShaderReadThroughputDescription</description>
      <issues>
        <issue>
          <issueEval><![CDATA[ query("/GPUL3ReadBandwidthWhenBusyIssue") ]]></issueEval>
          <issueText><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>L3BoundIssueText</xsl:text></issueText>
        </issue>
      </issues>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>78,159,79</timelineGraphColor>
        <timeScalems>1000</timeScalems>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUL3ShaderWriteThroughputGB{$currentGPUBDF}" displayName="%GPUL3ShaderWriteThroughputShort">
      <helpKeyword>configs.gpul3shaderwritethroughput_gpul3shaderwritethroughputdescription</helpKeyword>
      <valueType>double</valueType>
      <queryInherit>
        <xsl:text>/GPU</xsl:text>
        <xsl:value-of select="$currentGPUBDF"/>
        <xsl:text>L3_BYTE_WRITEMetric</xsl:text>
      </queryInherit>
      <description>%GPUXEL3ShaderWriteThroughputDescription</description>
      <issues>
        <issue>
          <issueEval><![CDATA[ query("/GPUL3WriteBandwidthWhenBusyIssue") ]]></issueEval>
          <issueText><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>L3BoundIssueText</xsl:text></issueText>
        </issue>
      </issues>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>78,119,79</timelineGraphColor>
        <timeScalems>1000</timeScalems>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUSharedLocalMemoryReadGB{$currentGPUBDF}" displayName="%BandwidthRead">
      <helpKeyword>configs.gpusharedlocalmemoryread_gpusharedlocalmemoryreaddescription</helpKeyword>
      <valueType>double</valueType>
      <xsl:choose>
        <xsl:when test="exsl:ctx('gsimClockDuration', 0) > 0">
          <xsl:variable name="text">
            (query("/gSimGPUEventCount/gSimGPUEventType[SLMRead12]") + query("/gSimGPUEventCount/gSimGPUEventType[SLMRead9]")) * 128 / 1000000000
          </xsl:variable>
          <valueEval>
            <xsl:value-of select="str:replace($text, '{$memoryMultiplier}', string($memoryMultiplier))"/>
          </valueEval>
        </xsl:when>
        <xsl:otherwise>
          <queryInherit>
            <xsl:text>/GPU</xsl:text>
            <xsl:value-of select="$currentGPUBDF"/>
            <xsl:text>SlmBytesReadMetric</xsl:text>
          </queryInherit>
        </xsl:otherwise>
      </xsl:choose>
      <description>%GPUSharedLocalMemoryReadDescription</description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>#75dbcb</timelineGraphColor>
        <timeScalems>1000</timeScalems>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUSharedLocalMemoryWriteGB{$currentGPUBDF}" displayName="%BandwidthWrite">
      <helpKeyword>configs.gpusharedlocalmemorywrite_gpusharedlocalmemorywritedescription</helpKeyword>
      <valueType>double</valueType>
      <xsl:choose>
      <xsl:when test="exsl:ctx('gsimClockDuration', 0) > 0">
        <xsl:variable name="text">
          (query("/gSimGPUEventCount/gSimGPUEventType[SLMWrite12]") + query("/gSimGPUEventCount/gSimGPUEventType[SLMWrite9]")) * {$memoryMultiplier} * 64 / 1000000000
        </xsl:variable>
        <valueEval>
          <xsl:value-of select="str:replace($text, '{$memoryMultiplier}', string($memoryMultiplier))"/>
        </valueEval>
      </xsl:when>
      <xsl:otherwise>
          <queryInherit>
            <xsl:text>/GPU</xsl:text>
            <xsl:value-of select="$currentGPUBDF"/>
            <xsl:text>SlmBytesWrittenMetric</xsl:text>
          </queryInherit>
      </xsl:otherwise>
      </xsl:choose>
      <description>%GPUSharedLocalMemoryWriteDescription</description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>#3765c1</timelineGraphColor>
        <timeScalems>1000</timeScalems>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPULSCReadGB{$currentGPUBDF}" displayName="%BandwidthRead">
      <helpKeyword>configs.gpuloadstorecacheread_gpuloadstorecachereaddescription</helpKeyword>
      <valueType>double</valueType>
      <queryInherit>
        <xsl:text>/GPU</xsl:text>
        <xsl:value-of select="$currentGPUBDF"/>
        <xsl:text>LOAD_STORE_CACHE_BYTE_READMetric</xsl:text>
      </queryInherit>
      <description>%GPULSCReadDescription</description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>#75dbcb</timelineGraphColor>
        <timeScalems>1000</timeScalems>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPULSCWriteGB{$currentGPUBDF}" displayName="%BandwidthWrite">
      <helpKeyword>configs.gpuloadstorecacheread_gpuloadstorecachereaddescriptionn</helpKeyword>
      <valueType>double</valueType>
      <queryInherit>
        <xsl:text>/GPU</xsl:text>
        <xsl:value-of select="$currentGPUBDF"/>
        <xsl:text>LOAD_STORE_CACHE_BYTE_WRITEMetric</xsl:text>
      </queryInherit>
      <description>%GPULSCWriteDescription</description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>#3765c1</timelineGraphColor>
        <timeScalems>1000</timeScalems>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUDataportReadGB{$currentGPUBDF}" displayName="%BandwidthRead">
      <helpKeyword>configs.gpudataportread_gpudataportreaddescription</helpKeyword>
      <valueType>double</valueType>
      <queryInherit>
        <xsl:text>/GPU</xsl:text>
        <xsl:value-of select="$currentGPUBDF"/>
        <xsl:text>DATAPORT_BYTE_READMetric</xsl:text>
      </queryInherit>
      <description>%GPUDataportReadDescription</description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>#75dbcb</timelineGraphColor>
        <timeScalems>1000</timeScalems>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUDataportWriteGB{$currentGPUBDF}" displayName="%BandwidthWrite">
      <helpKeyword>configs.gpudataportread_gpudataportreaddescriptionn</helpKeyword>
      <valueType>double</valueType>
      <queryInherit>
        <xsl:text>/GPU</xsl:text>
        <xsl:value-of select="$currentGPUBDF"/>
        <xsl:text>DATAPORT_BYTE_WRITEMetric</xsl:text>
      </queryInherit>
      <description>%GPUDataportWriteDescription</description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>#3765c1</timelineGraphColor>
        <timeScalems>1000</timeScalems>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUTypedMemoryReadGB{$currentGPUBDF}" displayName="%BandwidthRead">
      <helpKeyword>configs.gputypedmemoryread_gputypedmemoryreaddescription</helpKeyword>
      <valueType>double</valueType>
            <queryInherit>
            <xsl:text>/GPU</xsl:text>
            <xsl:value-of select="$currentGPUBDF"/>
            <xsl:text>TypedBytesReadMetric</xsl:text>
          </queryInherit>
      <description>%GPUTypedMemoryReadDescription</description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>#75dbcb</timelineGraphColor>
        <timeScalems>1000</timeScalems>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
    </derivedQuery>
        <derivedQuery id="GPUTypedMemoryWriteGB{$currentGPUBDF}" displayName="%BandwidthWrite">
      <helpKeyword>configs.gputypedmemorywrite_gputypedmemorywritedescription</helpKeyword>
      <valueType>double</valueType>
      <xsl:choose>
        <xsl:when test="$universalCollectorUsed='true'">
            <queryInherit>
            <xsl:text>/GPU</xsl:text>
            <xsl:value-of select="$currentGPUBDF"/>
            <xsl:text>TypedBytesWrittenMetric</xsl:text>
          </queryInherit>
        </xsl:when>
        <xsl:otherwise>
            <valueEval><![CDATA[ query("/GPUEventCount/GPUEventType[UAV Typed Writes Transactions]") * 64 / 1000000000 ]]></valueEval>
        </xsl:otherwise>
      </xsl:choose>
      <description>%GPUTypedMemoryWriteDescription</description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>#3765c1</timelineGraphColor>
        <timeScalems>1000</timeScalems>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUUntypedMemoryReadGB{$currentGPUBDF}" displayName="%BandwidthRead">
      <helpKeyword>configs.gpuuntypedmemoryread_gpuuntypedmemoryreaddescription</helpKeyword>
      <valueType>double</valueType>
      <xsl:choose>
        <xsl:when test="$universalCollectorUsed='true'">
            <queryInherit>
            <xsl:text>/GPU</xsl:text>
            <xsl:value-of select="$currentGPUBDF"/>
            <xsl:text>UntypedBytesReadMetric</xsl:text>
          </queryInherit>
        </xsl:when>
        <xsl:otherwise>
          <xsl:variable name="text">
            <xsl:choose>
              <xsl:when test="$gpuPlatform='IVB' or $gpuPlatform='HSW'">
                (query("/GPUEventCount/GPUEventType[Untyped Dataport Memory Reads Slice 0]") + query("/GPUEventCount/GPUEventType[Untyped Dataport Memory Reads Slice 1]")) * {$memoryMultiplier} * 64 / 1000000000
              </xsl:when>
              <xsl:when test="$gpuPlatform='VLV'">
                (query("/GPUEventCount/GPUEventType[Untyped Dataport Memory Reads Slice 0]")) * {$memoryMultiplier} * 64 / 1000000000
              </xsl:when>
            </xsl:choose>
          </xsl:variable>
          <valueEval>
            <xsl:value-of select="str:replace($text, '{$memoryMultiplier}', string($memoryMultiplier))"/>
          </valueEval>
        </xsl:otherwise>
      </xsl:choose>
      <description>%GPUUntypedMemoryReadDescription</description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>#75dbcb</timelineGraphColor>
        <timeScalems>1000</timeScalems>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUUntypedMemoryWriteGB{$currentGPUBDF}" displayName="%BandwidthWrite">
      <helpKeyword>configs.gpuuntypedmemorywrite_gpuuntypedmemorywritedescription</helpKeyword>
      <valueType>double</valueType>
      <queryInherit>
            <xsl:text>/GPU</xsl:text>
            <xsl:value-of select="$currentGPUBDF"/>
            <xsl:text>UntypedBytesWrittenMetric</xsl:text>
      </queryInherit>
      <description>%GPUUntypedMemoryWriteDescription</description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>#3765c1</timelineGraphColor>
        <timeScalems>1000</timeScalems>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUL3ShaderReadBDWMax{$currentGPUBDF}" displayName="%GPUL3ShaderReadThroughputMetricMaxGB">
      <queryInherit>/GPUL3ShaderReadBDWMax</queryInherit>
      <xsl:variable name="query">
        <value>
            <xsl:text>query("</xsl:text>
            <xsl:value-of select="concat('/GPU', $currentGPUBDF, 'L3_BYTE_READMetricMaxValue')"/>
            <xsl:text>") / query("/GPUElapsedTime") / 1000000000</xsl:text>
        </value>
      </xsl:variable>
      <valueEval>
         <xsl:value-of select="$query"/>
      </valueEval>
    </derivedQuery>
    <derivedQuery id="GPUL3ShaderWriteBDWMax{$currentGPUBDF}" displayName="%GPUL3ShaderWriteThroughputMetricMaxGB">
      <queryInherit>/GPUL3ShaderWriteBDWMax</queryInherit>
      <xsl:variable name="query">
        <value>
            <xsl:text>query("</xsl:text>
            <xsl:value-of select="concat('/GPU', $currentGPUBDF, 'L3_BYTE_WRITEMetricMaxValue')"/>
            <xsl:text>") / query("/GPUElapsedTime") / 1000000000</xsl:text>
        </value>
      </xsl:variable>
      <valueEval>
         <xsl:value-of select="$query"/>
      </valueEval>
    </derivedQuery>
  </xsl:for-each>
    <derivedQuery id="GPUTypedMemoryReadGB" displayName="%BandwidthRead">
      <helpKeyword>configs.gputypedmemoryread_gputypedmemoryreaddescription</helpKeyword>
      <valueType>double</valueType>
      <queryInherit>/GPUTypedBytesReadMetric</queryInherit>
      <description>%GPUTypedMemoryReadDescription</description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>#75dbcb</timelineGraphColor>
        <timeScalems>1000</timeScalems>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUTypedMemoryReadB" displayName="%BandwidthRead">
      <queryInherit>/GPUTypedMemoryReadGB</queryInherit>
      <valueType>memory</valueType>
      <valueEval>
        <![CDATA[ (query("/GPUTypedMemoryReadGB") * 1000000000) ]]>
      </valueEval>
    </derivedQuery>
    <derivedQuery id="GPUTypedMemoryReadBandwidthBase" displayName="%GPUTypedMemoryRead">
      <helpKeyword>configs.gputypedmemoryread_gputypedmemoryreaddescription</helpKeyword>
      <valueType>double</valueType>
      <boolean:valueSummable>false</boolean:valueSummable>
      <valueEval><![CDATA[ (query("/GPUTypedMemoryReadGB") / query("/GPUElapsedTime")) ]]></valueEval>
      <description>%GPUTypedMemoryReadDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUTypedMemoryReadBandwidth" displayName="%GPUTypedMemoryRead">
      <queryInherit>/GPUTypedMemoryReadBandwidthBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUTypedMemoryReadBandwidthBase/ConditionalTypedBytesReadSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
      <percentBases>
        <queryRef>/GPUTypedMemoryReadBDWAbsMax</queryRef>
      </percentBases>
    </derivedQuery>
    <derivedQuery id="GPUTypedMemoryReadBandwidthB" displayName="%GPUTypedMemoryReadFlex">
      <queryInherit>/GPUTypedMemoryReadBandwidth</queryInherit>
      <valueType>bandwidth</valueType>
      <valueEval>
        <![CDATA[ (query("/GPUTypedMemoryReadBandwidth") * 1000000000) ]]>
      </valueEval>
    </derivedQuery>
    <derivedQuery id="GPUTypedMemoryWriteGB" displayName="%BandwidthWrite">
      <helpKeyword>configs.gputypedmemorywrite_gputypedmemorywritedescription</helpKeyword>
      <valueType>double</valueType>
      <xsl:choose>
        <xsl:when test="$universalCollectorUsed='true'">
          <queryInherit>/GPUTypedBytesWrittenMetric</queryInherit>
        </xsl:when>
        <xsl:otherwise>
            <valueEval><![CDATA[ query("/GPUEventCount/GPUEventType[UAV Typed Writes Transactions]") * 64 / 1000000000 ]]></valueEval>
        </xsl:otherwise>
      </xsl:choose>
      <description>%GPUTypedMemoryWriteDescription</description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>#3765c1</timelineGraphColor>
        <timeScalems>1000</timeScalems>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUTypedMemoryWriteB" displayName="%BandwidthWrite">
      <queryInherit>/GPUTypedMemoryWriteGB</queryInherit>
      <valueType>memory</valueType>
      <valueEval>
        <![CDATA[ (query("/GPUTypedMemoryWriteGB") * 1000000000) ]]>
      </valueEval>
    </derivedQuery>
    <derivedQuery id="GPUTypedMemoryReadBDWAbsMax" displayName="%GPUTypedMemoryReadBDWMax">
      <valueType>double</valueType>
      <queryInherit>/GPUTypedBytesReadMetricAbsMaxValue</queryInherit>
      <description>%GPUTypedMemoryReadBDWMaxDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUTypedMemoryReadBDWAbsMaxRatio" displayName="%GPUBDWRatioUniversalName">
      <helpKeyword>configs.gpubdwratiouniversalname_gpureadbdwratiouniversaldescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ ( query("/GPUTypedMemoryReadBandwidth") / query("/GPUTypedMemoryReadBDWAbsMax")) ]]></valueEval>
      <description>%GPUReadBDWRatioUniversalDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUTypedMemoryWriteBandwidthBase" displayName="%GPUTypedMemoryWrite">
      <helpKeyword>configs.gputypedmemorywrite_gputypedmemorywritedescription</helpKeyword>
      <valueType>double</valueType>
      <boolean:valueSummable>false</boolean:valueSummable>
      <valueEval><![CDATA[ (query("/GPUTypedMemoryWriteGB") / query("/GPUElapsedTime")) ]]></valueEval>
      <description>%GPUTypedMemoryWriteDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUTypedMemoryWriteBandwidth" displayName="%GPUTypedMemoryWrite">
      <queryInherit>/GPUTypedMemoryWriteBandwidthBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUTypedMemoryWriteBandwidthBase/ConditionalTypedBytesWrittenSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
      <percentBases>
        <queryRef>/GPUTypedMemoryWriteBDWAbsMax</queryRef>
      </percentBases>
    </derivedQuery>
    <derivedQuery id="GPUTypedMemoryWriteBandwidthB" displayName="%GPUTypedMemoryWriteFlex">
      <queryInherit>/GPUTypedMemoryWriteBandwidth</queryInherit>
      <valueType>bandwidth</valueType>
      <valueEval>
        <![CDATA[ (query("/GPUTypedMemoryWriteBandwidth") * 1000000000) ]]>
      </valueEval>
    </derivedQuery>
    <derivedQuery id="GPUTypedMemoryReadBDWMax" displayName="%GPUTypedMemoryReadBDWMax">
      <valueType>double</valueType>
      <valueEval><![CDATA[ (query("/GPUTypedBytesReadMetricMaxValue") / query("/GPUElapsedTime") / 1000000000 ) ]]></valueEval>
      <description>%GPUTypedMemoryReadBDWMaxDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUTypedMemoryWriteBDWMax" displayName="%GPUTypedMemoryWriteBDWMax">
      <valueType>double</valueType>
      <valueEval><![CDATA[ (query("/GPUTypedBytesWrittenMetricMaxValue") / query("/GPUElapsedTime") / 1000000000 ) ]]></valueEval>
      <description>%GPUTypedMemoryWriteBDWMaxDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUTypedMemoryWriteBDWAbsMax" displayName="%GPUTypedMemoryWriteBDWMax">
      <valueType>double</valueType>
      <queryInherit>/GPUTypedBytesWrittenMetricAbsMaxValue</queryInherit>
      <description>%GPUTypedMemoryWriteBDWMaxDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUTypedMemoryWriteBDWMaxRatio" displayName="%GPUBDWRatioUniversalName">
      <helpKeyword>configs.gpubdwratiouniversalname_gpuwritebdwratiouniversaldescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ ( query("/GPUTypedMemoryWriteBandwidth") / query("/GPUTypedMemoryWriteBDWMax")) ]]></valueEval>
      <description>%GPUWriteBDWRatioUniversalDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUTypedMemoryWriteBDWAbsMaxRatio" displayName="%GPUBDWRatioUniversalName">
      <helpKeyword>configs.gpubdwratiouniversalname_gpuwritebdwratiouniversaldescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ ( query("/GPUTypedMemoryWriteBandwidth") / query("/GPUTypedMemoryWriteBDWAbsMax")) ]]></valueEval>
      <description>%GPUWriteBDWRatioUniversalDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUMemoryReadGB" displayName="%BandwidthRead">
      <helpKeyword>configs.gpumemoryread_gpumemoryreaddescription</helpKeyword>
      <valueType>double</valueType>
      <queryInherit>/GPUGtiReadThroughputMetric</queryInherit>
      <xsl:choose>
        <xsl:when test="exsl:is_value_exist('dd_uncore_event_type', 'name', 'GPU_MEMORY_BYTE_READ')">
          <description>%GPUMemoryReadDiscreteDescription</description>
        </xsl:when>
        <xsl:otherwise>
          <description>%GPUMemoryReadDescription</description>
        </xsl:otherwise>
      </xsl:choose>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>#75dbcb</timelineGraphColor>
        <timeScalems>1000</timeScalems>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUMemoryReadB" displayName="%BandwidthRead">
      <queryInherit>/GPUMemoryReadGB</queryInherit>
      <valueType>memory</valueType>
      <valueEval>
        <![CDATA[ (query("/GPUMemoryReadGB") * 1000000000) ]]>
      </valueEval>
    </derivedQuery>
    <derivedQuery id="GPUMemoryReadBandwidthBase" displayName="%GPUMemoryRead">
      <helpKeyword>configs.gpumemoryread_gpumemoryreaddescription</helpKeyword>
      <valueType>double</valueType>
      <boolean:valueSummable>false</boolean:valueSummable>
        <queryInherit>/GPUMemoryReadGB</queryInherit>
      <valueEval><![CDATA[ (query("/GPUMemoryReadGB") / query("/GPUElapsedTime")) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUMemoryReadBandwidth" displayName="%GPUMemoryRead">
      <queryInherit>/GPUMemoryReadBandwidthBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUMemoryReadBandwidthBase/ConditionalGtiReadThroughputSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
      <percentBases>
        <queryRef>/GPUMemoryReadBDWAbsMax</queryRef>
      </percentBases>
    </derivedQuery>
    <derivedQuery id="GPUMemoryReadBandwidthB" displayName="%GPUMemoryReadFlex">
      <queryInherit>/GPUMemoryReadBandwidth</queryInherit>
      <valueType>bandwidth</valueType>
      <valueEval>
        <![CDATA[ (query("/GPUMemoryReadBandwidth") * 1000000000) ]]>
      </valueEval>
    </derivedQuery>
    <derivedQuery id="GPUMemoryReadBDWMax" displayName="%GPUMemoryReadBDWMax">
      <valueType>double</valueType>
      <valueEval><![CDATA[ (query("/GPUGtiReadThroughputMetricMaxValue") / query("/GPUElapsedTime") / 1000000000 ) ]]></valueEval>
      <description><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>MemoryReadBDWMaxDescription</xsl:text></description>
    </derivedQuery>
    <derivedQuery id="GPUMemoryReadBDWAbsMax" displayName="%GPUMemoryReadBDWMax">
      <valueType>double</valueType>
      <queryInherit>/GPUGtiReadThroughputMetricAbsMaxValue</queryInherit>
      <xsl:choose>
        <xsl:when test="exsl:is_value_exist('dd_uncore_event_type', 'name', 'GPU_MEMORY_BYTE_READ')">
          <description>%GPUMemoryReadDiscreteBDWMaxDescription</description>
        </xsl:when>
        <xsl:otherwise>
          <description>%GPUMemoryReadBDWMaxDescription</description>
        </xsl:otherwise>
      </xsl:choose>
    </derivedQuery>
    <derivedQuery id="GPUMemoryReadBDWMaxRatio" displayName="%GPUBDWRatioUniversalName">
      <helpKeyword>configs.gpubdwratiouniversalname_gpureadbdwratiouniversaldescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ ( query("/GPUMemoryReadBandwidth") / query("/GPUMemoryReadBDWMax")) ]]></valueEval>
      <description>%GPUReadBDWRatioUniversalDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUMemoryReadBDWAbsMaxRatio" displayName="%GPUBDWRatioUniversalName">
      <helpKeyword>configs.gpubdwratiouniversalname_gpureadbdwratiouniversaldescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ ( query("/GPUMemoryReadBandwidth") / query("/GPUMemoryReadBDWAbsMax")) ]]></valueEval>
      <description>%GPUReadBDWRatioUniversalDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUMemoryWriteGB" displayName="%BandwidthWrite">
      <helpKeyword>configs.gpumemorywrite_gpumemorywritedescription</helpKeyword>
      <valueType>double</valueType>
      <queryInherit>/GPUGtiWriteThroughputMetric</queryInherit>
      <xsl:choose>
        <xsl:when test="exsl:is_value_exist('dd_uncore_event_type', 'name', 'GPU_MEMORY_BYTE_WRITE')">
          <description>%GPUMemoryWriteDiscreteDescription</description>
        </xsl:when>
        <xsl:otherwise>
          <description>%GPUMemoryWriteDescription</description>
        </xsl:otherwise>
      </xsl:choose>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>#3765c1</timelineGraphColor>
        <timeScalems>1000</timeScalems>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUMemoryWriteB" displayName="%BandwidthWrite">
      <queryInherit>/GPUMemoryWriteGB</queryInherit>
      <valueType>memory</valueType>
      <valueEval>
        <![CDATA[ (query("/GPUMemoryWriteGB") * 1000000000) ]]>
      </valueEval>
    </derivedQuery>
    <derivedQuery id="GPUMemoryWriteBandwidthBase" displayName="%GPUMemoryWrite">
      <helpKeyword>configs.gpumemorywrite_gpumemorywritedescription</helpKeyword>
      <valueType>double</valueType>
      <queryInherit>/GPUMemoryWriteGB</queryInherit>
      <boolean:valueSummable>false</boolean:valueSummable>
      <valueEval><![CDATA[ (query("/GPUMemoryWriteGB") / query("/GPUElapsedTime")) ]]></valueEval>
    </derivedQuery>
    <derivedQuery id="GPUMemoryWriteBandwidth" displayName="%GPUMemoryWrite">
      <queryInherit>/GPUMemoryWriteBandwidthBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUMemoryWriteBandwidthBase/ConditionalGtiWriteThroughputSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
      <percentBases>
        <queryRef>/GPUMemoryWriteBDWAbsMax</queryRef>
      </percentBases>
    </derivedQuery>
    <derivedQuery id="GPUMemoryWriteBandwidthB" displayName="%GPUMemoryWriteFlex">
      <queryInherit>/GPUMemoryWriteBandwidth</queryInherit>
      <valueType>bandwidth</valueType>
      <valueEval>
        <![CDATA[ (query("/GPUMemoryWriteBandwidth") * 1000000000) ]]>
      </valueEval>
    </derivedQuery>
    <derivedQuery id="GPUMemoryWriteBDWMax" displayName="%GPUMemoryWriteBDWMax">
      <valueType>double</valueType>
      <valueEval><![CDATA[ (query("/GPUGtiWriteThroughputMetricMaxValue") / query("/GPUElapsedTime") / 1000000000 ) ]]></valueEval>
      <xsl:choose>
        <xsl:when test="exsl:is_value_exist('dd_uncore_event_type', 'name', 'GPU_MEMORY_BYTE_WRITE')">
          <description>%GPUMemoryWriteDiscreteBDWMaxDescription</description>
        </xsl:when>
        <xsl:otherwise>
          <description>%GPUMemoryWriteBDWMaxDescription</description>
        </xsl:otherwise>
      </xsl:choose>
    </derivedQuery>
    <derivedQuery id="GPUMemoryWriteBDWAbsMax" displayName="%GPUMemoryWriteBDWMax">
      <valueType>double</valueType>
      <queryInherit>/GPUGtiWriteThroughputMetricAbsMaxValue</queryInherit>
    </derivedQuery>
    <derivedQuery id="GPUMemoryActiveBase" displayName="%GPUMemoryActive">
      <helpKeyword>configs.gpumemoryactive_gpumemoryactivedescription</helpKeyword>
      <valueType>ratio</valueType>
      <queryInherit>/GPUGPU_MEMORY_ACTIVEMetric</queryInherit>
      <description>%GPUL3BusyDescription</description>
      <confidenceEval><![CDATA[ (query("/GPUSampleCount/GPUEventType[GPU_MEMORY_ACTIVE]") > 5) ]]></confidenceEval>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>60,170,60</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <diagramObjectId>GPUMemoryActiveSlot</diagramObjectId>
      </displayAttributes>
      <maxEval>1</maxEval>
    </derivedQuery>
    <derivedQuery id="GPUMemoryActive" displayName="%GPUMemoryActive">
      <queryInherit>/GPUMemoryActiveBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUMemoryActiveBase/ConditionalGPU_MEMORY_ACTIVESamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUMemoryWriteBDWMaxRatio" displayName="%GPUBDWRatioUniversalName">
      <helpKeyword>configs.gpubdwratiouniversalname_gpuwritebdwratiouniversaldescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ (query("/GPUMemoryWriteBandwidth") / query("/GPUMemoryWriteBDWMax")) ]]></valueEval>
      <description>%GPUWriteBDWRatioUniversalDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUMemoryWriteBDWAbsMaxRatio" displayName="%GPUBDWRatioUniversalName">
      <helpKeyword>configs.gpubdwratiouniversalname_gpuwritebdwratiouniversaldescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ (query("/GPUMemoryWriteBandwidth") / query("/GPUMemoryWriteBDWAbsMax")) ]]></valueEval>
      <description>%GPUWriteBDWRatioUniversalDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUHostToGpuMemoryReadGB" displayName="%BandwidthRead">
      <helpKeyword>configs.hosttogpumemoryread_hosttogpumemoryreaddescription</helpKeyword>
      <valueType>double</valueType>
      <queryInherit>/GPUHOST_TO_GPUMEM_BYTE_READMetric</queryInherit>
      <description>%GPUHostToGpuMemoryReadDescription</description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>#75dbcb</timelineGraphColor>
        <timeScalems>1000</timeScalems>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUHostToGpuMemoryReadB" displayName="%BandwidthRead">
      <queryInherit>/GPUHostToGpuMemoryReadGB</queryInherit>
      <valueType>memory</valueType>
      <valueEval>
        <![CDATA[ (query("/GPUHostToGpuMemoryReadGB") * 1000000000) ]]>
      </valueEval>
    </derivedQuery>
    <derivedQuery id="GPUHostToGpuMemoryReadBandwidthBase" displayName="%GPUHostToGpuMemoryRead">
      <helpKeyword>configs.gpumemoryread_gpumemoryreaddescription</helpKeyword>
      <valueType>double</valueType>
      <boolean:valueSummable>false</boolean:valueSummable>
      <valueEval><![CDATA[ (query("/GPUHostToGpuMemoryReadGB") / query("/GPUElapsedTime")) ]]></valueEval>
      <description>%GPUHostToGpuMemoryReadDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUHostToGpuMemoryReadBandwidth" displayName="%GPUHostToGpuMemoryRead">
      <queryInherit>/GPUHostToGpuMemoryReadBandwidthBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUHostToGpuMemoryReadBandwidthBase/ConditionalHOST_TO_GPUMEM_BYTE_READSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
      <percentBases>
        <queryRef>/GPUHostToGpuMemoryReadBDWAbsMax</queryRef>
      </percentBases>
    </derivedQuery>
    <derivedQuery id="GPUHostToGpuMemoryReadBandwidthB" displayName="%GPUHostToGpuMemoryReadFlex">
      <queryInherit>/GPUHostToGpuMemoryReadBandwidth</queryInherit>
      <valueType>bandwidth</valueType>
      <valueEval>
        <![CDATA[ (query("/GPUHostToGpuMemoryReadBandwidth") * 1000000000) ]]>
      </valueEval>
    </derivedQuery>
    <derivedQuery id="GPUHostToGpuMemoryReadBDWMax" displayName="%GPUMemoryReadBDWMax">
      <valueType>double</valueType>
      <valueEval><![CDATA[ (query("/GPUHOST_TO_GPUMEM_BYTE_READMetricMaxValue") / query("/GPUElapsedTime") / 1000000000 ) ]]></valueEval>
      <description><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>HostToGpuMemoryReadBDWMaxDescription</xsl:text></description>
    </derivedQuery>
    <derivedQuery id="GPUHostToGpuMemoryReadBDWAbsMax" displayName="%GPUHostToGpuMemoryReadBDWMax">
      <valueType>double</valueType>
      <queryInherit>/GPUHOST_TO_GPUMEM_BYTE_READMetricAbsMaxValue</queryInherit>
      <description>%GPUHostToGpuMemoryReadBDWMaxDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUHostToGpuMemoryReadBDWMaxRatio" displayName="%GPUBDWRatioUniversalName">
      <helpKeyword>configs.gpubdwratiouniversalname_gpureadbdwratiouniversaldescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ ( query("/GPUHostToGpuMemoryReadBandwidth") / query("/GPUHostToGpuMemoryReadBDWMax")) ]]></valueEval>
      <description>%GPUReadBDWRatioUniversalDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUHostToGpuMemoryReadBDWAbsMaxRatio" displayName="%GPUBDWRatioUniversalName">
      <helpKeyword>configs.gpubdwratiouniversalname_gpureadbdwratiouniversaldescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ ( query("/GPUHostToGpuMemoryReadBandwidth") / query("/GPUHostToGpuMemoryReadBDWAbsMax")) ]]></valueEval>
      <description>%GPUReadBDWRatioUniversalDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUHostToGpuMemoryWriteGB" displayName="%BandwidthWrite">
      <helpKeyword>configs.gpumemorywrite_gpumemorywritedescription</helpKeyword>
      <valueType>double</valueType>
      <queryInherit>/GPUHOST_TO_GPUMEM_BYTE_WRITEMetric</queryInherit>
      <description>%GPUHostToGpuMemoryWriteDescription</description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>#3765c1</timelineGraphColor>
        <timeScalems>1000</timeScalems>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUHostToGpuMemoryWriteB" displayName="%BandwidthWrite">
      <queryInherit>/GPUHostToGpuMemoryWriteGB</queryInherit>
      <valueType>memory</valueType>
      <valueEval>
        <![CDATA[ (query("/GPUHostToGpuMemoryWriteGB") * 1000000000) ]]>
      </valueEval>
    </derivedQuery>
    <derivedQuery id="GPUHostToGpuMemoryWriteBandwidthBase" displayName="%GPUHostToGpuMemoryWrite">
      <helpKeyword>configs.gpumemorywrite_gpumemorywritedescription</helpKeyword>
      <valueType>double</valueType>
      <boolean:valueSummable>false</boolean:valueSummable>
      <valueEval><![CDATA[ (query("/GPUHostToGpuMemoryWriteGB") / query("/GPUElapsedTime")) ]]></valueEval>
      <description>%GPUHostToGpuMemoryWriteDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUHostToGpuMemoryWriteBandwidth" displayName="%GPUHostToGpuMemoryWrite">
      <queryInherit>/GPUHostToGpuMemoryWriteBandwidthBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUHostToGpuMemoryWriteBandwidthBase/ConditionalHOST_TO_GPUMEM_BYTE_WRITESamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
      <percentBases>
        <queryRef>/GPUHostToGpuMemoryWriteBDWAbsMax</queryRef>
      </percentBases>
    </derivedQuery>
    <derivedQuery id="GPUHostToGpuMemoryWriteBandwidthB" displayName="%GPUHostToGpuMemoryWriteFlex">
      <queryInherit>/GPUHostToGpuMemoryWriteBandwidth</queryInherit>
      <valueType>bandwidth</valueType>
      <valueEval>
        <![CDATA[ (query("/GPUHostToGpuMemoryWriteBandwidth") * 1000000000) ]]>
      </valueEval>
    </derivedQuery>
    <derivedQuery id="GPUHostToGpuMemoryWriteBDWMax" displayName="%GPUHostToGpuMemoryWriteBDWMax">
      <valueType>double</valueType>
      <valueEval><![CDATA[ (query("/GPUHOST_TO_GPUMEM_BYTE_WRITEMetricMaxValue") / query("/GPUElapsedTime") / 1000000000 ) ]]></valueEval>
      <description>%GPUHostToGpuMemoryWriteBDWMaxDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUHostToGpuMemoryWriteBDWAbsMax" displayName="%GPUMemoryWriteBDWMax">
      <valueType>double</valueType>
      <queryInherit>/GPUHOST_TO_GPUMEM_BYTE_WRITEMetricAbsMaxValue</queryInherit>
      <description>%GPUHostToGpuMemoryWriteBDWMaxDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUHostToGpuMemoryWriteBDWMaxRatio" displayName="%GPUBDWRatioUniversalName">
      <helpKeyword>configs.gpubdwratiouniversalname_gpuwritebdwratiouniversaldescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ (query("/GPUHostToGpuMemoryWriteBandwidth") / query("/GPUHostToGpuMemoryWriteBDWMax")) ]]></valueEval>
      <description>%GPUWriteBDWRatioUniversalDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUHostToGpuMemoryWriteBDWAbsMaxRatio" displayName="%GPUBDWRatioUniversalName">
      <helpKeyword>configs.gpubdwratiouniversalname_gpuwritebdwratiouniversaldescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ (query("/GPUHostToGpuMemoryWriteBandwidth") / query("/GPUHostToGpuMemoryWriteBDWAbsMax")) ]]></valueEval>
      <description>%GPUWriteBDWRatioUniversalDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUSysMemReadGB" displayName="%BandwidthRead">
      <helpKeyword>configs.hosttogpumemoryread_hosttogpumemoryreaddescription</helpKeyword>
      <valueType>double</valueType>
      <queryInherit>/GPUSYSMEM_BYTE_READMetric</queryInherit>
      <description>%GPUSysMemReadDescription</description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>#75dbcb</timelineGraphColor>
        <timeScalems>1000</timeScalems>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUSysMemReadB" displayName="%BandwidthRead">
      <queryInherit>/GPUSysMemReadGB</queryInherit>
      <valueType>memory</valueType>
      <valueEval>
        <![CDATA[ (query("/GPUSysMemReadGB") * 1000000000) ]]>
      </valueEval>
    </derivedQuery>
    <derivedQuery id="GPUSysMemReadBandwidthBase" displayName="%GPUSysMemRead">
      <helpKeyword>configs.gpumemoryread_gpumemoryreaddescription</helpKeyword>
      <valueType>double</valueType>
      <boolean:valueSummable>false</boolean:valueSummable>
      <valueEval><![CDATA[ (query("/GPUSysMemReadGB") / query("/GPUElapsedTime")) ]]></valueEval>
      <description>%GPUSysMemReadDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUSysMemReadBandwidth" displayName="%GPUSysMemRead">
      <queryInherit>/GPUSysMemReadBandwidthBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUSysMemReadBandwidthBase/ConditionalSYSMEM_BYTE_READSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
      <percentBases>
        <queryRef>/GPUSysMemReadBDWAbsMax</queryRef>
      </percentBases>
    </derivedQuery>
    <derivedQuery id="GPUSysMemReadBandwidthB" displayName="%GPUSysMemReadFlex">
      <queryInherit>/GPUSysMemReadBandwidth</queryInherit>
      <valueType>bandwidth</valueType>
      <valueEval>
        <![CDATA[ (query("/GPUSysMemReadBandwidth") * 1000000000) ]]>
      </valueEval>
    </derivedQuery>
    <derivedQuery id="GPUSysMemReadBDWMax" displayName="%GPUSysMemReadBDWMax">
      <valueType>double</valueType>
      <valueEval><![CDATA[ (query("/GPUSYSMEM_BYTE_READMetricMaxValue") / query("/GPUElapsedTime") / 1000000000 ) ]]></valueEval>
      <description><xsl:value-of select="$gpuPrefixMessage"/><xsl:text>SysMemReadBDWMaxDescription</xsl:text></description>
    </derivedQuery>
    <derivedQuery id="GPUSysMemReadBDWAbsMax" displayName="%GPUSysMemReadBDWMax">
      <valueType>double</valueType>
      <queryInherit>/GPUSYSMEM_BYTE_READMetricAbsMaxValue</queryInherit>
      <description>%GPUSysMemReadBDWMaxDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUSysMemReadBDWMaxRatio" displayName="%GPUBDWRatioUniversalName">
      <helpKeyword>configs.gpubdwratiouniversalname_gpureadbdwratiouniversaldescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ ( query("/GPUSysMemReadBandwidth") / query("/GPUSysMemReadBDWMax")) ]]></valueEval>
      <description>%GPUReadBDWRatioUniversalDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUSysMemReadBDWAbsMaxRatio" displayName="%GPUBDWRatioUniversalName">
      <helpKeyword>configs.gpubdwratiouniversalname_gpureadbdwratiouniversaldescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ ( query("/GPUSysMemReadBandwidth") / query("/GPUSysMemReadBDWAbsMax")) ]]></valueEval>
      <description>%GPUReadBDWRatioUniversalDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUSysMemWriteGB" displayName="%BandwidthWrite">
      <helpKeyword>configs.gpumemorywrite_gpumemorywritedescription</helpKeyword>
      <valueType>double</valueType>
      <queryInherit>/GPUSYSMEM_BYTE_WRITEMetric</queryInherit>
      <description>%GPUSysMemWriteDescription</description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>#3765c1</timelineGraphColor>
        <timeScalems>1000</timeScalems>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUSysMemWriteB" displayName="%BandwidthWrite">
      <queryInherit>/GPUSysMemWriteGB</queryInherit>
      <valueType>memory</valueType>
      <valueEval>
        <![CDATA[ (query("/GPUSysMemWriteGB") * 1000000000) ]]>
      </valueEval>
    </derivedQuery>
    <derivedQuery id="GPUSysMemWriteBandwidthBase" displayName="%GPUSysMemWrite">
      <helpKeyword>configs.gpumemorywrite_gpumemorywritedescription</helpKeyword>
      <valueType>double</valueType>
      <boolean:valueSummable>false</boolean:valueSummable>
      <valueEval><![CDATA[ (query("/GPUSysMemWriteGB") / query("/GPUElapsedTime")) ]]></valueEval>
      <description>%GPUSysMemWriteDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUSysMemWriteBandwidth" displayName="%GPUSysMemWrite">
      <queryInherit>/GPUSysMemWriteBandwidthBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUSysMemWriteBandwidthBase/ConditionalSYSMEM_BYTE_WRITESamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
      <percentBases>
        <queryRef>/GPUSysMemWriteBDWAbsMax</queryRef>
      </percentBases>
    </derivedQuery>
    <derivedQuery id="GPUSysMemWriteBandwidthB" displayName="%GPUSysMemWriteFlex">
      <queryInherit>/GPUSysMemWriteBandwidth</queryInherit>
      <valueType>bandwidth</valueType>
      <valueEval>
        <![CDATA[ (query("/GPUSysMemWriteBandwidth") * 1000000000) ]]>
      </valueEval>
    </derivedQuery>
    <derivedQuery id="GPUSysMemWriteBDWMax" displayName="%GPUSysMemWriteBDWMax">
      <valueType>double</valueType>
      <valueEval><![CDATA[ (query("/GPUSYSMEM_BYTE_WRITEMetricMaxValue") / query("/GPUElapsedTime") / 1000000000 ) ]]></valueEval>
      <description>%GPUHostToGpuMemoryWriteBDWMaxDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUSysMemWriteBDWAbsMax" displayName="%GPUSysMemWriteBDWMax">
      <valueType>double</valueType>
      <queryInherit>/GPUSYSMEM_BYTE_WRITEMetricAbsMaxValue</queryInherit>
      <description>%GPUHostToGpuMemoryWriteBDWMaxDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUSysMemWriteBDWMaxRatio" displayName="%GPUBDWRatioUniversalName">
      <helpKeyword>configs.gpubdwratiouniversalname_gpuwritebdwratiouniversaldescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ (query("/GPUSysMemWriteBandwidth") / query("/GPUSysMemWriteBDWMax")) ]]></valueEval>
      <description>%GPUWriteBDWRatioUniversalDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUSysMemWriteBDWAbsMaxRatio" displayName="%GPUBDWRatioUniversalName">
      <helpKeyword>configs.gpubdwratiouniversalname_gpuwritebdwratiouniversaldescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ (query("/GPUSysMemWriteBandwidth") / query("/GPUSysMemWriteBDWAbsMax")) ]]></valueEval>
      <description>%GPUWriteBDWRatioUniversalDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUGPUToHostMemoryGBIncoming" displayName="%BandwidthRead">
      <queryInherit>/GPUHostToGpuMemoryReadGB</queryInherit>
      <valueEval>
        <![CDATA[ query("/GPUSysMemReadGB") + query("/GPUHostToGpuMemoryWriteGB") ]]>
      </valueEval>
    </derivedQuery>
    <derivedQuery id="GPUGPUToHostMemoryGBOutgoing" displayName="%BandwidthWrite">
      <queryInherit>/GPUHostToGpuMemoryReadGB</queryInherit>
      <valueEval>
        <![CDATA[ query("/GPUHostToGpuMemoryReadGB") + query("/GPUSysMemWriteGB") ]]>
      </valueEval>
    </derivedQuery>
    <derivedQuery id="GPUStackToStackReceiveGB" displayName="%BandwidthReceive">
      <helpKeyword>configs.stacktostackreceive_stacktostackreceivedescription</helpKeyword>
      <valueType>double</valueType>
      <queryInherit>/GPUSTACK_TO_STACK_DATA_BYTE_RECEIVEMetric</queryInherit>
      <description>%GPUStackToStackReceiveDescription</description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>#75dbcb</timelineGraphColor>
        <timeScalems>1000</timeScalems>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUStackToStackReceiveB" displayName="%BandwidthReceive">
      <queryInherit>/GPUStackToStackReceiveGB</queryInherit>
      <valueType>memory</valueType>
      <valueEval>
        <![CDATA[ (query("/GPUStackToStackReceiveGB") * 1000000000) ]]>
      </valueEval>
    </derivedQuery>
    <derivedQuery id="GPUStackToStackReceiveBandwidthBase" displayName="%GPUMemoryRead">
      <helpKeyword>configs.stacktostackreceive_stacktostackreceivedescription</helpKeyword>
      <valueType>double</valueType>
      <boolean:valueSummable>false</boolean:valueSummable>
      <valueEval><![CDATA[ (query("/GPUStackToStackReceiveGB") / query("/GPUElapsedTime")) ]]></valueEval>
      <description>%GPUStackToStackReceiveDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUStackToStackReceiveBandwidth" displayName="%GPUStackToStackReceive">
      <queryInherit>/GPUStackToStackReceiveBandwidthBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUStackToStackReceiveBandwidthBase/ConditionalSTACK_TO_STACK_DATA_BYTE_RECEIVESamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
      <percentBases>
        <queryRef>/GPUStackToStackReceiveBDWAbsMax</queryRef>
      </percentBases>
    </derivedQuery>
    <derivedQuery id="GPUStackToStackReceiveBandwidthB" displayName="%GPUMemoryReadFlex">
      <queryInherit>/GPUStackToStackReceiveBandwidth</queryInherit>
      <valueType>bandwidth</valueType>
      <valueEval>
        <![CDATA[ (query("/GPUStackToStackReceiveBandwidth") * 1000000000) ]]>
      </valueEval>
    </derivedQuery>
    <derivedQuery id="GPUStackToStackReceiveBDWMax" displayName="%GPUStackToStackReceiveBDWMax">
      <valueType>double</valueType>
      <valueEval><![CDATA[ (query("/GPUSTACK_TO_STACK_DATA_BYTE_RECEIVEMaxValue") / query("/GPUElapsedTime") / 1000000000 ) ]]></valueEval>
      <description>GPUStackToStackReceiveBDWMaxDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUStackToStackReceiveBDWAbsMax" displayName="%GPUStackToStackReceiveBDWMax">
      <valueType>double</valueType>
      <queryInherit>/GPUSTACK_TO_STACK_DATA_BYTE_RECEIVEMetricAbsMaxValue</queryInherit>
      <description>%GPUStackToStackReceiveBDWMaxDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUStackToStackReceiveBDWMaxRatio" displayName="%GPUBDWRatioUniversalName">
      <helpKeyword>configs.gpubdwratiouniversalname_gpureadbdwratiouniversaldescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ ( query("/GPUStackToStackReceiveBandwidth") / query("/GPUStackToStackReceiveBDWMax")) ]]></valueEval>
      <description>%GPUReadBDWRatioUniversalDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUStackToStackReceiveBDWAbsMaxRatio" displayName="%GPUBDWRatioUniversalName">
      <helpKeyword>configs.gpubdwratiouniversalname_gpureadbdwratiouniversaldescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ ( query("/GPUStackToStackReceiveBandwidth") / query("/GPUStackToStackReceiveBDWAbsMax")) ]]></valueEval>
      <description>%GPUReadBDWRatioUniversalDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUStackToStackTransmitGB" displayName="%BandwidthTransmit">
      <helpKeyword>configs.stacktostacktransmit_stacktostacktransmitdescription</helpKeyword>
      <valueType>double</valueType>
      <queryInherit>/GPUSTACK_TO_STACK_DATA_BYTE_TRANSMITMetric</queryInherit>
      <description>%GPUStackToStackTransmitDescription</description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>#3765c1</timelineGraphColor>
        <timeScalems>1000</timeScalems>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUStackToStackTransmitB" displayName="%BandwidthTransmit">
      <queryInherit>/GPUStackToStackTransmitGB</queryInherit>
      <valueType>memory</valueType>
      <valueEval>
        <![CDATA[ (query("/GPUStackToStackTransmitGB") * 1000000000) ]]>
      </valueEval>
    </derivedQuery>
    <derivedQuery id="GPUStackToStackTransmitBandwidthBase" displayName="%GPUMemoryWrite">
      <helpKeyword>configs.stacktostacktransmit_stacktostacktransmitdescription</helpKeyword>
      <valueType>double</valueType>
      <boolean:valueSummable>false</boolean:valueSummable>
      <valueEval><![CDATA[ (query("/GPUStackToStackTransmitGB") / query("/GPUElapsedTime")) ]]></valueEval>
      <description>%GPUStackToStackTransmitDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUStackToStackTransmitBandwidth" displayName="%GPUMemoryWrite">
      <queryInherit>/GPUStackToStackTransmitBandwidthBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUStackToStackTransmitBandwidthBase/ConditionalSTACK_TO_STACK_DATA_BYTE_TRANSMITSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
      <percentBases>
        <queryRef>/GPUStackToStackTransmitBDWAbsMax</queryRef>
      </percentBases>
    </derivedQuery>
    <derivedQuery id="GPUStackToStackTransmitBandwidthB" displayName="%GPUStackToStackTransmitFlex">
      <queryInherit>/GPUStackToStackTransmitBandwidth</queryInherit>
      <valueType>bandwidth</valueType>
      <valueEval>
        <![CDATA[ (query("/GPUStackToStackTransmitBandwidth") * 1000000000) ]]>
      </valueEval>
    </derivedQuery>
    <derivedQuery id="GPUStackToStackTransmitBDWMax" displayName="%GPUStackToStackTransmitBDWMax">
      <valueType>double</valueType>
      <valueEval><![CDATA[ (query("/GPUSTACK_TO_STACK_DATA_BYTE_TRANSMITMetricMaxValue") / query("/GPUElapsedTime") / 1000000000 ) ]]></valueEval>
      <description>%GPUStackToStackTransmitBDWMaxDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUStackToStackTransmitBDWAbsMax" displayName="%GPUStackToStackTransmitBDWMax">
      <valueType>double</valueType>
      <queryInherit>/GPUSTACK_TO_STACK_DATA_BYTE_TRANSMITMetricAbsMaxValue</queryInherit>
      <description>%GPUStackToStackTransmitBDWMaxDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUStackToStackTransmitBDWMaxRatio" displayName="%GPUBDWRatioUniversalName">
      <helpKeyword>configs.gpubdwratiouniversalname_gpuwritebdwratiouniversaldescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ (query("/GPUStackToStackTransmitBandwidth") / query("/GPUStackToStackTransmitBDWMax")) ]]></valueEval>
      <description>%GPUWriteBDWRatioUniversalDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUStackToStackTransmitBDWAbsMaxRatio" displayName="%GPUBDWRatioUniversalName">
      <helpKeyword>configs.gpubdwratiouniversalname_gpuwritebdwratiouniversaldescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ (query("/GPUStackToStackTransmitBandwidth") / query("/GPUStackToStackTransmitBDWAbsMax")) ]]></valueEval>
      <description>%GPUWriteBDWRatioUniversalDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUL3MissCount" displayName="%GPUL3MissCount">
      <helpKeyword>configs.gpul3misscount_gpul3misscountdescription</helpKeyword>
      <valueType>count</valueType>
      <queryInherit>/GPUL3MissesMetric</queryInherit>
      <description>%GPUL3MissCountDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUL3Hit" displayName="%GPUL3Hit">
      <valueType>count</valueType>
      <queryInherit>/GPUL3_HITMetric</queryInherit>
    </derivedQuery>
    <derivedQuery id="GPUL3Miss" displayName="%GPUL3Miss">
      <helpKeyword>configs.gpul3miss_gpul3missdescription</helpKeyword>
      <valueType>count</valueType>
      <valueEval><![CDATA[ query("/GPUL3MissCount") ]]></valueEval>
      <description>%GPUL3MissDescription</description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>170,71,47</timelineGraphColor>
        <timeScalems>1000</timeScalems>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUL3MissRateBase" displayName="%GPUL3Miss">
      <helpKeyword>configs.gpul3miss_gpul3missdescription</helpKeyword>
      <valueType>double</valueType>
      <valueEval><![CDATA[ ( query("/GPUL3Miss")/ query("/GPUElapsedTime") ) ]]></valueEval>
      <description>%GPUL3MissDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUL3MissRate" displayName="%GPUL3Miss">
      <queryInherit>/GPUL3MissRateBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUL3MissRateBase/ConditionalL3MissesSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUL3MissRatioBase" displayName="%GPUL3MissRatio">
      <helpKeyword>configs.gpul3missratio_gpul3missratiodescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ ( query("/GPUL3Miss") / (query("/GPUL3Miss") + query("/GPUL3Hit")) ) ]]></valueEval>
      <description>%GPUL3MissRatioDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUL3MissRatio" displayName="%GPUL3MissRatio">
      <queryInherit>/GPUL3MissRatioBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUL3MissRatioBase/ConditionalL3MissesSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
    </derivedQuery>
    <derivedQuery id="GPUICacheMissCount" displayName="%GPUICacheMissCount">
      <helpKeyword>configs.gpulicachemisscount_gpuicachemisscountdescription</helpKeyword>
      <valueType>count</valueType>
      <queryInherit>/GPUICACHE_MISSMetric</queryInherit>
      <description>%GPUICacheMissCountDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUICacheHit" displayName="%GPUICacheHit">
      <valueType>count</valueType>
      <queryInherit>/GPUICACHE_HITMetric</queryInherit>
    </derivedQuery>
    <derivedQuery id="GPUICacheMiss" displayName="%GPUICacheMiss">
      <helpKeyword>configs.gpuicachemiss_gpuicachemissdescription</helpKeyword>
      <valueType>count</valueType>
      <valueEval><![CDATA[ query("/GPUICacheMissCount") ]]></valueEval>
      <description>%GPUICacheMissDescription</description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>47,71,47</timelineGraphColor>
        <timeScalems>1000</timeScalems>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUICacheMissRatioBase" displayName="%GPUICacheMissRatio">
      <helpKeyword>configs.gpuicachemissratio_gpuicachemissratiodescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ ( query("/GPUICacheMiss") / (query("/GPUICacheMiss") + query("/GPUICacheHit")) ) ]]></valueEval>
      <description>%GPUICacheMissRatioDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUICacheMissRatio" displayName="%GPUICacheMissRatio">
      <queryInherit>/GPUICacheMissRatioBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUICacheMissRatioBase/ConditionalICACHE_MISSSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
    </derivedQuery>
    <derivedQuery id="GPUICacheL3ReadGB" displayName="%GPUL3ICacheThroughputShort">
      <helpKeyword>configs.gpul3icachethroughput_gpul3icachereaddescription</helpKeyword>
      <valueType>double</valueType>
      <queryInherit>/GPUICACHE_L3_BYTE_READMetric</queryInherit>
      <description>%GPUL3ICacheReadDescription</description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>207,236,183</timelineGraphColor>
        <timeScalems>1000</timeScalems>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUICacheL3ReadB" displayName="%GPUL3ICacheThroughputShort">
      <queryInherit>/GPUICacheL3ReadGB</queryInherit>
      <valueType>memory</valueType>
      <valueEval>
        <![CDATA[ (query("/GPUICacheL3ReadGB") * 1000000000) ]]>
      </valueEval>
    </derivedQuery>
    <derivedQuery id="GPUICacheL3ReadBandwidthBase" displayName="%GPUL3ICacheThroughput">
      <helpKeyword>configs.gpul3icachethroughput_gpul3icachereadthroughputdescription</helpKeyword>
      <valueType>double</valueType>
      <boolean:valueSummable>false</boolean:valueSummable>
      <valueEval><![CDATA[ (query("/GPUICacheL3ReadGB") / query("/GPUElapsedTime")) ]]></valueEval>
      <description>%GPUL3ICacheReadThroughputDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUICacheL3ReadBandwidth" displayName="%GPUL3ICacheThroughput">
      <queryInherit>/GPUICacheL3ReadBandwidthBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPUICacheL3ReadBandwidthBase/ConditionalICACHE_L3_BYTE_READSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPUICacheL3ReadBandwidthB" displayName="%GPUL3ICacheThroughputFlex">
      <queryInherit>/GPUICacheL3ReadBandwidth</queryInherit>
      <valueType>bandwidth</valueType>
      <valueEval>
        <![CDATA[ (query("/GPUICacheL3ReadBandwidth") * 1000000000) ]]>
      </valueEval>
    </derivedQuery>
    <derivedQuery id="GPUICacheL3ReadBDWAbsMax" displayName="%GPUL3ICacheThroughputMaxGB">
      <valueType>double</valueType>
      <queryInherit>/GPUICACHE_L3_READMetricAbsMaxValue</queryInherit>
      <description>%GPUL3ICacheBDWMaxDescription</description>
    </derivedQuery>
    <derivedQuery id="GPUICacheL3ReadBDWAbsMaxRatio" displayName="%GPUBDWRatioUniversalName">
      <helpKeyword>configs.gpubdwratiouniversalname_gpubdwratiouniversaldescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ ( query("/GPUICacheL3ReadBandwidth") / query("/GPUICacheL3ReadBDWAbsMax") ) ]]></valueEval>
      <description>%GPUBDWRatioUniversalDescription</description>
    </derivedQuery>
    <derivedQuery id="GPULSCL3ReadGB" displayName="%GPUL3LSCReadShort">
      <helpKeyword>configs.gpul3lscread_gpul3lscreaddescription</helpKeyword>
      <valueType>double</valueType>
      <queryInherit>/GPULOAD_STORE_CACHE_L3_BYTE_READMetric</queryInherit>
      <description>%GPUL3LSCReadDescription</description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>207,236,183</timelineGraphColor>
        <timeScalems>1000</timeScalems>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPULSCL3ReadB" displayName="%GPUL3LSCReadShort">
      <queryInherit>/GPULSCL3ReadGB</queryInherit>
      <valueType>memory</valueType>
      <valueEval>
        <![CDATA[ (query("/GPULSCL3ReadGB") * 1000000000) ]]>
      </valueEval>
    </derivedQuery>
    <derivedQuery id="GPULSCL3ReadBandwidthBase" displayName="%GPUL3LSCRead">
      <helpKeyword>configs.gpul3lscread_gpul3lscreadreaddescription</helpKeyword>
      <valueType>double</valueType>
      <boolean:valueSummable>false</boolean:valueSummable>
      <valueEval><![CDATA[ (query("/GPULSCL3ReadGB") / query("/GPUElapsedTime")) ]]></valueEval>
      <description>%GPUL3LSCReadThroughputDescription</description>
    </derivedQuery>
    <derivedQuery id="GPULSCL3ReadBandwidth" displayName="%GPUL3LSCRead">
      <queryInherit>/GPULSCL3ReadBandwidthBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPULSCL3ReadBandwidthBase/ConditionalLOAD_STORE_CACHE_L3_BYTE_READSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPULSCL3ReadBandwidthB" displayName="%GPUL3LSCReadFlex">
      <queryInherit>/GPULSCL3ReadBandwidth</queryInherit>
      <valueType>bandwidth</valueType>
      <valueEval>
        <![CDATA[ (query("/GPULSCL3ReadBandwidth") * 1000000000) ]]>
      </valueEval>
    </derivedQuery>
    <derivedQuery id="GPULSCL3ReadBDWAbsMax" displayName="%GPUL3LSCReadMaxGB">
      <valueType>double</valueType>
      <queryInherit>/GPULOAD_STORE_CACHE_L3_BYTE_READMetricAbsMaxValue</queryInherit>
      <description>%GPUL3LSCReadBDWMaxDescription</description>
    </derivedQuery>
    <derivedQuery id="GPULSCL3ReadBDWAbsMaxRatio" displayName="%GPUBDWRatioUniversalName">
      <helpKeyword>configs.gpubdwratiouniversalname_gpubdwratiouniversaldescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ ( query("/GPULSCL3ReadBandwidth") / query("/GPULSCL3ReadBDWAbsMax") ) ]]></valueEval>
      <description>%GPUBDWRatioUniversalDescription</description>
    </derivedQuery>
    <derivedQuery id="GPULSCL3WriteGB" displayName="%GPUL3LSCWriteShort">
      <helpKeyword>configs.gpul3lscwrite_gpul3lscwritedescription</helpKeyword>
      <valueType>double</valueType>
      <queryInherit>/GPULOAD_STORE_CACHE_L3_BYTE_WRITEMetric</queryInherit>
      <description>%GPUL3LSCWriteDescription</description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>105,118,92</timelineGraphColor>
        <timeScalems>1000</timeScalems>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPULSCL3WriteB" displayName="%GPUL3LSCWriteShort">
      <queryInherit>/GPULSCL3WriteGB</queryInherit>
      <valueType>memory</valueType>
      <valueEval>
        <![CDATA[ (query("/GPULSCL3WriteGB") * 1000000000) ]]>
      </valueEval>
    </derivedQuery>
    <derivedQuery id="GPULSCL3WriteBandwidthBase" displayName="%GPUL3LSCWrite">
      <helpKeyword>configs.gpul3lscwrite_gpul3lscreawritedescription</helpKeyword>
      <valueType>double</valueType>
      <boolean:valueSummable>false</boolean:valueSummable>
      <valueEval><![CDATA[ (query("/GPULSCL3WriteGB") / query("/GPUElapsedTime")) ]]></valueEval>
      <description>%GPUL3LSCWriteThroughputDescription</description>
    </derivedQuery>
    <derivedQuery id="GPULSCL3WriteBandwidth" displayName="%GPUL3LSCWrite">
      <queryInherit>/GPULSCL3WriteBandwidthBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPULSCL3WriteBandwidthBase/ConditionalLOAD_STORE_CACHE_L3_BYTE_WRITESamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <confidenceText>%NotEnoughSamples</confidenceText>
    </derivedQuery>
    <derivedQuery id="GPULSCL3WriteBandwidthB" displayName="%GPUL3LSCWriteFlex">
      <queryInherit>/GPULSCL3WriteBandwidth</queryInherit>
      <valueType>bandwidth</valueType>
      <valueEval>
        <![CDATA[ (query("/GPULSCL3WriteBandwidth") * 1000000000) ]]>
      </valueEval>
    </derivedQuery>
    <derivedQuery id="GPULSCL3WriteBDWAbsMax" displayName="%GPUL3LSCWriteMaxGB">
      <valueType>double</valueType>
      <queryInherit>/GPULOAD_STORE_CACHE_L3_BYTE_WRITEMetricAbsMaxValue</queryInherit>
      <description>%GPUL3LSCWriteBDWMaxDescription</description>
    </derivedQuery>
    <derivedQuery id="GPULSCL3WriteBDWAbsMaxRatio" displayName="%GPUBDWRatioUniversalName">
      <helpKeyword>configs.gpubdwratiouniversalname_gpubdwratiouniversaldescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ ( query("/GPULSCL3WriteBandwidth") / query("/GPULSCL3WriteBDWAbsMax") ) ]]></valueEval>
      <description>%GPUBDWRatioUniversalDescription</description>
    </derivedQuery>
    <derivedQuery id="GPULSCMissCount" displayName="%GPULSCMissCount">
      <helpKeyword>configs.gpulscmisscount_gpulscmisscountdescription</helpKeyword>
      <valueType>count</valueType>
      <valueEval>
        <![CDATA[ ( query("/GPULOAD_STORE_CACHE_ACCESSMetric") - query("/GPULOAD_STORE_CACHE_HITMetric")) ]]>
      </valueEval>
      <description>%GPULSCMissCountDescription</description>
    </derivedQuery>
    <derivedQuery id="GPULSCAccess" displayName="%GPULSCAccess">
      <valueType>count</valueType>
      <queryInherit>/GPULOAD_STORE_CACHE_ACCESSMetric</queryInherit>
    </derivedQuery>
    <derivedQuery id="GPULSCMiss" displayName="%GPULSCMiss">
      <helpKeyword>configs.gpulscmiss_gpulscmissdescription</helpKeyword>
      <valueType>count</valueType>
      <valueEval><![CDATA[ query("/GPULSCMissCount") ]]></valueEval>
      <description>%GPULSCMissDescription</description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>47,71,47</timelineGraphColor>
        <timeScalems>1000</timeScalems>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPULSCMissRatioBase" displayName="%GPULSCMissRatio">
      <helpKeyword>configs.gpulscmissratio_gpulscmissratiodescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ ( query("/GPULSCMiss") / (query("/GPULSCAccess")) ) ]]></valueEval>
      <description>%GPULSCMissRatioDescription</description>
    </derivedQuery>
    <derivedQuery id="GPULSCMissRatio" displayName="%GPULSCMissRatio">
      <queryInherit>/GPULSCMissRatioBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPULSCMissRatioBase/ConditionalLOAD_STORE_CACHE_HITSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
    </derivedQuery>
    <derivedQuery id="GPULlcMissCount" displayName="%GPULlcMissRatio">
      <valueType>count</valueType>
      <valueEval><![CDATA[ ( query("/GPULlcAccessesMetric") - query("/GPULlcHitsMetric") ) ]]></valueEval>
      <description>%GPULlcMissCountDescription</description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>20,20,20</timelineGraphColor>
        <timeScalems>1000</timeScalems>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPULlcMissRatioBase" displayName="%GPULlcMissRatio">
      <helpKeyword>configs.gpullcmissratio_gpullcmissratiodescription</helpKeyword>
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ ( query("/GPULlcMissCount") / query("/GPULlcAccessesMetric") ) ]]></valueEval>
      <description>%GPULlcMissRatioDescription</description>
    </derivedQuery>
    <derivedQuery id="GPULlcMissRatio" displayName="%GPULlcMissRatio">
      <queryInherit>/GPULlcMissRatioBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPULlcMissRatioBase/ConditionalLlcMissSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
    </derivedQuery>
    <derivedQuery id="GPULlcMissRateBase" displayName="%GPULlcMiss">
      <valueType>double</valueType>
      <valueEval><![CDATA[ ( query("/GPULlcMissCount")/ query("/GPUElapsedTime") ) ]]></valueEval>
      <description>%GPULlcMissRateDescription</description>
    </derivedQuery>
    <derivedQuery id="GPULlcMissRate" displayName="%GPULlcMiss">
      <queryInherit>/GPULlcMissRateBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GPULlcMissRateBase/ConditionalLlcMissSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
    </derivedQuery>
    <xsl:if test="exsl:is_experimental('gps-analysis')">
      <derivedQuery id="GPUXVEActive">
        <queryInherit>/GPUEuActiveMetric</queryInherit>
        <valueEval><![CDATA[ query("/GPUEuActiveMetric/ConditionalXVE_ACTIVESamplesExist[%True]") ]]></valueEval>
      </derivedQuery>
      <derivedQuery id="GPUXVEStall">
        <queryInherit>/GPUEuStallMetric</queryInherit>
          <valueEval><![CDATA[ query("/GPUEuStallMetric/ConditionalXVE_STALLSamplesExist[%True]") ]]></valueEval>
      </derivedQuery>
      <derivedQuery id="GPUEuThreadOccupancyGPS">
        <queryInherit>/GPUEuThreadOccupancyMetric</queryInherit>
          <valueEval><![CDATA[ query("/GPUEuThreadOccupancyMetric/ConditionalXVE_THREADS_OCCUPANCY_ALLSamplesExist[%True]") ]]></valueEval>
      </derivedQuery>
      <derivedQuery id="GPUTotalMemoryGtiThroughput">
        <valueType>double</valueType>
        <valueEval><![CDATA[ (query("/GPUGtiReadThroughputMetric") + query("/GPUGtiWriteThroughputMetric")) ]]></valueEval>
      </derivedQuery>
      <derivedQuery id="GPUTotalMemoryThroughput">
        <valueType>ratio</valueType>
        <valueEval><![CDATA[ query("/GPUTotalMemoryGtiThroughput") / query("/GPUGpuCoreClocksMetric/ConditionalGtiReadThroughputSamplesExist[%True]") / (query("/GPUArchitecture") == 17 ? 512 : 1024)]]></valueEval>
      </derivedQuery>
      <derivedQuery id="GPUNormPeakBw">
        <valueType>double</valueType>
        <valueEval><![CDATA[ query("/GPUAvgGpuCoreFrequencyMHzMetricSource/ConditionalGPU_MEMORY_BYTE_READ_SQIDI0SamplesExist[%True]") / (query("/GPUArchitecture") == 17 ? 512000 : 1024000) ]]></valueEval>
      </derivedQuery>
      <derivedQuery id="GPUMemoryReadBwMaxExt">
        <valueType>double</valueType>
        <valueEval><![CDATA[ query("/GPUMetric_GPU_MEMORY_BYTE_READ") * query("/GPUNormPeakBw") / query("/GPUGpuCoreClocksMetric/ConditionalGPU_MEMORY_BYTE_READ_SQIDI0SamplesExist[%True]") ]]></valueEval>
      </derivedQuery>
      <derivedQuery id="GPUMemoryWriteBwMaxExt">
        <valueType>double</valueType>
        <valueEval><![CDATA[ query("/GPUMetric_GPU_MEMORY_BYTE_WRITE") * query("/GPUNormPeakBw") / query("/GPUGpuCoreClocksMetric/ConditionalGPU_MEMORY_BYTE_READ_SQIDI0SamplesExist[%True]") ]]></valueEval>
      </derivedQuery>
      <xsl:for-each select="str:split(exsl:ctx('gpuMetricsSelected', ''), ',')">
        <xsl:variable name="counterDescBdf" select="."/>
        <xsl:variable name="counterDescSplit" select="str:split($counterDescBdf, ':')"/>
        <xsl:variable name="counterDesc" select="$counterDescSplit[1]"/>
        <xsl:variable name="inheritText">/GPUMetric_{$counterDesc}</xsl:variable>
        <xsl:variable name="queryText">query("/GPUMetric_{$counterDesc}")</xsl:variable>
        <derivedQuery id="GPSMetric_{$counterDesc}">
          <xsl:choose>
            <xsl:when test="$counterDesc = 'XVE_THREADS_OCCUPANCY_ALL'">
              <queryInherit>/GPUEuThreadOccupancyGPS</queryInherit>
            </xsl:when>
            <xsl:when test="$counterDesc = 'XVE_ACTIVE'">
              <queryInherit>/GPUXVEActive</queryInherit>
            </xsl:when>
            <xsl:when test="$counterDesc = 'XVE_STALL'">
              <queryInherit>/GPUXVEStall</queryInherit>
            </xsl:when>
            <xsl:otherwise>
              <queryInherit>
                <xsl:value-of select="str:replace($inheritText, '{$counterDesc}', string($counterDesc))"/>
              </queryInherit>
            </xsl:otherwise>
          </xsl:choose>
          <xsl:choose>
            <xsl:when test="$counterDesc = 'XVE_THREADS_OCCUPANCY_ALL'">
              <issueText>%GPSLowOccupancyIssue</issueText>
              <issueEval>
                <![CDATA[ query("/GPUEuThreadOccupancyGPS") < 0.9 ]]>
              </issueEval>
            </xsl:when>
            <xsl:when test="$counterDesc = 'XVE_STALL'">
              <issueText>%GPSXVEBottleneck</issueText>
              <issueEval>
                <![CDATA[ query("/GPUXVEStall") > 0.2 ]]>
              </issueEval>
            </xsl:when>
            <xsl:when test="contains($counterDesc, 'GPU_MEMORY_REQUEST_QUEUE_FULL_SQIDI')">
              <issueText>%GPSThroughputBottlneck</issueText>
              <issueEval>
                <xsl:value-of select="concat(str:replace($queryText, '{$counterDesc}', string($counterDesc)), '&gt; 0.9')"/>
              </issueEval>
            </xsl:when>
            <xsl:when test="contains($counterDesc, 'COMMAND_PARSER_COMPUTE_ENGINE_BUSY_CCS')">
              <issueText>%GPSCommandParserComputeEngineBottleneck</issueText>
              <issueEval>
                <xsl:value-of select="concat(str:replace($queryText, '{$counterDesc}', string($counterDesc)), '&gt; 0.9')"/>
              </issueEval>
            </xsl:when>
            <xsl:when test="contains($counterDesc, 'COMMAND_PARSER_RENDER_ENGINE_BUSY')">
              <issueText>%GPSCommandParserRenderEngineBottleneck</issueText>
              <issueEval>
                <xsl:value-of select="concat(str:replace($queryText, '{$counterDesc}', string($counterDesc)), '&gt; 0.9')"/>
              </issueEval>
            </xsl:when>
            <xsl:when test="contains($counterDesc, 'THREADGROUP_DISPATCH_RESOURCE_STALL_CYCLES_XECORE')">
              <issueText>%GPSThreadgroupDispatchResourceBottleneck</issueText>
              <issueEval>
                <xsl:value-of select="concat(str:replace($queryText, '{$counterDesc}', string($counterDesc)), '&gt; 0.2')"/>
              </issueEval>
            </xsl:when>
            <xsl:when test="contains($counterDesc, 'L3_BANK_INPUT_AVAILABLE_L3BANK')">
              <xsl:variable name="XeCoreNumber">
                <xsl:value-of select="str:replace($counterDesc, 'L3_BANK_INPUT_AVAILABLE_L3BANK', '')"/>
              </xsl:variable>
              <issueText>%GPSGPUL3BankBottleneck</issueText>
              <issueEval>
                <xsl:value-of select="concat(str:replace($queryText, '{$counterDesc}', string($counterDesc)), '&gt; 0.8 and', str:replace($queryText, '{$counterDesc}', string($counterDesc)), '-', concat('query(&quot;/GPUMetric_L3_OUTPUT_READY_L3BANK', string($XeCoreNumber), '&quot;) &gt; 0.1'))"/>
              </issueEval>
            </xsl:when>
            <xsl:when test="contains($counterDesc, 'LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE')">
              <xsl:variable name="XeCoreNumber">
                <xsl:value-of select="str:replace($counterDesc, 'LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE', '')"/>
              </xsl:variable>
              <issueText>%GPSGPULSCXeCoreBottleneck</issueText>
              <issueEval>
                <xsl:value-of select="concat(str:replace($queryText, '{$counterDesc}', string($counterDesc)), '&gt; 0.8 and', str:replace($queryText, '{$counterDesc}', string($counterDesc)), '-', concat('query(&quot;/GPUMetric_LOAD_STORE_CACHE_OUTPUT_READY_XECORE', string($XeCoreNumber), '&quot;) &gt; 0.1'))"/>
              </issueEval>
            </xsl:when>
            <xsl:when test="contains($counterDesc, 'DATAPORT_INPUT_AVAILABLE_XECORE')">
              <xsl:variable name="XeCoreNumber">
                <xsl:value-of select="str:replace($counterDesc, 'DATAPORT_INPUT_AVAILABLE_XECORE', '')"/>
              </xsl:variable>
              <issueText>%GPSGPUDataPortXeCoreBottleneck</issueText>
              <issueEval>
                <xsl:value-of select="concat(str:replace($queryText, '{$counterDesc}', string($counterDesc)), '&gt; 0.8 and', str:replace($queryText, '{$counterDesc}', string($counterDesc)), '-', concat('query(&quot;/GPUMetric_DATAPORT_OUTPUT_READY_XECORE', string($XeCoreNumber), '&quot;) &gt; 0.1'))"/>
              </issueEval>
            </xsl:when>
            <xsl:when test="contains($counterDesc, 'RT_MESSAGE_STALL_COUNT_XECORE')">
              <issueText>%GPSRTFFBottleneck</issueText>
              <issueEval>
                <xsl:value-of select="concat(str:replace($queryText, '{$counterDesc}', string($counterDesc)), '&gt; 0.8')"/>
              </issueEval>
            </xsl:when>
            <xsl:when test="contains($counterDesc, 'XVE_SHARED_FUNCTION_ACCESS_HOLD_XECORE')">
              <issueText>%GPSXveSharedFunctionAccessBottleneck</issueText>
              <issueEval>
                <xsl:value-of select="concat(str:replace($queryText, '{$counterDesc}', string($counterDesc)), '&gt; 0.1')"/>
              </issueEval>
            </xsl:when>
          </xsl:choose>
        </derivedQuery>
      </xsl:for-each>
    </xsl:if>
    <derivedQuery id="GPUMemoryTextureRead" displayName="%GPUMemoryTextureRead">
      <helpKeyword>configs.gpumemorytextureread_gpumemorytexturereaddescription</helpKeyword>
      <valueType>double</valueType>
      <xsl:variable name="text">
        <xsl:choose>
          <xsl:when test="$gpuPlatform='IVB' or $gpuPlatform='HSW'">
            (query("/GPUEventCount/GPUEventType[GPU Memory: Texture Read Slice 0]") + query("/GPUEventCount/GPUEventType[GPU Memory: Texture Read Slice 1]")) * {$memoryMultiplier} * 128 / 1000000000
          </xsl:when>
          <xsl:when test="$gpuPlatform='VLV'">
            (query("/GPUEventCount/GPUEventType[GPU Memory: Texture Read Slice 0]")) * {$memoryMultiplier} * 128 / 1000000000
          </xsl:when>
        </xsl:choose>
      </xsl:variable>
      <valueEval>
        <xsl:value-of select="str:replace($text, '{$memoryMultiplier}', string($memoryMultiplier))"/>
      </valueEval>
      <description>%GPUMemoryTextureReadDescription</description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>0,64,128</timelineGraphColor>
        <timeScalems>1000</timeScalems>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUTexelQuadCount" displayName="%GPUTexelQuadCount">
      <helpKeyword>configs.gputexelquadcount_gputexelquadcountdescription</helpKeyword>
      <valueType>double</valueType>
      <xsl:choose>
        <xsl:when test="$universalCollectorUsed='true'">
          <queryInherit>/GPUSamplerTexelsMetric</queryInherit>
        </xsl:when>
        <xsl:otherwise>
          <xsl:variable name="text">
            <xsl:choose>
              <xsl:when test="$gpuPlatform='IVB' or $gpuPlatform='HSW'">
                (query("/GPUEventCount/GPUEventType[Texel Quads Count Slice 0]") + query("/GPUEventCount/GPUEventType[Texel Quads Count Slice 1]")) * {$memoryMultiplier}
              </xsl:when>
              <xsl:when test="$gpuPlatform='VLV'">
                (query("/GPUEventCount/GPUEventType[Texel Quads Count Slice 0]")) * {$memoryMultiplier}
              </xsl:when>
            </xsl:choose>
          </xsl:variable>
          <valueEval>
            <xsl:value-of select="str:replace($text, '{$memoryMultiplier}', string($memoryMultiplier))"/>
          </valueEval>
        </xsl:otherwise>
      </xsl:choose>
      <description>%GPUTexelQuadCountDescription</description>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>170,210,255</timelineGraphColor>
        <timeScalems>1000</timeScalems>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUMemoryBandwidth" displayName="%GPUMemoryBandwidth">
      <valueType>double</valueType>
      <valueEval><![CDATA[ (query("/GPUMemoryReadBandwidth") + query("/GPUMemoryWriteBandwidth")) ]]></valueEval>
      <description>%GPUMemoryBandwidthDescription</description>
      <displayAttributes>
        <diagramObjectId>GTIBDWSlot</diagramObjectId>
      </displayAttributes>
    </derivedQuery>
    <instanceCountQuery id="GPUSampleCount" displayName="%GPUSampleCount">
      <instanceDbTable>gpu_data::dd_sample</instanceDbTable>
      <valueType>double</valueType>
      <instanceBandTable>dd_gpu_node</instanceBandTable>
    </instanceCountQuery>
    <xsl:variable name="gpu_metric_sets" select="document('config://analysis_type/include/gpu_metric_sets.xsl')"/>
    <xsl:variable name="gpuCustomMetricSets" select="$gpu_metric_sets//metric_sets"/>
    <xsl:variable name="gpuMetricsInSets">
      <xsl:for-each select="$gpuCustomMetricSets/metric-set">
        <xsl:variable name="metricSet" select="."/>
        <xsl:for-each select="exsl:node-set($metricSet)/item">
          <value><xsl:value-of select="."/></value>
        </xsl:for-each>
      </xsl:for-each>
    </xsl:variable>
    <xsl:variable name="gpuMetricsSelectedSet">
    <xsl:for-each select="str:split(exsl:ctx('gpuMetricsSelected', ''), ',')">
      <xsl:variable name="counterDescBdf" select="."/>
      <xsl:variable name="counterDescSplit" select="str:split($counterDescBdf, ':')"/>
      <xsl:variable name="counterDesc" select="$counterDescSplit[1]"/>
      <value><xsl:value-of select="$counterDesc"/></value>
    </xsl:for-each>
    </xsl:variable>
    <xsl:variable name="gpuMetricsInSetsAndSelectedDupl">
      <xsl:copy-of select="$gpuMetricsSelectedSet"/>
      <xsl:copy-of select="$gpuMetricsInSets"/>
    </xsl:variable>
    <xsl:variable name="gpuMetricsInSetsAndSelected">
      <xsl:for-each select="exsl:node-set($gpuMetricsInSetsAndSelectedDupl)/value[not(.=preceding-sibling::*)]">
        <value><xsl:value-of select="."/></value>
      </xsl:for-each>
    </xsl:variable>
    <xsl:variable name="gpuMetrics">
          <item name="EuActive"/>
          <item name="EuStall"/>
          <item name="EuThreadOccupancy"/>
          <item name="EuFpuBothActive"/>
          <item name="EuFpuEmActive"/>
          <item name="EuFpuSysActive"/>
          <item name="EuSendActive"/>
          <item name="EuControlActive"/>
          <item name="SendActive"/>
          <item name="SysActive"/>
          <item name="EmActive"/>
          <item name="FpuActive"/>
          <item name="EuFpuActive"/>
          <item name="TypedReadsPerCacheLine"/>
          <item name="TypedWritesPerCacheLine"/>
          <item name="UntypedReadsPerCacheLine"/>
          <item name="UntypedWritesPerCacheLine"/>
          <item name="SamplerL1Misses"/>
          <item name="UntypedBytesWritten"/>
          <item name="UntypedBytesRead"/>
          <item name="SlmBytesRead"/>
          <item name="SlmBytesWritten"/>
          <item name="TypedBytesWritten"/>
          <item name="TypedBytesRead"/>
          <item name="GtiReadThroughput"/>
          <item name="GtiWriteThroughput"/>
          <item name="L3Misses"/>
          <item name="CsThreads"/>
          <item name="GtiL3Throughput"/>
          <item name="SamplerBottleneck"/>
          <item name="SamplersBusy"/>
          <item name="EuAvgIpcRate"/>
          <item name="ShaderAtomics"/>
          <item name="ShaderBarriers"/>
          <item name="EU_INST_EXECUTED_SYSTOLIC_ALL"/>
          <item name="EU_INST_EXECUTED_ALU0_ALL"/>
          <item name="EU_INST_EXECUTED_ALU1_ALL"/>
          <item name="EU_INST_EXECUTED_SEND_ALL"/>
          <item name="EU_INST_EXECUTED_CONTROL_ALL"/>
    </xsl:variable>
    <xsl:for-each select="exsl:node-set($gpuMetricsInSetsAndSelected)/value">
        <xsl:variable name="counterDesc" select="."/>
        <xsl:if test="count(exsl:node-set($gpuMetrics)/item[name = $counterDesc]) = 0">
            <infoQuery id="Conditional{$counterDesc[1]}SamplesExist">
                <xsl:variable name="dbPathText">conditional_gpu_data::dd_conditional_metric.is_{$counterDesc[1]}_exist</xsl:variable>
                <dbPath>
                    <xsl:value-of select="str:replace($dbPathText, '{$counterDesc[1]}', string($counterDesc[1]))"/>
                </dbPath>
                <displayDbPathSuffix>name</displayDbPathSuffix>
            </infoQuery>
        </xsl:if>
        <xsl:if test="count(exsl:node-set($gpuMetricsInSets)/value[$counterDesc]) = 0">
            <derivedQuery id="GPUMetric_{$counterDesc}">
                <xsl:variable name="valueEvalText">query("/GPU{$counterDesc}Metric/Conditional{$counterDesc}SamplesExist[%True]")</xsl:variable>
                <xsl:variable name="inheritText">/GPU{$counterDesc}Metric</xsl:variable>
                <queryInherit>
                    <xsl:value-of select="str:replace($inheritText, '{$counterDesc}', string($counterDesc))"/>
                </queryInherit>
                <valueEval>
                    <xsl:value-of select="str:replace($valueEvalText, '{$counterDesc}', string($counterDesc))"/>
                </valueEval>
                <displayAttributes>
                    <boolean:expand>false</boolean:expand>
                    <boolean:allowCollapse>false</boolean:allowCollapse>
                </displayAttributes>
            </derivedQuery>
        </xsl:if>
    </xsl:for-each>
    <xsl:for-each select="exsl:node-set($gpuMetrics)/item">
      <infoQuery id="Conditional{@name}SamplesExist">
        <xsl:variable name="dbPathText">conditional_gpu_data::dd_conditional_metric.is_{@name}_exist</xsl:variable>
        <dbPath>
          <xsl:value-of select="str:replace($dbPathText, '{@name}', string(@name))"/>
        </dbPath>
        <displayDbPathSuffix>name</displayDbPathSuffix>
      </infoQuery>
    </xsl:for-each>
    <xsl:variable name="gpuMetrics2">
      <item name="EuIdle"            event1="EuActive"           event2="EuStall"/>
      <item name="LlcMiss"           event1="LlcAccesses"        event2="LlcHits"/>
    </xsl:variable>
    <xsl:for-each select="exsl:node-set($gpuMetrics2)/item">
      <derivedQuery id="Is{@name}SamplesExist">
        <valueType>double</valueType>
        <xsl:variable name="valueEvalText">((query("/GPUSampleCount/GPUEventType[{@event1}]") + query("/GPUSampleCount/GPUEventType[{@event2}]"))> 0 ? 1 : 0)</xsl:variable>
        <valueEval>
          <xsl:value-of select="str:replace(str:replace($valueEvalText, '{@event1}', string(@event1)), '{@event2}', string(@event2))"/>
        </valueEval>
      </derivedQuery>
      <infoQuery id="Conditional{@name}SamplesExist">
        <xsl:variable name="dbPathText">conditional_gpu_data::dd_conditional_metric.is_{@name}_exist</xsl:variable>
        <dbPath>
          <xsl:value-of select="str:replace($dbPathText, '{@name}', string(@name))"/>
        </dbPath>
        <displayDbPathSuffix>name</displayDbPathSuffix>
      </infoQuery>
    </xsl:for-each>
    <derivedQuery id="IsL3ShaderThroughputSamplesExist">
      <valueType>double</valueType>
      <valueEval>
          <![CDATA[ ((query("/GPUSampleCount/GPUEventType[SlmBytesRead]") + query("/GPUSampleCount/GPUEventType[SlmBytesWritten]") + query("/GPUSampleCount/GPUEventType[ShaderMemoryAccesses]"))> 0 ? 1 : 0) ]]>
      </valueEval>
    </derivedQuery>
    <infoQuery id="ConditionalL3ShaderThroughputSamplesExist">
      <dbPath>conditional_gpu_data::dd_conditional_metric.is_L3ShaderThroughput_exist</dbPath>
      <displayDbPathSuffix>name</displayDbPathSuffix>
    </infoQuery>
    <derivedQuery id="GTIL3Throughput">
      <queryInherit>/GPUGtiL3ThroughputMetric</queryInherit>
      <xsl:if test="exsl:ctx('gsimClockDuration', 0) > 0">
        <valueEval>
         <![CDATA[ (query("/gSimGPUEventCount/gSimGPUEventType[GTIL3Read]") + query("/gSimGPUEventCount/gSimGPUEventType[GTIL3Write]")) * 64 / 1000000000 ]]>
        </valueEval>
      </xsl:if>
      <valueType>double</valueType>
    </derivedQuery>
    <derivedQuery id="GTIL3ThroughputB">
      <queryInherit>/GTIL3Throughput</queryInherit>
      <valueEval>
        <![CDATA[ (query("/GTIL3Throughput") * 1000000000) ]]>
      </valueEval>
      <valueType>memory</valueType>
    </derivedQuery>
    <derivedQuery id="GTIL3TotalBandwidthForTimeline" displayName="%GTIL3TotalBandwidthGBsec">
      <queryInherit>/GTIL3Throughput</queryInherit>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>72,104,155</timelineGraphColor>
        <timeScalems>1000</timeScalems>
        <minimumResolutionms>0</minimumResolutionms>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GTIL3TotalBandwidthBase" displayName="%GTIL3TotalBandwidth">
      <valueType>double</valueType>
      <boolean:valueSummable>false</boolean:valueSummable>
      <valueEval><![CDATA[ (query("/GTIL3Throughput") / query("/GPUElapsedTime")) ]]></valueEval>
      <displayAttributes>
        <boolean:vtNullAsZero>false</boolean:vtNullAsZero>
      </displayAttributes>
    </derivedQuery>
    <infoQuery id="ConditionalIsGTIL3ThroughputSamplesExist">
      <dbPath>conditional_gpu_data::dd_conditional_metric.is_GtiL3Throughput_exist</dbPath>
      <displayDbPathSuffix>name</displayDbPathSuffix>
    </infoQuery>
    <derivedQuery id="GTIL3TotalBandwidth" displayName="%GTIL3TotalBandwidthGBsec">
      <queryInherit>/GTIL3TotalBandwidthBase</queryInherit>
      <xsl:if test="fnc:is_universal_collector_in_multirun_mode()">
        <valueEval><![CDATA[ ( query("/GTIL3TotalBandwidthBase/ConditionalIsGTIL3ThroughputSamplesExist[%True]") ) ]]></valueEval>
      </xsl:if>
      <percentBases>
        <queryRef>/L3GTIBDWAbsMax</queryRef>
      </percentBases>
    </derivedQuery>
    <derivedQuery id="L3GTIBDWSlot" displayName="%GTIL3TotalBandwidth">
      <queryInherit>/GTIL3TotalBandwidth</queryInherit>
    </derivedQuery>
    <derivedQuery id="L3GTIBDWSlotB" displayName="%GTIL3TotalBandwidth">
      <queryInherit>/L3GTIBDWSlot</queryInherit>
      <valueType>bandwidth</valueType>
      <valueEval>
        <![CDATA[ (query("/L3GTIBDWSlot") * 1000000000) ]]>
      </valueEval>    </derivedQuery>
    <derivedQuery id="L3GTIBDWMax" displayName="%L3GTIBDWMax">
      <valueType>double</valueType>
      <valueEval><![CDATA[ (query("/GPUGtiL3ThroughputMetricMaxValue") / ( query("/GPUElapsedTime") * 1000000000 ) ) ]]></valueEval>
      <description>%L3GTIBDWMaxDescription</description>
    </derivedQuery>
    <derivedQuery id="L3GTIBDWAbsMax" displayName="%L3GTIBDWMax">
      <valueType>double</valueType>
      <queryInherit>/GPUGtiL3ThroughputMetricAbsMaxValue</queryInherit>
      <description>%L3GTIBDWMaxDescription</description>
    </derivedQuery>
    <derivedQuery id="L3GTIBDWAbsMaxRatioSlot" displayName="%GPUBDWRatioUniversalName">
      <valueType>ratio</valueType>
      <valueEval><![CDATA[ ( query("/GTIL3TotalBandwidth") / query("/L3GTIBDWAbsMax") ) ]]></valueEval>
      <description>%GPUBDWRatioUniversalDescription</description>
    </derivedQuery>
    <xsl:variable name="GPUMediaEngines">
      <item num="0"/>
      <item num="1"/>
    </xsl:variable>
    <xsl:for-each select="exsl:node-set($GPUMediaEngines)/item">
      <derivedQuery id="GPUVideoDecodeBox{@num}ReadRequests" displayName="%GPUVideoDecodeBoxReadRequestsName">
        <queryInherit>
          <xsl:text>/GPUMediaVIDEO_DECODE_BOX</xsl:text><xsl:value-of select="@num"/><xsl:text>_READ_REQUESTMetric</xsl:text>
        </queryInherit>
        <description>%GPUVideoDecodeBoxReadRequestsDescription</description>
        <valueType>count</valueType>
        <displayAttributes>
          <timelineFormat>line</timelineFormat>
          <timelineGraphColor>0,174,240</timelineGraphColor>
          <timelinePenWidth>1</timelinePenWidth>
          <minimumResolutionms>0</minimumResolutionms>
          <boolean:vtNullAsZero>false</boolean:vtNullAsZero>
        </displayAttributes>
      </derivedQuery>
      <derivedQuery id="GPUVideoDecodeBox{@num}WriteRequests" displayName="%GPUVideoDecodeBoxWriteRequestsName">
        <queryInherit>
          <xsl:text>/GPUMediaVIDEO_DECODE_BOX</xsl:text><xsl:value-of select="@num"/><xsl:text>_WRITE_REQUESTMetric</xsl:text>
        </queryInherit>
        <description>%GPUVideoDecodeBoxWriteRequestsDescription</description>
        <valueType>count</valueType>
        <displayAttributes>
          <timelineFormat>line</timelineFormat>
          <timelineGraphColor>111,42,145</timelineGraphColor>
          <timelinePenWidth>1</timelinePenWidth>
          <minimumResolutionms>0</minimumResolutionms>
          <boolean:vtNullAsZero>false</boolean:vtNullAsZero>
        </displayAttributes>
      </derivedQuery>
      <derivedQuery id="GPUVideoEnhancementBox{@num}ReadRequests" displayName="%GPUVideoEnhancementBoxReadRequestsName">
        <queryInherit>
          <xsl:text>/GPUMediaVIDEO_ENHANCEMENT_BOX</xsl:text><xsl:value-of select="@num"/><xsl:text>_READ_REQUESTMetric</xsl:text>
        </queryInherit>
        <description>%GPUVideoEnhancementBoxReadRequestsDescription</description>
        <valueType>count</valueType>
        <displayAttributes>
          <timelineFormat>line</timelineFormat>
          <timelineGraphColor>0,174,240</timelineGraphColor>
          <timelinePenWidth>1</timelinePenWidth>
          <minimumResolutionms>0</minimumResolutionms>
          <boolean:vtNullAsZero>false</boolean:vtNullAsZero>
        </displayAttributes>
      </derivedQuery>
      <derivedQuery id="GPUVideoEnhancementBox{@num}WriteRequests" displayName="%GPUVideoEnhancementBoxWriteRequestsName">
        <queryInherit>
          <xsl:text>/GPUMediaVIDEO_ENHANCEMENT_BOX</xsl:text><xsl:value-of select="@num"/><xsl:text>_WRITE_REQUESTMetric</xsl:text>
        </queryInherit>
        <description>%GPUVideoEnhancementBoxWriteRequestsDescription</description>
        <valueType>count</valueType>
        <displayAttributes>
          <timelineFormat>line</timelineFormat>
          <timelineGraphColor>111,42,145</timelineGraphColor>
          <timelinePenWidth>1</timelinePenWidth>
          <minimumResolutionms>0</minimumResolutionms>
          <boolean:vtNullAsZero>false</boolean:vtNullAsZero>
        </displayAttributes>
      </derivedQuery>
    </xsl:for-each>
    <derivedQuery id="GPUCommandParserVideoDecodeEngine0Busy" displayName="%GPUCommandParserVideoDecodeEngine0BusyName">
      <queryInherit>
        <xsl:text>/GPUMediaCOMMAND_PARSER_VIDEO_DECODE_ENGINE0_BUSYMetric</xsl:text>
      </queryInherit>
      <description>%GPUCommandParserVideoDecodeEngineBusyDescription</description>
      <valueType>ratio</valueType>
      <displayAttributes>
        <timelineFormat>area</timelineFormat>
        <timelineGraphColor>158,33,20</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <boolean:vtNullAsZero>false</boolean:vtNullAsZero>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUCommandParserVideoDecodeEngine1Busy" displayName="%GPUCommandParserVideoDecodeEngine1BusyName">
      <queryInherit>
        <xsl:text>/GPUMediaCOMMAND_PARSER_VIDEO_DECODE_ENGINE1_BUSYMetric</xsl:text>
      </queryInherit>
      <description>%GPUCommandParserVideoDecodeEngineBusyDescription</description>
      <valueType>ratio</valueType>
      <displayAttributes>
        <timelineFormat>area</timelineFormat>
        <timelineGraphColor>238,135,123</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <boolean:vtNullAsZero>false</boolean:vtNullAsZero>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUCommandParserVideoEnhancementEngine0Busy" displayName="%GPUCommandParserVideoEnhancementEngine0BusyName">
      <queryInherit>
        <xsl:text>/GPUMediaCOMMAND_PARSER_VIDEO_ENHANCEMENT_ENGINE0_BUSYMetric</xsl:text>
      </queryInherit>
      <description>%GPUCommandParserVideoEnhancementEngineBusyDescription</description>
      <valueType>ratio</valueType>
      <displayAttributes>
        <timelineFormat>area</timelineFormat>
        <timelineGraphColor>52,114,158</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <boolean:vtNullAsZero>false</boolean:vtNullAsZero>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUCommandParserVideoEnhancementEngine1Busy" displayName="%GPUCommandParserVideoEnhancementEngine1BusyName">
      <queryInherit>
        <xsl:text>/GPUMediaCOMMAND_PARSER_VIDEO_ENHANCEMENT_ENGINE1_BUSYMetric</xsl:text>
      </queryInherit>
      <description>%GPUCommandParserVideoEnhancementEngineBusyDescription</description>
      <valueType>ratio</valueType>
      <displayAttributes>
        <timelineFormat>area</timelineFormat>
        <timelineGraphColor>5,184,157</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <boolean:vtNullAsZero>false</boolean:vtNullAsZero>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUMediaReadRequests" displayName="%GPUMediaReadRequestsName">
      <queryInherit>
        <xsl:text>/GPUMediaMEDIA_READ_REQUESTMetric</xsl:text>
      </queryInherit>
      <description>%GPUMediaReadRequestsDescription</description>
      <valueType>count</valueType>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>0,174,240</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <boolean:vtNullAsZero>false</boolean:vtNullAsZero>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUMediaWriteRequests" displayName="%GPUMediaWriteRequestsName">
      <queryInherit>
        <xsl:text>/GPUMediaMEDIA_WRITE_REQUESTMetric</xsl:text>
      </queryInherit>
      <description>%GPUMediaWriteRequestsDescription</description>
      <valueType>count</valueType>
      <displayAttributes>
        <timelineFormat>line</timelineFormat>
        <timelineGraphColor>111,42,145</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <boolean:vtNullAsZero>false</boolean:vtNullAsZero>
      </displayAttributes>
    </derivedQuery>
    <derivedQuery id="GPUCommandParserGraphicsSecurityControllerBusy" displayName="%GPUCommandParserGraphicsSecurityControllerBusyName">
      <queryInherit>
        <xsl:text>/GPUMediaCOMMAND_PARSER_GRAPHICS_SECURITY_CONTROLLER_BUSYMetric</xsl:text>
      </queryInherit>
      <description>%GPUCommandParserGraphicsSecurityControllerBusyDescription</description>
      <valueType>ratio</valueType>
      <displayAttributes>
        <timelineFormat>area</timelineFormat>
        <timelineGraphColor>111,42,145</timelineGraphColor>
        <timelinePenWidth>1</timelinePenWidth>
        <minimumResolutionms>0</minimumResolutionms>
        <boolean:vtNullAsZero>false</boolean:vtNullAsZero>
      </displayAttributes>
    </derivedQuery>
    <infoQuery id="gSimStallEventType" displayName="Stall Type">
      <dbPath>gsim_stall_data::dd_sample.event_type.name</dbPath>
      <displayDbPathSuffix>value</displayDbPathSuffix>
      <displayAttributes>
        <boolean:hideZeroDataOnExpansion>true</boolean:hideZeroDataOnExpansion>
      </displayAttributes>
    </infoQuery>
    <countQuery id="gSimStallEventCount" displayName="Stall Count">
      <instanceDbTable>gsim_stall_data::dd_sample</instanceDbTable>
      <instanceBandTable>stalls_grouper</instanceBandTable>
      <displayAttributes>
        <boolean:expand>false</boolean:expand>
        <selfFormat>percentAndBar</selfFormat>
        <totalFormat>percentAndBar</totalFormat>
      </displayAttributes>
    </countQuery>
    <infoQuery id="GPUSamplingEventType" displayName="%GPUStallType">
      <dbPath>gpu_sampling_data::dd_sample.event_type.name</dbPath>
      <displayDbPathSuffix>value</displayDbPathSuffix>
      <displayAttributes>
        <boolean:hideZeroDataOnExpansion>true</boolean:hideZeroDataOnExpansion>
      </displayAttributes>
    </infoQuery>
    <countQuery id="GPUSamplingEventCount" displayName="%GPUStallCount">
      <instanceDbTable>gpu_sampling_data::dd_sample</instanceDbTable>
      <instanceBandTable>gpu_sampling_grouper</instanceBandTable>
      <displayAttributes>
        <boolean:expand>false</boolean:expand>
        <selfFormat>percentAndBar</selfFormat>
        <totalFormat>percentAndBar</totalFormat>
      </displayAttributes>
    </countQuery>
    <derivedQuery id="gSimCollectionStartTsc" displayName="%gSimCollectionStartTsc">
      <valueEval>$collectionStartTsc</valueEval>
      <valueType>count</valueType>
    </derivedQuery>
    <derivedQuery id="gSimCollectionStopTsc" displayName="%gSimCollectionStopTsc">
      <valueEval>$collectionStopTsc</valueEval>
      <valueType>count</valueType>
    </derivedQuery>
    <derivedQuery id="gSimCollectionDuration" displayName="%gSimCollectionDuration">
      <valueEval><![CDATA[ ( query("/gSimCollectionStopTsc") - query("/gSimCollectionStartTsc") ) ]]></valueEval>
      <valueType>count</valueType>
    </derivedQuery>
    <derivedQuery id="gSim16bitGOPsPerClkExpanded" displayName="%gSim16bitGOPsPerClk">
      <description>%gSim16bitGOPsPerClkDescription</description>
      <valueEval><![CDATA[ ( query("/GPUGTPinOperations16bitExecuted") / query("/gSimCollectionDuration") ) ]]></valueEval>
      <valueType>double</valueType>
      <displayAttributes>
        <boolean:expand>false</boolean:expand>
        <boolean:allowCollapse>true</boolean:allowCollapse>
      </displayAttributes>
      <expand>
        <vectorQuery id="gSim16bitGOPsPerClkVector">
          <derivedQuery id="gSim16bitIOPsPerClkExpand" displayName="%gSim16bitIOPsPerClk">
            <description>%gSim16bitIOPsPerClkDescription</description>
            <valueEval><![CDATA[ ( query("/GPUGTPinOperationInt16Executed") / query("/gSimCollectionDuration") ) ]]></valueEval>
            <valueType>double</valueType>
          </derivedQuery>
          <derivedQuery id="gSimHpFLOPsPerClkExpand" displayName="%gSimHpFLOPsPerClk">
            <description>%gSimHpFLOPsPerClkDescription</description>
            <valueEval><![CDATA[ ( query("/GPUGTPinOperationHpExecuted") / query("/gSimCollectionDuration") ) ]]></valueEval>
            <valueType>double</valueType>
          </derivedQuery>
        </vectorQuery>
      </expand>
    </derivedQuery>
    <derivedQuery id="gSim32bitGOPsPerClkExpanded" displayName="%gSim32bitGOPsPerClk">
      <description>%gSim32bitGOPsPerClkDescription</description>
      <valueEval><![CDATA[ ( query("/GPUGTPinOperations32bitExecuted") / query("/gSimCollectionDuration") ) ]]></valueEval>
      <valueType>double</valueType>
      <displayAttributes>
        <boolean:expand>true</boolean:expand>
        <boolean:allowCollapse>true</boolean:allowCollapse>
      </displayAttributes>
      <expand>
        <vectorQuery id="gSim32bitGOPsPerClkVector">
          <derivedQuery id="gSim32bitIOPsPerClkExpand" displayName="%gSim32bitIOPsPerClk">
            <description>%gSim32bitIOPsPerClkDescription</description>
            <valueEval><![CDATA[ ( query("/GPUGTPinOperationInt32Executed") / query("/gSimCollectionDuration") ) ]]></valueEval>
            <valueType>double</valueType>
          </derivedQuery>
          <derivedQuery id="gSimSpFLOPsPerClkExpand" displayName="%gSimSpFLOPsPerClk">
            <description>%gSimSpFLOPsPerClkDescription</description>
            <valueEval><![CDATA[ ( query("/GPUGTPinOperationSpExecuted") / query("/gSimCollectionDuration") ) ]]></valueEval>
            <valueType>double</valueType>
          </derivedQuery>
        </vectorQuery>
      </expand>
    </derivedQuery>
    <derivedQuery id="gSim64bitGOPsPerClkExpanded" displayName="%gSim64bitGOPsPerClk">
      <description>%gSim64bitGOPsPerClkDescription</description>
      <valueEval><![CDATA[ ( query("/GPUGTPinOperations64bitExecuted") / query("/gSimCollectionDuration") ) ]]></valueEval>
      <valueType>double</valueType>
      <displayAttributes>
        <boolean:expand>true</boolean:expand>
        <boolean:allowCollapse>true</boolean:allowCollapse>
      </displayAttributes>
      <expand>
        <vectorQuery id="gSim64bitGOPsPerClkVector">
          <derivedQuery id="gSim64bitIOPsPerClkExpand" displayName="%gSim64bitIOPsPerClk">
            <description>%gSim64bitIOPsPerClkDescription</description>
            <valueEval><![CDATA[ ( query("/GPUGTPinOperationInt64Executed") / query("/gSimCollectionDuration") ) ]]></valueEval>
            <valueType>double</valueType>
          </derivedQuery>
          <derivedQuery id="gSimDpFLOPsPerClkExpand" displayName="%gSimDpFLOPsPerClk">
            <description>%gSimDpFLOPsPerClkDescription</description>
            <valueEval><![CDATA[ ( query("/GPUGTPinOperationDpExecuted") / query("/gSimCollectionDuration") ) ]]></valueEval>
            <valueType>double</valueType>
          </derivedQuery>
        </vectorQuery>
      </expand>
    </derivedQuery>
    <xsl:variable name="gpuAbsMaxContextValues">
      <item name="gpuL3SamplerThroughputAbsMaxValue" query="GPUL3SamplerThroughputMetricAbsMaxValue"/>
      <item name="gpuL3ShaderThroughputAbsMaxValue"  query="GPUL3ShaderThroughputMetricAbsMaxValue"/>
      <item name="gpuL3_BYTE_READAbsMaxValue"        query="GPUL3ShaderReadThroughputMetricAbsMaxValue"/>
      <item name="gpuL3_BYTE_WRITEAbsMaxValue"       query="GPUL3ShaderWriteThroughputMetricAbsMaxValue"/>
      <item name="gpuUntypedBytesReadAbsMaxValue"    query="GPUUntypedBytesReadMetricAbsMaxValue"/>
      <item name="gpuUntypedBytesWrittenAbsMaxValue" query="GPUUntypedBytesWrittenMetricAbsMaxValue"/>
      <item name="gpuSlmBytesReadAbsMaxValue"        query="GPUSlmBytesReadMetricAbsMaxValue"/>
      <item name="gpuSlmBytesWrittenAbsMaxValue"     query="GPUSlmBytesWrittenMetricAbsMaxValue"/>
      <item name="gpuTypedBytesReadAbsMaxValue"      query="GPUTypedBytesReadMetricAbsMaxValue"/>
      <item name="gpuTypedBytesWrittenAbsMaxValue"   query="GPUTypedBytesWrittenMetricAbsMaxValue"/>
      <item name="gpuGtiReadThroughputAbsMaxValue"   query="GPUGtiReadThroughputMetricAbsMaxValue"/>
      <item name="gpuGtiWriteThroughputAbsMaxValue"  query="GPUGtiWriteThroughputMetricAbsMaxValue"/>
      <item name="gpuGtiL3ThroughputAbsMaxValue"     query="GPUGtiL3ThroughputMetricAbsMaxValue"/>
      <item name="gpuHOST_TO_GPUMEM_BYTE_READAbsMaxValue"   query="GPUHOST_TO_GPUMEM_BYTE_READAbsMaxValue"/>
      <item name="gpuHOST_TO_GPUMEM_BYTE_WRITEAbsMaxValue"  query="GPUHOST_TO_GPUMEM_BYTE_WRITEAbsMaxValue"/>
      <item name="gpuSYSMEM_BYTE_READAbsMaxValue"   query="GPUSYSMEM_BYTE_READAbsMaxValue"/>
      <item name="gpuSYSMEM_BYTE_WRITEAbsMaxValue"  query="GPUSYSMEM_BYTE_WRITEAbsMaxValue"/>
      <item name="gpuSTACK_TO_STACK_RECEIVEAbsMaxValue"   query="GPUSTACK_TO_STACK_RECEIVEAbsMaxValue"/>
      <item name="gpuSTACK_TO_STACK_TRANSMITAbsMaxValue"  query="GPUSTACK_TO_STACK_TRANSMITAbsMaxValue"/>
    </xsl:variable>
    <xsl:for-each select="exsl:node-set($gpuAbsMaxContextValues)/item">
      <xsl:if test="exsl:ctx(string(@name))">
        <derivedQuery id="{@query}">
          <valueEval><xsl:value-of select="concat('$', string(@name))"/></valueEval>
        </derivedQuery>
      </xsl:if>
    </xsl:for-each>
    <xsl:variable name="gpuAdapterTileNameList">
      <xsl:choose>
        <xsl:when test="exsl:ctx('gpuAdapterTileNameList', '') != ''">
          <xsl:value-of select="exsl:ctx('gpuAdapterTileNameList', '')"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:choose>
            <xsl:when test="exsl:ctx('gpuAdapterNameList', '') != ''">
              <xsl:value-of select="exsl:ctx('gpuAdapterNameList', '')"/>
            </xsl:when>
            <xsl:otherwise>
          <![CDATA[gpu adapter name stub]]>
          </xsl:otherwise>
          </xsl:choose>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="gpuVariables" select="document('config://include/gpu_variables.xsl')"/>
    <xsl:variable name="isMultiGpuAdapterSystem" select="string($gpuVariables//variables/isMultiGpuAdapterSystem)"/>
    <xsl:variable name="isMultiGpuTileSystem" select="string($gpuVariables//variables/isMultiGpuTileSystem)"/>
    <xsl:variable name="GpuAdapterGroupAverageMetrics">
      <item name="GPUEUNotActiveWhenBusy"/>
      <item name="GPUEUNotActiveExtWhenBusy"/>
      <item name="GPUThreadOccupancyWhenBusy"/>
      <item name="GPUThreadOccupancyExtWhenBusy"/>
      <item name="GPUEUNotActiveBase"/>
      <item name="GPUPeakThreadsPerWorkGroupRatioWhenLowOccupancy"/>
      <item name="GPUL3ReadWriteBandwidthWhenBusyAggregation"/>
      <item name="GPUL3BandwidthWhenBusy"/>
    </xsl:variable>
    <xsl:variable name="GpuAdapterGroupSummedMetrics">
      <item name="GPUEUActive"/>
      <item name="GPUEUStalled"/>
      <item name="GPUComputeTaskTimeDerived"/>
    </xsl:variable>
    <xsl:for-each select="str:split(exsl:group_adapters_by_device_id(), ';')">
        <xsl:variable name="deviceGroup" select="str:split(., '|')"/>
        <xsl:variable name="groupId" select="$deviceGroup[1]"/>
        <xsl:for-each select="exsl:node-set($GpuAdapterGroupAverageMetrics)/item">
            <xsl:variable name="MetricName" select="string(@name)"/>
            <xsl:variable name="AvgByAdapters">
                <xsl:variable name="resultRaw">
                    <xsl:for-each select="str:split($gpuAdapterTileNameList, ';')">
                        <xsl:variable name="gpuInfo" select="str:split(., '|')"/>
                        <xsl:if test="contains($deviceGroup[2], $gpuInfo[1])">
                            <xsl:variable name="adapterId" select="string(position())"/>
                            <value>
                                <xsl:text>queryOptional("</xsl:text>
                                <xsl:value-of select="concat('/', $MetricName, '_AverageOnAdapter_', $adapterId)"/>
                                <xsl:text>") +</xsl:text>
                            </value>
                        </xsl:if>
                    </xsl:for-each>
                </xsl:variable>
                <xsl:variable name="result" select="substring(exsl:node-set($resultRaw), 1, string-length(exsl:node-set($resultRaw)) - 1)"/>
                <xsl:value-of select="concat('(', exsl:node-set($result), ') / ', count(str:split($result, '+')))"/>
            </xsl:variable>
            <derivedQuery id="{@name}_AverageInGroup_{$groupId}">
                <queryInherit><xsl:value-of select="concat('/', $MetricName)"/></queryInherit>
                <valueEval>
                    <xsl:value-of select="$AvgByAdapters"/>
                </valueEval>
            </derivedQuery>
        </xsl:for-each>
        <xsl:for-each select="exsl:node-set($GpuAdapterGroupSummedMetrics)/item">
            <xsl:variable name="MetricName" select="string(@name)"/>
            <xsl:variable name="SummByAdaptersRaw">
                <xsl:for-each select="str:split($gpuAdapterTileNameList, ';')">
                    <xsl:variable name="gpuInfo" select="str:split(., '|')"/>
                    <xsl:if test="contains($deviceGroup[2], $gpuInfo[1])">
                        <xsl:variable name="adapterId" select="string(position())"/>
                        <value>
                            <xsl:text>queryOptional("</xsl:text>
                            <xsl:value-of select="concat('/', $MetricName, '_SummedOnAdapter_', $adapterId)"/>
                            <xsl:text>") +</xsl:text>
                        </value>
                    </xsl:if>
                </xsl:for-each>
            </xsl:variable>
            <xsl:variable name="SummByAdapters" select="substring(exsl:node-set($SummByAdaptersRaw), 1, string-length(exsl:node-set($SummByAdaptersRaw)) - 1)"/>
            <derivedQuery id="{@name}_SummedInGroup_{$groupId}">
                <queryInherit><xsl:value-of select="concat('/', $MetricName)"/></queryInherit>
                <valueEval>
                    <xsl:value-of select="$SummByAdapters"/>
                </valueEval>
            </derivedQuery>
        </xsl:for-each>
        <derivedQuery id="GPUThreadOccupancyWhenBusyIssue_Aggregated_{$groupId}">
          <valueType>bool</valueType>
          <xsl:variable name="query">(0.9 > query("/GPUThreadOccupancyWhenBusy_AverageInGroup_{@groupId}")) * (query("/GPUEUNotActiveBase_AverageInGroup_{@groupId}") > 0.2)</xsl:variable>
          <valueEval><xsl:value-of select="str:replace($query, '{@groupId}', $groupId)"/></valueEval>
        </derivedQuery>
        <derivedQuery id="GPUComputeTaskTimeWhenLowOccupancy_Aggregated_{$groupId}">
          <queryInherit>/GPUComputeTaskTimeWhenLowOccupancy</queryInherit>
          <xsl:variable name="query">query("/GPUComputeGlobalDimSummary") ? (query("/GPUThreadOccupancyWhenBusyIssue_Aggregated_{@groupId}") ? query("/GPUComputeTaskTimeDerived_SummedInGroup_{@groupId}") : $NULL) : $NULL</xsl:variable>
          <valueEval><xsl:value-of select="str:replace($query, '{@groupId}', $groupId)"/></valueEval>
        </derivedQuery>
        <derivedQuery id="GPUThreadOccupancyWhenBusyCTWhenLowOccupancy_Aggregated_{$groupId}">
          <queryInherit>/GPUThreadOccupancyWhenBusy</queryInherit>
          <xsl:variable name="OccupancyGroupQuery">
            query("/GPUThreadOccupancyWhenBusyIssue_Aggregated_{@groupId}") ? query("/GPUThreadOccupancyWhenBusy_AverageInGroup_{@groupId}/GPUComputeTaskPurpose[%ComputeComputingTaskPurpose]") : $NULL
          </xsl:variable>
          <valueEval><xsl:value-of select="str:replace($OccupancyGroupQuery, '{@groupId}', $groupId)"/></valueEval>
          <description>%GPUThreadOccupancyWhenBusyDescriptionInKernel</description>
          <xsl:variable name="issue">0.9 > query("/GPUThreadOccupancyWhenBusyCTWhenLowOccupancy_Aggregated_{@groupId}")</xsl:variable>
          <issueEval><xsl:value-of select="str:replace($issue, '{@groupId}', $groupId)"/></issueEval>
        </derivedQuery>
        <derivedQuery id="GPUEUStalled_Aggregated_{$groupId}">
          <queryInherit><xsl:value-of select="concat('/GPUEUStalled_SummedInGroup_', $groupId)"/></queryInherit>
          <xsl:variable name="issue">(query("/GPUEUStalled_Aggregated_{@groupId}") > 0.2) * (query("/GPUComputeTaskTimeDerived_SummedInGroup_{@groupId}") > 0)</xsl:variable>
          <issueEval><xsl:value-of select="str:replace($issue, '{@groupId}', $groupId)"/></issueEval>
        </derivedQuery>
        <derivedQuery id="GPUEUIdle_Aggregated_{$groupId}">
          <queryInherit>/GPUEUIdle</queryInherit>
          <xsl:variable name="query">(query("/GPUEUActive_SummedInGroup_{@groupId}") + query("/GPUEUStalled_SummedInGroup_{@groupId}")) >= 0 ? (1 - query("/GPUEUActive_SummedInGroup_{@groupId}") - query("/GPUEUStalled_SummedInGroup_{@groupId}")) : "$NULL"</xsl:variable>
          <valueEval>
            <xsl:value-of select="str:replace($query, '{@groupId}', $groupId)"/>
          </valueEval>
          <xsl:variable name="issue">(query("/GPUEUIdle_Aggregated_{@groupId}") > 0.05) * (query("/GPUComputeTaskTimeDerived_SummedInGroup_{@groupId}") > 0)</xsl:variable>
          <issueEval><xsl:value-of select="str:replace($issue, '{@groupId}', $groupId)"/></issueEval>
        </derivedQuery>
        <xsl:variable name="GpuAdapterGroupL3BandwidthQueries">
          <item name="L3ReadWrite"/>
          <item name="L3"/>
        </xsl:variable>
        <xsl:for-each select="exsl:node-set($GpuAdapterGroupL3BandwidthQueries)/item">
            <xsl:variable name="MetricName" select="string(@name)"/>
            <derivedQuery id="GPU{@name}BandwidthWhenBusyIssue_Aggregated_{$groupId}">
              <valueType>bool</valueType>
              <xsl:variable name="query">(query("/GPU{@name}BandwidthWhenBusyAggregation_AverageInGroup_{@groupId}"))? (query("/GPU{@name}BandwidthWhenBusyAggregation_AverageInGroup_{@groupId}") > 0.6) * (query("/GPUEUNotActiveBase_AverageInGroup_{@groupId}") > 0.2) : 0</xsl:variable>
              <valueEval><xsl:value-of select="str:replace(str:replace($query, '{@groupId}', $groupId), '{@name}', $MetricName)"/></valueEval>
            </derivedQuery>
            <derivedQuery id="GPU{@name}BandwidthWhenBusy_Aggregated_{$groupId}">
              <queryInherit><xsl:value-of select="concat('/GPU', $MetricName, 'BandwidthWhenBusyAggregation_AverageInGroup_', $groupId)"/></queryInherit>
              <xsl:variable name="issue">query("/GPU{@name}BandwidthWhenBusyIssue_Aggregated_{@groupId}")</xsl:variable>
              <issueEval><xsl:value-of select="str:replace(str:replace($issue, '{@groupId}', $groupId), '{@name}', $MetricName)"/></issueEval>
            </derivedQuery>
            <derivedQuery id="GPUComputeTaskTimeWhenHigh{@name}Bandwidth_Aggregated_{$groupId}">
              <queryInherit><xsl:value-of select="concat('/GPUComputeTaskTimeWhenHigh', $MetricName, 'Bandwidth')"/></queryInherit>
              <xsl:variable name="query">query("/GPUComputeGlobalDimSummary") ? (query("/GPU{@name}BandwidthWhenBusyIssue_Aggregated_{@groupId}") ? query("/GPUComputeTaskTimeDerived_SummedInGroup_{@groupId}") : $NULL) : $NULL</xsl:variable>
              <valueEval><xsl:value-of select="str:replace(str:replace($query, '{@groupId}', $groupId), '{@name}', $MetricName)"/></valueEval>
            </derivedQuery>
        </xsl:for-each>
    </xsl:for-each>
    <xsl:for-each select="str:split($gpuAdapterTileNameList, ';')">
      <xsl:variable name="gpuInfo" select="str:split(., '|')"/>
      <xsl:variable name="currentGPUBDF">
          <xsl:value-of select="concat('_', str:replace(str:replace(string($gpuInfo[1]), '.', '_'), ':', '_'), '_')" />
      </xsl:variable>
      <xsl:variable name="adapterId" select="string(position())"/>
      <xsl:variable name ="gpuAdapterGrouping">
        <xsl:if test="$isMultiGpuAdapterSystem">
          <xsl:value-of select="concat('/GPUAdapter[', $gpuInfo[1], ' : ', str:replace($gpuInfo[2], '/', '\/'), ']')"/>
        </xsl:if>
      </xsl:variable>
      <xsl:variable name ="tiles">
        <xsl:choose>
          <xsl:when test="count($gpuInfo) = 3">
            <xsl:value-of select="$gpuInfo[3]"/>
          </xsl:when>
          <xsl:otherwise>0,</xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name ="gpuTiles" select="str:split($tiles, ',')"/>
    <xsl:variable name="GpuAdapterAverageMetrics">
      <item name="GPUEUNotActiveWhenBusy"/>
      <item name="GPUEUNotActiveExtWhenBusy"/>
      <item name="GPUThreadOccupancyWhenBusy"/>
      <item name="GPUThreadOccupancyExtWhenBusy"/>
      <item name="GPUEUNotActiveBase"/>
      <item name="GPUEUNotActiveExtBase"/>
      <item name="GPUPeakThreadsPerWorkGroupRatioWhenLowOccupancy"/>
      <item name="GPUL3ReadWriteBandwidthWhenBusyAggregation"/>
      <item name="GPUL3BandwidthWhenBusy"/>
    </xsl:variable>
    <xsl:for-each select="exsl:node-set($GpuAdapterAverageMetrics)/item">
      <xsl:variable name="MetricName" select="string(@name)"/>
      <xsl:variable name="MetricAvgByTiles">
        <xsl:variable name="result">
        <xsl:for-each select="exsl:node-set($gpuTiles)">
            <xsl:variable name="tileId" select="string(current())"/>
            <value>
                <xsl:text>queryOptional("</xsl:text>
                <xsl:value-of select="concat('/', $MetricName, '_', $adapterId, '_', $tileId)"/>
                <xsl:text>")</xsl:text>
                <xsl:if test="not(position()=last())"><xsl:text> + </xsl:text></xsl:if>
            </value>
        </xsl:for-each>
        </xsl:variable>
        <xsl:value-of select="concat('(', exsl:node-set($result), ') / ', count(exsl:node-set($gpuTiles)))"/>
      </xsl:variable>
      <derivedQuery id="{@name}_AverageOnAdapter_{$adapterId}" displayName="%{$gpuPrefix}{@name}_AverageOnAdapter_{$adapterId}">
        <queryInherit><xsl:value-of select="concat('/', $MetricName)"/></queryInherit>
        <valueEval>
            <xsl:value-of select="$MetricAvgByTiles"/>
        </valueEval>
        <expand>
            <vectorQuery id="ExpandByTiles">
                <xsl:for-each select="exsl:node-set($gpuTiles)">
                    <xsl:variable name="tileId" select="string(current())"/>
                    <queryRef><xsl:value-of select="concat('/', $MetricName, '_', $adapterId, '_', $tileId)"/></queryRef>
                </xsl:for-each>
            </vectorQuery>
        </expand>
      </derivedQuery>
    </xsl:for-each>
    <xsl:variable name="GpuAdapterSummedMetrics">
      <item name="GPUEUActive"/>
      <item name="GPUEUStalled"/>
      <item name="GPUComputeTaskTimeDerived"/>
    </xsl:variable>
    <xsl:for-each select="exsl:node-set($GpuAdapterSummedMetrics)/item">
      <xsl:variable name="MetricName" select="string(@name)"/>
      <xsl:variable name="MetricSummByTiles">
        <xsl:for-each select="exsl:node-set($gpuTiles)">
            <xsl:variable name="tileId" select="string(current())"/>
            <value>
                <xsl:text>queryOptional("</xsl:text>
                <xsl:value-of select="concat('/', $MetricName, '_', $adapterId, '_', $tileId)"/>
                <xsl:text>")</xsl:text>
                <xsl:if test="not(position()=last())"><xsl:text> + </xsl:text></xsl:if>
            </value>
        </xsl:for-each>
      </xsl:variable>
      <derivedQuery id="{@name}_SummedOnAdapter_{$adapterId}" displayName="%{$gpuPrefix}{@name}_{$adapterId}">
        <queryInherit><xsl:value-of select="concat('/', $MetricName)"/></queryInherit>
        <valueEval>
            <xsl:value-of select="$MetricSummByTiles"/>
        </valueEval>
      </derivedQuery>
    </xsl:for-each>
      <xsl:for-each select="exsl:node-set($gpuTiles)">
        <xsl:variable name="tileId" select="string(current())"/>
        <xsl:variable name="notLocalizedName" select="concat('%', $gpuTilePrefix, 'TileName')"/>
        <xsl:variable name="tileName" select="exsl:message('viewpoint', $notLocalizedName, string($tileId))"/>
        <xsl:variable name ="gpuTileGrouping">
          <xsl:if test="$isMultiGpuTileSystem">
            <xsl:value-of select="concat('/GPUTileName[', $tileName, ']')"/>
          </xsl:if>
        </xsl:variable>
        <xsl:variable name ="gpuAdapterTileGrouping">
          <xsl:value-of select="concat($gpuAdapterGrouping, $gpuTileGrouping)"/>
        </xsl:variable>
        <derivedQuery id="GPUEUNotActiveWhenBusyInKernel_{$adapterId}_{$tileId}">
          <xsl:variable name="query">query("/GPUEUNotActiveWhenBusyInKernel{@grouping}")</xsl:variable>
          <queryInherit>/GPUEUNotActiveWhenBusyInKernel</queryInherit>
          <valueEval>
            <xsl:value-of select="str:replace($query, '{@grouping}', $gpuAdapterTileGrouping)"/>
          </valueEval>
          <xsl:variable name="issue">query("/GPUEUNotActiveWhenBusyIssue{@grouping}")</xsl:variable>
          <issueEval><xsl:value-of select="str:replace($issue, '{@grouping}', $gpuAdapterTileGrouping)"/></issueEval>
        </derivedQuery>
        <derivedQuery id="GPUEUNotActiveWhenBusy_{$adapterId}_{$tileId}">
          <xsl:variable name="query">query("/GPUEUNotActiveWhenBusy{@grouping}")</xsl:variable>
          <queryInherit>/GPUEUNotActiveWhenBusy</queryInherit>
          <valueEval>
            <xsl:value-of select="str:replace($query, '{@grouping}', $gpuAdapterTileGrouping)"/>
          </valueEval>
          <xsl:variable name="issue">query("/GPUEUNotActiveWhenBusyIssue{@grouping}")</xsl:variable>
          <issueEval><xsl:value-of select="str:replace($issue, '{@grouping}', $gpuAdapterTileGrouping)"/></issueEval>
        </derivedQuery>
        <derivedQuery id="GPUL3BandwidthWhenBusyInKernel_{$adapterId}_{$tileId}">
          <xsl:variable name="query">query("/GPUL3BandwidthWhenBusyInKernel{@grouping}")</xsl:variable>
          <queryInherit>/GPUL3BandwidthWhenBusyInKernel</queryInherit>
          <valueEval>
            <xsl:value-of select="str:replace($query, '{@grouping}', $gpuAdapterTileGrouping)"/>
          </valueEval>
          <xsl:variable name="issue">query("/GPUL3BandwidthWhenBusyIssue{@grouping}")</xsl:variable>
          <issueEval><xsl:value-of select="str:replace($issue, '{@grouping}', $gpuAdapterTileGrouping)"/></issueEval>
        </derivedQuery>
        <derivedQuery id="GPUL3BandwidthWhenBusy_{$adapterId}_{$tileId}">
          <xsl:variable name="query">query("/GPUL3BandwidthWhenBusy{@grouping}")</xsl:variable>
          <queryInherit>/GPUL3BandwidthWhenBusy</queryInherit>
          <valueEval>
            <xsl:value-of select="str:replace($query, '{@grouping}', $gpuAdapterTileGrouping)"/>
          </valueEval>
          <xsl:variable name="issue">query("/GPUL3BandwidthWhenBusyIssue{@grouping}")</xsl:variable>
          <issueEval><xsl:value-of select="str:replace($issue, '{@grouping}', $gpuAdapterTileGrouping)"/></issueEval>
        </derivedQuery>
        <derivedQuery id="GPUL3ReadWriteBandwidthWhenBusyInKernel_{$adapterId}_{$tileId}">
          <xsl:variable name="query">query("/GPUL3ReadWriteBandwidthWhenBusyInKernel{@grouping}")</xsl:variable>
          <queryInherit>/GPUL3ReadWriteBandwidthWhenBusyInKernel</queryInherit>
          <valueEval>
            <xsl:value-of select="str:replace($query, '{@grouping}', $gpuAdapterTileGrouping)"/>
          </valueEval>
          <xsl:variable name="issue">query("/GPUL3ReadWriteBandwidthWhenBusyIssue{@grouping}")</xsl:variable>
          <issueEval><xsl:value-of select="str:replace($issue, '{@grouping}', $gpuAdapterTileGrouping)"/></issueEval>
        </derivedQuery>
        <derivedQuery id="GPUL3ReadWriteBandwidthWhenBusy_{$adapterId}_{$tileId}">
          <xsl:variable name="query">query("/GPUL3ReadWriteBandwidthWhenBusy{@grouping}")</xsl:variable>
          <queryInherit>/GPUL3ReadWriteBandwidthWhenBusy</queryInherit>
          <valueEval>
            <xsl:value-of select="str:replace($query, '{@grouping}', $gpuAdapterTileGrouping)"/>
          </valueEval>
          <xsl:variable name="issue">query("/GPUL3ReadWriteBandwidthWhenBusyIssue{@grouping}")</xsl:variable>
          <issueEval><xsl:value-of select="str:replace($issue, '{@grouping}', $gpuAdapterTileGrouping)"/></issueEval>
        </derivedQuery>
        <derivedQuery id="GPUL3ReadWriteBandwidthWhenBusyAggregation_{$adapterId}_{$tileId}">
          <queryInherit>/GPUL3ReadWriteBandwidthWhenBusy</queryInherit>
          <xsl:variable name="valueQuery">query("/GPUL3ShaderReadWriteBDWMaxRatio{@adapterTileId}/{@condition}[%True]")</xsl:variable>
          <xsl:choose>
            <xsl:when test="fnc:is_universal_collector_in_multirun_mode()">
              <valueEval><xsl:value-of select="str:replace(str:replace($valueQuery, '{@adapterTileId}', concat('_', $adapterId, '_', $tileId) ), '{@condition}', 'ConditionalL3_BYTE_WRITESamplesExist' )"/></valueEval>
            </xsl:when>
            <xsl:otherwise>
              <valueEval><xsl:value-of select="str:replace(str:replace($valueQuery, '{@adapterTileId}', concat('_', $adapterId, '_', $tileId) ), '{@condition}', 'ConditionalGPUBusyData' )"/></valueEval>
            </xsl:otherwise>
          </xsl:choose>
          <xsl:variable name="issue">query("/GPUL3ReadWriteBandwidthWhenBusyIssue{@grouping}")</xsl:variable>
          <issueEval><xsl:value-of select="str:replace($issue, '{@grouping}', $gpuAdapterTileGrouping)"/></issueEval>
        </derivedQuery>
        <derivedQuery id="GPUComputeTaskTimeWhenHighL3ReadWriteBandwidth_{$adapterId}_{$tileId}">
          <xsl:variable name="query">query("/GPUComputeTaskTimeWhenHighL3ReadWriteBandwidth{@grouping}")</xsl:variable>
          <queryInherit>/GPUComputeTaskTimeWhenHighL3ReadWriteBandwidth</queryInherit>
          <valueEval>
            <xsl:value-of select="str:replace($query, '{@grouping}', $gpuAdapterTileGrouping)"/>
          </valueEval>
        </derivedQuery>
        <derivedQuery id="GPUDRAMBoundWhenBusy_{$adapterId}_{$tileId}">
          <xsl:variable name="query">query("/GPUDRAMBoundWhenBusyGPUDRAMBoundWhenBusy_{@grouping}")</xsl:variable>
          <queryInherit>/GPUDRAMBoundWhenBusy</queryInherit>
          <valueEval>
            <xsl:value-of select="str:replace($query, '{@grouping}', $gpuAdapterTileGrouping)"/>
          </valueEval>
        </derivedQuery>
        <derivedQuery id="GPUThreadOccupancyWhenBusyInKernel_{$adapterId}_{$tileId}">
          <xsl:variable name="query">query("/GPUThreadOccupancyWhenBusyInKernel{@grouping}")</xsl:variable>
          <queryInherit>/GPUThreadOccupancyWhenBusyInKernel</queryInherit>
          <valueEval>
            <xsl:value-of select="str:replace($query, '{@grouping}', $gpuAdapterTileGrouping)"/>
          </valueEval>
          <xsl:variable name="issue">query("/GPUThreadOccupancyWhenBusyIssue{@grouping}")</xsl:variable>
          <issueEval><xsl:value-of select="str:replace($issue, '{@grouping}', $gpuAdapterTileGrouping)"/></issueEval>
        </derivedQuery>
        <derivedQuery id="GPUThreadOccupancyWhenBusy_{$adapterId}_{$tileId}">
          <xsl:variable name="query">query("/GPUThreadOccupancyWhenBusy{@grouping}")</xsl:variable>
          <queryInherit>/GPUThreadOccupancyWhenBusy</queryInherit>
          <valueEval>
            <xsl:value-of select="str:replace($query, '{@grouping}', $gpuAdapterTileGrouping)"/>
          </valueEval>
          <xsl:variable name="issue">query("/GPUThreadOccupancyWhenBusyIssue{@grouping}")</xsl:variable>
          <issueEval><xsl:value-of select="str:replace($issue, '{@grouping}', $gpuAdapterTileGrouping)"/></issueEval>
        </derivedQuery>
        <derivedQuery id="GPUSamplerBusyWhenBusyInKernel_{$adapterId}_{$tileId}">
          <xsl:variable name="query">query("/GPUSamplerBusyWhenBusyInKernel{@grouping}")</xsl:variable>
          <queryInherit>/GPUSamplerBusyWhenBusyInKernel</queryInherit>
          <valueEval>
            <xsl:value-of select="str:replace($query, '{@grouping}', $gpuAdapterTileGrouping)"/>
          </valueEval>
          <xsl:variable name="issue">query("/GPUSamplerBusyWhenBusyIssue{@grouping}")</xsl:variable>
          <issueEval><xsl:value-of select="str:replace($issue, '{@grouping}', $gpuAdapterTileGrouping)"/></issueEval>
        </derivedQuery>
        <derivedQuery id="GPUSamplerBusyWhenBusy_{$adapterId}_{$tileId}">
          <xsl:variable name="query">query("/GPUSamplerBusyWhenBusy{@grouping}")</xsl:variable>
          <queryInherit>/GPUSamplerBusyWhenBusy</queryInherit>
          <valueEval>
            <xsl:value-of select="str:replace($query, '{@grouping}', $gpuAdapterTileGrouping)"/>
          </valueEval>
          <xsl:variable name="issue">query("/GPUSamplerBusyWhenBusyIssue{@grouping}")</xsl:variable>
          <issueEval><xsl:value-of select="str:replace($issue, '{@grouping}', $gpuAdapterTileGrouping)"/></issueEval>
        </derivedQuery>
        <derivedQuery id="GPUEuFpuBothActiveInKernel_{$adapterId}_{$tileId}">
          <xsl:variable name="query">query("/GPUEuFpuBothActiveInKernel{@grouping}")</xsl:variable>
          <queryInherit>/GPUEuFpuBothActiveInKernel</queryInherit>
          <valueEval>
            <xsl:value-of select="str:replace($query, '{@grouping}', $gpuAdapterTileGrouping)"/>
          </valueEval>
          <xsl:variable name="issue">query("/GPUFPUIssue{@grouping}")</xsl:variable>
          <issueEval><xsl:value-of select="str:replace($issue, '{@grouping}', $gpuAdapterTileGrouping)"/></issueEval>
        </derivedQuery>
        <derivedQuery id="GPUEuFpuBothActive_{$adapterId}_{$tileId}">
          <xsl:variable name="query">query("/GPUEuFpuBothActive{@grouping}")</xsl:variable>
          <queryInherit>/GPUEuFpuBothActive</queryInherit>
          <valueEval>
            <xsl:value-of select="str:replace($query, '{@grouping}', $gpuAdapterTileGrouping)"/>
          </valueEval>
          <xsl:variable name="issue">query("/GPUFPUIssue{@grouping}")</xsl:variable>
          <issueEval><xsl:value-of select="str:replace($issue, '{@grouping}', $gpuAdapterTileGrouping)"/></issueEval>
        </derivedQuery>
        <derivedQuery id="GPUEUNotActiveExtWhenBusy_{$adapterId}_{$tileId}">
          <xsl:variable name="query">query("/GPUEUNotActiveExtWhenBusy{@grouping}")</xsl:variable>
          <queryInherit>/GPUEUNotActiveExtWhenBusy</queryInherit>
          <valueEval>
            <xsl:value-of select="str:replace($query, '{@grouping}', $gpuAdapterTileGrouping)"/>
          </valueEval>
          <xsl:variable name="issue">query("/GPUEUNotActiveExtWhenBusyIssue{@grouping}")</xsl:variable>
          <issueEval><xsl:value-of select="str:replace($issue, '{@grouping}', $gpuAdapterTileGrouping)"/></issueEval>
        </derivedQuery>
        <xsl:variable name="GpuTileMetrics">
            <item name="GPU_EU_ACTIVE"/>
            <item name="GPUEUActive"/>
            <item name="GPUEUStalled"/>
            <item name="GPU_EU_STALLED"/>
            <item name="GPUEUIdle"/>
            <item name="GPU_EU_IDLE"/>
            <item name="GPU_EU_THREAD_OCCUPANCY"/>
            <item name="GPUEuThreadOccupancy"/>
            <item name="GPUEuFpuEmActiveExt"/>
            <item name="GPUEuFpuEmActive"/>
            <item name="GPUEuFpuSysActiveExt"/>
            <item name="GPUEuFpuSysActive"/>
            <item name="GPUComputeTaskTimeWhenSamplerOverutilized"/>
            <item name="GPUComputeTaskTimeWhenGPUEuFpuBothActive"/>
            <item name="GPUComputeTaskTimeWhenHighL3Bandwidth"/>
            <item name="GPUComputeTaskTimeWhenHighDRAMBandwidth"/>
            <item name="GPUDRAMBoundWhenBusyInKernel"/>
            <item name="GPUThreadOccupancyWhenBusyInKernelCTWhenLowOccupancy"/>
            <item name="GPUPeakOccupancyWhenLowOccupancy"/>
            <item name="GPUEUNotActiveBase"/>
            <item name="GPUEUNotActiveExtBase"/>
            <item name="GPUComputeTaskTimeDerived"/>
            <item name="GPUComputeTaskTimeWhenLowOccupancy"/>
            <item name="GPUComputeGlobalDimWhenLowOccupancy"/>
            <item name="GPUComputeLocalDimWhenLowOccupancy"/>
            <item name="GPUComputeSimdWidthWhenLowOccupancy"/>
            <item name="GPUPeakThreadsPerWorkGroupRatioWhenLowOccupancy"/>
            <item name="GPUL3ShaderReadBandwidth"/>
            <item name="GPUL3ShaderWriteBandwidth"/>
        </xsl:variable>
        <xsl:for-each select="exsl:node-set($GpuTileMetrics)/item">
            <xsl:variable name="MetricName" select="string(@name)"/>
            <derivedQuery id="{@name}_{$adapterId}_{$tileId}">
              <xsl:variable name="query">query("/{@name}{@grouping}")</xsl:variable>
              <queryInherit><xsl:value-of select="concat('/', $MetricName)"/></queryInherit>
              <valueEval>
                <xsl:value-of select="str:replace(str:replace($query, '{@name}', string(@name)), '{@grouping}', $gpuAdapterTileGrouping)"/>
              </valueEval>
            </derivedQuery>
        </xsl:for-each>
        <derivedQuery id="GPUEUNotActiveExtWhenBusyInKernel_{$adapterId}_{$tileId}">
          <xsl:variable name="query">query("/GPUEUNotActiveExtWhenBusyInKernel{@grouping}")</xsl:variable>
          <queryInherit>/GPUEUNotActiveExtWhenBusyInKernel</queryInherit>
          <valueEval>
            <xsl:value-of select="str:replace($query, '{@grouping}', $gpuAdapterTileGrouping)"/>
          </valueEval>
          <xsl:variable name="issue">query("/GPUEUNotActiveExtWhenBusyIssue{@grouping}")</xsl:variable>
          <issueEval><xsl:value-of select="str:replace($issue, '{@grouping}', $gpuAdapterTileGrouping)"/></issueEval>
        </derivedQuery>
        <derivedQuery id="GPUThreadOccupancyExtWhenBusy_{$adapterId}_{$tileId}">
          <xsl:variable name="query">query("/GPUThreadOccupancyExtWhenBusy{@grouping}")</xsl:variable>
          <queryInherit>/GPUThreadOccupancyExtWhenBusy</queryInherit>
          <valueEval>
            <xsl:value-of select="str:replace($query, '{@grouping}', $gpuAdapterTileGrouping)"/>
          </valueEval>
          <xsl:variable name="issue">query("/GPUThreadOccupancyExtWhenBusyIssue{@grouping}")</xsl:variable>
          <issueEval><xsl:value-of select="str:replace($issue, '{@grouping}', $gpuAdapterTileGrouping)"/></issueEval>
        </derivedQuery>
        <derivedQuery id="GPUThreadOccupancyExtWhenBusyInKernel_{$adapterId}_{$tileId}">
          <xsl:variable name="query">query("/GPUThreadOccupancyExtWhenBusyInKernel{@grouping}")</xsl:variable>
          <queryInherit>/GPUThreadOccupancyExtWhenBusyInKernel</queryInherit>
          <valueEval>
            <xsl:value-of select="str:replace($query, '{@grouping}', $gpuAdapterTileGrouping)"/>
          </valueEval>
          <xsl:variable name="issue">query("/GPUThreadOccupancyExtWhenBusyIssue{@grouping}")</xsl:variable>
          <issueEval><xsl:value-of select="str:replace($issue, '{@grouping}', $gpuAdapterTileGrouping)"/></issueEval>
        </derivedQuery>
        <derivedQuery id="GPUComputeTaskTimeExtWhenLowOccupancy_{$adapterId}_{$tileId}">
          <xsl:variable name="query">query("/GPUComputeTaskTimeExtWhenLowOccupancy{@grouping}")</xsl:variable>
          <queryInherit>/GPUComputeTaskTimeExtWhenLowOccupancy</queryInherit>
          <valueEval>
            <xsl:value-of select="str:replace($query, '{@grouping}', $gpuAdapterTileGrouping)"/>
          </valueEval>
        </derivedQuery>
        <derivedQuery id="GPUComputeGlobalDimExtWhenLowOccupancy_{$adapterId}_{$tileId}">
          <xsl:variable name="query">query("/GPUComputeGlobalDimExtWhenLowOccupancy{@grouping}")</xsl:variable>
          <queryInherit>/GPUComputeGlobalDimExtWhenLowOccupancy</queryInherit>
          <valueEval>
            <xsl:value-of select="str:replace($query, '{@grouping}', $gpuAdapterTileGrouping)"/>
          </valueEval>
        </derivedQuery>
        <derivedQuery id="GPUComputeLocalDimExtWhenLowOccupancy_{$adapterId}_{$tileId}">
          <xsl:variable name="query">query("/GPUComputeLocalDimExtWhenLowOccupancy{@grouping}")</xsl:variable>
          <queryInherit>/GPUComputeLocalDimExtWhenLowOccupancy</queryInherit>
          <valueEval>
            <xsl:value-of select="str:replace($query, '{@grouping}', $gpuAdapterTileGrouping)"/>
          </valueEval>
        </derivedQuery>
        <derivedQuery id="GPUComputeSimdWidthExtWhenLowOccupancy_{$adapterId}_{$tileId}">
          <xsl:variable name="query">query("/GPUComputeSimdWidthExtWhenLowOccupancy{@grouping}")</xsl:variable>
          <queryInherit>/GPUComputeSimdWidthExtWhenLowOccupancy</queryInherit>
          <valueEval>
            <xsl:value-of select="str:replace($query, '{@grouping}', $gpuAdapterTileGrouping)"/>
          </valueEval>
        </derivedQuery>
        <derivedQuery id="GPUPeakOccupancyExtWhenLowOccupancy_{$adapterId}_{$tileId}">
          <xsl:variable name="query">query("/GPUPeakOccupancyExtWhenLowOccupancy{@grouping}")</xsl:variable>
          <queryInherit>/GPUPeakOccupancyExtWhenLowOccupancy</queryInherit>
          <valueEval>
            <xsl:value-of select="str:replace($query, '{@grouping}', $gpuAdapterTileGrouping)"/>
          </valueEval>
        </derivedQuery>
        <derivedQuery id="GPUThreadOccupancyExtWhenBusyInKernelCTWhenLowOccupancy_{$adapterId}_{$tileId}">
          <xsl:variable name="query">query("/GPUThreadOccupancyExtWhenBusyInKernelCTWhenLowOccupancy{@grouping}")</xsl:variable>
          <queryInherit>/GPUThreadOccupancyExtWhenBusyInKernelCTWhenLowOccupancy</queryInherit>
          <valueEval>
            <xsl:value-of select="str:replace($query, '{@grouping}', $gpuAdapterTileGrouping)"/>
          </valueEval>
        </derivedQuery>
        <derivedQuery id="GPUPeakThreadsPerWorkGroupRatioExtWhenLowOccupancy_{$adapterId}_{$tileId}">
          <xsl:variable name="query">query("/GPUPeakThreadsPerWorkGroupRatioExtWhenLowOccupancy{@grouping}")</xsl:variable>
          <queryInherit>/GPUPeakThreadsPerWorkGroupRatioExtWhenLowOccupancy</queryInherit>
          <valueEval>
            <xsl:value-of select="str:replace($query, '{@grouping}', $gpuAdapterTileGrouping)"/>
          </valueEval>
        </derivedQuery>
        <derivedQuery id="GPUMemoryReadBandwidth_{$adapterId}_{$tileId}" displayName="%GPUMemoryRead_{$adapterId}_{$tileId}">
          <xsl:variable name="query">query("/GPUMemoryReadBandwidth{@grouping}")</xsl:variable>
          <queryInherit>/GPUMemoryReadBandwidth</queryInherit>
          <valueEval>
            <xsl:value-of select="str:replace($query, '{@grouping}', $gpuAdapterTileGrouping)"/>
          </valueEval>
          <percentBases>
            <queryRef>/GPUMemoryReadBDWAbsMax_{$adapterId}_{$tileId}</queryRef>
          </percentBases>
        </derivedQuery>
        <derivedQuery id="GPUL3ShaderReadWriteBDWMaxRatio_{$adapterId}_{$tileId}" displayName="%GPUBDWRatioUniversalName_{$adapterId}_{$tileId}">
          <queryInherit>/GPUL3ShaderReadWriteBDWMaxRatio</queryInherit>
          <xsl:variable name="query">( query("/GPUL3ShaderReadBandwidth{@adapterTileId}") + query("/GPUL3ShaderWriteBandwidth{@adapterTileId}") ) / ( query("/GPUL3ShaderReadBDWMax{@currentGPUBDF}") + query("/GPUL3ShaderWriteBDWMax{@currentGPUBDF}") )</xsl:variable>
          <valueEval><xsl:value-of select="str:replace(str:replace($query, '{@adapterTileId}', concat('_', $adapterId, '_', $tileId)), '{@currentGPUBDF}', $currentGPUBDF)"/></valueEval>
        </derivedQuery>
      </xsl:for-each>
    </xsl:for-each>
  </queryLibrary>
  </xsl:template>
</xsl:stylesheet>
