﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/ec2/EC2_EXPORTS.h>

namespace Aws {
namespace EC2 {
namespace Model {
enum class HostMaintenance { NOT_SET, on, off };

namespace HostMaintenanceMapper {
AWS_EC2_API HostMaintenance GetHostMaintenanceForName(const Aws::String& name);

AWS_EC2_API Aws::String GetNameForHostMaintenance(HostMaintenance value);
}  // namespace HostMaintenanceMapper
}  // namespace Model
}  // namespace EC2
}  // namespace Aws
