/*
 * Decompiled with CFR 0.152.
 */
package firrtl.annotations;

import firrtl.FirrtlUserException;
import firrtl.annotations.Annotation;
import firrtl.annotations.AnnotationClassNotFoundException;
import firrtl.annotations.HasSerializationHints;
import firrtl.annotations.InvalidAnnotationFileException;
import firrtl.annotations.InvalidAnnotationJSONException;
import firrtl.annotations.JsonProtocol;
import firrtl.annotations.UnrecogizedAnnotationsException;
import firrtl.annotations.UnrecognizedAnnotation;
import firrtl.annotations.UnserializableAnnotationException$;
import firrtl.annotations.UnserializeableAnnotation;
import firrtl.stage.AllowUnrecognizedAnnotations$;
import java.io.File;
import java.io.Serializable;
import logger.LazyLogging;
import logger.Logger;
import org.json4s.FileInput;
import org.json4s.Formats;
import org.json4s.FullTypeHints;
import org.json4s.JsonAST;
import org.json4s.JsonInput;
import org.json4s.ParserUtil;
import org.json4s.native.JsonMethods$;
import org.json4s.native.Serialization$;
import org.json4s.package;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.LinearSeqOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.package$;
import scala.reflect.ManifestFactory$;
import scala.runtime.BooleanRef;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;

public final class JsonProtocol$
implements LazyLogging {
    public static final JsonProtocol$ MODULE$ = new JsonProtocol$();
    private static final Regex GetClassPattern;
    private static Logger logger;

    static {
        LazyLogging.$init$(MODULE$);
        GetClassPattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("[^']*'([^']+)'.*"));
    }

    @Override
    public Logger getLogger() {
        return LazyLogging.getLogger$(this);
    }

    @Override
    public Logger logger() {
        return logger;
    }

    @Override
    public void logger$LazyLogging$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
    }

    private Regex GetClassPattern() {
        return GetClassPattern;
    }

    public Formats jsonFormat(Seq<Class<?>> tags) {
        return Serialization$.MODULE$.formats(new FullTypeHints(tags.toList())).withTypeHintFieldName("class").$plus(new JsonProtocol.TransformClassSerializer()).$plus(new JsonProtocol.NamedSerializer()).$plus(new JsonProtocol.CircuitNameSerializer()).$plus(new JsonProtocol.ModuleNameSerializer()).$plus(new JsonProtocol.ComponentNameSerializer()).$plus(new JsonProtocol.TargetSerializer()).$plus(new JsonProtocol.GenericTargetSerializer()).$plus(new JsonProtocol.CircuitTargetSerializer()).$plus(new JsonProtocol.ModuleTargetSerializer()).$plus(new JsonProtocol.InstanceTargetSerializer()).$plus(new JsonProtocol.ReferenceTargetSerializer()).$plus(new JsonProtocol.TransformSerializer()).$plus(new JsonProtocol.LoadMemoryFileTypeSerializer()).$plus(new JsonProtocol.IsModuleSerializer()).$plus(new JsonProtocol.IsMemberSerializer()).$plus(new JsonProtocol.CompleteTargetSerializer()).$plus(new JsonProtocol.TypeSerializer()).$plus(new JsonProtocol.ExpressionSerializer()).$plus(new JsonProtocol.StatementSerializer()).$plus(new JsonProtocol.PortSerializer()).$plus(new JsonProtocol.DefModuleSerializer()).$plus(new JsonProtocol.CircuitSerializer()).$plus(new JsonProtocol.InfoSerializer()).$plus(new JsonProtocol.GroundTypeSerializer()).$plus(new JsonProtocol.UnrecognizedAnnotationSerializer());
    }

    public String serialize(Seq<Annotation> annos) {
        return this.serializeTry(annos).get();
    }

    public Seq<Tuple2<Annotation, Throwable>> firrtl$annotations$JsonProtocol$$findUnserializeableAnnos(Seq<Annotation> annos, Formats formats) {
        return (Seq)((IterableOps)annos.map((Function1<Annotation, Tuple2> & Serializable)a -> Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(a), Try$.MODULE$.apply((Function0<String> & Serializable)() -> Serialization$.MODULE$.write(a, formats))))).collect(new Serializable(){
            private static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<Annotation, Try<String>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                void var3_10;
                A1 A1 = x1;
                if (A1 != null) {
                    Annotation a = A1._1();
                    Try<String> try_ = A1._2();
                    if (try_ instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable e = failure.exception();
                        Tuple2<Annotation, Throwable> tuple2 = new Tuple2<Annotation, Throwable>(a, e);
                        return var3_10;
                    }
                }
                B1 B1 = function1.apply(x1);
                return var3_10;
            }

            public final boolean isDefinedAt(Tuple2<Annotation, Try<String>> x1) {
                Try<String> try_;
                Tuple2<Annotation, Try<String>> tuple2 = x1;
                boolean bl = tuple2 != null && (try_ = tuple2._2()) instanceof Failure;
                return bl;
            }
        });
    }

    private Seq<Class<?>> getTags(Seq<Annotation> annos) {
        return (Seq)((SeqOps)annos.flatMap((Function1<Annotation, Seq> & Serializable)x0$1 -> {
            Seq seq;
            Annotation annotation = x0$1;
            if (annotation instanceof HasSerializationHints) {
                Annotation annotation2 = annotation;
                Class<?> clazz = annotation2.getClass();
                seq = (Seq)((HasSerializationHints)((Object)annotation2)).typeHints().$plus$colon(clazz);
            } else {
                seq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{annotation.getClass()}));
            }
            return seq;
        })).distinct();
    }

    public Try<String> serializeTry(Seq<Annotation> annos) {
        Seq<Class<?>> tags = this.getTags(annos);
        Formats formats = this.jsonFormat(tags);
        return Try$.MODULE$.apply((Function0<String> & Serializable)() -> Serialization$.MODULE$.writePretty(annos, formats)).recoverWith(new Serializable(annos, formats){
            private static final long serialVersionUID = 0L;
            private final Seq annos$1;
            private final Formats formats$2;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof package.MappingException) {
                    package.MappingException mappingException = (package.MappingException)A1;
                    Seq<Tuple2<Annotation, Throwable>> badAnnos = JsonProtocol$.MODULE$.firrtl$annotations$JsonProtocol$$findUnserializeableAnnos(this.annos$1, this.formats$2);
                    object = new Failure<T>(badAnnos.isEmpty() ? mappingException : UnserializableAnnotationException$.MODULE$.apply(badAnnos));
                } else {
                    object = function1.apply(x1);
                }
                return object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof package.MappingException;
                return bl;
            }
            {
                this.annos$1 = annos$1;
                this.formats$2 = formats$2;
            }
        });
    }

    public String serializeRecover(Seq<Annotation> annos) {
        Seq tags = (Seq)this.getTags(annos).$plus$colon(UnserializeableAnnotation.class);
        Formats formats = this.jsonFormat(tags);
        Seq safeAnnos = (Seq)annos.map((Function1<Annotation, Annotation> & Serializable)anno -> {
            Annotation annotation;
            Try try_ = Try$.MODULE$.apply((Function0<String> & Serializable)() -> Serialization$.MODULE$.write(anno, formats));
            if (try_ instanceof Success) {
                annotation = anno;
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                annotation = new UnserializeableAnnotation(e.getMessage(), anno.toString());
            } else {
                throw new MatchError(try_);
            }
            return annotation;
        });
        return Serialization$.MODULE$.writePretty(safeAnnos, formats);
    }

    public Seq<Annotation> deserialize(JsonInput in, boolean allowUnrecognizedAnnotations) {
        return this.deserializeTry(in, allowUnrecognizedAnnotations).get();
    }

    public boolean deserialize$default$2() {
        return false;
    }

    public Try<Seq<Annotation>> deserializeTry(JsonInput in, boolean allowUnrecognizedAnnotations) {
        return Try$.MODULE$.apply((Function0<List> & Serializable)() -> {
            Object object;
            List<JsonAST.JValue> objs;
            JsonAST.JValue parsed = JsonMethods$.MODULE$.parse(in, JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3());
            JsonAST.JValue jValue = parsed;
            if (!(jValue instanceof JsonAST.JArray)) {
                throw new InvalidAnnotationJSONException(new StringBuilder(57).append("Annotations must be serialized as a JArray, got ").append(jValue.getClass().getName()).append(" instead!").toString());
            }
            JsonAST.JArray jArray = (JsonAST.JArray)jValue;
            List<JsonAST.JValue> list2 = objs = jArray.arr();
            List<JsonAST.JValue> annos = list2;
            BooleanRef classNotFoundBuildingLoaded = BooleanRef.create(false);
            Seq classes = JsonProtocol$.findTypeHints$1(annos, true);
            Seq loaded = (Seq)classes.flatMap((Function1<String, Option> & Serializable)x -> {
                Option option;
                try {
                    option = new Some(Class.forName(x));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundBuildingLoaded$1.elem = true;
                    option = None$.MODULE$;
                }
                return option;
            });
            Formats formats = MODULE$.jsonFormat(loaded);
            try {
                object = Serialization$.MODULE$.read(in, formats, ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(Annotation.class), Nil$.MODULE$));
            }
            catch (package.MappingException e) {
                ArrayBuffer exceptionList = new ArrayBuffer();
                Object firrtlAnnos = annos.map((Function1<JsonAST.JValue, Annotation> & Serializable)jsonAnno -> {
                    Annotation annotation;
                    try {
                        annotation = (Annotation)org.json4s.package$.MODULE$.jvalue2extractable((JsonAST.JValue)jsonAnno).extract(formats, ManifestFactory$.MODULE$.classType(Annotation.class));
                    }
                    catch (package.MappingException mappingException) {
                        exceptionList.$plus$eq(JsonProtocol$.getAnnotationNameFromMappingException$1(mappingException));
                        annotation = new UnrecognizedAnnotation((JsonAST.JValue)jsonAnno);
                    }
                    return annotation;
                });
                if (((List)firrtlAnnos).contains(AllowUnrecognizedAnnotations$.MODULE$) || allowUnrecognizedAnnotations) {
                    object = firrtlAnnos;
                }
                MODULE$.logger().error((Function0<String> & Serializable)() -> new StringBuilder(177).append("Annotation parsing found unrecognized annotations\nThis error can be ignored with an AllowUnrecognizedAnnotationsAnnotation or command line flag --allow-unrecognized-annotations\n").append(exceptionList.mkString("\n")).toString());
                if (classNotFoundBuildingLoaded.elem) {
                    ArrayBuffer distinctProblems = (ArrayBuffer)exceptionList.distinct();
                    String problems = ((IterableOnceOps)distinctProblems.take(10)).mkString(", ");
                    String dots = distinctProblems.length() > 10 ? ", ..." : "";
                    throw new UnrecogizedAnnotationsException(new StringBuilder(2).append("(").append(problems).append(dots).append(")").toString());
                }
                throw e;
            }
            return object;
        }).recoverWith(new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Failure<Object> failure;
                A1 A1 = x1;
                if (A1 instanceof ClassNotFoundException) {
                    ClassNotFoundException classNotFoundException = (ClassNotFoundException)A1;
                    failure = new Failure<T>(new AnnotationClassNotFoundException(classNotFoundException.getMessage()));
                } else {
                    boolean bl = A1 instanceof ParserUtil.ParseException ? true : A1 instanceof package.MappingException;
                    failure = bl ? new Failure<T>(new InvalidAnnotationJSONException(A1.getMessage())) : function1.apply(x1);
                }
                return (B1)failure;
            }

            public final boolean isDefinedAt(Throwable x1) {
                boolean bl;
                Throwable throwable = x1;
                boolean bl2 = throwable instanceof ClassNotFoundException ? true : (bl = throwable instanceof ParserUtil.ParseException ? true : throwable instanceof package.MappingException);
                return bl2;
            }
        }).recoverWith(new Serializable(in){
            private static final long serialVersionUID = 0L;
            private final JsonInput in$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof UnrecogizedAnnotationsException) {
                    Failure<T> failure;
                    UnrecogizedAnnotationsException unrecogizedAnnotationsException = (UnrecogizedAnnotationsException)A1;
                    JsonInput jsonInput = this.in$1;
                    if (jsonInput instanceof FileInput) {
                        FileInput fileInput = (FileInput)jsonInput;
                        File file = fileInput.file();
                        failure = new Failure<T>(new InvalidAnnotationFileException(file, unrecogizedAnnotationsException));
                    } else {
                        failure = new Failure<T>(unrecogizedAnnotationsException);
                    }
                    object = failure;
                } else if (A1 instanceof FirrtlUserException) {
                    Failure<T> failure;
                    FirrtlUserException firrtlUserException = (FirrtlUserException)A1;
                    JsonInput jsonInput = this.in$1;
                    if (jsonInput instanceof FileInput) {
                        FileInput fileInput = (FileInput)jsonInput;
                        File file = fileInput.file();
                        failure = new Failure<T>(new InvalidAnnotationFileException(file, firrtlUserException));
                    } else {
                        failure = new Failure<T>(firrtlUserException);
                    }
                    object = failure;
                } else {
                    object = function1.apply(x2);
                }
                return object;
            }

            public final boolean isDefinedAt(Throwable x2) {
                Throwable throwable = x2;
                boolean bl = throwable instanceof UnrecogizedAnnotationsException ? true : throwable instanceof FirrtlUserException;
                return bl;
            }
            {
                this.in$1 = in$1;
            }
        });
    }

    public boolean deserializeTry$default$2() {
        return false;
    }

    private static final String getAnnotationNameFromMappingException$1(package.MappingException mappingException) {
        String name;
        Option<List<String>> option;
        String string = mappingException.getMessage();
        String string2 = string != null && !(option = MODULE$.GetClassPattern().unapplySeq(string)).isEmpty() && option.get() != null && option.get().lengthCompare(1) == 0 ? (name = (String)((LinearSeqOps)option.get()).apply(0)) : string;
        return string2;
    }

    private static final Seq findTypeHints$1(Seq classInst, boolean requireClassField) {
        return (Seq)((SeqOps)classInst.flatMap((Function1<JsonAST.JValue, Seq> & Serializable)x0$1 -> {
            Seq seq;
            JsonAST.JValue jValue = x0$1;
            if (jValue instanceof JsonAST.JObject) {
                JsonAST.JObject jObject = (JsonAST.JObject)jValue;
                List<Tuple2<String, JsonAST.JValue>> fields = jObject.obj();
                Option<String> hint = fields.collectFirst(new Serializable(){
                    private static final long serialVersionUID = 0L;

                    /*
                     * WARNING - void declaration
                     * Enabled aggressive block sorting
                     */
                    public final <A1 extends Tuple2<String, JsonAST.JValue>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        void var3_10;
                        A1 A1 = x1;
                        if (A1 != null) {
                            String string = A1._1();
                            JsonAST.JValue jValue = A1._2();
                            if ("class".equals(string) && jValue instanceof JsonAST.JString) {
                                String name;
                                JsonAST.JString jString = (JsonAST.JString)jValue;
                                String string2 = name = jString.s();
                                return var3_10;
                            }
                        }
                        B1 B1 = function1.apply(x1);
                        return var3_10;
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean isDefinedAt(Tuple2<String, JsonAST.JValue> x1) {
                        Tuple2<String, JsonAST.JValue> tuple2 = x1;
                        if (tuple2 == null) return false;
                        String string = tuple2._1();
                        JsonAST.JValue jValue = tuple2._2();
                        if (!"class".equals(string)) return false;
                        if (!(jValue instanceof JsonAST.JString)) return false;
                        return true;
                    }
                });
                if (requireClassField && hint.isEmpty()) {
                    throw new InvalidAnnotationJSONException(new StringBuilder(34).append("Expected field 'class' not found! ").append(fields).toString());
                }
                Option<String> option = hint;
                seq = (Seq)JsonProtocol$.findTypeHints$1((Seq)fields.map((Function1<Tuple2, JsonAST.JValue> & Serializable)x$1 -> (JsonAST.JValue)x$1._2()), JsonProtocol$.findTypeHints$default$2$1()).$plus$plus$colon(option);
            } else if (jValue instanceof JsonAST.JArray) {
                JsonAST.JArray jArray = (JsonAST.JArray)jValue;
                List<JsonAST.JValue> arr = jArray.arr();
                seq = JsonProtocol$.findTypeHints$1(arr, JsonProtocol$.findTypeHints$default$2$1());
            } else {
                seq = (Seq)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$);
            }
            return seq;
        })).distinct();
    }

    private static final boolean findTypeHints$default$2$1() {
        return false;
    }

    private JsonProtocol$() {
    }
}

