/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.styles.mindmapmode.styleeditorpanel;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.freeplane.api.LengthUnit;
import org.freeplane.api.Quantity;
import org.freeplane.core.resources.components.IPropertyControl;
import org.freeplane.core.resources.components.QuantityProperty;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodelocation.LocationController;
import org.freeplane.features.nodelocation.LocationModel;
import org.freeplane.features.nodelocation.mindmapmode.MLocationController;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.ControlGroup;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.ControlGroupChangeListener;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.RevertingProperty;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.StylePropertyAdjuster;

class ChildHorizontalGapControlGroup
implements ControlGroup {
    private static final String HORIZONTAL_CHILD_GAP = "horizontal_child_gap";
    private RevertingProperty mSetChildDistance;
    private QuantityProperty<LengthUnit> mChildDistance;
    private ChildDistanceChangeListener propertyChangeListener;

    ChildHorizontalGapControlGroup() {
    }

    @Override
    public void addControlGroup(DefaultFormBuilder formBuilder) {
        this.mSetChildDistance = new RevertingProperty();
        this.mChildDistance = new QuantityProperty(HORIZONTAL_CHILD_GAP, -1000.0, 1000.0, 0.1, (Enum)LengthUnit.px);
        this.propertyChangeListener = new ChildDistanceChangeListener(this.mSetChildDistance, new IPropertyControl[]{this.mChildDistance});
        this.mSetChildDistance.addPropertyChangeListener(this.propertyChangeListener);
        this.mChildDistance.addPropertyChangeListener((PropertyChangeListener)this.propertyChangeListener);
        this.mChildDistance.appendToForm(formBuilder);
        this.mSetChildDistance.appendToForm(formBuilder);
    }

    @Override
    public void setStyle(NodeModel node, boolean canEdit) {
        this.propertyChangeListener.setStyle(node);
    }

    private class ChildDistanceChangeListener
    extends ControlGroupChangeListener {
        public ChildDistanceChangeListener(RevertingProperty mSet, IPropertyControl ... mProperty) {
            super(mSet, mProperty);
        }

        @Override
        void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            MLocationController locationController = (MLocationController)Controller.getCurrentModeController().getExtension(LocationController.class);
            locationController.setBaseHGapToChildren(node, (Quantity<LengthUnit>)(enabled ? ChildHorizontalGapControlGroup.this.mChildDistance.getQuantifiedValue() : LocationModel.DEFAULT_HGAP));
        }

        @Override
        void setStyleOnExternalChange(NodeModel node) {
            ModeController modeController = Controller.getCurrentModeController();
            LocationModel locationModel = LocationModel.getModel((NodeModel)node);
            LocationController locationController = (LocationController)modeController.getExtension(LocationController.class);
            Quantity gap = locationModel.getBaseHGap();
            Quantity viewGap = locationController.getBaseHGapToChildren(node);
            ChildHorizontalGapControlGroup.this.mSetChildDistance.setValue(gap != LocationModel.DEFAULT_HGAP);
            ChildHorizontalGapControlGroup.this.mChildDistance.setQuantifiedValue(viewGap);
        }

        @Override
        void adjustForStyle(NodeModel node) {
            StylePropertyAdjuster.adjustPropertyControl(node, ChildHorizontalGapControlGroup.this.mSetChildDistance);
            StylePropertyAdjuster.adjustPropertyControl(node, (IPropertyControl)ChildHorizontalGapControlGroup.this.mChildDistance);
        }
    }
}

