/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.appearance.plugin.palette;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.gephi.appearance.plugin.palette.Palette;
import org.gephi.appearance.plugin.palette.PaletteGenerator;
import org.gephi.appearance.plugin.palette.Preset;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;

public class PaletteManager {
    public static final String COLORS = "PaletteColors";
    private static final int RECENT_PALETTE_SIZE = 5;
    protected static String DEFAULT_NODE_NAME = "prefs";
    private static PaletteManager instance;
    private final List<Preset> presets;
    private final Collection<Palette> defaultPalettes;
    private final LinkedList<Palette> recentPalette;
    private final Color DEFAULT_COLOR = Color.LIGHT_GRAY;
    protected String nodeName = "recentpartitionpalettes";

    private PaletteManager() {
        this.presets = this.loadPresets();
        this.defaultPalettes = PaletteManager.loadDefaultPalettes();
        this.recentPalette = new LinkedList();
        this.retrieve();
    }

    public static synchronized PaletteManager getInstance() {
        if (instance == null) {
            instance = new PaletteManager();
        }
        return instance;
    }

    private static Collection<Palette> loadDefaultPalettes() {
        try {
            return PaletteManager.loadPalettes("palette_default.csv");
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.EMPTY_LIST;
        }
    }

    private static Collection<Palette> loadPalettes(String fileName) throws IOException {
        String line;
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(PaletteManager.class.getResourceAsStream(fileName)));
        ArrayList palettes = new ArrayList();
        while ((line = reader.readLine()) != null) {
            String[] split;
            ArrayList<Color> palette = new ArrayList<Color>();
            for (String colorStr : split = line.split(",")) {
                if (colorStr.isEmpty()) continue;
                palette.add(PaletteManager.parseHexColor(colorStr.trim()));
            }
            if (palette.isEmpty()) continue;
            palettes.add(palette);
        }
        ArrayList<Palette> result = new ArrayList<Palette>();
        for (List list : palettes) {
            Palette plt = new Palette(list.toArray(new Color[0]));
            result.add(plt);
        }
        return result;
    }

    private static Color parseHexColor(String hexColor) {
        int rgb = Integer.parseInt(hexColor.replaceFirst("#", ""), 16);
        return new Color(rgb);
    }

    public Palette randomPalette(int colorCount) {
        ArrayList<Color> colors = new ArrayList<Color>();
        Random random = new Random();
        float B = random.nextFloat() * 2.0f / 5.0f + 0.6f;
        float S = random.nextFloat() * 2.0f / 5.0f + 0.6f;
        for (int i = 1; i <= colorCount; ++i) {
            float H = (float)i / (float)colorCount;
            Color c = Color.getHSBColor(H, S, B);
            colors.add(c);
        }
        Collections.shuffle(colors);
        return new Palette(colors.toArray(new Color[0]));
    }

    public Palette generatePalette(int colorCount) {
        return this.generatePalette(colorCount, null);
    }

    public int getGeneratePaletteQuality(int colorCount) {
        int quality = 50;
        if (colorCount > 300) {
            quality = 2;
        } else if (colorCount > 200) {
            quality = 5;
        } else if (colorCount > 100) {
            quality = 10;
        } else if (colorCount > 50) {
            quality = 25;
        }
        return quality;
    }

    public Palette generatePalette(int colorCount, Preset preset) {
        int quality = this.getGeneratePaletteQuality(colorCount);
        Color[] cls = PaletteGenerator.generatePalette(colorCount, quality, preset != null ? preset.toArray() : null);
        return new Palette(cls);
    }

    public Collection<Preset> getPresets() {
        return this.presets;
    }

    public Preset getPreset(String name) {
        return this.presets.stream().filter(p -> p.getName().equals(name)).findFirst().orElse(null);
    }

    public Collection<Palette> getDefaultPalette(int colorCount) {
        ArrayList<Palette> palettes = new ArrayList<Palette>();
        for (Palette p : this.defaultPalettes) {
            if (p.size() == colorCount) {
                palettes.add(p);
                continue;
            }
            if (p.size() >= colorCount) continue;
            Color[] cols = Arrays.copyOf(p.getColors(), colorCount);
            for (int i = p.size(); i < cols.length; ++i) {
                cols[i] = this.DEFAULT_COLOR;
            }
            palettes.add(new Palette(cols));
        }
        Collections.reverse(palettes);
        return palettes;
    }

    public void addRecentPalette(Palette palette) {
        this.recentPalette.remove(palette);
        if (this.recentPalette.size() == 5) {
            this.recentPalette.removeLast();
        }
        this.recentPalette.addFirst(palette);
        this.store();
    }

    public Collection<Palette> getRecentPalettes() {
        return this.recentPalette;
    }

    private List<Preset> loadPresets() {
        ArrayList<Preset> presetList = new ArrayList<Preset>();
        try {
            String line;
            LineNumberReader reader = new LineNumberReader(new InputStreamReader(PaletteManager.class.getResourceAsStream("palette_presets.csv")));
            reader.readLine();
            while ((line = reader.readLine()) != null) {
                String[] split = line.split(",");
                String name = split[0];
                boolean dark = Boolean.parseBoolean(split[1]);
                int hMin = Integer.parseInt(split[2]);
                int hMax = Integer.parseInt(split[3]);
                float cMin = Float.parseFloat(split[4]);
                float cMax = Float.parseFloat(split[5]);
                float lMin = Float.parseFloat(split[6]);
                float lMax = Float.parseFloat(split[7]);
                presetList.add(new Preset(name, dark, hMin, hMax, cMin, cMax, lMin, lMax));
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return presetList;
    }

    private void retrieve() {
        byte[] cols;
        this.recentPalette.clear();
        Preferences prefs = this.getPreferences();
        for (int i = 0; i < 5 && (cols = prefs.getByteArray(COLORS + i, null)) != null; ++i) {
            try {
                Color[] colors = this.deserializeColors(cols);
                this.recentPalette.addLast(new Palette(colors));
                continue;
            }
            catch (Exception e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
    }

    private void store() {
        Preferences prefs = this.getPreferences();
        try {
            prefs.clear();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        int i = 0;
        for (Palette palette : this.recentPalette) {
            try {
                prefs.putByteArray(COLORS + i, this.serializeColors(palette.getColors()));
            }
            catch (Exception e) {
                Exceptions.printStackTrace((Throwable)e);
            }
            ++i;
        }
    }

    private byte[] serializeColors(Color[] colors) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (ObjectOutputStream out = new ObjectOutputStream(bos);){
            out.writeObject(colors);
        }
        return bos.toByteArray();
    }

    private Color[] deserializeColors(byte[] colors) throws Exception {
        Color[] array;
        ByteArrayInputStream bis = new ByteArrayInputStream(colors);
        try (ObjectInputStream in = new ObjectInputStream(bis);){
            array = (Color[])in.readObject();
        }
        return array;
    }

    protected final Preferences getPreferences() {
        String name = DEFAULT_NODE_NAME;
        if (this.nodeName != null) {
            name = this.nodeName;
        }
        Preferences prefs = NbPreferences.forModule(this.getClass()).node("options").node(name);
        return prefs;
    }
}

