/*
 * Copyright (C) 2005 Intel Corporation
 *
 * This software and the related documents are Intel copyrighted materials, and your use of them
 * is governed by the express license under which they were provided to you ("License"). Unless
 * the License provides otherwise, you may not use, modify, copy, publish, distribute, disclose
 * or transmit this software or the related documents without Intel's prior written permission.
 *
 * This software and the related documents are provided as is, with no express or implied
 * warranties, other than those that are expressly stated in the License.
*/


#ifndef _PMI_H_
#define _PMI_H_

#include <sys/param.h>
#include <sys/proc.h>

#include <machine/frame.h>

#include "lwpmudrv_defines.h"

#if defined(DRV_IA32)
#define REGS_xcs(regs)       regs->cs
#define REGS_eip(regs)       regs->ip
#define REGS_eflags(regs)    regs->flags
#endif

#if defined(DRV_EM64T)
#define REGS_cs(regs)        regs->tf_cs
#define REGS_rip(regs)       regs->tf_rip
#define REGS_eflags(regs)    regs->tf_rflags
#endif

#if defined(DRV_IA32) || defined(DRV_EM64T)
__attribute__((regparm(0)))
void PMI_Interrupt_Handler(struct trapframe *regs);

#if __FreeBSD_version >= 1200067
int _PMI_Interrupt_Handler(struct trapframe *regs);
#else
int _PMI_Interrupt_Handler(int cpu, struct trapframe *regs);
#endif
#endif

int	sep_hook_handler(struct thread *td, int function, void *arg);
int	sep_save_user_callchain(uintptr_t *cc, int nframes, struct trapframe *tf);
int	sep_save_kernel_callchain(uintptr_t *cc, int nframes, struct trapframe *tf);
void    FBSD_PMC_Register_PMI_Handler(void);
void    FBSD_PMC_Unregister_PMI_Handler(void);
#endif
