#
# Copyright (C) 2017 Intel Corporation
#
# This software and the related documents are Intel copyrighted materials, and your use of them
# is governed by the express license under which they were provided to you ("License"). Unless
# the License provides otherwise, you may not use, modify, copy, publish, distribute, disclose
# or transmit this software or the related documents without Intel's prior written permission.
#
# This software and the related documents are provided as is, with no express or implied
# warranties, other than those that are expressly stated in the License.
#


# ------------------------------------------------------------------------------
# This example shows how to obtain a joined version of the data in the bottomup
# table. The join version contains headers and data for each entry.
# ------------------------------------------------------------------------------

import sys

try:

    import advisor

except ImportError:

    print(
        """Import error: Python could not resolve path to Advisor's pythonapi directory.
        To fix, either manually add path to the pythonapi directory into PYTHONPATH environment
        variable, or use advixe-vars.* scripts to set up product environment variables automatically."""
    )
    sys.exit(1)

# Check command-line arguments.
if len(sys.argv) < 2:
    print('Usage: "python {} path_to_project_dir"'.format(__file__))
    sys.exit(2)


def quotes(value):
    value = value.replace("\n", "")
    value = value.replace("\r", "")
    if "," in value:
        return '"{}"'.format(value)
    return str(value)


# Open the Advisor Project and load the data.
project = advisor.open_project(sys.argv[1])
data = project.load(advisor.ALL)

# Iterate over the entries in the bottomup table and print a joined version.
for idx, entry in enumerate(data.bottomup):

    # Process the header.
    if idx == 0:

        print(",".join([quotes(key) for key in entry]))

    # Process the entires.
    print(",".join([quotes(entry[key]) for key in entry]))
