!===============================================================================
! Copyright 2024 Intel Corporation.
!
! This software and the related documents are Intel copyrighted  materials,  and
! your use of  them is  governed by the  express license  under which  they were
! provided to you (License).  Unless the License provides otherwise, you may not
! use, modify, copy, publish, distribute,  disclose or transmit this software or
! the related documents without Intel's prior written permission.
!
! This software and the related documents  are provided as  is,  with no express
! or implied  warranties,  other  than those  that are  expressly stated  in the
! License.
!===============================================================================

#include "mkl_omp_offload.f90"

program dsyevd_example

    use omp_lib
#ifdef MKL_ILP64
    use onemkl_lapack_omp_offload_ilp64
#else
    use onemkl_lapack_omp_offload_lp64
#endif

! dsyevd and workspace query parameters
    character*1 :: jobz, uplo
    integer :: n, lda, lwork, liwork, info
    double precision, allocatable :: a(:,:), w(:)
    type(c_ptr) :: c_work, c_iwork
    double precision, pointer :: work(:)
    integer, pointer :: iwork(:)
    double precision :: work_query(1)
    integer :: iwork_query(1)
    integer(c_size_t), parameter :: fp_size = 8
#ifdef MKL_ILP64
    integer(c_size_t), parameter :: int_size = 8
#else
    integer(c_size_t), parameter :: int_size = 4
#endif

    jobz = 'V'
    uplo = 'L'
    n = 24
    lda = 33
    lwork = -1
    liwork = -1

    print*,'Solving Symmetric Eigenvalue Problem:'
    print*,'==================================================================='
    print*,'  n   = ', n
    print*,'  lda = ', lda
    print*,'==================================================================='

! Allocate host memory for input/output arrays
    allocate(a(lda, n), w(n))

! Initialize data for input arrays
    call random_seed()
    call random_number(a)

! Query workspace on device
!$omp target data map(from:work_query, iwork_query, info)
!$omp dispatch
    call dsyevd(jobz, uplo, n, a, lda, w, work_query, lwork, iwork_query, liwork, info)
!$omp end target data

! Set work array sizes
    lwork = work_query(1)
    liwork = iwork_query(1)

! Allocate device workspace
    c_work = omp_target_alloc(lwork * fp_size, omp_get_default_device())
    c_iwork = omp_target_alloc(liwork * int_size, omp_get_default_device())

! Solve SEP on device
!$omp target data map(tofrom:a) map(from:w,info)
    call c_f_pointer(c_work, work, [lwork])
    call c_f_pointer(c_iwork, iwork, [liwork])
!$omp dispatch
    call dsyevd(jobz, uplo, n, a, lda, w, work, lwork, iwork, liwork, info)
    nullify(work)
    nullify(iwork)
!$omp end target data

! Free device workspace
    call omp_target_free(c_work, omp_get_default_device())
    call omp_target_free(c_iwork, omp_get_default_device())

! Examine output data
    if (info .ne. 0) then
        print*,'Error: info = ', info
    else
        print*,'Example completed successfully'
    end if

! Free host memory
    deallocate(a, w)
end program
