!===============================================================================
! Copyright 2020-2022 Intel Corporation.
!
! This software and the related documents are Intel copyrighted  materials,  and
! your use of  them is  governed by the  express license  under which  they were
! provided to you (License).  Unless the License provides otherwise, you may not
! use, modify, copy, publish, distribute,  disclose or transmit this software or
! the related documents without Intel's prior written permission.
!
! This software and the related documents  are provided as  is,  with no express
! or implied  warranties,  other  than those  that are  expressly stated  in the
! License.
!===============================================================================

!*
!
!*  Content:
!*            Pow example program text (OpenMP offload interface)
!*
!*******************************************************************************/

include "mkl_omp_offload.f90"
include "_vml_common_functions.f90"

! @brief Real single precision function test begin
integer (kind=4) function test_float(funcname)

    use onemkl_vml_omp_offload
    implicit none
    include "_vml_common_data.f90"
    character (len = *) :: funcname
    real      (kind=4)  :: as_float
    integer   (kind=4)  :: check_result_float
    real      (kind=4),allocatable :: varg1(:), varg2(:), vres1(:), vmres1(:), vref1(:)
    real      (kind=4),allocatable :: vresi1(:), vmresi1(:), vrefi1(:)
    integer   (kind=4) i, a, errs
    integer   (kind=4) VLEN, VLEN_2
    parameter (VLEN = 4)
    parameter (VLEN_2 = VLEN / 2)
    integer   (kind=4) test_arg1(VLEN)
    integer   (kind=4) test_arg2(VLEN)
    integer   (kind=4) test_ref1(VLEN)
    integer   (kind=4) nan_value
    integer   (kind=8) vml_accuracy_mode(3)
    data vml_accuracy_mode / VML_HA, VML_LA, VML_EP /
    integer   (kind=4) tmode

    ! NaN value to fill result vector
    data  nan_value /Z'FFFFFFFF'/

    ! Arguments and reference results begin
    data test_arg1 / Z'41093E24', & ! 8.57767105
                     Z'41011D03', & ! 8.06958294
                     Z'41136B29', & ! 9.21366215
                     Z'4082ABE3'  / ! 4.08348227
    data test_arg2 / Z'4093852F', & ! 4.61000776
                     Z'41034C40', & ! 8.20611572
                     Z'4036ECDE', & ! 2.85820723
                     Z'40FDFDE5'  / ! 7.93724298
    data test_ref1 / Z'469CE711', & ! 20083.5332
                     Z'4BD2F79E', & ! 27651900
                     Z'440EB888', & ! 570.883301
                     Z'478A3D0D'  / ! 70778.1016
    ! Arguments and reference results end

    errs = 0

    ! Allocate vectors
    allocate(varg1(VLEN))
    allocate(varg2(VLEN))
    allocate(vres1(VLEN))
    allocate(vmres1(VLEN))
    allocate(vref1(VLEN))
    allocate(vresi1(VLEN))
    allocate(vmresi1(VLEN))
    allocate(vrefi1(VLEN))

    ! Fill vectors
    do i = 1, VLEN
        varg1(i) = as_float(test_arg1(i))
        varg2(i) = as_float(test_arg2(i))
        vref1(i) = as_float(test_ref1(i))
        vres1(i) = as_float(nan_value)
        vmres1(i) = as_float(nan_value)

        ! Fill even result values with 777 pads for strided indexing
        if (and(i,1) .eq. 1) then
            vrefi1(i)  = as_float(test_ref1(i))
            vresi1(i)  = 999
            vmresi1(i) = 999
        else
            vrefi1(i)  = 777
            vresi1(i)  = 777
            vmresi1(i) = 777
        end if
    enddo

    ! Loop by three accuracy flavors
    do a = 1, 3
        ! Call VML function with specific accuracy flavor

        !$omp dispatch 
        tmode = vmlsetmode(vml_accuracy_mode(a))

        !$omp target data map(varg1,varg2,vres1)
        !$omp dispatch 
        call vspow(VLEN, varg1, varg2, vres1)
        !$omp end target data

        !$omp target data map(varg1,varg2,vmres1)
        !$omp dispatch 
        call vmspow(VLEN, varg1, varg2, vmres1, vml_accuracy_mode(a))
        !$omp end target data

        !$omp target data map(varg1,varg2,vresi1)
        !$omp dispatch 
        call vspowi(VLEN_2, varg1, 2, varg2, 2, vresi1, 2)
        !$omp end target data

        !$omp target data map(varg1,varg2,vmresi1)
        !$omp dispatch 
        call vmspowi(VLEN_2, varg1, 2, varg2, 2, vmresi1, 2, vml_accuracy_mode(a))
        !$omp end target data

        ! Check results
        do i = 1, VLEN
          errs = errs + check_result_float(i, VML_ARG2_RES1, varg1(i), varg2(i), &
                           vres1(i), vres1(i), vref1(i), vref1(i), "v"//funcname, a, ",  simple")
          errs = errs + check_result_float(i, VML_ARG2_RES1, varg1(i), varg2(i), &
                           vmres1(i), vmres1(i), vref1(i), vref1(i), "vm"//funcname, a, ",  simple")
          errs = errs + check_result_float(i, VML_ARG2_RES1, varg1(i), varg2(i), &
                           vresi1(i), vresi1(i), vrefi1(i), vrefi1(i), "v"//funcname//"i", a, ", strided")
          errs = errs + check_result_float(i, VML_ARG2_RES1, varg1(i), varg2(i), &
                           vmresi1(i), vmresi1(i), vrefi1(i), vrefi1(i), "vm"//funcname//"i", a, ", strided")
        enddo
    enddo

    test_float = errs

end function
! @brief Real single precision function test end

! @brief Real double precision function test begin
integer (kind=4) function test_double(funcname)

    use onemkl_vml_omp_offload
    implicit none
    include "_vml_common_data.f90"
    character (len = *) :: funcname
    real      (kind=8) :: as_double
    integer   (kind=4) :: check_result_double
    real      (kind=8),allocatable :: varg1(:), varg2(:), vres1(:), vmres1(:), vref1(:)
    real      (kind=8),allocatable :: vresi1(:), vmresi1(:), vrefi1(:)
    integer   (kind=4) i, a, errs
    integer   (kind=4) VLEN, VLEN_2
    parameter (VLEN = 4)
    parameter (VLEN_2 = VLEN / 2)
    integer   (kind=8) test_arg1(VLEN)
    integer   (kind=8) test_arg2(VLEN)
    integer   (kind=8) test_ref1(VLEN)
    integer   (kind=8) nan_value
    integer   (kind=8) vml_accuracy_mode(3)
    data vml_accuracy_mode / VML_HA, VML_LA, VML_EP /
    integer   (kind=4) tmode

    ! NaN value to fill result vector
    data  nan_value /Z'FFFFFFFFFFFFFFFF'/

    ! Arguments and reference results begin
    data test_arg1 / Z'402127C473A3E923', & ! 8.57767068267691535
                     Z'402023A0651C4741', & ! 8.06958309145159269
                     Z'40226D6509CA7464', & ! 9.21366148563738108
                     Z'4010557C717977C6'  / ! 4.0834825258625127
    data test_arg2 / Z'401270A5F32DAE19', & ! 4.6100080486899282
                     Z'40206988134D9FDD', & ! 8.20611629793705255
                     Z'4006DD9BBAC0EE6B', & ! 2.8582071867111174
                     Z'401FBFBCBB737F7A'  / ! 7.93724339382594657
    data test_ref1 / Z'40D39CE2AABD156D', & ! 20083.5416710576283
                     Z'417A5EF61F31C368', & ! 27651937.9496492445
                     Z'4081D7109BAA7980', & ! 570.883109409172903
                     Z'40F147A2E685447B'  / ! 70778.1812794375437
    ! Arguments and reference results end

    errs = 0

    ! Allocate vectors
    allocate(varg1(VLEN))
    allocate(varg2(VLEN))
    allocate(vres1(VLEN))
    allocate(vmres1(VLEN))
    allocate(vref1(VLEN))
    allocate(vresi1(VLEN))
    allocate(vmresi1(VLEN))
    allocate(vrefi1(VLEN))

    ! Fill vectors
    do i = 1, VLEN
        varg1(i) = as_double(test_arg1(i))
        varg2(i) = as_double(test_arg2(i))
        vref1(i) = as_double(test_ref1(i))
        vres1(i) = as_double(nan_value)
        vmres1(i) = as_double(nan_value)

        ! Fill even result values with 777 pads for strided indexing
        if (and(i,1) .eq. 1) then
            vrefi1(i)  = as_double(test_ref1(i))
            vresi1(i)  = 999
            vmresi1(i) = 999
        else
            vrefi1(i)  = 777
            vresi1(i)  = 777
            vmresi1(i) = 777
        end if
    enddo

    ! Loop by three accuracy flavors
    do a = 1, 3
        ! Call VML function with specific accuracy flavor

        !$omp dispatch 
        tmode = vmlsetmode(vml_accuracy_mode(a))

        !$omp target data map(varg1,varg2,vres1)
        !$omp dispatch 
        call vdpow(VLEN, varg1, varg2, vres1)
        !$omp end target data

        !$omp target data map(varg1,varg2,vmres1)
        !$omp dispatch 
        call vmdpow(VLEN, varg1, varg2, vmres1, vml_accuracy_mode(a))
        !$omp end target data

        !$omp target data map(varg1,varg2,vresi1)
        !$omp dispatch 
        call vdpowi(VLEN_2, varg1, 2, varg2, 2, vresi1, 2)
        !$omp end target data

        !$omp target data map(varg1,varg2,vmresi1)
        !$omp dispatch 
        call vmdpowi(VLEN_2, varg1, 2, varg2, 2, vmresi1, 2, vml_accuracy_mode(a))
        !$omp end target data

        ! Check results
        do i = 1, VLEN
          errs = errs + check_result_double(i, VML_ARG2_RES1, varg1(i), varg2(i), &
                            vres1(i), vres1(i), vref1(i), vref1(i), "v"//funcname, a, ",  simple")
          errs = errs + check_result_double(i, VML_ARG2_RES1, varg1(i), varg2(i), &
                            vmres1(i), vmres1(i), vref1(i), vref1(i), "vm"//funcname, a, ",  simple")
          errs = errs + check_result_double(i, VML_ARG2_RES1, varg1(i), varg2(i), &
                            vresi1(i), vresi1(i), vrefi1(i), vrefi1(i), "v"//funcname//"i", a, ", strided")
          errs = errs + check_result_double(i, VML_ARG2_RES1, varg1(i), varg2(i), &
                            vmresi1(i), vmresi1(i), vrefi1(i), vrefi1(i), "vm"//funcname//"i", a, ", strided")
        enddo
    enddo

    test_double = errs

end function
! @brief Real double precision function test end

! @brief Complex single precision function test begin
integer (kind=4) function test_float_complex(funcname)

    use onemkl_vml_omp_offload
    implicit none
    include "_vml_common_data.f90"
    character (len = *) :: funcname
    real      (kind=4)  :: as_float
    integer   (kind=4)  :: check_result_float_complex
    complex      (kind=4),allocatable :: varg1(:), varg2(:), vres1(:), vmres1(:), vref1(:)
    complex      (kind=4),allocatable :: vresi1(:), vmresi1(:), vrefi1(:)
    integer   (kind=4) i, a, errs
    integer   (kind=4) VLEN, VLEN_2
    parameter (VLEN = 4)
    parameter (VLEN_2 = VLEN / 2)
    integer   (kind=4) test_arg1(2*VLEN)
    integer   (kind=4) test_arg2(2*VLEN)
    integer   (kind=4) test_ref1(2*VLEN)
    integer   (kind=4) nan_value
    integer   (kind=8) vml_accuracy_mode(3)
    data vml_accuracy_mode / VML_HA, VML_LA, VML_EP /
    integer   (kind=4) tmode

    ! NaN value to fill result vector
    data  nan_value /Z'FFFFFFFF'/

    ! Arguments and reference results begin
    data test_arg1 / Z'4093852F', Z'41093E24', & ! 4.61000776      + i * 8.57767105
                     Z'4036ECDE', Z'41136B29', & ! 2.85820723      + i * 9.21366215
                     Z'40C0F87C', Z'40649ED8', & ! 6.03033257      + i * 3.57219505
                     Z'40B56AA4', Z'408B1733'  / ! 5.66926765      + i * 4.34658194
    data test_arg2 / Z'41034C40', Z'41011D03', & ! 8.20611572      + i * 8.06958294
                     Z'40FDFDE5', Z'4082ABE3', & ! 7.93724298      + i * 4.08348227
                     Z'40D64D6C', Z'40AB29A5', & ! 6.69695091      + i * 5.34883356
                     Z'411410F1', Z'41193290'  / ! 9.25413609      + i * 9.57484436
    data test_ref1 / Z'C623D50C', Z'4693B11C', & ! -10485.2617     + i * 18904.5547
                     Z'489D1870', Z'482626A1', & ! 321731.5        + i * 170138.516
                     Z'4566C04A', Z'46CBEE93', & ! 3692.01807      + i * 26103.2871
                     Z'480FE542', Z'C714EC50'  / ! 147349.031      + i * -38124.3125
    ! Arguments and reference results end

    errs = 0

    ! Allocate vectors
    allocate(varg1(VLEN))
    allocate(varg2(VLEN))
    allocate(vres1(VLEN))
    allocate(vmres1(VLEN))
    allocate(vref1(VLEN))
    allocate(vresi1(VLEN))
    allocate(vmresi1(VLEN))
    allocate(vrefi1(VLEN))

    ! Fill vectors
    do i = 1, VLEN
        varg1(i) = CMPLX(as_float(test_arg1(2*i-1)), as_float(test_arg1(2*i)), 4)
        varg2(i) = CMPLX(as_float(test_arg2(2*i-1)), as_float(test_arg2(2*i)), 4)
        vref1(i) = CMPLX(as_float(test_ref1(2*i-1)), as_float(test_ref1(2*i)), 4)
        vres1(i) = as_float(nan_value)
        vmres1(i) = as_float(nan_value)

        ! Fill even result values with 777 pads for strided indexing
        if (and(i,1) .eq. 1) then
            vrefi1(i)  = CMPLX(as_float(test_ref1(2*i-1)), as_float(test_ref1(2*i)), 4)
            vresi1(i)  = CMPLX(999,999,4)
            vmresi1(i) = CMPLX(999,999,4)
        else
            vrefi1(i)  = CMPLX(777,777,4)
            vresi1(i)  = CMPLX(777,777,4)
            vmresi1(i) = CMPLX(777,777,4)
        end if
    enddo

    ! Loop by three accuracy flavors
    do a = 1, 3
        ! Call VML function with specific accuracy flavor

        !$omp dispatch 
        tmode = vmlsetmode(vml_accuracy_mode(a))

        !$omp target data map(varg1,varg2,vres1)
        !$omp dispatch 
        call vcpow(VLEN, varg1, varg2, vres1)
        !$omp end target data

        !$omp target data map(varg1,varg2,vmres1)
        !$omp dispatch 
        call vmcpow(VLEN, varg1, varg2, vmres1, vml_accuracy_mode(a))
        !$omp end target data

        !$omp target data map(varg1,varg2,vresi1)
        !$omp dispatch 
        call vcpowi(VLEN_2, varg1, 2, varg2, 2, vresi1, 2)
        !$omp end target data

        !$omp target data map(varg1,varg2,vmresi1)
        !$omp dispatch 
        call vmcpowi(VLEN_2, varg1, 2, varg2, 2, vmresi1, 2, vml_accuracy_mode(a))
        !$omp end target data

        ! Check results
        do i = 1, VLEN
          errs = errs + check_result_float_complex(i, VML_ARG2_RES1, varg1(i), varg2(i), &
                           vres1(i), vres1(i), vref1(i), vref1(i), "v"//funcname, a, ",  simple")
          errs = errs + check_result_float_complex(i, VML_ARG2_RES1, varg1(i), varg2(i), &
                           vmres1(i), vmres1(i), vref1(i), vref1(i), "vm"//funcname, a, ",  simple")
          errs = errs + check_result_float_complex(i, VML_ARG2_RES1, varg1(i), varg2(i), &
                           vresi1(i), vresi1(i), vrefi1(i), vrefi1(i), "v"//funcname//"i", a, ", strided")
          errs = errs + check_result_float_complex(i, VML_ARG2_RES1, varg1(i), varg2(i), &
                           vmresi1(i), vmresi1(i), vrefi1(i), vrefi1(i), "vm"//funcname//"i", a, ", strided")
        enddo
    enddo

    test_float_complex = errs

end function
! @brief Complex single precision function test end

! @brief Complex double precision function test begin
integer (kind=4) function test_double_complex(funcname)

    use onemkl_vml_omp_offload
    implicit none
    include "_vml_common_data.f90"
    character (len = *) :: funcname
    real      (kind=8) :: as_double
    integer   (kind=4) :: check_result_double_complex
    complex   (kind=8),allocatable :: varg1(:), varg2(:), vres1(:), vmres1(:), vref1(:)
    complex   (kind=8),allocatable :: vresi1(:), vmresi1(:), vrefi1(:)
    integer   (kind=4) i, a, errs
    integer   (kind=4) VLEN, VLEN_2
    parameter (VLEN = 4)
    parameter (VLEN_2 = VLEN / 2)
    integer   (kind=8) test_arg1(2*VLEN)
    integer   (kind=8) test_arg2(2*VLEN)
    integer   (kind=8) test_ref1(2*VLEN)
    integer   (kind=8) nan_value
    integer   (kind=8) vml_accuracy_mode(3)
    data vml_accuracy_mode / VML_HA, VML_LA, VML_EP /
    integer   (kind=4) tmode

    ! NaN value to fill result vector
    data  nan_value /Z'FFFFFFFFFFFFFFFF'/

    ! Arguments and reference results begin
    data test_arg1 / Z'401270A5F32DAE19', Z'402127C473A3E923', & ! 4.6100080486899282        + i * 8.57767068267691535
                     Z'4006DD9BBAC0EE6B', Z'40226D6509CA7464', & ! 2.8582071867111174        + i * 9.21366148563738108
                     Z'40181F0F82C50AEC', Z'400C93DAEEF5F483', & ! 6.03033260657933212       + i * 3.57219492614837142
                     Z'4016AD549DF3C110', Z'401162E657685F66'  / ! 5.66926810074097887       + i * 4.34658180784740544
    data test_arg2 / Z'40206988134D9FDD', Z'402023A0651C4741', & ! 8.20611629793705255       + i * 8.06958309145159269
                     Z'401FBFBCBB737F7A', Z'4010557C717977C6', & ! 7.93724339382594657       + i * 4.0834825258625127
                     Z'401AC9AD9555935C', Z'40156534AD76CA6A', & ! 6.69695123038112783       + i * 5.34883376157322665
                     Z'4022821E20A96AA3', Z'40232652067FE63E'  / ! 9.25413610523293606       + i * 9.57484455405494472
    data test_ref1 / Z'C0C47AA470F16D42', Z'40D27624C7C04344', & ! -10485.2846967490659      + i * 18904.5746918351069
                     Z'4113A30DBF54F1C6', Z'4104C4D62BEAA20C', & ! 321731.436847474775       + i * 170138.771443620673
                     Z'40ACD804D2E3A03F', Z'40D97DD363DA339D', & ! 3692.00942145663385       + i * 26103.3029695037876
                     Z'4101FCA94042F62A', Z'C0E29D899EA112CB'  / ! 147349.156377719075       + i * -38124.3006139151621
    ! Arguments and reference results end

    errs = 0

    ! Allocate vectors
    allocate(varg1(VLEN))
    allocate(varg2(VLEN))
    allocate(vres1(VLEN))
    allocate(vmres1(VLEN))
    allocate(vref1(VLEN))
    allocate(vresi1(VLEN))
    allocate(vmresi1(VLEN))
    allocate(vrefi1(VLEN))

    ! Fill vectors
    do i = 1, VLEN
        varg1(i) = CMPLX(as_double(test_arg1(2*i-1)), as_double(test_arg1(2*i)), 8)
        varg2(i) = CMPLX(as_double(test_arg2(2*i-1)), as_double(test_arg2(2*i)), 8)
        vref1(i) = CMPLX(as_double(test_ref1(2*i-1)), as_double(test_ref1(2*i)), 8)
        vres1(i) = as_double(nan_value)
        vmres1(i) = as_double(nan_value)

        ! Fill even result values with 777 pads for strided indexing
        if (and(i,1) .eq. 1) then
            vrefi1(i)  = CMPLX(as_double(test_ref1(2*i-1)), as_double(test_ref1(2*i)), 8)
            vresi1(i)  = CMPLX(999,999,8)
            vmresi1(i) = CMPLX(999,999,8)
        else
            vrefi1(i)  = CMPLX(777,777,8)
            vresi1(i)  = CMPLX(777,777,8)
            vmresi1(i) = CMPLX(777,777,8)
        end if
    enddo

    ! Loop by three accuracy flavors
    do a = 1, 3
        ! Call VML function with specific accuracy flavor

        !$omp dispatch 
        tmode = vmlsetmode(vml_accuracy_mode(a))

        !$omp target data map(varg1,varg2,vres1)
        !$omp dispatch 
        call vzpow(VLEN, varg1, varg2, vres1)
        !$omp end target data

        !$omp target data map(varg1,varg2,vmres1)
        !$omp dispatch 
        call vmzpow(VLEN, varg1, varg2, vmres1, vml_accuracy_mode(a))
        !$omp end target data

        !$omp target data map(varg1,varg2,vresi1)
        !$omp dispatch 
        call vzpowi(VLEN_2, varg1, 2, varg2, 2, vresi1, 2)
        !$omp end target data

        !$omp target data map(varg1,varg2,vmresi1)
        !$omp dispatch 
        call vmzpowi(VLEN_2, varg1, 2, varg2, 2, vmresi1, 2, vml_accuracy_mode(a))
        !$omp end target data

        ! Check results
        do i = 1, VLEN
          errs = errs + check_result_double_complex(i, VML_ARG2_RES1, varg1(i), varg2(i), &
                            vres1(i), vres1(i), vref1(i), vref1(i), "v"//funcname, a, ",  simple")
          errs = errs + check_result_double_complex(i, VML_ARG2_RES1, varg1(i), varg2(i), &
                            vmres1(i), vmres1(i), vref1(i), vref1(i), "vm"//funcname, a, ",  simple")
          errs = errs + check_result_double_complex(i, VML_ARG2_RES1, varg1(i), varg2(i), &
                            vresi1(i), vresi1(i), vrefi1(i), vrefi1(i), "v"//funcname//"i", a, ", strided")
          errs = errs + check_result_double_complex(i, VML_ARG2_RES1, varg1(i), varg2(i), &
                            vmresi1(i), vmresi1(i), vrefi1(i), vrefi1(i), "vm"//funcname//"i", a, ", strided")
        enddo
    enddo

    test_double_complex = errs

end function
! @brief Complex double precision function test end

! @brief Main test program begin
program pow_example

    use onemkl_vml_omp_offload
    implicit none
    include "_vml_common_data.f90"
    integer   (kind=4) :: blend_int32
    integer   (kind=4) :: test_float
    integer   (kind=4) :: test_float_complex
    integer   (kind=4) :: test_double
    integer   (kind=4) :: test_double_complex
    integer   (kind=4) errs, total_errs, exit_status
    character (len = *), parameter :: funcname = "pow"

    total_errs = 0

    data FLOAT_MAXULP /FLOAT_MAXULP_HA,FLOAT_MAXULP_LA,FLOAT_MAXULP_EP/
    data COMPLEX_FLOAT_MAXULP /5000.0,5000.0,5000.0/
    data DOUBLE_MAXULP /DOUBLE_MAXULP_HA,DOUBLE_MAXULP_LA,DOUBLE_MAXULP_EP/
    data COMPLEX_DOUBLE_MAXULP /7D7,7D7,7D7/

    write (*, 111) funcname
    111 format ('Running ', A, ' functions:')

    ! Single precision test run begin
    write (*, 112) TAB, funcname
    112 format(A, 'Running ',  A, ' with single precision real data type:')
    errs = test_float(funcname)
    total_errs = total_errs + errs
    write (*, 113) TAB, funcname, TEST_RESULT(blend_int32((errs>0),2,1))
    113 format(A, A, ' single precision real result: ', A)
    ! Single precision test run end

    ! Real double precision test run begin
    write (*, 117) TAB, funcname
    117 format(A, 'Running ',  A, ' with double precision real data type:')
    errs = test_double(funcname)
    total_errs = total_errs + errs
    write (*, 118) TAB, funcname, TEST_RESULT(blend_int32((errs>0),2,1))
    118 format(A, A, ' double precision real result: ', A)
    ! Real double precision test run end

    ! Single precision complex test run begin
    write (*, 115) TAB, funcname
    115 format(A, 'Running ',  A, ' with single precision complex data type:')
    errs = test_float_complex(funcname)
    total_errs = total_errs + errs
    write (*, 116) TAB, funcname, TEST_RESULT(blend_int32((errs>0),2,1))
    116 format(A, A, ' single precision complex result: ', A)
    ! Single precision complex test run end

    ! Complex double precision test run begin
    write (*, 119) TAB, funcname
    119 format(A, 'Running ',  A, ' with double precision complex data type:')
    errs = test_double_complex(funcname)
    total_errs = total_errs + errs
    write (*, 120) TAB, funcname, TEST_RESULT(blend_int32((errs>0),2,1))
    120 format(A, A, ' double precision complex result: ', A)
    ! Complex double precision  test run end

    write (*, 121) funcname, TEST_RESULT(blend_int32((total_errs>0),2,1))
    121 format(A, ' function result: ', A)

    exit_status = 0
    if (total_errs .ne. 0) then
         exit_status = 1
    endif
    stop exit_status
end program
! @brief Main test program end
