/*******************************************************************************
* Copyright 2016 Intel Corporation.
*
*
* This software and the related documents are Intel copyrighted materials, and your use of them is governed by
* the express license under which they were provided to you ('License'). Unless the License provides otherwise,
* you may not use, modify, copy, publish, distribute, disclose or transmit this software or the related
* documents without Intel's prior written permission.
* This software and the related documents are provided as is, with no express or implied warranties, other than
* those that are expressly stated in the License.
*******************************************************************************/

#if !defined( __IPP_IW_OWNS__ )
#define __IPP_IW_OWNS__

#include "iw_own.h"

#ifndef IW_BUILD
#error this is a private header
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* /////////////////////////////////////////////////////////////////////////////
//                   Base IW Signal internal definitions
///////////////////////////////////////////////////////////////////////////// */


/* /////////////////////////////////////////////////////////////////////////////
//                   Utility functions
///////////////////////////////////////////////////////////////////////////// */
static IW_INLINE IppStatus ownsCheckVectorRead(const IwsVector *pVector)
{
    if(!pVector)
        return ippStsNullPtrErr;
    if(!pVector->m_size)
        return ippStsNoOperation;
    if(!pVector->m_ptrConst)
        return ippStsNullPtrErr;
    return ippStsNoErr;
}

static IW_INLINE IppStatus ownsCheckVectorWrite(const IwsVector *pVector)
{
    if(!pVector)
        return ippStsNullPtrErr;
    if(!pVector->m_size)
        return ippStsNoOperation;
    if(!pVector->m_ptr)
        return ippStsNullPtrErr;
    return ippStsNoErr;
}

static IW_INLINE int ownsBorderSizeIsNegative(const IwsBorderSize *pBorderSize)
{
    if(pBorderSize->left < 0 || pBorderSize->right < 0)
        return 1;
    return 0;
}

static IW_INLINE void ownsBorderSizeSaturate(IwsBorderSize *pBorderSize)
{
    if(pBorderSize->left < 0)
        pBorderSize->left = 0;
    if(pBorderSize->right < 0)
        pBorderSize->right = 0;
}

/* /////////////////////////////////////////////////////////////////////////////
//                   OWN ROI manipulation
///////////////////////////////////////////////////////////////////////////// */
IW_DECL(int) ownsTile_BoundToSize(IwsRoi *pRoi, IwSize *pMinSize);

#ifdef __cplusplus
}
#endif

#endif
