/*******************************************************************************
* Copyright 2020 Intel Corporation.
*
*
* This software and the related documents are Intel copyrighted materials, and your use of them is governed by
* the express license under which they were provided to you ('License'). Unless the License provides otherwise,
* you may not use, modify, copy, publish, distribute, disclose or transmit this software or the related
* documents without Intel's prior written permission.
* This software and the related documents are provided as is, with no express or implied warranties, other than
* those that are expressly stated in the License.
*******************************************************************************/

#include "ippcv.h"
#include "ippcore_tl.h"
#include "ippcv_tl.h"
#include "owndefs_tl.h"
#include "owncv_tl.h"
#include "ownisplit_tl.h"

typedef struct
{
    IppiSize kernelSize;
} SeparableInfo;

#define TILE_S (maskSize.height)

typedef union {
    Ipp8u* borderValue_8u;
    Ipp16s* borderValue_16s;
    Ipp16u* borderValue_16u;
    Ipp32f* borderValue_32f;
} bValue;

typedef struct _ippiFilterSeparable_LT_Str
{
    Ipp8u * pSrc; //const
    IppSizeL srcStep;
    Ipp8u * pDst;
    IppSizeL dstStep;
    IppiBorderType borderType;
    bValue borderValue;
    IppiFilterSeparableSpec_LT * pSpec; //const
    Ipp8u * pBuffer;
    IppSizeL bufSize;
    int numChannels;
    IppiPointL splitImage;
    IppiSizeL pTileSize;
    IppiSizeL pLastSize;
} ippiFilterSeparable_LT_Str;

static void fSeparableThreadingStructureEncode(
    Ipp8u * pSrc,
    IppSizeL srcStep,
    Ipp8u * pDst,
    IppSizeL dstStep,
    IppiBorderType borderType,
    bValue borderValue,
    IppiFilterSeparableSpec_LT * pSpec,
    Ipp8u * pBuffer,
    IppSizeL bufSize,
    int numChannels,
    IppiPointL splitImage,
    IppiSizeL pTileSize,
    IppiSizeL pLastSize,
    ippiFilterSeparable_LT_Str * ts
)
{
    ts->pSrc = pSrc;
    ts->srcStep = srcStep;
    ts->pDst = pDst;
    ts->dstStep = dstStep;
    ts->borderType = borderType;
    ts->borderValue = borderValue;
    ts->pSpec = pSpec;
    ts->pBuffer = pBuffer;
    ts->bufSize = bufSize;
    ts->numChannels = numChannels;
    ts->splitImage = splitImage;
    ts->pTileSize = pTileSize;
    ts->pLastSize = pLastSize;
}
