/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Labels the pixels on the border of the objects in a binary image.


BinaryContourImageFilter takes a binary image as input, where the pixels in the objects are
the pixels with a value equal to ForegroundValue. Only the pixels on
the contours of the objects are kept. The pixels not on the border are
changed to BackgroundValue.

The connectivity can be changed to minimum or maximum connectivity
with SetFullyConnected() . Full connectivity produces thicker contours.

https://doi.org/10.54294/c7d3gv


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.

See:
 LabelContourImageFilter BinaryErodeImageFilter SimpleContourExtractorImageFilter

 itk::simple::BinaryContour for the procedural interface

 itk::BinaryContourImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkBinaryContourImageFilter.h
*/
public class BinaryContourImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected BinaryContourImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.BinaryContourImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(BinaryContourImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(BinaryContourImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::BinaryContourImageFilter::~BinaryContourImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_BinaryContourImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::BinaryContourImageFilter::BinaryContourImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  BinaryContourImageFilter() {
    this(SimpleITKJNI.new_BinaryContourImageFilter(), true);
  }

  /**
Self&amp; itk::simple::BinaryContourImageFilter::SetFullyConnected(bool FullyConnected)

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public  void setFullyConnected(boolean FullyConnected) {
    SimpleITKJNI.BinaryContourImageFilter_setFullyConnected(swigCPtr, this, FullyConnected);
  }

  /**
Self&amp; itk::simple::BinaryContourImageFilter::FullyConnectedOn()

Set the value of FullyConnected to true or false respectfully.

*/
public  void fullyConnectedOn() {
    SimpleITKJNI.BinaryContourImageFilter_fullyConnectedOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::BinaryContourImageFilter::FullyConnectedOff()
*/
public  void fullyConnectedOff() {
    SimpleITKJNI.BinaryContourImageFilter_fullyConnectedOff(swigCPtr, this);
  }

  /**
bool itk::simple::BinaryContourImageFilter::GetFullyConnected() const

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public  boolean getFullyConnected() {
    return SimpleITKJNI.BinaryContourImageFilter_getFullyConnected(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::BinaryContourImageFilter::SetBackgroundValue(double BackgroundValue)

Set/Get the background value used to mark the pixels not on the border
of the objects.

*/
public  void setBackgroundValue(double BackgroundValue) {
    SimpleITKJNI.BinaryContourImageFilter_setBackgroundValue(swigCPtr, this, BackgroundValue);
  }

  /**
double itk::simple::BinaryContourImageFilter::GetBackgroundValue() const

Set/Get the background value used to mark the pixels not on the border
of the objects.

*/
public  double getBackgroundValue() {
    return SimpleITKJNI.BinaryContourImageFilter_getBackgroundValue(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::BinaryContourImageFilter::SetForegroundValue(double ForegroundValue)

Set/Get the foreground value used to identify the objects in the input
and output images.

*/
public  void setForegroundValue(double ForegroundValue) {
    SimpleITKJNI.BinaryContourImageFilter_setForegroundValue(swigCPtr, this, ForegroundValue);
  }

  /**
double itk::simple::BinaryContourImageFilter::GetForegroundValue() const

Set/Get the foreground value used to identify the objects in the input
and output images.

*/
public  double getForegroundValue() {
    return SimpleITKJNI.BinaryContourImageFilter_getForegroundValue(swigCPtr, this);
  }

  /**
std::string itk::simple::BinaryContourImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.BinaryContourImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::BinaryContourImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.BinaryContourImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::BinaryContourImageFilter::Execute(Image &amp;&amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.BinaryContourImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
