/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rule.storage;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.rule.RuleQueryMapper;
import org.opensearch.rule.action.GetRuleRequest;

@ExperimentalApi
public class IndexBasedRuleQueryMapper
implements RuleQueryMapper<QueryBuilder> {
    @Override
    public QueryBuilder from(GetRuleRequest request) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        Map<String, Set<String>> attributeFilters = request.getAttributeFilters();
        String id = request.getId();
        boolQuery.filter((QueryBuilder)QueryBuilders.existsQuery((String)request.getFeatureType().getName()));
        if (id != null) {
            return boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"_id", (String)id));
        }
        HashMap<String, BoolQueryBuilder> groupedQueries = new HashMap<String, BoolQueryBuilder>();
        for (Map.Entry<String, Set<String>> entry : attributeFilters.entrySet()) {
            String attribute = entry.getKey();
            Set<String> values = entry.getValue();
            if (values == null || values.isEmpty()) continue;
            String topLevelAttribute = attribute.contains(".") ? attribute.substring(0, attribute.indexOf(46)) : attribute;
            BoolQueryBuilder groupQuery = groupedQueries.computeIfAbsent(topLevelAttribute, k -> QueryBuilders.boolQuery());
            for (String value : values) {
                groupQuery.should((QueryBuilder)QueryBuilders.termQuery((String)(attribute + ".keyword"), (String)value));
            }
        }
        for (BoolQueryBuilder groupQuery : groupedQueries.values()) {
            boolQuery.must((QueryBuilder)groupQuery);
        }
        return boolQuery;
    }

    @Override
    public QueryBuilder getCardinalityQuery() {
        return QueryBuilders.matchAllQuery();
    }
}

