/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.AcknowledgedResponseBase;
import org.opensearch.client.opensearch.indices.add_block.IndicesBlockStatus;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class AddBlockResponse
extends AcknowledgedResponseBase
implements ToCopyableBuilder<Builder, AddBlockResponse> {
    @Nonnull
    private final List<IndicesBlockStatus> indices;
    private final boolean shardsAcknowledged;
    public static final JsonpDeserializer<AddBlockResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AddBlockResponse::setupAddBlockResponseDeserializer);

    private AddBlockResponse(Builder builder) {
        super(builder);
        this.indices = ApiTypeHelper.unmodifiableRequired(builder.indices, (Object)this, "indices");
        this.shardsAcknowledged = ApiTypeHelper.requireNonNull(builder.shardsAcknowledged, this, "shardsAcknowledged");
    }

    public static AddBlockResponse of(Function<Builder, ObjectBuilder<AddBlockResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<IndicesBlockStatus> indices() {
        return this.indices;
    }

    public final boolean shardsAcknowledged() {
        return this.shardsAcknowledged;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("indices");
        generator.writeStartArray();
        for (IndicesBlockStatus item0 : this.indices) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("shards_acknowledged");
        generator.write(this.shardsAcknowledged);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupAddBlockResponseDeserializer(ObjectDeserializer<Builder> op) {
        AddBlockResponse.setupAcknowledgedResponseBaseDeserializer(op);
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(IndicesBlockStatus._DESERIALIZER), "indices");
        op.add(Builder::shardsAcknowledged, JsonpDeserializer.booleanDeserializer(), "shards_acknowledged");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.indices.hashCode();
        result = 31 * result + Boolean.hashCode(this.shardsAcknowledged);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddBlockResponse other = (AddBlockResponse)o;
        return this.indices.equals(other.indices) && this.shardsAcknowledged == other.shardsAcknowledged;
    }

    public static class Builder
    extends AcknowledgedResponseBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, AddBlockResponse> {
        private List<IndicesBlockStatus> indices;
        private Boolean shardsAcknowledged;

        public Builder() {
        }

        private Builder(AddBlockResponse o) {
            super(o);
            this.indices = Builder._listCopy(o.indices);
            this.shardsAcknowledged = o.shardsAcknowledged;
        }

        private Builder(Builder o) {
            super(o);
            this.indices = Builder._listCopy(o.indices);
            this.shardsAcknowledged = o.shardsAcknowledged;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder indices(List<IndicesBlockStatus> list) {
            this.indices = Builder._listAddAll(this.indices, list);
            return this;
        }

        @Nonnull
        public final Builder indices(IndicesBlockStatus value, IndicesBlockStatus ... values) {
            this.indices = Builder._listAdd(this.indices, value, values);
            return this;
        }

        @Nonnull
        public final Builder indices(Function<IndicesBlockStatus.Builder, ObjectBuilder<IndicesBlockStatus>> fn) {
            return this.indices(fn.apply(new IndicesBlockStatus.Builder()).build(), new IndicesBlockStatus[0]);
        }

        @Nonnull
        public final Builder shardsAcknowledged(boolean value) {
            this.shardsAcknowledged = value;
            return this;
        }

        @Override
        @Nonnull
        public AddBlockResponse build() {
            this._checkSingleUse();
            return new AddBlockResponse(this);
        }
    }
}

