/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.tagger;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.xml.stream.XMLStreamException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenFilterFactory;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.core.StopFilterFactory;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.Terms;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.IntsRef;
import org.apache.solr.analysis.TokenizerChain;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.CollectionUtil;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.tagger.OffsetCorrector;
import org.apache.solr.handler.tagger.TagClusterReducer;
import org.apache.solr.handler.tagger.Tagger;
import org.apache.solr.handler.tagger.XmlOffsetCorrector;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocList;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.DocSlice;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SolrReturnFields;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaggerRequestHandler
extends RequestHandlerBase {
    public static final String OVERLAPS = "overlaps";
    public static final String TAGS_LIMIT = "tagsLimit";
    public static final String MATCH_TEXT = "matchText";
    public static final String SKIP_ALT_TOKENS = "skipAltTokens";
    public static final String IGNORE_STOPWORDS = "ignoreStopwords";
    public static final String XML_OFFSET_ADJUST = "xmlOffsetAdjust";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    public String getDescription() {
        return "Processes input text to find matching tokens stored in the index.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        String inputString;
        String indexedField = req.getParams().get("field");
        if (indexedField == null) {
            throw new RuntimeException("required param 'field'");
        }
        TagClusterReducer tagClusterReducer = this.chooseTagClusterReducer(req.getParams().get(OVERLAPS));
        int rows = req.getParams().getInt("rows", 10000);
        final int tagsLimit = req.getParams().getInt(TAGS_LIMIT, 1000);
        final boolean addMatchText = req.getParams().getBool(MATCH_TEXT, false);
        final SchemaField idSchemaField = req.getSchema().getUniqueKeyField();
        if (idSchemaField == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "The tagger requires auniqueKey in the schema.");
        }
        boolean skipAltTokens = req.getParams().getBool(SKIP_ALT_TOKENS, false);
        boolean ignoreStopWords = req.getParams().getBool(IGNORE_STOPWORDS, this.fieldHasIndexedStopFilter(indexedField, req));
        Reader inputReader = null;
        Iterable<ContentStream> streams = req.getContentStreams();
        if (streams != null) {
            Iterator<ContentStream> iter = streams.iterator();
            if (iter.hasNext()) {
                inputReader = iter.next().getReader();
            }
            if (iter.hasNext()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, this.getClass().getSimpleName() + " does not support multiple ContentStreams");
            }
        }
        if (inputReader == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, this.getClass().getSimpleName() + " requires text to be POSTed to it");
        }
        InputStringLazy inputStringFuture = new InputStringLazy(inputReader);
        final OffsetCorrector offsetCorrector = this.getOffsetCorrector(req.getParams(), inputStringFuture);
        if (addMatchText || inputStringFuture.inputString != null) {
            inputString = inputStringFuture.call();
            inputReader.close();
            inputReader = new StringReader(inputString);
        } else {
            inputString = null;
        }
        final SolrIndexSearcher searcher = req.getSearcher();
        final FixedBitSet matchDocIdsBS = new FixedBitSet(searcher.maxDoc());
        final ArrayList tags = new ArrayList(2000);
        try {
            Analyzer analyzer = req.getSchema().getField(indexedField).getType().getQueryAnalyzer();
            try (TokenStream tokenStream = analyzer.tokenStream("", inputReader);){
                Terms terms = searcher.getSlowAtomicReader().terms(indexedField);
                if (terms != null) {
                    Tagger tagger = new Tagger(terms, this.computeDocCorpus(req), tokenStream, tagClusterReducer, skipAltTokens, ignoreStopWords){
                        Map<Object, List<Object>> docIdsListCache;
                        ValueSourceAccessor uniqueKeyCache;
                        {
                            super(terms, liveDocs, tokenStream, tagClusterReducer, skipAltTokens, ignoreStopWords);
                            this.docIdsListCache = CollectionUtil.newHashMap((int)2000);
                            this.uniqueKeyCache = new ValueSourceAccessor(searcher, idSchemaField.getType().getValueSource(idSchemaField, null));
                        }

                        @Override
                        protected void tagCallback(int startOffset, int endOffset, Object docIdsKey) {
                            if (tags.size() >= tagsLimit) {
                                return;
                            }
                            if (offsetCorrector != null) {
                                int[] offsetPair = offsetCorrector.correctPair(startOffset, endOffset);
                                if (offsetPair == null) {
                                    log.debug("Discarded offsets [{}, {}] because couldn't balance XML.", (Object)startOffset, (Object)endOffset);
                                    return;
                                }
                                startOffset = offsetPair[0];
                                endOffset = offsetPair[1];
                            }
                            SimpleOrderedMap tag = new SimpleOrderedMap();
                            tag.add("startOffset", (Object)startOffset);
                            tag.add("endOffset", (Object)endOffset);
                            if (addMatchText) {
                                tag.add(TaggerRequestHandler.MATCH_TEXT, (Object)inputString.substring(startOffset, endOffset));
                            }
                            tag.add("ids", this.lookupSchemaDocIds(docIdsKey));
                            tags.add(tag);
                        }

                        private List<Object> lookupSchemaDocIds(Object docIdsKey) {
                            List<Object> schemaDocIds = this.docIdsListCache.get(docIdsKey);
                            if (schemaDocIds != null) {
                                return schemaDocIds;
                            }
                            IntsRef docIds = this.lookupDocIds(docIdsKey);
                            schemaDocIds = new ArrayList<Object>(docIds.length);
                            for (int i = docIds.offset; i < docIds.offset + docIds.length; ++i) {
                                int docId = docIds.ints[i];
                                assert (i == docIds.offset || docIds.ints[i - 1] < docId) : "not sorted?";
                                matchDocIdsBS.set(docId);
                                try {
                                    schemaDocIds.add(this.uniqueKeyCache.objectVal(docId));
                                    continue;
                                }
                                catch (IOException e) {
                                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
                                }
                            }
                            assert (!schemaDocIds.isEmpty());
                            this.docIdsListCache.put(docIds, schemaDocIds);
                            return schemaDocIds;
                        }
                    };
                    tagger.enableDocIdsCache(2000);
                    tagger.process();
                }
            }
        }
        finally {
            inputReader.close();
        }
        rsp.add("tagsCount", tags.size());
        rsp.add("tags", tags);
        rsp.setReturnFields(new SolrReturnFields(req));
        rsp.add("response", this.getDocList(rows, matchDocIdsBS));
    }

    @Override
    public PermissionNameProvider.Name getPermissionName(AuthorizationContext request) {
        return PermissionNameProvider.Name.READ_PERM;
    }

    protected OffsetCorrector getOffsetCorrector(SolrParams params, Callable<String> inputStringProvider) throws Exception {
        boolean xmlOffsetAdjust = params.getBool(XML_OFFSET_ADJUST, false);
        if (!xmlOffsetAdjust) {
            return null;
        }
        try {
            return new XmlOffsetCorrector(inputStringProvider.call());
        }
        catch (XMLStreamException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Expecting XML but wasn't: " + String.valueOf(e), (Throwable)e);
        }
    }

    private DocList getDocList(int rows, FixedBitSet matchDocIdsBS) throws IOException {
        int matchDocs = matchDocIdsBS.cardinality();
        int[] docIds = new int[Math.min(rows, matchDocs)];
        BitSetIterator docIdIter = new BitSetIterator((BitSet)matchDocIdsBS, 1L);
        for (int i = 0; i < docIds.length; ++i) {
            docIds[i] = docIdIter.nextDoc();
        }
        return new DocSlice(0, docIds.length, docIds, null, matchDocs, 1.0f, TotalHits.Relation.EQUAL_TO);
    }

    private TagClusterReducer chooseTagClusterReducer(String overlaps) {
        TagClusterReducer tagClusterReducer;
        if (overlaps == null || overlaps.equals("NO_SUB")) {
            tagClusterReducer = TagClusterReducer.NO_SUB;
        } else if (overlaps.equals("ALL")) {
            tagClusterReducer = TagClusterReducer.ALL;
        } else if (overlaps.equals("LONGEST_DOMINANT_RIGHT")) {
            tagClusterReducer = TagClusterReducer.LONGEST_DOMINANT_RIGHT;
        } else {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "unknown tag overlap mode: " + overlaps);
        }
        return tagClusterReducer;
    }

    private Bits computeDocCorpus(SolrQueryRequest req) throws SyntaxError, IOException {
        Bits docBits;
        String[] corpusFilterQueries = req.getParams().getParams("fq");
        SolrIndexSearcher searcher = req.getSearcher();
        if (corpusFilterQueries != null && corpusFilterQueries.length > 0) {
            ArrayList<Query> filterQueries = new ArrayList<Query>(corpusFilterQueries.length);
            for (String corpusFilterQuery : corpusFilterQueries) {
                QParser qParser = QParser.getParser(corpusFilterQuery, null, req);
                try {
                    filterQueries.add(qParser.parse());
                }
                catch (SyntaxError e) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
                }
            }
            DocSet docSet = searcher.getDocSet(filterQueries);
            docBits = docSet.getBits();
        } else {
            docBits = searcher.getSlowAtomicReader().getLiveDocs();
        }
        return docBits;
    }

    private boolean fieldHasIndexedStopFilter(String field, SolrQueryRequest req) {
        FieldType fieldType = req.getSchema().getFieldType(field);
        Analyzer analyzer = fieldType.getIndexAnalyzer();
        if (analyzer instanceof TokenizerChain) {
            TokenFilterFactory[] tokenFilterFactories;
            TokenizerChain tokenizerChain = (TokenizerChain)analyzer;
            for (TokenFilterFactory tokenFilterFactory : tokenFilterFactories = tokenizerChain.getTokenFilterFactories()) {
                if (!(tokenFilterFactory instanceof StopFilterFactory)) continue;
                return true;
            }
        }
        return false;
    }

    static class ValueSourceAccessor {
        private final List<LeafReaderContext> readerContexts;
        private final ValueSource valueSource;
        private final Map<Object, Object> fContext;
        private final FunctionValues[] functionValuesPerSeg;
        private final int[] functionValuesDocIdPerSeg;

        ValueSourceAccessor(IndexSearcher searcher, ValueSource valueSource) {
            this.readerContexts = searcher.getIndexReader().leaves();
            this.valueSource = valueSource;
            this.fContext = ValueSource.newContext((IndexSearcher)searcher);
            this.functionValuesPerSeg = new FunctionValues[this.readerContexts.size()];
            this.functionValuesDocIdPerSeg = new int[this.readerContexts.size()];
        }

        Object objectVal(int topDocId) throws IOException {
            int segIdx = ReaderUtil.subIndex((int)topDocId, this.readerContexts);
            LeafReaderContext rcontext = this.readerContexts.get(segIdx);
            int segDocId = topDocId - rcontext.docBase;
            FunctionValues functionValues = this.functionValuesPerSeg[segIdx];
            if (functionValues == null || segDocId < this.functionValuesDocIdPerSeg[segIdx]) {
                functionValues = this.functionValuesPerSeg[segIdx] = this.valueSource.getValues(this.fContext, rcontext);
            }
            this.functionValuesDocIdPerSeg[segIdx] = segDocId;
            return functionValues.objectVal(segDocId);
        }
    }

    private static class InputStringLazy
    implements Callable<String> {
        final Reader inputReader;
        String inputString;

        InputStringLazy(Reader inputReader) {
            this.inputReader = inputReader;
        }

        @Override
        public String call() throws IOException {
            if (this.inputString == null) {
                this.inputString = StrUtils.stringFromReader((Reader)this.inputReader);
            }
            return this.inputString;
        }
    }
}

