/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.constant.Constant;
import proguard.classfile.editor.AttributeAdder;
import proguard.classfile.editor.ClassEditor;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.io.ProgramClassReader;
import proguard.classfile.io.ProgramClassWriter;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.util.ArrayUtil;
import proguard.util.StringTransformer;

public class MemberAdder
extends SimplifiedVisitor
implements MemberVisitor {
    private static final boolean DEBUG = false;
    private static final Attribute[] EMPTY_ATTRIBUTES = new Attribute[0];
    private final ProgramClass targetClass;
    private final StringTransformer nameTransformer;
    private final MemberVisitor extraMemberVisitor;
    private final ClassEditor classEditor;
    private final ConstantPoolEditor constantPoolEditor;

    public MemberAdder(ProgramClass targetClass) {
        this(targetClass, null);
    }

    public MemberAdder(ProgramClass targetClass, MemberVisitor extraMemberVisitor) {
        this(targetClass, null, extraMemberVisitor);
    }

    public MemberAdder(ProgramClass targetClass, StringTransformer nameTransformer, MemberVisitor extraMemberVisitor) {
        this.targetClass = targetClass;
        this.nameTransformer = nameTransformer;
        this.extraMemberVisitor = extraMemberVisitor;
        this.classEditor = new ClassEditor(targetClass);
        this.constantPoolEditor = new ConstantPoolEditor(targetClass);
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        String name = programField.getName(programClass);
        String descriptor = programField.getDescriptor(programClass);
        int accessFlags = programField.getAccessFlags();
        if (this.nameTransformer != null) {
            name = this.nameTransformer.transform(name);
        }
        ProgramField newProgramField = new ProgramField(accessFlags, this.constantPoolEditor.addUtf8Constant(name), this.constantPoolEditor.addUtf8Constant(descriptor), 0, programField.u2attributesCount > 0 ? new Attribute[programField.u2attributesCount] : EMPTY_ATTRIBUTES, programField.referencedClass);
        newProgramField.setVisitorInfo(programField);
        programField.attributesAccept(programClass, new AttributeAdder(this.targetClass, newProgramField, false));
        this.classEditor.addField(newProgramField);
        if (this.extraMemberVisitor != null) {
            this.extraMemberVisitor.visitProgramField(this.targetClass, newProgramField);
        }
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        ProgramMethod targetMethod;
        String name = programMethod.getName(programClass);
        String descriptor = programMethod.getDescriptor(programClass);
        int accessFlags = programMethod.getAccessFlags();
        if (this.nameTransformer != null) {
            name = this.nameTransformer.transform(name);
        }
        if ((targetMethod = (ProgramMethod)this.targetClass.findMethod(name, descriptor)) != null) {
            if ((accessFlags & 0x400) != 0) {
                return;
            }
            int targetAccessFlags = targetMethod.getAccessFlags();
            if ((targetAccessFlags & 0x400) != 0) {
                targetMethod.u2accessFlags = accessFlags & 0xFFFFFFEF;
                programMethod.attributesAccept(programClass, new AttributeAdder(this.targetClass, targetMethod, true));
                return;
            }
        }
        ProgramMethod newProgramMethod = new ProgramMethod(accessFlags & 0xFFFFFFEF, this.constantPoolEditor.addUtf8Constant(name), this.constantPoolEditor.addUtf8Constant(descriptor), 0, programMethod.u2attributesCount > 0 ? new Attribute[programMethod.u2attributesCount] : EMPTY_ATTRIBUTES, ArrayUtil.cloneOrNull(programMethod.referencedClasses));
        newProgramMethod.setVisitorInfo(programMethod);
        programMethod.attributesAccept(programClass, new AttributeAdder(this.targetClass, newProgramMethod, false));
        this.classEditor.addMethod(newProgramMethod);
        if (this.extraMemberVisitor != null) {
            this.extraMemberVisitor.visitProgramMethod(this.targetClass, newProgramMethod);
        }
    }

    private String newUniqueMemberName(String name, String descriptor) {
        return name.equals("<init>") ? "<init>" : name + '$' + Long.toHexString(Math.abs(descriptor.hashCode()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String inputClassFileName = args[0];
        String outputClassFileName = args[1];
        try (DataInputStream dataInputStream = new DataInputStream(new FileInputStream(inputClassFileName));){
            ProgramClass inputProgramClass = new ProgramClass();
            inputProgramClass.accept(new ProgramClassReader(dataInputStream));
            ProgramClass outputProgramClass = new ProgramClass(inputProgramClass.u4version, 1, new Constant[1], inputProgramClass.u2accessFlags, 0, 0);
            ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor(outputProgramClass);
            outputProgramClass.u2thisClass = constantPoolEditor.addClassConstant(inputProgramClass.getName() + "Copy", null);
            outputProgramClass.u2superClass = constantPoolEditor.addClassConstant("java/lang/Object", null);
            MemberAdder memberAdder = new MemberAdder(outputProgramClass);
            inputProgramClass.fieldsAccept(memberAdder);
            inputProgramClass.methodsAccept(memberAdder);
            try (DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(outputClassFileName));){
                outputProgramClass.accept(new ProgramClassWriter(dataOutputStream));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

