/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.util.Utils;

public class Goods
extends AbstractGoods
implements Locatable,
Ownable {
    private static final Logger logger = Logger.getLogger(Goods.class.getName());
    public static final String TAG = "goods";
    private final Game game;
    private Location location;
    private static final String AMOUNT_TAG = "amount";
    private static final String LOCATION_TAG = "location";
    private static final String TYPE_TAG = "type";

    private Goods(Game game) {
        if (game == null) {
            throw new RuntimeException("Null game: " + this);
        }
        this.game = game;
    }

    public Goods(Game game, String id) {
        this(game);
    }

    public Goods(Game game, Location location, GoodsType type, int amount) {
        this(game);
        if (type == null) {
            throw new RuntimeException("Null type: " + this);
        }
        if (location != null && location.getGoodsContainer() == null) {
            throw new RuntimeException("Can not store goods at: " + location);
        }
        this.setId(type.getId());
        this.setType(type);
        this.setAmount(amount);
        this.location = location;
    }

    public Goods(Game game, FreeColXMLReader xr) throws XMLStreamException {
        this(game);
        this.readFromXML(xr);
    }

    public void adjustAmount() {
        if (this.location == null) {
            return;
        }
        GoodsContainer gc = this.location.getGoodsContainer();
        if (gc != null) {
            int maxAmount = gc.getGoodsCount(this.getType());
            if (this.getAmount() > maxAmount) {
                this.setAmount(maxAmount);
            }
        }
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public boolean setLocation(Location location) {
        this.location = location;
        return true;
    }

    @Override
    public boolean isInEurope() {
        return this.location instanceof Europe || this.location instanceof Unit && ((Unit)this.location).isInEurope();
    }

    @Override
    public Tile getTile() {
        return this.location == null ? null : this.location.getTile();
    }

    @Override
    public int getSpaceTaken() {
        return 1;
    }

    @Override
    public Player getOwner() {
        return this.location instanceof Ownable ? ((Ownable)((Object)this.location)).getOwner() : null;
    }

    @Override
    public void setOwner(Player p) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Specification getSpecification() {
        return this.getGame().getSpecification();
    }

    @Override
    public void setSpecification(Specification specification) {
        throw new RuntimeException("Can not set specification: " + this);
    }

    @Override
    public Game getGame() {
        return this.game;
    }

    @Override
    public void setGame(Game game) {
        throw new RuntimeException("Can not set game: " + this);
    }

    @Override
    public FreeColObject getDisplayObject() {
        return this.getType();
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        Goods o = this.copyInCast(other, Goods.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        this.location = this.getGame().updateLocationRef(o.getLocation());
        return true;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(TYPE_TAG, this.type);
        xw.writeAttribute(AMOUNT_TAG, this.amount);
        if (this.location != null) {
            xw.writeLocationAttribute(LOCATION_TAG, this.location);
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        Specification spec = this.getSpecification();
        super.readAttributes(xr);
        this.type = xr.getType(spec, TYPE_TAG, GoodsType.class, null);
        if (this.type == null) {
            throw new XMLStreamException("Null goods type: " + this);
        }
        this.setId(this.type.getId());
        this.amount = xr.getAttribute(AMOUNT_TAG, 0);
        this.location = xr.getLocationAttribute(this.game, LOCATION_TAG, true);
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof Goods) {
            Goods other = (Goods)o;
            return this.location == other.location && super.equals(other);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        return 31 * hash + Utils.hashCode(this.location);
    }
}

