/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.fop.pdf.PDFArray;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.pdf.PDFText;

public class PDFNumsArray
extends PDFObject {
    protected SortedMap<Integer, Object> map = new TreeMap<Integer, Object>();

    public PDFNumsArray(PDFObject parent) {
        super(parent);
    }

    public int length() {
        return this.map.size();
    }

    private boolean shouldConvertToRef(PDFObject obj) {
        boolean retval = false;
        if (this.getDocument() != null && this.getDocument().getPDFVersion() != null) {
            switch (this.getDocument().getPDFVersion()) {
                case V1_0: 
                case V1_1: 
                case V1_2: {
                    log.error((Object)("Number Tree used in PDF version " + (Object)((Object)this.getDocument().getPDFVersion())));
                    break;
                }
                case V1_3: 
                case V1_4: {
                    retval = true;
                    break;
                }
                case V1_5: 
                case V1_6: 
                case V1_7: 
                case V2_0: {
                    if (!(obj instanceof PDFStream) && !(obj instanceof PDFDictionary) && !(obj instanceof PDFArray) && !(obj instanceof PDFText)) break;
                    retval = true;
                    break;
                }
                default: {
                    log.error((Object)("Unrecognised PDF version " + (Object)((Object)this.getDocument().getPDFVersion())));
                }
            }
        }
        return retval;
    }

    private Object indirectIfReq(Object obj) {
        PDFDocument doc = this.getDocument();
        Object retval = obj;
        if (obj instanceof PDFObject) {
            PDFObject pdfObj = (PDFObject)obj;
            PDFObject parent = pdfObj.getParent();
            if (this.shouldConvertToRef(pdfObj)) {
                if (!pdfObj.hasObjectNumber()) {
                    pdfObj.setParent(null);
                    pdfObj = doc.registerObject(pdfObj);
                    if (parent != null) {
                        pdfObj.setParent(parent);
                    }
                }
                retval = pdfObj.makeReference();
            }
        }
        return retval;
    }

    public void put(Integer key, Object obj) {
        this.map.put(key, this.indirectIfReq(obj));
    }

    public void put(int key, Object obj) {
        this.put((Integer)key, obj);
    }

    public Object get(Integer key) {
        return this.map.get(key);
    }

    public Object get(int key) {
        return this.get((Integer)key);
    }

    @Override
    public int output(OutputStream stream) throws IOException {
        CountingOutputStream cout = new CountingOutputStream(stream);
        StringBuilder textBuffer = new StringBuilder(64);
        textBuffer.append('[');
        boolean first = true;
        for (Map.Entry<Integer, Object> entry : this.map.entrySet()) {
            if (!first) {
                textBuffer.append(" ");
            }
            first = false;
            this.formatObject(entry.getKey(), (OutputStream)cout, textBuffer);
            textBuffer.append(" ");
            this.formatObject(entry.getValue(), (OutputStream)cout, textBuffer);
        }
        textBuffer.append(']');
        PDFDocument.flushTextBuffer(textBuffer, (OutputStream)cout);
        return cout.getCount();
    }
}

