/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.dom.DOMDocument;
import io.sf.carte.doc.dom.NDTNode;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

abstract class NamespacedNode
extends NDTNode {
    private static final long serialVersionUID = 1L;
    private final String namespaceUri;
    private String prefix = null;

    public NamespacedNode(short nodeType, String namespaceUri) {
        super(nodeType);
        this.namespaceUri = namespaceUri;
    }

    @Override
    void checkAppendNodeHierarchy(Node newChild) {
        super.checkAppendNodeHierarchy(newChild);
        if (newChild.getNodeType() == 10) {
            throw new DOMException(3, "Cannot append a document type here.");
        }
    }

    @Override
    public String getNamespaceURI() {
        return this.namespaceUri;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public void setPrefix(String prefix) throws DOMException {
        String nsUri = this.getNamespaceURI();
        if (nsUri != null && !this.isDefaultNamespace(nsUri)) {
            if ("xml".equals(prefix) && "http://www.w3.org/XML/1998/namespace" != this.getNamespaceURI()) {
                throw new DOMException(14, "Wrong namespace for prefix xml");
            }
            if (prefix != null && !DOMDocument.isValidName(prefix)) {
                throw new DOMException(5, "Invalid prefix");
            }
            this.prefix = prefix;
        } else if (prefix != null && prefix.length() != 0) {
            throw new DOMException(14, "Cannot put a prefix to default namespace.");
        }
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        if (prefix == null) {
            if (this.getPrefix() == null) {
                return this.getNamespaceURI();
            }
        } else {
            if (prefix.equals(this.getPrefix())) {
                return this.getNamespaceURI();
            }
            if ("xml".equals(prefix)) {
                return "http://www.w3.org/XML/1998/namespace";
            }
        }
        return null;
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        if (namespaceURI == null) {
            return null;
        }
        if (namespaceURI.equals(this.getNamespaceURI())) {
            return this.getPrefix();
        }
        return null;
    }
}

