/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSNumberValue;
import io.sf.carte.doc.style.css.CSSUnit;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.property.PercentageValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Locale;
import org.w3c.dom.DOMException;

public class NumberValue
extends TypedValue
implements CSSNumberValue {
    private static final long serialVersionUID = 1L;
    private short unitType;
    protected float realvalue = 0.0f;
    private String dimensionUnitText = "";
    private boolean asInteger = false;
    boolean lengthUnitType = false;
    private boolean calculated = false;
    private boolean specified = true;
    private int maxFractionDigits = -1;

    public NumberValue() {
        super(CSSValue.Type.NUMERIC);
        this.unitType = 0;
    }

    protected NumberValue(NumberValue copied) {
        super(copied);
        this.unitType = copied.unitType;
        this.realvalue = copied.realvalue;
        this.asInteger = copied.asInteger;
        this.calculated = copied.calculated;
        this.specified = copied.specified;
        this.maxFractionDigits = copied.maxFractionDigits;
        this.lengthUnitType = copied.lengthUnitType;
        this.dimensionUnitText = copied.dimensionUnitText;
        this.maxFractionDigits = copied.maxFractionDigits;
    }

    @Override
    public short getUnitType() {
        return this.unitType;
    }

    void setUnitType(short unitType) {
        this.unitType = unitType;
    }

    @Override
    public String getCssText() {
        boolean notaNumber;
        boolean bl = notaNumber = this.unitType != 0;
        if (this.realvalue == 0.0f && !notaNumber) {
            return "0";
        }
        if (Float.isInfinite(this.realvalue)) {
            return this.serializeInfinite();
        }
        double rintValue = Math.rint(this.realvalue);
        if (this.asInteger) {
            return Integer.toString((int)rintValue);
        }
        if ((double)this.realvalue == rintValue && notaNumber) {
            return (int)rintValue + this.dimensionUnitText;
        }
        String s = this.serializeNumber(this.realvalue);
        StringBuilder buf = new StringBuilder(s.length() + this.dimensionUnitText.length());
        buf.append(s);
        buf.append(this.dimensionUnitText);
        return buf.toString();
    }

    private String serializeNumber(float real) {
        String s;
        if (this.specified && !this.calculated) {
            s = Float.toString(real);
        } else {
            NumberFormat format = NumberFormat.getNumberInstance(Locale.ROOT);
            format.setMinimumFractionDigits(0);
            int fdigits = this.maxFractionDigits;
            if (fdigits < 0) {
                fdigits = NumberValue.fractionDigits(this.getUnitType());
            }
            format.setMaximumFractionDigits(fdigits);
            s = format.format(real);
        }
        return s;
    }

    @Override
    public void writeCssText(SimpleWriter wri) throws IOException {
        this.writeCssText(wri, this.realvalue);
    }

    void writeCssText(SimpleWriter wri, float realvalue) throws IOException {
        boolean notaNumber;
        boolean bl = notaNumber = this.getUnitType() != 0;
        if (realvalue == 0.0f && !notaNumber) {
            wri.write('0');
            return;
        }
        if (Float.isInfinite(realvalue)) {
            this.writeInfinite(wri);
            return;
        }
        double rintValue = Math.rint(realvalue);
        if (this.asInteger) {
            wri.write((CharSequence)Integer.toString((int)rintValue));
            return;
        }
        if ((double)realvalue == rintValue && notaNumber) {
            wri.write((CharSequence)Integer.toString((int)rintValue));
            wri.write((CharSequence)this.dimensionUnitText);
            return;
        }
        String s = this.serializeNumber(realvalue);
        wri.write((CharSequence)s);
        wri.write((CharSequence)this.dimensionUnitText);
    }

    private void writeInfinite(SimpleWriter wri) throws IOException {
        if (this.realvalue > 0.0f) {
            wri.write((CharSequence)"calc(1/0)");
        } else {
            wri.write((CharSequence)"calc(-1/0)");
        }
    }

    public void serializeAbsolute(SimpleWriter wri) throws IOException {
        this.writeCssText(wri, Math.abs(this.realvalue));
    }

    @Override
    public String getMinifiedCssText(String propertyName) {
        return this.getMinifiedCssText(propertyName, this.realvalue);
    }

    private String getMinifiedCssText(String propertyName, float realvalue) {
        if (realvalue == 0.0f && this.getUnitType() != 2 && this.isLengthUnitType() && !this.isSubproperty() && this.isSpecified()) {
            return "0";
        }
        if (Float.isInfinite(realvalue)) {
            return this.serializeInfinite();
        }
        double rintValue = Math.rint(realvalue);
        if (this.asInteger) {
            return Integer.toString((int)rintValue);
        }
        if ((double)realvalue == rintValue) {
            boolean notaNumber;
            String s = Integer.toString((int)rintValue);
            boolean bl = notaNumber = this.getUnitType() != 0;
            if (notaNumber) {
                return s + this.dimensionUnitText;
            }
            return s;
        }
        String s = this.serializeNumber(realvalue);
        int len = s.length();
        StringBuilder buf = new StringBuilder(len + this.dimensionUnitText.length());
        char c = s.charAt(0);
        if (c == '-' && s.charAt(1) == '0') {
            buf.append('-');
            buf.append(s.subSequence(2, len));
        } else if (c == '0' && len > 2) {
            buf.append(s.subSequence(1, len));
        } else {
            buf.append(s);
        }
        buf.append(this.dimensionUnitText);
        return buf.toString();
    }

    private String serializeInfinite() {
        if (this.realvalue > 0.0f) {
            return "calc(1/0)";
        }
        return "calc(-1/0)";
    }

    public String minifyAbsolute(String propertyName) {
        return this.getMinifiedCssText(propertyName, Math.abs(this.realvalue));
    }

    private boolean isLengthUnitType() {
        return this.lengthUnitType;
    }

    @Override
    public void setFloatValue(short unitType, float floatValue) throws DOMException {
        this.checkModifiableProperty();
        this.setUnitType(unitType);
        this.realvalue = floatValue;
        this.dimensionUnitText = CSSUnit.dimensionUnitString(unitType);
        this.asInteger = unitType == 0 && (float)Math.rint(floatValue) == this.realvalue;
        this.lengthUnitType = CSSUnit.isLengthUnitType(unitType);
    }

    public void setFloatValuePt(float floatValue) {
        this.setUnitType((short)6);
        this.realvalue = floatValue;
        this.dimensionUnitText = "pt";
        this.asInteger = false;
        this.lengthUnitType = true;
    }

    public void setIntegerValue(int intValue) {
        this.realvalue = intValue;
        this.setUnitType((short)0);
        this.asInteger = true;
        this.lengthUnitType = false;
    }

    @Override
    public void setExpectInteger() throws DOMException {
        if (this.getUnitType() != 0) {
            super.setExpectInteger();
        } else if (this.calculated) {
            this.asInteger = true;
            this.realvalue = Math.round(this.realvalue);
        } else if (!this.asInteger) {
            super.setExpectInteger();
        }
    }

    @Override
    public void roundToInteger() throws DOMException {
        this.asInteger = true;
        this.setExpectInteger();
        this.realvalue = Math.round(this.realvalue);
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        throw new DOMException(7, "Cannot use setCssText here");
    }

    @Override
    public boolean isCalculatedNumber() {
        return this.calculated;
    }

    @Override
    public void setCalculatedNumber(boolean calculated) {
        this.calculated = calculated;
        this.specified = this.specified && !calculated;
    }

    public void setAbsolutizedUnit() {
        this.specified = false;
    }

    void setSpecified(boolean specified) {
        this.specified = specified;
    }

    boolean isSpecified() {
        return this.specified;
    }

    public void setMaximumFractionDigits(int maxFractionDigits) {
        this.maxFractionDigits = maxFractionDigits;
    }

    @Override
    public boolean isNegativeNumber() {
        return this.realvalue < 0.0f;
    }

    @Override
    public boolean isNumberZero() {
        return this.realvalue == 0.0f;
    }

    @Override
    public float getFloatValue() {
        return this.realvalue;
    }

    @Override
    public float getFloatValue(short unitType) throws DOMException {
        return NumberValue.floatValueConversion(this.realvalue, this.getUnitType(), unitType);
    }

    public static float floatValueConversion(float fvalue, short declType, short unitType) throws DOMException {
        String requestedUnitStr;
        if (declType == unitType) {
            return fvalue;
        }
        switch (declType) {
            case 6: {
                if (unitType == 3) {
                    return fvalue / 0.75f;
                }
                if (unitType == 4) {
                    return fvalue / 72.0f;
                }
                if (unitType == 5) {
                    return fvalue / 12.0f;
                }
                if (unitType == 7) {
                    return fvalue / 28.346457f;
                }
                if (unitType == 8) {
                    return fvalue / 2.8346457f;
                }
                if (unitType != 9) break;
                return fvalue * 1.4111111f;
            }
            case 3: {
                if (unitType == 6) {
                    return fvalue * 0.75f;
                }
                if (unitType == 4) {
                    return fvalue / 96.0f;
                }
                if (unitType == 5) {
                    return fvalue / 16.0f;
                }
                if (unitType == 7) {
                    return fvalue / 37.795277f;
                }
                if (unitType == 8) {
                    return fvalue / 3.7795277f;
                }
                if (unitType != 9) break;
                return fvalue * 1.0583333f;
            }
            case 5: {
                if (unitType == 6) {
                    return fvalue * 12.0f;
                }
                if (unitType == 4) {
                    return fvalue / 6.0f;
                }
                if (unitType == 3) {
                    return fvalue * 16.0f;
                }
                if (unitType == 7) {
                    return fvalue * 0.42333332f;
                }
                if (unitType == 8) {
                    return fvalue * 4.233333f;
                }
                if (unitType != 9) break;
                return fvalue * 16.933332f;
            }
            case 4: {
                if (unitType == 3) {
                    return fvalue * 96.0f;
                }
                if (unitType == 6) {
                    return fvalue * 72.0f;
                }
                if (unitType == 5) {
                    return fvalue * 6.0f;
                }
                if (unitType == 7) {
                    return fvalue * 2.54f;
                }
                if (unitType == 8) {
                    return fvalue * 25.4f;
                }
                if (unitType != 9) break;
                return fvalue * 101.6f;
            }
            case 7: {
                if (unitType == 6) {
                    return fvalue * 28.346457f;
                }
                if (unitType == 4) {
                    return fvalue / 2.54f;
                }
                if (unitType == 3) {
                    return fvalue * 37.795277f;
                }
                if (unitType == 5) {
                    return fvalue * 2.3622048f;
                }
                if (unitType == 8) {
                    return fvalue * 10.0f;
                }
                if (unitType != 9) break;
                return fvalue * 40.0f;
            }
            case 8: {
                if (unitType == 6) {
                    return fvalue * 2.8346457f;
                }
                if (unitType == 4) {
                    return fvalue / 25.4f;
                }
                if (unitType == 3) {
                    return fvalue * 3.7795277f;
                }
                if (unitType == 5) {
                    return fvalue * 0.23622046f;
                }
                if (unitType == 7) {
                    return fvalue * 0.1f;
                }
                if (unitType != 9) break;
                return fvalue * 4.0f;
            }
            case 9: {
                if (unitType == 6) {
                    return fvalue * 0.7086614f;
                }
                if (unitType == 4) {
                    return fvalue / 101.6f;
                }
                if (unitType == 3) {
                    return fvalue * 0.9448819f;
                }
                if (unitType == 5) {
                    return fvalue / 16.933332f;
                }
                if (unitType == 8) {
                    return fvalue * 0.25f;
                }
                if (unitType != 7) break;
                return fvalue * 0.025f;
            }
            case 91: {
                if (unitType != 90) break;
                return fvalue * 0.001f;
            }
            case 90: {
                if (unitType != 91) break;
                return fvalue * 1000.0f;
            }
            case 83: {
                if (unitType == 81) {
                    return fvalue * 2.0f * (float)Math.PI;
                }
                if (unitType == 82) {
                    return fvalue * 400.0f;
                }
                if (unitType != 80) break;
                return fvalue * 360.0f;
            }
            case 81: {
                if (unitType == 80) {
                    return (float)Math.toDegrees(fvalue);
                }
                if (unitType == 82) {
                    return fvalue * 63.661976f;
                }
                if (unitType != 83) break;
                return fvalue * 0.15915494f;
            }
            case 80: {
                if (unitType == 81) {
                    return (float)Math.toRadians(fvalue);
                }
                if (unitType == 82) {
                    return fvalue * 1.1111112f;
                }
                if (unitType != 83) break;
                return fvalue / 360.0f;
            }
            case 82: {
                if (unitType == 80) {
                    return fvalue * 0.9f;
                }
                if (unitType == 81) {
                    return fvalue * 0.015707964f;
                }
                if (unitType != 83) break;
                return fvalue * 0.0025f;
            }
            case 0: {
                if (unitType == 80) {
                    return fvalue;
                }
            }
            case 100: {
                if (unitType != 101) break;
                return fvalue * 0.001f;
            }
            case 101: {
                if (unitType != 100) break;
                return fvalue * 1000.0f;
            }
            case 60: {
                if (unitType == 61) {
                    return fvalue / 2.54f;
                }
                if (unitType != 62) break;
                return fvalue / 96.0f;
            }
            case 61: {
                if (unitType == 60) {
                    return fvalue * 2.54f;
                }
                if (unitType != 62) break;
                return fvalue / 37.795277f;
            }
            case 62: {
                if (unitType == 60) {
                    return fvalue * 96.0f;
                }
                if (unitType != 61) break;
                return fvalue * 37.795277f;
            }
            default: {
                if (1 != unitType) break;
                return fvalue;
            }
        }
        if (fvalue == 0.0f) {
            return fvalue;
        }
        String unit = CSSUnit.dimensionUnitString(declType);
        if (unit.length() == 0) {
            unit = '<' + Integer.toString(declType) + '>';
        }
        try {
            requestedUnitStr = CSSUnit.dimensionUnitString(unitType);
            if (requestedUnitStr.length() == 0) {
                requestedUnitStr = "<number>";
            }
        }
        catch (DOMException e) {
            requestedUnitStr = '<' + Integer.toString(unitType) + '>';
        }
        throw new DOMException(15, "Cannot transform unit " + unit + " to " + requestedUnitStr);
    }

    public String getDimensionUnitText() {
        return this.dimensionUnitText;
    }

    @Override
    CSSValueSyntax.Match matchesComponent(CSSValueSyntax syntax) {
        switch (syntax.getCategory()) {
            case length: {
                return this.isLengthCompatible() ? CSSValueSyntax.Match.TRUE : CSSValueSyntax.Match.FALSE;
            }
            case lengthPercentage: {
                return this.isLengthCompatible() || this.getUnitType() == 2 ? CSSValueSyntax.Match.TRUE : CSSValueSyntax.Match.FALSE;
            }
            case percentage: {
                return this.getUnitType() == 2 ? CSSValueSyntax.Match.TRUE : CSSValueSyntax.Match.FALSE;
            }
            case number: {
                return this.getUnitType() == 0 ? CSSValueSyntax.Match.TRUE : CSSValueSyntax.Match.FALSE;
            }
            case integer: {
                return this.getUnitType() == 0 && (this.asInteger || this.isCalculatedNumber()) ? CSSValueSyntax.Match.TRUE : CSSValueSyntax.Match.FALSE;
            }
            case angle: {
                return CSSUnit.isAngleUnitType(this.getUnitType()) ? CSSValueSyntax.Match.TRUE : CSSValueSyntax.Match.FALSE;
            }
            case time: {
                return CSSUnit.isTimeUnitType(this.getUnitType()) ? CSSValueSyntax.Match.TRUE : CSSValueSyntax.Match.FALSE;
            }
            case resolution: {
                return CSSUnit.isResolutionUnitType(this.getUnitType()) ? CSSValueSyntax.Match.TRUE : CSSValueSyntax.Match.FALSE;
            }
            case frequency: {
                return this.getUnitType() == 100 || this.getUnitType() == 101 ? CSSValueSyntax.Match.TRUE : CSSValueSyntax.Match.FALSE;
            }
            case flex: {
                return this.getUnitType() == 70 ? CSSValueSyntax.Match.TRUE : CSSValueSyntax.Match.FALSE;
            }
            case universal: {
                return CSSValueSyntax.Match.TRUE;
            }
        }
        return CSSValueSyntax.Match.FALSE;
    }

    private boolean isLengthCompatible() {
        return CSSUnit.isLengthUnitType(this.getUnitType()) || this.getUnitType() == 0 && this.isNumberZero();
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = this.getCssValueType().hashCode();
        result = 31 * result + this.getPrimitiveType().hashCode();
        short pType = this.realvalue != 0.0f ? this.getUnitType() : (short)0;
        result = 31 * result + pType;
        result = 31 * result + Float.floatToIntBits(this.realvalue);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof NumberValue)) {
            return false;
        }
        NumberValue other = (NumberValue)obj;
        if (Float.floatToIntBits(this.realvalue) != Float.floatToIntBits(other.realvalue)) {
            return false;
        }
        return this.getUnitType() == other.getUnitType() || this.realvalue == 0.0f;
    }

    @Override
    public NumberValue clone() {
        return new NumberValue(this);
    }

    NumberValue immutable() {
        return new ImmutableCSSNumberValue(this);
    }

    private static int fractionDigits(short unit) {
        switch (unit) {
            case 0: 
            case 81: {
                return 3;
            }
            case 7: 
            case 83: 
            case 101: {
                return 4;
            }
        }
        return 2;
    }

    public static NumberValue createCSSNumberValue(short unit, float floatValue) {
        NumberValue num = unit != 2 ? new NumberValue() : new PercentageValue();
        num.setFloatValue(unit, floatValue);
        return num;
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
            super(NumberValue.this);
        }

        @Override
        void setLexicalUnit(LexicalUnit lunit) {
            super.setLexicalUnit(lunit);
            this.nextLexicalUnit = lunit.getNextLexicalUnit();
            switch (lunit.getLexicalUnitType()) {
                case INTEGER: {
                    NumberValue.this.realvalue = lunit.getIntegerValue();
                    NumberValue.this.asInteger = true;
                    NumberValue.this.setUnitType((short)0);
                    break;
                }
                default: {
                    NumberValue.this.realvalue = lunit.getFloatValue();
                    NumberValue.this.asInteger = false;
                    NumberValue.this.dimensionUnitText = lunit.getDimensionUnitText();
                    NumberValue.this.setUnitType(lunit.getCssUnit());
                }
            }
        }
    }

    private static class ImmutableCSSNumberValue
    extends NumberValue {
        private static final long serialVersionUID = 1L;

        ImmutableCSSNumberValue(NumberValue value) {
            super(value);
        }

        @Override
        public void setFloatValue(short unitType, float floatValue) throws DOMException {
            throw new DOMException(7, "This value is immutable");
        }

        @Override
        public void setFloatValuePt(float floatValue) {
            throw new DOMException(7, "This value is immutable");
        }

        @Override
        public void setIntegerValue(int intValue) {
            throw new DOMException(7, "This value is immutable");
        }

        @Override
        public NumberValue clone() {
            return this;
        }
    }
}

