/*
 * Decompiled with CFR 0.152.
 */
package mpi;

import mpi.Allocable;
import mpi.AllocablePool;
import mpi.UserFunction;

public class Op
implements Allocable {
    public static Op MPI_OP_NULL = new Op(0);
    public static Op MPI_MAX = new Op(1);
    public static Op MPI_MIN = new Op(2);
    public static Op MPI_SUM = new Op(3);
    public static Op MPI_PROD = new Op(4);
    public static Op MPI_LAND = new Op(5);
    public static Op MPI_BAND = new Op(6);
    public static Op MPI_LOR = new Op(7);
    public static Op MPI_BOR = new Op(8);
    public static Op MPI_LXOR = new Op(9);
    public static Op MPI_BXOR = new Op(10);
    public static Op MPI_MINLOC = new Op(11);
    public static Op MPI_MAXLOC = new Op(12);
    private int id;
    private long handle;
    private boolean isCustom = false;
    private UserFunction userFunction;

    private Op(int n) {
        this.id = n;
    }

    public Op(UserFunction userFunction) {
        this.userFunction = userFunction;
    }

    public UserFunction getUserFunction() {
        return this.userFunction;
    }

    public void setUserFunction(UserFunction userFunction) {
        this.userFunction = userFunction;
    }

    public int getId() {
        return this.id;
    }

    public long getHandle() {
        return this.handle;
    }

    void setHandle(long l) {
        this.handle = l;
    }

    public boolean isCustom() {
        return this.isCustom;
    }

    public void setIsCustom(boolean bl) {
        this.isCustom = bl;
    }

    public void createOP(boolean bl) {
        this.isCustom = true;
        this.handle = this.MPI_Op_Create(bl, this);
        AllocablePool.add(this);
    }

    private native long MPI_Op_Create(boolean var1, Op var2);

    @Override
    public void free() {
        AllocablePool.remove(this);
        this.jniFree();
    }

    private native void jniFree();
}

