#!/usr/bin/env python
from apm_helpers.compatibility import python_ver_check
python_ver_check()
import argparse
import os
import sys
sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__),'..','pythonapi')))
from analyze_impl import run_analyze
from collect_impl import run_collect
from shared import add_shared_arguments,get_accelerator,add_accel_args_to_parser,Positional_Arg_Formatter
if __name__=='__main__':
 parser=argparse.ArgumentParser(prog=sys.argv[0],description='''Collects basic data, does markup, and collects refinement data. Then proceeds to run analysis on profiling data.''',conflict_handler='resolve',formatter_class=Positional_Arg_Formatter)
 add_shared_arguments(parser)
 Accelerator,arch_name,accs,is_arch_used=get_accelerator()
 suppress_accel_help=not(is_arch_used or len(accs)==1)
 add_accel_args_to_parser(Accelerator,parser,"shared",suppress_help=suppress_accel_help)
 run_collect(parser)
 run_analyze(parser)
