/*******************************************************************************
* Copyright (C) 2023 Intel Corporation
*
* This software and the related documents are Intel copyrighted  materials,  and
* your use of  them is  governed by the  express license  under which  they were
* provided to you (License).  Unless the License provides otherwise, you may not
* use, modify, copy, publish, distribute,  disclose or transmit this software or
* the related documents without Intel's prior written permission.
*
* This software and the related documents  are provided as  is,  with no express
* or implied  warranties,  other  than those  that are  expressly stated  in the
* License.
*******************************************************************************/

//@HEADER
// ***************************************************
//
// HPCG: High Performance Conjugate Gradient Benchmark
//
// Contact:
// Michael A. Heroux ( maherou@sandia.gov)
// Jack Dongarra     (dongarra@eecs.utk.edu)
// Piotr Luszczek    (luszczek@eecs.utk.edu)
//
// ***************************************************
//@HEADER


#include "CustomKernels.hpp"

#include "kernels/mv_kernels.hpp"

namespace custom {

    // y = A * x          y,x should be USM device allocated
    sycl::event SpGEMV(sycl::queue &queue, sparseMatrix *matA, const double *x, double *y, const std::vector<sycl::event>& dependencies)
    {
        // printf("SpGEMV:  matA->nrows = %zu\n", matA->nrows);
        if (matA->block_size != HPCG_BLOCK_SIZE) {
            printf("Incorrect block_size provided to SpGEMV\n");
            throw std::runtime_error("SpGEMV invalid block_size");
        }

        return sparse_esb3_mv_esimd<HPCG_BLOCK_SIZE, false>(queue, matA->nrows, matA->nBlocks,
            matA->esbblockptr, matA->esbcolind, matA->esbvalues, x, y, NULL, matA->mv_reorder, matA->applyL3CacheMVReorder, dependencies);
    }

    sycl::event SpGEMV_DOT(sycl::queue &queue, sparseMatrix *matA, const double *x, double *y, double *xAx, const std::vector<sycl::event>& dependencies)
    {
        // printf("SpGEMV_DOT:  matA->nrows = %zu\n", matA->nrows);
        if (matA->block_size != HPCG_BLOCK_SIZE) {
            printf("Incorrect block_size provided to SpGEMV_DOT\n");
            throw std::runtime_error("SpGEMV_DOT invalid block_size");
        }

        return sparse_esb3_mv_esimd<HPCG_BLOCK_SIZE, true>(queue, matA->nrows, matA->nBlocks,
            matA->esbblockptr, matA->esbcolind, matA->esbvalues, x, y, xAx, matA->mv_reorder, matA->applyL3CacheMVReorder, dependencies);
    }

} // namespace custom
