<?xml version='1.0' encoding='utf-8'?>
<!--

 Copyright © 2009 Intel Corporation. All rights reserved.

 The information contained herein is the exclusive property of
 Intel Corporation and may not be disclosed, examined, or reproduced in
 whole or in part without explicit written authorization from the Company.

-->
<xsl:stylesheet exclude-result-prefixes="msxsl" syntax="norules" version="1.0" xmlns:boolean="http://www.w3.org/2001/XMLSchema#boolean" xmlns:exsl="http://exslt.org/common" xmlns:int="http://www.w3.org/2001/XMLSchema#int" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output indent="yes" method="xml" />
    <xsl:template match="/">
        <bag>
            <vectorQuery id="GETopDown_socsmall" xmlns:blob="http://www.intel.com/2009/BagSchema#blob" xmlns:boolean="http://www.w3.org/2001/XMLSchema#boolean" xmlns:byte="http://www.w3.org/2001/XMLSchema#byte" xmlns:double="http://www.w3.org/2001/XMLSchema#double" xmlns:float="http://www.w3.org/2001/XMLSchema#float" xmlns:int="http://www.w3.org/2001/XMLSchema#int" xmlns:long="http://www.w3.org/2001/XMLSchema#long" xmlns:null="http://www.intel.com/2009/BagSchema#null" xmlns:short="http://www.w3.org/2001/XMLSchema#short" xmlns:unsignedByte="http://www.w3.org/2001/XMLSchema#unsignedByte" xmlns:unsignedInt="http://www.w3.org/2001/XMLSchema#unsignedInt" xmlns:unsignedLong="http://www.w3.org/2001/XMLSchema#unsignedLong" xmlns:unsignedShort="http://www.w3.org/2001/XMLSchema#unsignedShort">
                <derivedQuery id="RetiredPipelineSlotsGroup">
                    <queryInherit>/RetiredPipelineSlots_socsmall</queryInherit>
                    <displayAttributes>
                        <boolean:expand>false</boolean:expand>
                        <boolean:allowCollapse>true</boolean:allowCollapse>
                    </displayAttributes>
                    <expand>
                        <vectorQuery id="RetiredPipelineSlotsGroupExpanded">
                            <derivedQuery id="BASEGroup">
                                <queryInherit>/BASE_socsmall</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="BASEGroupExpanded">
                                        <queryRef>/FP_Arith_socsmall</queryRef>
                                        <queryRef>/OTHER_socsmall</queryRef>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <queryRef>/MicroSequencer_socsmall</queryRef>
                        </vectorQuery>
                    </expand>
                </derivedQuery>
                <derivedQuery id="FrontendBoundPipelineSlotsGroup">
                    <queryInherit>/FrontendBoundPipelineSlots_socsmall</queryInherit>
                    <displayAttributes>
                        <boolean:expand>false</boolean:expand>
                        <boolean:allowCollapse>true</boolean:allowCollapse>
                    </displayAttributes>
                    <expand>
                        <vectorQuery id="FrontendBoundPipelineSlotsGroupExpanded">
                            <derivedQuery id="FELatencyGroup">
                                <queryInherit>/FELatency_socsmall</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="FELatencyGroupExpanded">
                                        <queryRef>/ICacheMisses_socsmall</queryRef>
                                        <queryRef>/ITLBOverhead_socsmall</queryRef>
                                        <queryRef>/BACLEARS_socsmall</queryRef>
                                        <queryRef>/BranchResteers_socsmall</queryRef>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <derivedQuery id="FEBandwidthGroup">
                                <queryInherit>/FEBandwidth_socsmall</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="FEBandwidthGroupExpanded">
                                        <queryRef>/FEBandwidthCisc_socsmall</queryRef>
                                        <queryRef>/FEBandwidthDecode_socsmall</queryRef>
                                        <queryRef>/PreDecodeWrong_socsmall</queryRef>
                                        <queryRef>/FEOther_socsmall</queryRef>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                        </vectorQuery>
                    </expand>
                </derivedQuery>
                <derivedQuery id="CancelledPipelineSlotsGroup">
                    <queryInherit>/CancelledPipelineSlots_socsmall</queryInherit>
                    <displayAttributes>
                        <boolean:expand>false</boolean:expand>
                        <boolean:allowCollapse>true</boolean:allowCollapse>
                    </displayAttributes>
                    <expand>
                        <vectorQuery id="CancelledPipelineSlotsGroupExpanded">
                            <queryRef>/BranchMispredict_socsmall</queryRef>
                            <derivedQuery id="MachineClearsGroup">
                                <queryInherit>/MachineClears_socsmall</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="MachineClearsGroupExpanded">
                                        <derivedQuery id="MachineClearsNukeGroup">
                                            <queryInherit>/MachineClearsNuke_socsmall</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="MachineClearsNukeGroupExpanded">
                                                    <queryRef>/SMCMachineClear_socsmall</queryRef>
                                                    <queryRef>/MOMachineClear_socsmall</queryRef>
                                                    <queryRef>/FPAssistMachineClear_socsmall</queryRef>
                                                    <queryRef>/Disambiguation_socsmall</queryRef>
                                                    <queryRef>/PageFaultMachineClear_socsmall</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <queryRef>/FastMachineClear_socsmall</queryRef>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                        </vectorQuery>
                    </expand>
                </derivedQuery>
                <derivedQuery id="BackendBoundGroup">
                    <queryInherit>/BackendBound_socsmall</queryInherit>
                    <displayAttributes>
                        <boolean:expand>false</boolean:expand>
                        <boolean:allowCollapse>true</boolean:allowCollapse>
                    </displayAttributes>
                    <expand>
                        <vectorQuery id="BackendBoundGroupExpanded">
                            <queryRef>/CoreBound_socsmall</queryRef>
                            <derivedQuery id="MemBoundGroup">
                                <queryInherit>/MemBound_socsmall</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="MemBoundGroupExpanded">
                                        <queryRef>/StoresBound_socsmall</queryRef>
                                        <derivedQuery id="L1BoundGroup">
                                            <queryInherit>/L1Bound_socsmall</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="L1BoundGroupExpanded">
                                                    <queryRef>/LoadsBlockedbyStoreForwarding_socsmall</queryRef>
                                                    <queryRef>/Load_STLB_Hit_socsmall</queryRef>
                                                    <queryRef>/Load_STLB_Miss_socsmall</queryRef>
                                                    <queryRef>/OtherL1_socsmall</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <queryRef>/L2Bound_socsmall</queryRef>
                                        <queryRef>/L3Bound_socsmall</queryRef>
                                        <queryRef>/DRAMBound_socsmall</queryRef>
                                        <queryRef>/OtherLoadStore_socsmall</queryRef>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                        </vectorQuery>
                    </expand>
                </derivedQuery>
                <derivedQuery id="BackendBoundAuxGroup">
                    <queryInherit>/BackendBoundAux_socsmall</queryInherit>
                    <displayAttributes>
                        <boolean:expand>false</boolean:expand>
                        <boolean:allowCollapse>true</boolean:allowCollapse>
                    </displayAttributes>
                    <expand>
                        <vectorQuery id="BackendBoundAuxGroupExpanded">
                            <derivedQuery id="ResourceBoundGroup">
                                <queryInherit>/ResourceBound_socsmall</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="ResourceBoundGroupExpanded">
                                        <derivedQuery id="MemorySchedulerGroup">
                                            <queryInherit>/MemoryScheduler_socsmall</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="MemorySchedulerGroupExpanded">
                                                    <queryRef>/STBuffer_socsmall</queryRef>
                                                    <queryRef>/LDBuffer_socsmall</queryRef>
                                                    <queryRef>/RSV_socsmall</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <queryRef>/NonMemoryScheduler_socsmall</queryRef>
                                        <queryRef>/BERegister_socsmall</queryRef>
                                        <queryRef>/BEReorderBuffer_socsmall</queryRef>
                                        <queryRef>/BEAllocRestriction_socsmall</queryRef>
                                        <queryRef>/Serializing_Operation_socsmall</queryRef>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                        </vectorQuery>
                    </expand>
                </derivedQuery>
            </vectorQuery>
            <queryLibrary>
                <derivedQuery displayName="%RetiredPipelineSlots" id="RetiredPipelineSlots_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%RetiredPipelineSlotsDescriptionAll</description>
                    <helpKeyword>configs.retiredpipelineslots_retiredpipelineslotsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") / query("/SLOTS_socsmall") ) ]]></valueEval>
                    <issueText>%RetiredPipelineSlotsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/RetiredPipelineSlots_socsmall") >0.75 ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $FALSE ) ]]></minIsBetterEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%BASE" id="BASE_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%BASEDescriptionAll</description>
                    <helpKeyword>configs.base_basedescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") - query("/PMUEventCount/PMUEventType[UOPS_RETIRED.MS]/PMUCoreType[LPE-Core]") ) / query("/SLOTS_socsmall") ) ]]></valueEval>
                    <issueText>%BASEIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/BASE_socsmall") >0.60 ) ) && ( ( query("/RetiredPipelineSlots_socsmall") >0.75 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.60 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]/PMUCoreType[LPE-Core]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Arith" id="FP_Arith_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FP_ArithDescriptionAll</description>
                    <helpKeyword>configs.fp_arith_fp_arithdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[UOPS_RETIRED.FPDIV]/PMUCoreType[LPE-Core]") / query("/SLOTS_socsmall") ) ]]></valueEval>
                    <issueText>%FP_ArithIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/FP_Arith_socsmall") >0.20 ) ) && ( ( query("/BASE_socsmall") >0.60 ) && ( query("/RetiredPipelineSlots_socsmall") >0.75 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.20 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.FPDIV]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%OTHER" id="OTHER_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%OTHERDescriptionAll</description>
                    <helpKeyword>configs.other_otherdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") - query("/PMUEventCount/PMUEventType[UOPS_RETIRED.MS]/PMUCoreType[LPE-Core]") - query("/PMUEventCount/PMUEventType[UOPS_RETIRED.FPDIV]/PMUCoreType[LPE-Core]") ) / query("/SLOTS_socsmall") ) ]]></valueEval>
                    <issueText>%OTHERIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/OTHER_socsmall") >0.30 ) ) && ( ( query("/BASE_socsmall") >0.60 ) && ( query("/RetiredPipelineSlots_socsmall") >0.75 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.30 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.FPDIV]/PMUCoreType[LPE-Core]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%MicroSequencer" id="MicroSequencer_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%MicroSequencerDescriptionAll</description>
                    <helpKeyword>configs.microsequencer_microsequencerdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[UOPS_RETIRED.MS]/PMUCoreType[LPE-Core]") / query("/SLOTS_socsmall") ) ]]></valueEval>
                    <issueText>%MicroSequencerIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/MicroSequencer_socsmall") >0.05 ) ) && ( ( query("/RetiredPipelineSlots_socsmall") >0.75 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FrontendBoundPipelineSlots" id="FrontendBoundPipelineSlots_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FrontendBoundPipelineSlotsDescriptionAll</description>
                    <helpKeyword>configs.frontendboundpipelineslots_frontendboundpipelineslotsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") / query("/SLOTS_socsmall") ) ]]></valueEval>
                    <issueText>%FrontendBoundPipelineSlotsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/FrontendBoundPipelineSlots_socsmall") >0.20 ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.20 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FELatency" id="FELatency_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FELatencyDescriptionAll</description>
                    <helpKeyword>configs.felatency_felatencydescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_FE_BOUND.FRONTEND_LATENCY]/PMUCoreType[LPE-Core]") / query("/SLOTS_socsmall") ) ]]></valueEval>
                    <issueText>%FELatencyIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/FELatency_socsmall") >0.15 ) ) && ( ( query("/FrontendBoundPipelineSlots_socsmall") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.15 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.FRONTEND_LATENCY]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%ICacheMisses" id="ICacheMisses_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%ICacheMissesDescriptionAll</description>
                    <helpKeyword>configs.icachemisses_icachemissesdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_FE_BOUND.ICACHE]/PMUCoreType[LPE-Core]") / query("/SLOTS_socsmall") ) ]]></valueEval>
                    <issueText>%ICacheMissesIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/ICacheMisses_socsmall") >0.05 ) ) && ( ( query("/FELatency_socsmall") >0.15 ) && ( query("/FrontendBoundPipelineSlots_socsmall") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ICACHE]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%ITLBOverhead" id="ITLBOverhead_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%ITLBOverheadDescriptionAll</description>
                    <helpKeyword>configs.itlboverhead_itlboverheaddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_FE_BOUND.ITLB]/PMUCoreType[LPE-Core]") / query("/SLOTS_socsmall") ) ]]></valueEval>
                    <issueText>%ITLBOverheadIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/ITLBOverhead_socsmall") >0.05 ) ) && ( ( query("/FELatency_socsmall") >0.15 ) && ( query("/FrontendBoundPipelineSlots_socsmall") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ITLB]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%BACLEARS" id="BACLEARS_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%BACLEARSDescriptionAll</description>
                    <helpKeyword>configs.baclears_baclearsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_FE_BOUND.BRANCH_DETECT]/PMUCoreType[LPE-Core]") / query("/SLOTS_socsmall") ) ]]></valueEval>
                    <issueText>%BACLEARSIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/BACLEARS_socsmall") >0.05 ) ) && ( ( query("/FELatency_socsmall") >0.15 ) && ( query("/FrontendBoundPipelineSlots_socsmall") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.BRANCH_DETECT]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%BranchResteers" id="BranchResteers_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%BranchResteersDescriptionAll</description>
                    <helpKeyword>configs.branchresteers_branchresteersdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_FE_BOUND.BRANCH_RESTEER]/PMUCoreType[LPE-Core]") / query("/SLOTS_socsmall") ) ]]></valueEval>
                    <issueText>%BranchResteersIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/BranchResteers_socsmall") >0.05 ) ) && ( ( query("/FELatency_socsmall") >0.15 ) && ( query("/FrontendBoundPipelineSlots_socsmall") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.BRANCH_RESTEER]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FEBandwidth" id="FEBandwidth_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FEBandwidthDescriptionAll</description>
                    <helpKeyword>configs.febandwidth_febandwidthdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_FE_BOUND.FRONTEND_BANDWIDTH]/PMUCoreType[LPE-Core]") / query("/SLOTS_socsmall") ) ]]></valueEval>
                    <issueText>%FEBandwidthIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/FEBandwidth_socsmall") >0.10 ) ) && ( ( query("/FrontendBoundPipelineSlots_socsmall") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.FRONTEND_BANDWIDTH]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FEBandwidthCisc" id="FEBandwidthCisc_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FEBandwidthCiscDescriptionAll</description>
                    <helpKeyword>configs.febandwidthcisc_febandwidthciscdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_FE_BOUND.CISC]/PMUCoreType[LPE-Core]") / query("/SLOTS_socsmall") ) ]]></valueEval>
                    <issueText>%FEBandwidthCiscIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/FEBandwidthCisc_socsmall") >0.05 ) ) && ( ( query("/FEBandwidth_socsmall") >0.10 ) && ( query("/FrontendBoundPipelineSlots_socsmall") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.CISC]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FEBandwidthDecode" id="FEBandwidthDecode_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FEBandwidthDecodeDescriptionAll</description>
                    <helpKeyword>configs.febandwidthdecode_febandwidthdecodedescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_FE_BOUND.DECODE]/PMUCoreType[LPE-Core]") / query("/SLOTS_socsmall") ) ]]></valueEval>
                    <issueText>%FEBandwidthDecodeIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/FEBandwidthDecode_socsmall") >0.05 ) ) && ( ( query("/FEBandwidth_socsmall") >0.10 ) && ( query("/FrontendBoundPipelineSlots_socsmall") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.DECODE]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%PreDecodeWrong" id="PreDecodeWrong_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%PreDecodeWrongDescriptionAll</description>
                    <helpKeyword>configs.predecodewrong_predecodewrongdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_FE_BOUND.PREDECODE]/PMUCoreType[LPE-Core]") / query("/SLOTS_socsmall") ) ]]></valueEval>
                    <issueText>%PreDecodeWrongIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/PreDecodeWrong_socsmall") >0.05 ) ) && ( ( query("/FEBandwidth_socsmall") >0.10 ) && ( query("/FrontendBoundPipelineSlots_socsmall") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.PREDECODE]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FEOther" id="FEOther_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FEOtherDescriptionAll</description>
                    <helpKeyword>configs.feother_feotherdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_FE_BOUND.OTHER]/PMUCoreType[LPE-Core]") / query("/SLOTS_socsmall") ) ]]></valueEval>
                    <issueText>%FEOtherIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/FEOther_socsmall") >0.05 ) ) && ( ( query("/FEBandwidth_socsmall") >0.10 ) && ( query("/FrontendBoundPipelineSlots_socsmall") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.OTHER]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%CancelledPipelineSlots" id="CancelledPipelineSlots_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%CancelledPipelineSlotsDescriptionAll</description>
                    <helpKeyword>configs.cancelledpipelineslots_cancelledpipelineslotsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") / query("/SLOTS_socsmall") ) ]]></valueEval>
                    <issueText>%CancelledPipelineSlotsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/CancelledPipelineSlots_socsmall") >0.15 ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.15 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%BranchMispredict" id="BranchMispredict_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%BranchMispredictDescriptionAll</description>
                    <helpKeyword>configs.branchmispredict_branchmispredictdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_BAD_SPECULATION.MISPREDICT]/PMUCoreType[LPE-Core]") / query("/SLOTS_socsmall") ) ]]></valueEval>
                    <issueText>%BranchMispredictIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/BranchMispredict_socsmall") >0.05 ) ) && ( ( query("/CancelledPipelineSlots_socsmall") >0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.MISPREDICT]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%MachineClears" id="MachineClears_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%MachineClearsDescriptionAll</description>
                    <helpKeyword>configs.machineclears_machineclearsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_BAD_SPECULATION.MACHINE_CLEARS]/PMUCoreType[LPE-Core]") / query("/SLOTS_socsmall") ) ]]></valueEval>
                    <issueText>%MachineClearsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/MachineClears_socsmall") >0.05 ) ) && ( ( query("/CancelledPipelineSlots_socsmall") >0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.MACHINE_CLEARS]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%MachineClearsNuke" id="MachineClearsNuke_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%MachineClearsNukeDescriptionAll</description>
                    <helpKeyword>configs.machineclearsnuke_machineclearsnukedescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_BAD_SPECULATION.NUKE]/PMUCoreType[LPE-Core]") / query("/SLOTS_socsmall") ) ]]></valueEval>
                    <issueText>%MachineClearsNukeIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/MachineClearsNuke_socsmall") >0.05 ) ) && ( ( query("/MachineClears_socsmall") >0.05 ) && ( query("/CancelledPipelineSlots_socsmall") >0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.NUKE]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%SMCMachineClear" id="SMCMachineClear_socsmall">
                    <description>%SMCMachineClearDescriptionAll</description>
                    <helpKeyword>configs.smcmachineclear_smcmachinecleardescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/MachineClearsNuke_socsmall") * ( query("/PMUEventCount/PMUEventType[MACHINE_CLEARS.SMC]/PMUCoreType[LPE-Core]") / query("/PMUEventCount/PMUEventType[MACHINE_CLEARS.SLOW]/PMUCoreType[LPE-Core]") ) ) ]]></valueEval>
                    <issueText>%SMCMachineClearIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/SMCMachineClear_socsmall") >0.02 ) ) && ( ( query("/MachineClearsNuke_socsmall") >0.05 ) && ( query("/MachineClears_socsmall") >0.05 ) && ( query("/CancelledPipelineSlots_socsmall") >0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.02 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.NUKE]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.SMC]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.SLOW]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%MOMachineClear" id="MOMachineClear_socsmall">
                    <description>%MOMachineClearDescriptionAll</description>
                    <helpKeyword>configs.momachineclear_momachinecleardescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/MachineClearsNuke_socsmall") * ( query("/PMUEventCount/PMUEventType[MACHINE_CLEARS.MEMORY_ORDERING]/PMUCoreType[LPE-Core]") / query("/PMUEventCount/PMUEventType[MACHINE_CLEARS.SLOW]/PMUCoreType[LPE-Core]") ) ) ]]></valueEval>
                    <issueText>%MOMachineClearIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/MOMachineClear_socsmall") >0.02 ) ) && ( ( query("/MachineClearsNuke_socsmall") >0.05 ) && ( query("/MachineClears_socsmall") >0.05 ) && ( query("/CancelledPipelineSlots_socsmall") >0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.02 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.NUKE]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.MEMORY_ORDERING]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.SLOW]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FPAssistMachineClear" id="FPAssistMachineClear_socsmall">
                    <description>%FPAssistMachineClearDescriptionAll</description>
                    <helpKeyword>configs.fpassistmachineclear_fpassistmachinecleardescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/MachineClearsNuke_socsmall") * ( query("/PMUEventCount/PMUEventType[MACHINE_CLEARS.FP_ASSIST]/PMUCoreType[LPE-Core]") / query("/PMUEventCount/PMUEventType[MACHINE_CLEARS.SLOW]/PMUCoreType[LPE-Core]") ) ) ]]></valueEval>
                    <issueText>%FPAssistMachineClearIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/FPAssistMachineClear_socsmall") >0.02 ) ) && ( ( query("/MachineClearsNuke_socsmall") >0.05 ) && ( query("/MachineClears_socsmall") >0.05 ) && ( query("/CancelledPipelineSlots_socsmall") >0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.02 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.NUKE]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.FP_ASSIST]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.SLOW]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Disambiguation" id="Disambiguation_socsmall">
                    <description>%DisambiguationDescriptionAll</description>
                    <helpKeyword>configs.disambiguation_disambiguationdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/MachineClearsNuke_socsmall") * ( query("/PMUEventCount/PMUEventType[MACHINE_CLEARS.DISAMBIGUATION]/PMUCoreType[LPE-Core]") / query("/PMUEventCount/PMUEventType[MACHINE_CLEARS.SLOW]/PMUCoreType[LPE-Core]") ) ) ]]></valueEval>
                    <issueText>%DisambiguationIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/Disambiguation_socsmall") >0.02 ) ) && ( ( query("/MachineClearsNuke_socsmall") >0.05 ) && ( query("/MachineClears_socsmall") >0.05 ) && ( query("/CancelledPipelineSlots_socsmall") >0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.02 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.NUKE]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.DISAMBIGUATION]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.SLOW]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%PageFaultMachineClear" id="PageFaultMachineClear_socsmall">
                    <description>%PageFaultMachineClearDescriptionAll</description>
                    <helpKeyword>configs.pagefaultmachineclear_pagefaultmachinecleardescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/MachineClearsNuke_socsmall") * ( query("/PMUEventCount/PMUEventType[MACHINE_CLEARS.PAGE_FAULT]/PMUCoreType[LPE-Core]") / query("/PMUEventCount/PMUEventType[MACHINE_CLEARS.SLOW]/PMUCoreType[LPE-Core]") ) ) ]]></valueEval>
                    <issueText>%PageFaultMachineClearIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/PageFaultMachineClear_socsmall") >0.02 ) ) && ( ( query("/MachineClearsNuke_socsmall") >0.05 ) && ( query("/MachineClears_socsmall") >0.05 ) && ( query("/CancelledPipelineSlots_socsmall") >0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.02 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.NUKE]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.PAGE_FAULT]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.SLOW]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%FastMachineClear" id="FastMachineClear_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%FastMachineClearDescriptionAll</description>
                    <helpKeyword>configs.fastmachineclear_fastmachinecleardescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_BAD_SPECULATION.FASTNUKE]/PMUCoreType[LPE-Core]") / query("/SLOTS_socsmall") ) ]]></valueEval>
                    <issueText>%FastMachineClearIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/FastMachineClear_socsmall") >0.05 ) ) && ( ( query("/MachineClears_socsmall") >0.05 ) && ( query("/CancelledPipelineSlots_socsmall") >0.15 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.FASTNUKE]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%BackendBound" id="BackendBound_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%BackendBoundDescriptionAll</description>
                    <helpKeyword>configs.backendbound_backendbounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]/PMUCoreType[LPE-Core]") / query("/SLOTS_socsmall") ) ]]></valueEval>
                    <issueText>%BackendBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/BackendBound_socsmall") >0.10 ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%CoreBound" id="CoreBound_socsmall">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%CoreBoundDescriptionAll</description>
                    <helpKeyword>configs.corebound_corebounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/BackendBound_socsmall") - query("/MemBound_socsmall") if query("/BackendBound_socsmall") - query("/MemBound_socsmall") > 0 else 0 ) ]]></valueEval>
                    <issueText>%CoreBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/CoreBound_socsmall") >0.10 ) ) && ( ( query("/BackendBound_socsmall") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) / SLOTS ) < ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.ANY_AT_RET]/PMUCoreType[LPE-Core]") ) / query("/DerivedClockticks_socsmall") ) + query("/StoresBound_socsmall") ) ) ) else ( ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.ANY_AT_RET]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/MemBound_socsmall") ) > 0 ) ) else ( 0 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%MemBound" id="MemBound_socsmall">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%MemBoundDescriptionAll</description>
                    <helpKeyword>configs.membound_membounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]/PMUCoreType[LPE-Core]") / query("/SLOTS_socsmall") ) if ( query("/PMUEventCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]/PMUCoreType[LPE-Core]") / query("/SLOTS_socsmall") ) < ( ( query("/PMUEventCount/PMUEventType[LD_HEAD.ANY_AT_RET]/PMUCoreType[LPE-Core]") / query("/DerivedClockticks_socsmall") ) + query("/StoresBound_socsmall") ) else ( ( query("/PMUEventCount/PMUEventType[LD_HEAD.ANY_AT_RET]/PMUCoreType[LPE-Core]") / query("/DerivedClockticks_socsmall") ) + query("/StoresBound_socsmall") ) ) ]]></valueEval>
                    <issueText>%MemBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/MemBound_socsmall") >0.20 ) ) && ( ( query("/BackendBound_socsmall") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.20 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) / SLOTS ) < ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.ANY_AT_RET]/PMUCoreType[LPE-Core]") ) / query("/DerivedClockticks_socsmall") ) + query("/StoresBound_socsmall") ) ) ) else ( ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.ANY_AT_RET]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%StoresBound" id="StoresBound_socsmall">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%StoresBoundDescriptionAll</description>
                    <helpKeyword>configs.storesbound_storesbounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/MemoryScheduler_socsmall") * ( query("/PMUEventCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") / query("/PMUEventCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ]]></valueEval>
                    <issueText>%StoresBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/StoresBound_socsmall") >0.10 ) ) && ( ( query("/MemBound_socsmall") >0.20 ) && ( query("/BackendBound_socsmall") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%L1Bound" id="L1Bound_socsmall">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%L1BoundDescriptionAll</description>
                    <helpKeyword>configs.l1bound_l1bounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") / query("/DerivedClockticks_socsmall") ) ]]></valueEval>
                    <issueText>%L1BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/L1Bound_socsmall") >0.10 ) ) && ( ( query("/MemBound_socsmall") >0.20 ) && ( query("/BackendBound_socsmall") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%LoadsBlockedbyStoreForwarding" id="LoadsBlockedbyStoreForwarding_socsmall">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%LoadsBlockedbyStoreForwardingDescriptionAll</description>
                    <helpKeyword>configs.loadsblockedbystoreforwarding_loadsblockedbystoreforwardingdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[LD_HEAD.ST_ADDR_AT_RET]/PMUCoreType[LPE-Core]") / query("/DerivedClockticks_socsmall") ) ]]></valueEval>
                    <issueText>%LoadsBlockedbyStoreForwardingIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/LoadsBlockedbyStoreForwarding_socsmall") >0.05 ) ) && ( ( query("/L1Bound_socsmall") >0.10 ) && ( query("/MemBound_socsmall") >0.20 ) && ( query("/BackendBound_socsmall") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.ST_ADDR_AT_RET]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Load_STLB_Hit" id="Load_STLB_Hit_socsmall">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Load_STLB_HitDescriptionAll</description>
                    <helpKeyword>configs.load_stlb_hit_load_stlb_hitdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[LD_HEAD.DTLB_MISS_AT_RET]/PMUCoreType[LPE-Core]") / query("/DerivedClockticks_socsmall") ) ]]></valueEval>
                    <issueText>%Load_STLB_HitIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/Load_STLB_Hit_socsmall") >0.05 ) ) && ( ( query("/L1Bound_socsmall") >0.10 ) && ( query("/MemBound_socsmall") >0.20 ) && ( query("/BackendBound_socsmall") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.DTLB_MISS_AT_RET]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Load_STLB_Miss" id="Load_STLB_Miss_socsmall">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%Load_STLB_MissDescriptionAll</description>
                    <helpKeyword>configs.load_stlb_miss_load_stlb_missdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[LD_HEAD.PGWALK_AT_RET]/PMUCoreType[LPE-Core]") / query("/DerivedClockticks_socsmall") ) ]]></valueEval>
                    <issueText>%Load_STLB_MissIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/Load_STLB_Miss_socsmall") >0.05 ) ) && ( ( query("/L1Bound_socsmall") >0.10 ) && ( query("/MemBound_socsmall") >0.20 ) && ( query("/BackendBound_socsmall") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.PGWALK_AT_RET]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%OtherL1" id="OtherL1_socsmall">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%OtherL1DescriptionAll</description>
                    <helpKeyword>configs.otherl1_otherl1descriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[LD_HEAD.OTHER_AT_RET]/PMUCoreType[LPE-Core]") / query("/DerivedClockticks_socsmall") ) ]]></valueEval>
                    <issueText>%OtherL1IssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/OtherL1_socsmall") >0.05 ) ) && ( ( query("/L1Bound_socsmall") >0.10 ) && ( query("/MemBound_socsmall") >0.20 ) && ( query("/BackendBound_socsmall") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.OTHER_AT_RET]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%L2Bound" id="L2Bound_socsmall">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%L2BoundDescriptionAll</description>
                    <helpKeyword>configs.l2bound_l2bounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS_LOAD.L2_HIT]/PMUCoreType[LPE-Core]") / query("/DerivedClockticks_socsmall") ) - ( query("/MEM_BOUND_STALLS_AT_RET_CORRECTION_socsmall") * query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS_LOAD.L2_HIT]/PMUCoreType[LPE-Core]") / query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) ) ]]></valueEval>
                    <issueText>%L2BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/L2Bound_socsmall") >0.10 ) ) && ( ( query("/MemBound_socsmall") >0.20 ) && ( query("/BackendBound_socsmall") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.L2_HIT]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]/PMUCoreType[LPE-Core]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") >= 10 ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) - ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]/PMUCoreType[LPE-Core]") ) ) / query("/DerivedClockticks_socsmall") ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.L2_HIT]/PMUCoreType[LPE-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%L3Bound" id="L3Bound_socsmall">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%L3BoundDescriptionAll</description>
                    <helpKeyword>configs.l3bound_l3bounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_HIT]/PMUCoreType[LPE-Core]") / query("/DerivedClockticks_socsmall") ) - ( query("/MEM_BOUND_STALLS_AT_RET_CORRECTION_socsmall") * query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_HIT]/PMUCoreType[LPE-Core]") / query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) ) ]]></valueEval>
                    <issueText>%L3BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/L3Bound_socsmall") >0.10 ) ) && ( ( query("/MemBound_socsmall") >0.20 ) && ( query("/BackendBound_socsmall") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_HIT]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]/PMUCoreType[LPE-Core]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") >= 10 ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) - ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]/PMUCoreType[LPE-Core]") ) ) / query("/DerivedClockticks_socsmall") ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_HIT]/PMUCoreType[LPE-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%DRAMBound" id="DRAMBound_socsmall">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%DRAMBoundDescriptionAll</description>
                    <helpKeyword>configs.drambound_drambounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_MISS]/PMUCoreType[LPE-Core]") / query("/DerivedClockticks_socsmall") ) - ( query("/MEM_BOUND_STALLS_AT_RET_CORRECTION_socsmall") * query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_MISS]/PMUCoreType[LPE-Core]") / query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) ) ]]></valueEval>
                    <issueText>%DRAMBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/DRAMBound_socsmall") >0.10 ) ) && ( ( query("/MemBound_socsmall") >0.20 ) && ( query("/BackendBound_socsmall") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_MISS]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]/PMUCoreType[LPE-Core]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") >= 10 ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) - ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]/PMUCoreType[LPE-Core]") ) ) / query("/DerivedClockticks_socsmall") ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_MISS]/PMUCoreType[LPE-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%OtherLoadStore" id="OtherLoadStore_socsmall">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%OtherLoadStoreDescriptionAll</description>
                    <helpKeyword>configs.otherloadstore_otherloadstoredescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/MemBound_socsmall") - ( query("/StoresBound_socsmall") + query("/L1Bound_socsmall") + query("/L2Bound_socsmall") + query("/L3Bound_socsmall") + query("/DRAMBound_socsmall") ) if query("/MemBound_socsmall") - ( query("/StoresBound_socsmall") + query("/L1Bound_socsmall") + query("/L2Bound_socsmall") + query("/L3Bound_socsmall") + query("/DRAMBound_socsmall") ) > 0 else 0 ) ]]></valueEval>
                    <issueText>%OtherLoadStoreIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/OtherLoadStore_socsmall") >0.10 ) ) && ( ( query("/MemBound_socsmall") >0.20 ) && ( query("/BackendBound_socsmall") >0.10 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) / SLOTS ) < ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.ANY_AT_RET]/PMUCoreType[LPE-Core]") ) / query("/DerivedClockticks_socsmall") ) + query("/StoresBound_socsmall") ) ) ) else ( ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.ANY_AT_RET]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) ) || ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.L2_HIT]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]/PMUCoreType[LPE-Core]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") >= 10 ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) - ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]/PMUCoreType[LPE-Core]") ) ) / query("/DerivedClockticks_socsmall") ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.L2_HIT]/PMUCoreType[LPE-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_HIT]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]/PMUCoreType[LPE-Core]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") >= 10 ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) - ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]/PMUCoreType[LPE-Core]") ) ) / query("/DerivedClockticks_socsmall") ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_HIT]/PMUCoreType[LPE-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_MISS]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]/PMUCoreType[LPE-Core]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") >= 10 ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) - ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]/PMUCoreType[LPE-Core]") ) ) / query("/DerivedClockticks_socsmall") ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_MISS]/PMUCoreType[LPE-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) if ( ( ( query("/MemBound_socsmall") - ( ( ( ( query("/StoresBound_socsmall") + query("/L1Bound_socsmall") ) + query("/L2Bound_socsmall") ) + query("/L3Bound_socsmall") ) + query("/DRAMBound_socsmall") ) ) > 0 ) ) else ( 0 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%BackendBoundAux" id="BackendBoundAux_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%BackendBoundAuxDescriptionAll</description>
                    <helpKeyword>configs.backendboundaux_backendboundauxdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/BackendBound_socsmall") ) ]]></valueEval>
                    <issueText>%BackendBoundAuxIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/BackendBoundAux_socsmall") >0.20 ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.20 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%ResourceBound" id="ResourceBound_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%ResourceBoundDescriptionAll</description>
                    <helpKeyword>configs.resourcebound_resourcebounddescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/BackendBound_socsmall") ) ]]></valueEval>
                    <issueText>%ResourceBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/ResourceBound_socsmall") >0.20 ) ) && ( ( query("/BackendBoundAux_socsmall") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.20 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%MemoryScheduler" id="MemoryScheduler_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%MemorySchedulerDescriptionAll</description>
                    <helpKeyword>configs.memoryscheduler_memoryschedulerdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") / query("/SLOTS_socsmall") ) ]]></valueEval>
                    <issueText>%MemorySchedulerIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/MemoryScheduler_socsmall") >0.10 ) ) && ( ( query("/ResourceBound_socsmall") >0.20 ) && ( query("/BackendBoundAux_socsmall") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%STBuffer" id="STBuffer_socsmall">
                    <description>%STBufferDescriptionAll</description>
                    <helpKeyword>configs.stbuffer_stbufferdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/MemoryScheduler_socsmall") * ( query("/PMUEventCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") / query("/PMUEventCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ]]></valueEval>
                    <issueText>%STBufferIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/STBuffer_socsmall") >0.05 ) ) && ( ( query("/MemoryScheduler_socsmall") >0.10 ) && ( query("/ResourceBound_socsmall") >0.20 ) && ( query("/BackendBoundAux_socsmall") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%LDBuffer" id="LDBuffer_socsmall">
                    <description>%LDBufferDescriptionAll</description>
                    <helpKeyword>configs.ldbuffer_ldbufferdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/MemoryScheduler_socsmall") * ( query("/PMUEventCount/PMUEventType[MEM_SCHEDULER_BLOCK.LD_BUF]/PMUCoreType[LPE-Core]") / query("/PMUEventCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ]]></valueEval>
                    <issueText>%LDBufferIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/LDBuffer_socsmall") >0.05 ) ) && ( ( query("/MemoryScheduler_socsmall") >0.10 ) && ( query("/ResourceBound_socsmall") >0.20 ) && ( query("/BackendBoundAux_socsmall") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.LD_BUF]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%RSV" id="RSV_socsmall">
                    <description>%RSVDescriptionAll</description>
                    <helpKeyword>configs.rsv_rsvdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/MemoryScheduler_socsmall") * ( query("/PMUEventCount/PMUEventType[MEM_SCHEDULER_BLOCK.RSV]/PMUCoreType[LPE-Core]") / query("/PMUEventCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") ) ) ]]></valueEval>
                    <issueText>%RSVIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/RSV_socsmall") >0.05 ) ) && ( ( query("/MemoryScheduler_socsmall") >0.10 ) && ( query("/ResourceBound_socsmall") >0.20 ) && ( query("/BackendBoundAux_socsmall") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.05 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.RSV]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%NonMemoryScheduler" id="NonMemoryScheduler_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%NonMemorySchedulerDescriptionAll</description>
                    <helpKeyword>configs.nonmemoryscheduler_nonmemoryschedulerdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_BE_BOUND.NON_MEM_SCHEDULER]/PMUCoreType[LPE-Core]") / query("/SLOTS_socsmall") ) ]]></valueEval>
                    <issueText>%NonMemorySchedulerIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/NonMemoryScheduler_socsmall") >0.10 ) ) && ( ( query("/ResourceBound_socsmall") >0.20 ) && ( query("/BackendBoundAux_socsmall") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.NON_MEM_SCHEDULER]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%BERegister" id="BERegister_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%BERegisterDescriptionAll</description>
                    <helpKeyword>configs.beregister_beregisterdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_BE_BOUND.REGISTER]/PMUCoreType[LPE-Core]") / query("/SLOTS_socsmall") ) ]]></valueEval>
                    <issueText>%BERegisterIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/BERegister_socsmall") >0.10 ) ) && ( ( query("/ResourceBound_socsmall") >0.20 ) && ( query("/BackendBoundAux_socsmall") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.REGISTER]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%BEReorderBuffer" id="BEReorderBuffer_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%BEReorderBufferDescriptionAll</description>
                    <helpKeyword>configs.bereorderbuffer_bereorderbufferdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_BE_BOUND.REORDER_BUFFER]/PMUCoreType[LPE-Core]") / query("/SLOTS_socsmall") ) ]]></valueEval>
                    <issueText>%BEReorderBufferIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/BEReorderBuffer_socsmall") >0.10 ) ) && ( ( query("/ResourceBound_socsmall") >0.20 ) && ( query("/BackendBoundAux_socsmall") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.REORDER_BUFFER]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%BEAllocRestriction" id="BEAllocRestriction_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%BEAllocRestrictionDescriptionAll</description>
                    <helpKeyword>configs.beallocrestriction_beallocrestrictiondescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") / query("/SLOTS_socsmall") ) ]]></valueEval>
                    <issueText>%BEAllocRestrictionIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/BEAllocRestriction_socsmall") >0.10 ) ) && ( ( query("/ResourceBound_socsmall") >0.20 ) && ( query("/BackendBoundAux_socsmall") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Serializing_Operation" id="Serializing_Operation_socsmall">
                    <queryInherit>/GeMetricBaseSlots</queryInherit>
                    <description>%Serializing_OperationDescriptionAll</description>
                    <helpKeyword>configs.serializing_operation_serializing_operationdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/PMUEventCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") / query("/SLOTS_socsmall") ) ]]></valueEval>
                    <issueText>%Serializing_OperationIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( ( query("/Serializing_Operation_socsmall") >0.10 ) ) && ( ( query("/ResourceBound_socsmall") >0.20 ) && ( query("/BackendBoundAux_socsmall") >0.20 ) ) ) ]]></issueEval>
                    <minIsBetterEval>
                        <![CDATA[ ( $TRUE ) ]]></minIsBetterEval>
                    <thresholdEval>
                        <![CDATA[ ( 0.10 ) ]]></thresholdEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%SLOTS" id="SLOTS_socsmall">
                    <queryInherit>/GeMetricBaseClockticks</queryInherit>
                    <description>%SLOTSDescriptionAll</description>
                    <helpKeyword>configs.slots_slotsdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( query("/Pipeline_Width_socsmall") * query("/DerivedClockticks_socsmall") ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( (  ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%Pipeline_Width" id="Pipeline_Width_socsmall">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%Pipeline_WidthDescriptionAll</description>
                    <helpKeyword>configs.pipeline_width_pipeline_widthdescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( 6 ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
                <derivedQuery displayName="%MEM_BOUND_STALLS_AT_RET_CORRECTION" id="MEM_BOUND_STALLS_AT_RET_CORRECTION_socsmall">
                    <queryInherit>/GeMetricBasePercentageNotClockticks</queryInherit>
                    <description>%MEM_BOUND_STALLS_AT_RET_CORRECTIONDescriptionAll</description>
                    <helpKeyword>configs.mem_bound_stalls_at_ret_correction_mem_bound_stalls_at_ret_correctiondescriptionall</helpKeyword>
                    <valueEval>
                        <![CDATA[ ( ( query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") - query("/PMUEventCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]/PMUCoreType[LPE-Core]") ) / query("/DerivedClockticks_socsmall") if ( query("/PMUEventCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") - query("/PMUEventCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]/PMUCoreType[LPE-Core]") ) / query("/DerivedClockticks_socsmall") > 0 else 0 ) ]]></valueEval>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]/PMUCoreType[LPE-Core]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") >= 10 ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) - ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]/PMUCoreType[LPE-Core]") ) ) / query("/DerivedClockticks_socsmall") ) > 0 ) ) else ( 0 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                </derivedQuery>
            </queryLibrary>
            <vectorQuery id="locatorGETopDown_socsmall" xmlns:blob="http://www.intel.com/2009/BagSchema#blob" xmlns:boolean="http://www.w3.org/2001/XMLSchema#boolean" xmlns:byte="http://www.w3.org/2001/XMLSchema#byte" xmlns:double="http://www.w3.org/2001/XMLSchema#double" xmlns:float="http://www.w3.org/2001/XMLSchema#float" xmlns:int="http://www.w3.org/2001/XMLSchema#int" xmlns:long="http://www.w3.org/2001/XMLSchema#long" xmlns:null="http://www.intel.com/2009/BagSchema#null" xmlns:short="http://www.w3.org/2001/XMLSchema#short" xmlns:unsignedByte="http://www.w3.org/2001/XMLSchema#unsignedByte" xmlns:unsignedInt="http://www.w3.org/2001/XMLSchema#unsignedInt" xmlns:unsignedLong="http://www.w3.org/2001/XMLSchema#unsignedLong" xmlns:unsignedShort="http://www.w3.org/2001/XMLSchema#unsignedShort">
                <derivedQuery displayName="Locators" id="LocatorsGridSection">
                    <valueEval>0</valueEval>
                    <valueType>double</valueType>
                    <displayAttributes>
                        <boolean:expand>true</boolean:expand>
                        <boolean:allowCollapse>false</boolean:allowCollapse>
                    </displayAttributes>
                    <expand>
                        <vectorQuery id="LocatorsGridGroup">
                            <derivedQuery id="locatorRetiredPipelineSlotsGroup">
                                <queryInherit>/locatorRetiredPipelineSlots_socsmall</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="locatorRetiredPipelineSlotsGroupExpanded">
                                        <derivedQuery id="locatorBASEGroup">
                                            <queryInherit>/locatorBASE_socsmall</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorBASEGroupExpanded">
                                                    <queryRef>/locatorFP_Arith_socsmall</queryRef>
                                                    <queryRef>/locatorOTHER_socsmall</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <queryRef>/locatorMicroSequencer_socsmall</queryRef>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <derivedQuery id="locatorFrontendBoundPipelineSlotsGroup">
                                <queryInherit>/locatorFrontendBoundPipelineSlots_socsmall</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="locatorFrontendBoundPipelineSlotsGroupExpanded">
                                        <derivedQuery id="locatorFELatencyGroup">
                                            <queryInherit>/locatorFELatency_socsmall</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorFELatencyGroupExpanded">
                                                    <queryRef>/locatorICacheMisses_socsmall</queryRef>
                                                    <queryRef>/locatorITLBOverhead_socsmall</queryRef>
                                                    <queryRef>/locatorBACLEARS_socsmall</queryRef>
                                                    <queryRef>/locatorBranchResteers_socsmall</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                        <derivedQuery id="locatorFEBandwidthGroup">
                                            <queryInherit>/locatorFEBandwidth_socsmall</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorFEBandwidthGroupExpanded">
                                                    <queryRef>/locatorFEBandwidthCisc_socsmall</queryRef>
                                                    <queryRef>/locatorFEBandwidthDecode_socsmall</queryRef>
                                                    <queryRef>/locatorPreDecodeWrong_socsmall</queryRef>
                                                    <queryRef>/locatorFEOther_socsmall</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <derivedQuery id="locatorCancelledPipelineSlotsGroup">
                                <queryInherit>/locatorCancelledPipelineSlots_socsmall</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="locatorCancelledPipelineSlotsGroupExpanded">
                                        <queryRef>/locatorBranchMispredict_socsmall</queryRef>
                                        <derivedQuery id="locatorMachineClearsGroup">
                                            <queryInherit>/locatorMachineClears_socsmall</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorMachineClearsGroupExpanded">
                                                    <derivedQuery id="locatorMachineClearsNukeGroup">
                                                        <queryInherit>/locatorMachineClearsNuke_socsmall</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="locatorMachineClearsNukeGroupExpanded">
                                                                <queryRef>/locatorSMCMachineClear_socsmall</queryRef>
                                                                <queryRef>/locatorMOMachineClear_socsmall</queryRef>
                                                                <queryRef>/locatorFPAssistMachineClear_socsmall</queryRef>
                                                                <queryRef>/locatorDisambiguation_socsmall</queryRef>
                                                                <queryRef>/locatorPageFaultMachineClear_socsmall</queryRef>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                    <queryRef>/locatorFastMachineClear_socsmall</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <derivedQuery id="locatorBackendBoundGroup">
                                <queryInherit>/locatorBackendBound_socsmall</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="locatorBackendBoundGroupExpanded">
                                        <queryRef>/locatorCoreBound_socsmall</queryRef>
                                        <derivedQuery id="locatorMemBoundGroup">
                                            <queryInherit>/locatorMemBound_socsmall</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorMemBoundGroupExpanded">
                                                    <queryRef>/locatorStoresBound_socsmall</queryRef>
                                                    <derivedQuery id="locatorL1BoundGroup">
                                                        <queryInherit>/locatorL1Bound_socsmall</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="locatorL1BoundGroupExpanded">
                                                                <queryRef>/locatorLoadsBlockedbyStoreForwarding_socsmall</queryRef>
                                                                <queryRef>/locatorLoad_STLB_Hit_socsmall</queryRef>
                                                                <queryRef>/locatorLoad_STLB_Miss_socsmall</queryRef>
                                                                <queryRef>/locatorOtherL1_socsmall</queryRef>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                    <queryRef>/locatorL2Bound_socsmall</queryRef>
                                                    <queryRef>/locatorL3Bound_socsmall</queryRef>
                                                    <queryRef>/locatorDRAMBound_socsmall</queryRef>
                                                    <queryRef>/locatorOtherLoadStore_socsmall</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                            <derivedQuery id="locatorBackendBoundAuxGroup">
                                <queryInherit>/locatorBackendBoundAux_socsmall</queryInherit>
                                <displayAttributes>
                                    <boolean:expand>false</boolean:expand>
                                    <boolean:allowCollapse>true</boolean:allowCollapse>
                                </displayAttributes>
                                <expand>
                                    <vectorQuery id="locatorBackendBoundAuxGroupExpanded">
                                        <derivedQuery id="locatorResourceBoundGroup">
                                            <queryInherit>/locatorResourceBound_socsmall</queryInherit>
                                            <displayAttributes>
                                                <boolean:expand>false</boolean:expand>
                                                <boolean:allowCollapse>true</boolean:allowCollapse>
                                            </displayAttributes>
                                            <expand>
                                                <vectorQuery id="locatorResourceBoundGroupExpanded">
                                                    <derivedQuery id="locatorMemorySchedulerGroup">
                                                        <queryInherit>/locatorMemoryScheduler_socsmall</queryInherit>
                                                        <displayAttributes>
                                                            <boolean:expand>false</boolean:expand>
                                                            <boolean:allowCollapse>true</boolean:allowCollapse>
                                                        </displayAttributes>
                                                        <expand>
                                                            <vectorQuery id="locatorMemorySchedulerGroupExpanded">
                                                                <queryRef>/locatorSTBuffer_socsmall</queryRef>
                                                                <queryRef>/locatorLDBuffer_socsmall</queryRef>
                                                                <queryRef>/locatorRSV_socsmall</queryRef>
                                                            </vectorQuery>
                                                        </expand>
                                                    </derivedQuery>
                                                    <queryRef>/locatorNonMemoryScheduler_socsmall</queryRef>
                                                    <queryRef>/locatorBERegister_socsmall</queryRef>
                                                    <queryRef>/locatorBEReorderBuffer_socsmall</queryRef>
                                                    <queryRef>/locatorBEAllocRestriction_socsmall</queryRef>
                                                    <queryRef>/locatorSerializing_Operation_socsmall</queryRef>
                                                </vectorQuery>
                                            </expand>
                                        </derivedQuery>
                                    </vectorQuery>
                                </expand>
                            </derivedQuery>
                        </vectorQuery>
                    </expand>
                </derivedQuery>
            </vectorQuery>
            <locatorqueryLibrary>
                <derivedQuery displayName="%RetiredPipelineSlots" id="locatorRetiredPipelineSlots_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%RetiredPipelineSlotsDescriptionAll</description>
                    <helpKeyword>configs.retiredpipelineslots_retiredpipelineslotsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/RetiredPipelineSlots_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%RetiredPipelineSlotsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorRetiredPipelineSlots") >0.75 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%BASE" id="locatorBASE_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%BASEDescriptionAll</description>
                    <helpKeyword>configs.base_basedescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]/PMUCoreType[LPE-Core]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/BASE_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%BASEIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorBASE") >0.60 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FP_Arith" id="locatorFP_Arith_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FP_ArithDescriptionAll</description>
                    <helpKeyword>configs.fp_arith_fp_arithdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.FPDIV]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FP_Arith_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%FP_ArithIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFP_Arith") >0.20 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%OTHER" id="locatorOTHER_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%OTHERDescriptionAll</description>
                    <helpKeyword>configs.other_otherdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_RETIRING.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.FPDIV]/PMUCoreType[LPE-Core]") >= 10 ) ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/OTHER_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%OTHERIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorOTHER") >0.30 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%MicroSequencer" id="locatorMicroSequencer_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MicroSequencerDescriptionAll</description>
                    <helpKeyword>configs.microsequencer_microsequencerdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[UOPS_RETIRED.MS]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/MicroSequencer_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%MicroSequencerIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMicroSequencer") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FrontendBoundPipelineSlots" id="locatorFrontendBoundPipelineSlots_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FrontendBoundPipelineSlotsDescriptionAll</description>
                    <helpKeyword>configs.frontendboundpipelineslots_frontendboundpipelineslotsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ALL]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FrontendBoundPipelineSlots_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%FrontendBoundPipelineSlotsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFrontendBoundPipelineSlots") >0.20 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FELatency" id="locatorFELatency_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FELatencyDescriptionAll</description>
                    <helpKeyword>configs.felatency_felatencydescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.FRONTEND_LATENCY]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FELatency_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%FELatencyIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFELatency") >0.15 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%ICacheMisses" id="locatorICacheMisses_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%ICacheMissesDescriptionAll</description>
                    <helpKeyword>configs.icachemisses_icachemissesdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ICACHE]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/ICacheMisses_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%ICacheMissesIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorICacheMisses") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%ITLBOverhead" id="locatorITLBOverhead_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%ITLBOverheadDescriptionAll</description>
                    <helpKeyword>configs.itlboverhead_itlboverheaddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.ITLB]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/ITLBOverhead_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%ITLBOverheadIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorITLBOverhead") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%BACLEARS" id="locatorBACLEARS_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%BACLEARSDescriptionAll</description>
                    <helpKeyword>configs.baclears_baclearsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.BRANCH_DETECT]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/BACLEARS_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%BACLEARSIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorBACLEARS") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%BranchResteers" id="locatorBranchResteers_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%BranchResteersDescriptionAll</description>
                    <helpKeyword>configs.branchresteers_branchresteersdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.BRANCH_RESTEER]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/BranchResteers_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%BranchResteersIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorBranchResteers") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FEBandwidth" id="locatorFEBandwidth_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FEBandwidthDescriptionAll</description>
                    <helpKeyword>configs.febandwidth_febandwidthdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.FRONTEND_BANDWIDTH]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FEBandwidth_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%FEBandwidthIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFEBandwidth") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FEBandwidthCisc" id="locatorFEBandwidthCisc_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FEBandwidthCiscDescriptionAll</description>
                    <helpKeyword>configs.febandwidthcisc_febandwidthciscdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.CISC]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FEBandwidthCisc_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%FEBandwidthCiscIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFEBandwidthCisc") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FEBandwidthDecode" id="locatorFEBandwidthDecode_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FEBandwidthDecodeDescriptionAll</description>
                    <helpKeyword>configs.febandwidthdecode_febandwidthdecodedescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.DECODE]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FEBandwidthDecode_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%FEBandwidthDecodeIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFEBandwidthDecode") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%PreDecodeWrong" id="locatorPreDecodeWrong_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%PreDecodeWrongDescriptionAll</description>
                    <helpKeyword>configs.predecodewrong_predecodewrongdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.PREDECODE]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/PreDecodeWrong_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%PreDecodeWrongIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorPreDecodeWrong") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FEOther" id="locatorFEOther_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FEOtherDescriptionAll</description>
                    <helpKeyword>configs.feother_feotherdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_FE_BOUND.OTHER]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FEOther_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%FEOtherIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFEOther") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%CancelledPipelineSlots" id="locatorCancelledPipelineSlots_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%CancelledPipelineSlotsDescriptionAll</description>
                    <helpKeyword>configs.cancelledpipelineslots_cancelledpipelineslotsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.ALL]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/CancelledPipelineSlots_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%CancelledPipelineSlotsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorCancelledPipelineSlots") >0.15 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%BranchMispredict" id="locatorBranchMispredict_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%BranchMispredictDescriptionAll</description>
                    <helpKeyword>configs.branchmispredict_branchmispredictdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.MISPREDICT]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/BranchMispredict_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%BranchMispredictIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorBranchMispredict") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%MachineClears" id="locatorMachineClears_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MachineClearsDescriptionAll</description>
                    <helpKeyword>configs.machineclears_machineclearsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.MACHINE_CLEARS]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/MachineClears_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%MachineClearsIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMachineClears") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%MachineClearsNuke" id="locatorMachineClearsNuke_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MachineClearsNukeDescriptionAll</description>
                    <helpKeyword>configs.machineclearsnuke_machineclearsnukedescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.NUKE]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/MachineClearsNuke_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%MachineClearsNukeIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMachineClearsNuke") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%SMCMachineClear" id="locatorSMCMachineClear_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%SMCMachineClearDescriptionAll</description>
                    <helpKeyword>configs.smcmachineclear_smcmachinecleardescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.NUKE]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.SMC]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.SLOW]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/SMCMachineClear_socsmall") ) ]]></valueEval>
                    <issueText>%SMCMachineClearIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorSMCMachineClear") >0.02 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%MOMachineClear" id="locatorMOMachineClear_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MOMachineClearDescriptionAll</description>
                    <helpKeyword>configs.momachineclear_momachinecleardescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.NUKE]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.MEMORY_ORDERING]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.SLOW]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/MOMachineClear_socsmall") ) ]]></valueEval>
                    <issueText>%MOMachineClearIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMOMachineClear") >0.02 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FPAssistMachineClear" id="locatorFPAssistMachineClear_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FPAssistMachineClearDescriptionAll</description>
                    <helpKeyword>configs.fpassistmachineclear_fpassistmachinecleardescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.NUKE]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.FP_ASSIST]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.SLOW]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/FPAssistMachineClear_socsmall") ) ]]></valueEval>
                    <issueText>%FPAssistMachineClearIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFPAssistMachineClear") >0.02 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Disambiguation" id="locatorDisambiguation_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%DisambiguationDescriptionAll</description>
                    <helpKeyword>configs.disambiguation_disambiguationdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.NUKE]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.DISAMBIGUATION]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.SLOW]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/Disambiguation_socsmall") ) ]]></valueEval>
                    <issueText>%DisambiguationIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorDisambiguation") >0.02 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%PageFaultMachineClear" id="locatorPageFaultMachineClear_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%PageFaultMachineClearDescriptionAll</description>
                    <helpKeyword>configs.pagefaultmachineclear_pagefaultmachinecleardescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.NUKE]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.PAGE_FAULT]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MACHINE_CLEARS.SLOW]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/PageFaultMachineClear_socsmall") ) ]]></valueEval>
                    <issueText>%PageFaultMachineClearIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorPageFaultMachineClear") >0.02 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%FastMachineClear" id="locatorFastMachineClear_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%FastMachineClearDescriptionAll</description>
                    <helpKeyword>configs.fastmachineclear_fastmachinecleardescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BAD_SPECULATION.FASTNUKE]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/FastMachineClear_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%FastMachineClearIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorFastMachineClear") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%BackendBound" id="locatorBackendBound_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%BackendBoundDescriptionAll</description>
                    <helpKeyword>configs.backendbound_backendbounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/BackendBound_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%BackendBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorBackendBound") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%CoreBound" id="locatorCoreBound_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%CoreBoundDescriptionAll</description>
                    <helpKeyword>configs.corebound_corebounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) / SLOTS ) < ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.ANY_AT_RET]/PMUCoreType[LPE-Core]") ) / query("/DerivedClockticks_socsmall") ) + query("/StoresBound_socsmall") ) ) ) else ( ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.ANY_AT_RET]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) ) ) if ( ( ( query("/BackendBound_socsmall") - query("/MemBound_socsmall") ) > 0 ) ) else ( 0 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/CoreBound_socsmall") ) ]]></valueEval>
                    <issueText>%CoreBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorCoreBound") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%MemBound" id="locatorMemBound_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MemBoundDescriptionAll</description>
                    <helpKeyword>configs.membound_membounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) / SLOTS ) < ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.ANY_AT_RET]/PMUCoreType[LPE-Core]") ) / query("/DerivedClockticks_socsmall") ) + query("/StoresBound_socsmall") ) ) ) else ( ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.ANY_AT_RET]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/MemBound_socsmall") ) ]]></valueEval>
                    <issueText>%MemBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMemBound") >0.20 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%StoresBound" id="locatorStoresBound_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%StoresBoundDescriptionAll</description>
                    <helpKeyword>configs.storesbound_storesbounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/StoresBound_socsmall") ) ]]></valueEval>
                    <issueText>%StoresBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorStoresBound") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%L1Bound" id="locatorL1Bound_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%L1BoundDescriptionAll</description>
                    <helpKeyword>configs.l1bound_l1bounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/L1Bound_socsmall") ) ]]></valueEval>
                    <issueText>%L1BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorL1Bound") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%LoadsBlockedbyStoreForwarding" id="locatorLoadsBlockedbyStoreForwarding_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%LoadsBlockedbyStoreForwardingDescriptionAll</description>
                    <helpKeyword>configs.loadsblockedbystoreforwarding_loadsblockedbystoreforwardingdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.ST_ADDR_AT_RET]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/LoadsBlockedbyStoreForwarding_socsmall") ) ]]></valueEval>
                    <issueText>%LoadsBlockedbyStoreForwardingIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorLoadsBlockedbyStoreForwarding") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Load_STLB_Hit" id="locatorLoad_STLB_Hit_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Load_STLB_HitDescriptionAll</description>
                    <helpKeyword>configs.load_stlb_hit_load_stlb_hitdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.DTLB_MISS_AT_RET]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/Load_STLB_Hit_socsmall") ) ]]></valueEval>
                    <issueText>%Load_STLB_HitIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorLoad_STLB_Hit") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Load_STLB_Miss" id="locatorLoad_STLB_Miss_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Load_STLB_MissDescriptionAll</description>
                    <helpKeyword>configs.load_stlb_miss_load_stlb_missdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.PGWALK_AT_RET]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/Load_STLB_Miss_socsmall") ) ]]></valueEval>
                    <issueText>%Load_STLB_MissIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorLoad_STLB_Miss") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%OtherL1" id="locatorOtherL1_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%OtherL1DescriptionAll</description>
                    <helpKeyword>configs.otherl1_otherl1descriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.OTHER_AT_RET]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/OtherL1_socsmall") ) ]]></valueEval>
                    <issueText>%OtherL1IssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorOtherL1") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%L2Bound" id="locatorL2Bound_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%L2BoundDescriptionAll</description>
                    <helpKeyword>configs.l2bound_l2bounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.L2_HIT]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]/PMUCoreType[LPE-Core]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") >= 10 ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) - ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]/PMUCoreType[LPE-Core]") ) ) / query("/DerivedClockticks_socsmall") ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.L2_HIT]/PMUCoreType[LPE-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/L2Bound_socsmall") ) ]]></valueEval>
                    <issueText>%L2BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorL2Bound") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%L3Bound" id="locatorL3Bound_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%L3BoundDescriptionAll</description>
                    <helpKeyword>configs.l3bound_l3bounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_HIT]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]/PMUCoreType[LPE-Core]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") >= 10 ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) - ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]/PMUCoreType[LPE-Core]") ) ) / query("/DerivedClockticks_socsmall") ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_HIT]/PMUCoreType[LPE-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/L3Bound_socsmall") ) ]]></valueEval>
                    <issueText>%L3BoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorL3Bound") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%DRAMBound" id="locatorDRAMBound_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%DRAMBoundDescriptionAll</description>
                    <helpKeyword>configs.drambound_drambounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_MISS]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]/PMUCoreType[LPE-Core]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") >= 10 ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) - ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]/PMUCoreType[LPE-Core]") ) ) / query("/DerivedClockticks_socsmall") ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_MISS]/PMUCoreType[LPE-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/DRAMBound_socsmall") ) ]]></valueEval>
                    <issueText>%DRAMBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorDRAMBound") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%OtherLoadStore" id="locatorOtherLoadStore_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%OtherLoadStoreDescriptionAll</description>
                    <helpKeyword>configs.otherloadstore_otherloadstoredescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) if ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]/PMUCoreType[LPE-Core]") ) / SLOTS ) < ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.ANY_AT_RET]/PMUCoreType[LPE-Core]") ) / query("/DerivedClockticks_socsmall") ) + query("/StoresBound_socsmall") ) ) ) else ( ( ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.ANY_AT_RET]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) ) || ( ( ( ( ( ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) || ( ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_BOUND_AT_RET]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") >= 10 ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.L2_HIT]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]/PMUCoreType[LPE-Core]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") >= 10 ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) - ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]/PMUCoreType[LPE-Core]") ) ) / query("/DerivedClockticks_socsmall") ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.L2_HIT]/PMUCoreType[LPE-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_HIT]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]/PMUCoreType[LPE-Core]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") >= 10 ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) - ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]/PMUCoreType[LPE-Core]") ) ) / query("/DerivedClockticks_socsmall") ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_HIT]/PMUCoreType[LPE-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) || ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_MISS]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") >= 10 ) ) || ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]/PMUCoreType[LPE-Core]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") >= 10 ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) - ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]/PMUCoreType[LPE-Core]") ) ) / query("/DerivedClockticks_socsmall") ) > 0 ) ) else ( 0 ) ) ) || ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.LLC_MISS]/PMUCoreType[LPE-Core]") >= 10 ) ) && ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) if ( ( ( query("/MemBound_socsmall") - ( ( ( ( query("/StoresBound_socsmall") + query("/L1Bound_socsmall") ) + query("/L2Bound_socsmall") ) + query("/L3Bound_socsmall") ) + query("/DRAMBound_socsmall") ) ) > 0 ) ) else ( 0 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/OtherLoadStore_socsmall") ) ]]></valueEval>
                    <issueText>%OtherLoadStoreIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorOtherLoadStore") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%BackendBoundAux" id="locatorBackendBoundAux_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%BackendBoundAuxDescriptionAll</description>
                    <helpKeyword>configs.backendboundaux_backendboundauxdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/BackendBoundAux_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%BackendBoundAuxIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorBackendBoundAux") >0.20 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%ResourceBound" id="locatorResourceBound_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%ResourceBoundDescriptionAll</description>
                    <helpKeyword>configs.resourcebound_resourcebounddescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALL]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/ResourceBound_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%ResourceBoundIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorResourceBound") >0.20 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%MemoryScheduler" id="locatorMemoryScheduler_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MemorySchedulerDescriptionAll</description>
                    <helpKeyword>configs.memoryscheduler_memoryschedulerdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/MemoryScheduler_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%MemorySchedulerIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorMemoryScheduler") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%STBuffer" id="locatorSTBuffer_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%STBufferDescriptionAll</description>
                    <helpKeyword>configs.stbuffer_stbufferdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ST_BUF]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/STBuffer_socsmall") ) ]]></valueEval>
                    <issueText>%STBufferIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorSTBuffer") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%LDBuffer" id="locatorLDBuffer_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%LDBufferDescriptionAll</description>
                    <helpKeyword>configs.ldbuffer_ldbufferdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.LD_BUF]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/LDBuffer_socsmall") ) ]]></valueEval>
                    <issueText>%LDBufferIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorLDBuffer") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%RSV" id="locatorRSV_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%RSVDescriptionAll</description>
                    <helpKeyword>configs.rsv_rsvdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.MEM_SCHEDULER]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) || ( ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.RSV]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/PMUSampleCount/PMUEventType[MEM_SCHEDULER_BLOCK.ALL]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/RSV_socsmall") ) ]]></valueEval>
                    <issueText>%RSVIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorRSV") >0.05 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%NonMemoryScheduler" id="locatorNonMemoryScheduler_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%NonMemorySchedulerDescriptionAll</description>
                    <helpKeyword>configs.nonmemoryscheduler_nonmemoryschedulerdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.NON_MEM_SCHEDULER]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/NonMemoryScheduler_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%NonMemorySchedulerIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorNonMemoryScheduler") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%BERegister" id="locatorBERegister_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%BERegisterDescriptionAll</description>
                    <helpKeyword>configs.beregister_beregisterdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.REGISTER]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/BERegister_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%BERegisterIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorBERegister") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%BEReorderBuffer" id="locatorBEReorderBuffer_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%BEReorderBufferDescriptionAll</description>
                    <helpKeyword>configs.bereorderbuffer_bereorderbufferdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.REORDER_BUFFER]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/BEReorderBuffer_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%BEReorderBufferIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorBEReorderBuffer") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%BEAllocRestriction" id="locatorBEAllocRestriction_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%BEAllocRestrictionDescriptionAll</description>
                    <helpKeyword>configs.beallocrestriction_beallocrestrictiondescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.ALLOC_RESTRICTIONS]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/BEAllocRestriction_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%BEAllocRestrictionIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorBEAllocRestriction") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%Serializing_Operation" id="locatorSerializing_Operation_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Serializing_OperationDescriptionAll</description>
                    <helpKeyword>configs.serializing_operation_serializing_operationdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( query("/PMUSampleCount/PMUEventType[TOPDOWN_BE_BOUND.SERIALIZATION]/PMUCoreType[LPE-Core]") >= 10 ) && ( query("/ClocktickSamples") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( (query("/Serializing_Operation_socsmall") * query("/SLOTS_socsmall")) / queryAll("/SLOTS_socsmall", true) ) ]]></valueEval>
                    <issueText>%Serializing_OperationIssueTextAll</issueText>
                    <issueEval>
                        <![CDATA[ ( ( query("/locatorSerializing_Operation") >0.10 ) ) ]]></issueEval>
                </derivedQuery>
                <derivedQuery displayName="%SLOTS" id="locatorSLOTS_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%SLOTSDescriptionAll</description>
                    <helpKeyword>configs.slots_slotsdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( (  ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") >= 10 ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/SLOTS_socsmall") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%Pipeline_Width" id="locatorPipeline_Width_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%Pipeline_WidthDescriptionAll</description>
                    <helpKeyword>configs.pipeline_width_pipeline_widthdescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/Pipeline_Width_socsmall") ) ]]></valueEval>
                </derivedQuery>
                <derivedQuery displayName="%MEM_BOUND_STALLS_AT_RET_CORRECTION" id="locatorMEM_BOUND_STALLS_AT_RET_CORRECTION_socsmall">
                    <queryInherit>/GeMetricBaseLocator</queryInherit>
                    <description>%MEM_BOUND_STALLS_AT_RET_CORRECTIONDescriptionAll</description>
                    <helpKeyword>configs.mem_bound_stalls_at_ret_correction_mem_bound_stalls_at_ret_correctiondescriptionall</helpKeyword>
                    <confidenceEval>
                        <![CDATA[ ( ( ($useCountingMode || $useAggregatedCounting) ? $TRUE : ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") >= 10 ) || ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]/PMUCoreType[LPE-Core]") >= 10 ) ) && ( ( ( query("/PMUSampleCount/PMUEventType[CPU_CLK_UNHALTED.THREAD]/PMUCoreType[LPE-Core]") >= 10 ) ) if ( ( ( ( ( query("/PMUSampleCount/PMUEventType[MEM_BOUND_STALLS_LOAD.ALL]/PMUCoreType[LPE-Core]") ) - ( query("/PMUSampleCount/PMUEventType[LD_HEAD.L1_MISS_AT_RET]/PMUCoreType[LPE-Core]") ) ) / query("/DerivedClockticks_socsmall") ) > 0 ) ) else ( 0 ) ) ) ) ) && ( query("/Reliability") >= 0.5 ) && ( $shortCollectionMux ? $FALSE : $TRUE )) ]]></confidenceEval>
                    <valueEval>
                        <![CDATA[ ( query("/MEM_BOUND_STALLS_AT_RET_CORRECTION_socsmall") ) ]]></valueEval>
                </derivedQuery>
            </locatorqueryLibrary>
        </bag>
    </xsl:template>
    <xsl:variable name="isHTOn" select="exsl:ctx('isHTEnabled', 0) or (exsl:ctx('logicalCPUCount', 1) &gt; exsl:ctx('physicalCoreCount', 1))" />
    <xsl:variable name="is3DXOn" select="exsl:ctx('is3DXPPresent', 0) and not(exsl:ctx('is3DXP2LMMode', 0))" />
</xsl:stylesheet>
