/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.core.model.UpdateCpeDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateCpeRequest
extends BmcRequest<UpdateCpeDetails> {
    private String cpeId;
    private UpdateCpeDetails updateCpeDetails;
    private String ifMatch;

    public String getCpeId() {
        return this.cpeId;
    }

    public UpdateCpeDetails getUpdateCpeDetails() {
        return this.updateCpeDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdateCpeDetails getBody$() {
        return this.updateCpeDetails;
    }

    public Builder toBuilder() {
        return new Builder().cpeId(this.cpeId).updateCpeDetails(this.updateCpeDetails).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",cpeId=").append(String.valueOf(this.cpeId));
        sb.append(",updateCpeDetails=").append(String.valueOf((Object)this.updateCpeDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateCpeRequest)) {
            return false;
        }
        UpdateCpeRequest other = (UpdateCpeRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.cpeId, other.cpeId) && Objects.equals((Object)this.updateCpeDetails, (Object)other.updateCpeDetails) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.cpeId == null ? 43 : this.cpeId.hashCode());
        result = result * 59 + (this.updateCpeDetails == null ? 43 : this.updateCpeDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateCpeRequest, UpdateCpeDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String cpeId = null;
        private UpdateCpeDetails updateCpeDetails = null;
        private String ifMatch = null;

        public Builder cpeId(String cpeId) {
            this.cpeId = cpeId;
            return this;
        }

        public Builder updateCpeDetails(UpdateCpeDetails updateCpeDetails) {
            this.updateCpeDetails = updateCpeDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateCpeRequest o) {
            this.cpeId(o.getCpeId());
            this.updateCpeDetails(o.getUpdateCpeDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateCpeRequest build() {
            UpdateCpeRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateCpeDetails body) {
            this.updateCpeDetails(body);
            return this;
        }

        public UpdateCpeRequest buildWithoutInvocationCallback() {
            UpdateCpeRequest request = new UpdateCpeRequest();
            request.cpeId = this.cpeId;
            request.updateCpeDetails = this.updateCpeDetails;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

