/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.ant;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.netbeans.modules.web.clientproject.ant.PropertyEvaluatorImpl;
import org.netbeans.modules.web.clientproject.env.CommonProjectHelper;
import org.netbeans.modules.web.clientproject.env.Values;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.AuxiliaryProperties;
import org.netbeans.spi.project.CacheDirectoryProvider;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ProjectXmlSavedHook;
import org.netbeans.spi.queries.SharabilityQueryImplementation2;
import org.openide.filesystems.FileObject;
import org.openide.util.WeakSet;
import org.w3c.dom.Element;

final class AntProjectHelperImpl
extends CommonProjectHelper {
    final AntProjectHelper delegate;
    private final L listener;
    private final Collection<CommonProjectHelper.Callback> antListeners;
    private static final Field DELEGATE;

    public AntProjectHelperImpl(AntProjectHelper delegate) {
        this.delegate = delegate;
        this.listener = new L();
        this.delegate.addAntProjectListener((AntProjectListener)this.listener);
        this.antListeners = Collections.synchronizedSet(new WeakSet());
    }

    @Override
    public void registerCallback(CommonProjectHelper.Callback listener) {
        this.antListeners.add(listener);
    }

    @Override
    public FileObject getProjectDirectory() {
        return this.delegate.getProjectDirectory();
    }

    @Override
    public void notifyDeleted() {
        this.delegate.notifyDeleted();
    }

    @Override
    public Element getPrimaryConfigurationData(boolean shared) {
        return this.delegate.getPrimaryConfigurationData(shared);
    }

    @Override
    public void putPrimaryConfigurationData(Element data, boolean shared) throws IllegalArgumentException {
        this.delegate.putPrimaryConfigurationData(data, shared);
    }

    @Override
    public AuxiliaryConfiguration createAuxiliaryConfiguration() {
        return this.delegate.createAuxiliaryConfiguration();
    }

    public CacheDirectoryProvider createCacheDirectoryProvider() {
        return this.delegate.createCacheDirectoryProvider();
    }

    public AuxiliaryProperties createAuxiliaryProperties() {
        return this.delegate.createAuxiliaryProperties();
    }

    @Override
    public Values getStandardPropertyEvaluator() {
        return new PropertyEvaluatorImpl(this.delegate.getStandardPropertyEvaluator());
    }

    @Override
    public Object getXmlSavedHook() {
        return this.listener;
    }

    @Override
    public File resolveFile(String path) {
        return this.delegate.resolveFile(path);
    }

    @Override
    public FileObject resolveFileObject(String path) {
        return this.delegate.resolveFileObject(path);
    }

    @Override
    public void putProperties(Object path, org.openide.util.EditableProperties props) {
        EditableProperties copy = new EditableProperties(true);
        copy.putAll((Map)props);
        this.delegate.putProperties(AntProjectHelperImpl.mapPath(path), copy);
    }

    @Override
    public org.openide.util.EditableProperties getProperties(Object path) {
        return AntProjectHelperImpl.extract(this.delegate.getProperties(AntProjectHelperImpl.mapPath(path)));
    }

    @Override
    public SharabilityQueryImplementation2 createSharabilityQuery2(Values e, String[] roots, String[] dirs) {
        PropertyEvaluatorImpl ip = (PropertyEvaluatorImpl)e;
        return this.delegate.createSharabilityQuery2(ip.delegate, roots, dirs);
    }

    private static org.openide.util.EditableProperties extract(EditableProperties p) {
        try {
            return (org.openide.util.EditableProperties)DELEGATE.get(p);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static String mapPath(Object path) {
        if (path == CommonProjectHelper.PRIVATE_PROPERTIES_PATH) {
            return "nbproject/private/private.properties";
        }
        if (path == CommonProjectHelper.PROJECT_PROPERTIES_PATH) {
            return "nbproject/project.properties";
        }
        return path.toString();
    }

    static {
        try {
            DELEGATE = EditableProperties.class.getDeclaredField("delegate");
            DELEGATE.setAccessible(true);
        }
        catch (NoSuchFieldException ex) {
            throw new SecurityException(ex);
        }
    }

    private final class L
    extends ProjectXmlSavedHook
    implements AntProjectListener {
        private L() {
        }

        public void configurationXmlChanged(AntProjectEvent ev) {
            for (CommonProjectHelper.Callback l : AntProjectHelperImpl.this.antListeners) {
                l.configurationXmlChanged();
            }
        }

        public void propertiesChanged(AntProjectEvent ev) {
            for (CommonProjectHelper.Callback l : AntProjectHelperImpl.this.antListeners) {
                l.propertiesChanged();
            }
        }

        protected void projectXmlSaved() throws IOException {
            for (CommonProjectHelper.Callback l : AntProjectHelperImpl.this.antListeners) {
                l.projectXmlSaved();
            }
        }
    }
}

