/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.cdnjs.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.netbeans.modules.javascript.cdnjs.Library;
import org.netbeans.modules.javascript.cdnjs.ui.FileSelectionPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class EditPanel
extends JPanel {
    private final Library.Version installedVersion;
    private FileSelectionPanel fileSelectionPanel;
    private JLabel filesLabel;
    private JComboBox versionComboBox;
    private JLabel versionLabel;

    public EditPanel(Library library, Library.Version installedVersion) {
        this.initComponents();
        this.installedVersion = installedVersion;
        Library.Version[] versions = library == null ? new Library.Version[]{installedVersion} : library.getVersions();
        this.versionComboBox.setModel(new DefaultComboBoxModel<Library.Version>(versions));
        this.versionComboBox.setRenderer(new LibraryVersionRenderer());
        int indexOfInstalled = -1;
        for (int i = 0; i < versions.length; ++i) {
            if (!versions[i].getName().equals(installedVersion.getName())) continue;
            indexOfInstalled = i;
            break;
        }
        this.versionComboBox.setSelectedIndex(indexOfInstalled);
        this.updateFileSelectionPanel();
    }

    private void updateFileSelectionPanel() {
        Library.Version version = (Library.Version)this.versionComboBox.getSelectedItem();
        String[] installedFiles = version.getName().equals(this.installedVersion.getName()) ? this.installedVersion.getFiles() : null;
        this.fileSelectionPanel.setLibrary(version, installedFiles);
    }

    Library.Version getSelection() {
        return this.fileSelectionPanel.getSelection();
    }

    private void initComponents() {
        this.versionLabel = new JLabel();
        this.versionComboBox = new JComboBox();
        this.fileSelectionPanel = new FileSelectionPanel();
        this.filesLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.versionLabel, (String)NbBundle.getMessage(EditPanel.class, (String)"EditPanel.versionLabel.text"));
        this.versionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditPanel.this.versionComboBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.filesLabel, (String)NbBundle.getMessage(EditPanel.class, (String)"EditPanel.filesLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.versionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.versionComboBox, -2, -1, -2)).addComponent(this.fileSelectionPanel, -1, -1, Short.MAX_VALUE).addComponent(this.filesLabel)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.versionLabel).addComponent(this.versionComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fileSelectionPanel, -1, 150, Short.MAX_VALUE).addContainerGap()));
    }

    private void versionComboBoxActionPerformed(ActionEvent evt) {
        this.updateFileSelectionPanel();
    }

    static class LibraryVersionRenderer
    extends DefaultListCellRenderer {
        LibraryVersionRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof Library.Version) {
                Library.Version version = (Library.Version)value;
                value = version.getName();
            }
            return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
    }
}

