/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.actions;

import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.modules.web.beans.actions.InterceptorGenerator;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.openide.util.Lookup;

public class InterceptorFactory
implements CodeGenerator.Factory {
    static final String INTERCEPTOR_BINDING = "InterceptorBinding";
    private static final String INTERCEPTOR_BINDING_FQN = "javax.interceptor.InterceptorBinding";
    private static final String INTERCEPTOR_BINDING_FQN_JAKARTA = "jakarta.interceptor.InterceptorBinding";

    public List<? extends CodeGenerator> create(Lookup lookup) {
        CompilationController controller = (CompilationController)lookup.lookup(CompilationController.class);
        JTextComponent component = (JTextComponent)lookup.lookup(JTextComponent.class);
        ArrayList<InterceptorGenerator> result = new ArrayList<InterceptorGenerator>(1);
        if (component != null && controller != null) {
            try {
                controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                TypeElement interceptorBinding = controller.getElements().getTypeElement(INTERCEPTOR_BINDING_FQN);
                TypeElement interceptorBindingJakarta = controller.getElements().getTypeElement(INTERCEPTOR_BINDING_FQN_JAKARTA);
                if (interceptorBinding == null && interceptorBindingJakarta == null) {
                    return result;
                }
                int dot = component.getCaret().getDot();
                TreePath tp = controller.getTreeUtilities().pathFor(dot);
                if (tp == null) {
                    return result;
                }
                Element contextElement = controller.getTrees().getElement(tp);
                if (contextElement == null || contextElement.getKind() != ElementKind.ANNOTATION_TYPE) {
                    return result;
                }
                List<? extends AnnotationMirror> annotations = controller.getElements().getAllAnnotationMirrors(contextElement);
                boolean isInterceptorBinding = false;
                boolean isInterceptorBindingJakarta = false;
                for (AnnotationMirror annotationMirror : annotations) {
                    Element annotationElement = controller.getTypes().asElement(annotationMirror.getAnnotationType());
                    if (interceptorBinding != null && interceptorBinding.equals(annotationElement)) {
                        isInterceptorBinding = true;
                        break;
                    }
                    if (interceptorBindingJakarta == null || !interceptorBindingJakarta.equals(annotationElement)) continue;
                    isInterceptorBindingJakarta = true;
                    break;
                }
                if (isInterceptorBindingJakarta) {
                    result.add(new InterceptorGenerator(true, contextElement.getSimpleName().toString(), controller.getFileObject()));
                } else if (isInterceptorBinding) {
                    result.add(new InterceptorGenerator(false, contextElement.getSimpleName().toString(), controller.getFileObject()));
                }
            }
            catch (IOException ex) {
                Logger.getLogger(InterceptorFactory.class.getName()).log(Level.INFO, null, ex);
            }
        }
        return result;
    }
}

