/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.output.dataexport;

import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import org.netbeans.modules.db.dataview.output.DataViewTableUIModel;
import org.netbeans.modules.db.dataview.util.LobHelper;

public class DataExportUtils {
    public static String[] getColumnNames(DataViewTableUIModel model) {
        String[] header = new String[model.getColumnCount()];
        for (int i = 0; i < model.getColumnCount(); ++i) {
            header[i] = model.getColumnName(i);
        }
        return header;
    }

    public static Object[][] getTableContents(DataViewTableUIModel model) {
        Object[][] contents = new Object[model.getRowCount()][model.getColumnCount()];
        for (int i = 0; i < model.getRowCount(); ++i) {
            for (int j = 0; j < model.getColumnCount(); ++j) {
                Object value = model.getValueAt(i, j);
                Class<? extends Object> c = model.getColumnClass(j);
                if (value != null && c == Blob.class) {
                    value = LobHelper.blobToString((Blob)value);
                } else if (value != null && c == Clob.class) {
                    Clob lob = (Clob)value;
                    try {
                        value = lob.getSubString(1L, (int)lob.length());
                    }
                    catch (SQLException ex) {
                        value = LobHelper.clobToString(lob);
                    }
                }
                contents[i][j] = value;
            }
        }
        return contents;
    }
}

