/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.options;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.ui.ProjectGroup;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.options.Bundle;
import org.netbeans.modules.maven.options.MavenSettings;
import org.netbeans.modules.maven.options.SettingsPanel;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class MavenGroupPanel
extends JPanel {
    private final DefaultComboBoxModel mavenHomeDataModel = new DefaultComboBoxModel();
    private String mavenRuntimeHome = null;
    private static final String SEPARATOR = "SEPARATOR";
    private final ProjectCustomizer.Category category;
    private final List<String> userDefinedMavenRuntimes = new ArrayList<String>();
    private final List<String> predefinedRuntimes = new ArrayList<String>();
    private final ActionListener listItemChangedListener;
    private int lastSelected = -1;
    private String globalMavenValue;
    private JComboBox comMavenHome;
    private JLabel lblCommandLine;
    private JLabel lblExternalVersion;

    MavenGroupPanel(ProjectCustomizer.Category category, final ProjectGroup grp) {
        this.initComponents();
        this.category = category;
        this.comMavenHome.setModel(this.mavenHomeDataModel);
        this.comMavenHome.setRenderer(new ComboBoxRenderer());
        File f = EmbedderFactory.getMavenHome();
        this.globalMavenValue = f.equals(EmbedderFactory.getDefaultMavenHome()) ? Bundle.MAVEN_RUNTIME_Bundled() : Bundle.MAVEN_RUNTIME_External(f.getAbsolutePath());
        this.listItemChangedListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MavenGroupPanel.SEPARATOR.equals(MavenGroupPanel.this.comMavenHome.getSelectedItem())) {
                    MavenGroupPanel.this.comMavenHome.setSelectedIndex(MavenGroupPanel.this.lastSelected);
                    return;
                }
                int selected = MavenGroupPanel.this.comMavenHome.getSelectedIndex();
                if (selected == MavenGroupPanel.this.mavenHomeDataModel.getSize() - 1) {
                    MavenGroupPanel.this.comMavenHome.setSelectedIndex(MavenGroupPanel.this.lastSelected);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MavenGroupPanel.this.browseAddNewRuntime();
                        }
                    });
                    return;
                }
                MavenGroupPanel.this.listDataChanged();
                MavenGroupPanel.this.lastSelected = selected;
            }
        };
        this.loadValues(grp);
        category.setStoreListener(new ActionListener(){
            final /* synthetic */ MavenGroupPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.applyValues(grp);
            }
        });
    }

    private void initComponents() {
        this.lblExternalVersion = new JLabel();
        this.lblCommandLine = new JLabel();
        this.comMavenHome = new JComboBox();
        Mnemonics.setLocalizedText((JLabel)this.lblCommandLine, (String)NbBundle.getMessage(MavenGroupPanel.class, (String)"MavenGroupPanel.lblCommandLine.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lblCommandLine).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblExternalVersion, -1, -1, Short.MAX_VALUE).addComponent(this.comMavenHome, 0, 325, Short.MAX_VALUE))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblCommandLine).addComponent(this.comMavenHome, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblExternalVersion, -2, 14, -2).addGap(0, 147, Short.MAX_VALUE)));
    }

    private String getSelectedRuntime(int selected) {
        if (selected < 0) {
            return null;
        }
        if (selected < this.predefinedRuntimes.size()) {
            return this.predefinedRuntimes.get(selected);
        }
        if (!this.userDefinedMavenRuntimes.isEmpty() && selected - this.predefinedRuntimes.size() <= this.userDefinedMavenRuntimes.size()) {
            return this.userDefinedMavenRuntimes.get(selected - 1 - this.predefinedRuntimes.size());
        }
        return null;
    }

    private void browseAddNewRuntime() {
        File f;
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(NbBundle.getMessage(SettingsPanel.class, (String)"TIT_Select2"));
        chooser.setFileSelectionMode(1);
        chooser.setFileHidingEnabled(false);
        int selected = this.comMavenHome.getSelectedIndex();
        String path = this.getSelectedRuntime(selected);
        if (path == null || path.trim().length() == 0) {
            path = new File(System.getProperty("user.home")).getAbsolutePath();
        }
        if (path.length() > 0 && (f = new File(path)).exists()) {
            chooser.setSelectedFile(f);
        }
        if (0 == chooser.showOpenDialog(this)) {
            File projectDir = chooser.getSelectedFile();
            String newRuntimePath = FileUtil.normalizeFile((File)projectDir).getAbsolutePath();
            boolean existed = false;
            ArrayList<String> runtimes = new ArrayList<String>();
            runtimes.addAll(this.predefinedRuntimes);
            runtimes.addAll(this.userDefinedMavenRuntimes);
            for (String runtime : runtimes) {
                if (!runtime.equals(newRuntimePath)) continue;
                existed = true;
            }
            if (!existed) {
                if (this.userDefinedMavenRuntimes.isEmpty()) {
                    this.mavenHomeDataModel.insertElementAt(SEPARATOR, this.predefinedRuntimes.size());
                }
                this.userDefinedMavenRuntimes.add(newRuntimePath);
                this.mavenHomeDataModel.insertElementAt(newRuntimePath, runtimes.size() + 1);
            }
            this.comMavenHome.setSelectedItem(newRuntimePath);
        }
    }

    private void loadValues(final ProjectGroup grp) {
        RequestProcessor.getDefault().post(new Runnable(){
            final /* synthetic */ MavenGroupPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.predefinedRuntimes.clear();
                this.this$0.predefinedRuntimes.add("");
                String defaultExternalMavenRuntime = MavenSettings.getDefaultExternalMavenRuntime();
                if (defaultExternalMavenRuntime != null) {
                    this.this$0.predefinedRuntimes.add(defaultExternalMavenRuntime);
                }
                this.this$0.userDefinedMavenRuntimes.clear();
                this.this$0.userDefinedMavenRuntimes.addAll(MavenSettings.getDefault().getUserDefinedMavenRuntimes());
                final ArrayList<String> toAdd = new ArrayList<String>();
                final File command = EmbedderFactory.getEffectiveMavenHome((ProjectGroup)grp);
                for (String runtime : this.this$0.predefinedRuntimes) {
                    boolean bundledRuntime = runtime.isEmpty();
                    String desc = bundledRuntime ? Bundle.MAVEN_RUNTIME_Bundled() : Bundle.MAVEN_RUNTIME_External(runtime);
                    toAdd.add(desc);
                }
                if (!this.this$0.userDefinedMavenRuntimes.isEmpty()) {
                    toAdd.add(MavenGroupPanel.SEPARATOR);
                    for (String runtime : this.this$0.userDefinedMavenRuntimes) {
                        String desc = Bundle.MAVEN_RUNTIME_External(runtime);
                        toAdd.add(desc);
                    }
                }
                toAdd.add(MavenGroupPanel.SEPARATOR);
                toAdd.add(Bundle.MAVEN_RUNTIME_Browse());
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run() {
                        this.this$1.this$0.comMavenHome.removeActionListener(this.this$1.this$0.listItemChangedListener);
                        this.this$1.this$0.mavenHomeDataModel.removeAllElements();
                        for (String s : toAdd) {
                            this.this$1.this$0.mavenHomeDataModel.addElement(s);
                        }
                        this.this$1.this$0.comMavenHome.setSelectedItem(command.getAbsolutePath());
                        this.this$1.this$0.listDataChanged();
                        this.this$1.this$0.lastSelected = this.this$1.this$0.comMavenHome.getSelectedIndex();
                        this.this$1.this$0.comMavenHome.addActionListener(this.this$1.this$0.listItemChangedListener);
                    }
                });
            }
        });
    }

    public void applyValues(ProjectGroup grp) {
        File command;
        ArrayList<String> runtimes = new ArrayList<String>();
        for (int i = 0; i < this.userDefinedMavenRuntimes.size() && i < 5; ++i) {
            runtimes.add(0, this.userDefinedMavenRuntimes.get(this.userDefinedMavenRuntimes.size() - 1 - i));
        }
        int selected = this.comMavenHome.getSelectedIndex() - this.predefinedRuntimes.size() - 1;
        if (selected >= 0 && runtimes.size() == 5 && this.userDefinedMavenRuntimes.size() - 5 > selected) {
            runtimes.set(0, this.userDefinedMavenRuntimes.get(selected));
        }
        if (this.predefinedRuntimes.size() > 1) {
            runtimes.add(0, this.predefinedRuntimes.get(1));
        }
        MavenSettings.getDefault().setMavenRuntimes(runtimes);
        String cl = this.mavenRuntimeHome;
        File file = command = cl == null || cl.isEmpty() ? null : new File(cl);
        if (command != null && command.isDirectory()) {
            EmbedderFactory.setGroupedMavenHome((ProjectGroup)grp, (File)command);
        } else {
            EmbedderFactory.setGroupedMavenHome((ProjectGroup)grp, null);
        }
    }

    private void listDataChanged() {
        int selected = this.comMavenHome.getSelectedIndex();
        String path = this.getSelectedRuntime(selected);
        if (path != null && "".equals(path = path.trim())) {
            path = null;
            this.category.setValid(true);
            this.lblExternalVersion.setText(NbBundle.getMessage(SettingsPanel.class, (String)"LBL_ExMavenVersion2", (Object)SettingsPanel.BUNDLED_RUNTIME_VERSION));
        }
        if (path != null) {
            path = path.trim();
            File fil = new File(path);
            String ver = null;
            if (fil.exists() && new File(fil, "bin" + File.separator + "mvn").exists()) {
                ver = MavenSettings.getCommandLineMavenVersion(new File(path));
            }
            if (ver != null) {
                this.lblExternalVersion.setText(NbBundle.getMessage(SettingsPanel.class, (String)"LBL_ExMavenVersion2", ver));
                this.category.setValid(true);
            } else {
                this.lblExternalVersion.setText(NbBundle.getMessage(SettingsPanel.class, (String)"ERR_NoValidInstallation"));
                this.category.setValid(false);
            }
        }
        this.mavenRuntimeHome = path;
    }

    private class ComboBoxRenderer
    extends DefaultListCellRenderer {
        private final JSeparator separator = new JSeparator(0);

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (MavenGroupPanel.SEPARATOR.equals(value)) {
                return this.separator;
            }
            if (MavenGroupPanel.this.globalMavenValue.equals(value)) {
                value = Bundle.LBL_Global_selection(value);
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }
}

