/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.dev.wizard;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.SwingUtilities;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.ui.ScanDialog;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.api.ejbjar.EjbReference;
import org.netbeans.modules.j2ee.common.ProjectUtil;
import org.netbeans.modules.websvc.api.jaxws.project.WSUtils;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.api.jaxws.project.config.ServiceAlreadyExistsExeption;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModel;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModelListener;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModeler;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlPort;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlService;
import org.netbeans.modules.websvc.api.support.ServiceCreator;
import org.netbeans.modules.websvc.api.support.java.GenerationUtils;
import org.netbeans.modules.websvc.api.support.java.SourceUtils;
import org.netbeans.modules.websvc.core.JaxWsUtils;
import org.netbeans.modules.websvc.core.ProjectInfo;
import org.netbeans.modules.websvc.core.dev.wizard.WsdlServiceHandler;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class JaxWsServiceCreator
implements ServiceCreator {
    private ProjectInfo projectInfo;
    private WizardDescriptor wiz;
    private boolean addJaxWsLib;
    private int serviceType;
    private int projectType;

    public JaxWsServiceCreator(ProjectInfo projectInfo, WizardDescriptor wiz, boolean addJaxWsLib) {
        this.projectInfo = projectInfo;
        this.wiz = wiz;
        this.addJaxWsLib = addJaxWsLib;
    }

    public void createService() throws IOException {
        this.serviceType = (Integer)this.wiz.getProperty("webServiceType");
        this.projectType = this.projectInfo.getProjectType();
        final ProgressHandle handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(JaxWsServiceCreator.class, (String)"TXT_WebServiceGeneration"));
        handle.start(100);
        Runnable r = new Runnable(){
            final /* synthetic */ JaxWsServiceCreator this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try {
                    this.this$0.generateWebService(handle);
                }
                catch (Exception e) {
                    handle.finish();
                    String message = e.getLocalizedMessage();
                    if (message != null) {
                        ErrorManager.getDefault().notify(1, (Throwable)e);
                        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)message, 0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    }
                    ErrorManager.getDefault().notify(4096, (Throwable)e);
                }
            }
        };
        RequestProcessor.getDefault().post(r);
    }

    public void createServiceFromWsdl() throws IOException {
        final ProgressHandle handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(JaxWsServiceCreator.class, (String)"TXT_WebServiceGeneration"));
        Runnable r = new Runnable(){
            final /* synthetic */ JaxWsServiceCreator this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try {
                    handle.start();
                    this.this$0.generateWsFromWsdl15(handle);
                }
                catch (Exception e) {
                    handle.finish();
                    String message = e.getLocalizedMessage();
                    if (message != null) {
                        ErrorManager.getDefault().notify(1, (Throwable)e);
                        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)message, 0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    }
                    ErrorManager.getDefault().notify(4096, (Throwable)e);
                }
            }
        };
        RequestProcessor.getDefault().post(r);
    }

    private void generateWebService(ProgressHandle handle) throws Exception {
        FileObject pkg = Templates.getTargetFolder((WizardDescriptor)this.wiz);
        String wsName = Templates.getTargetName((WizardDescriptor)this.wiz);
        Project p = this.projectInfo.getProject();
        if (this.serviceType == 0) {
            JAXWSSupport jaxWsSupport = JAXWSSupport.getJAXWSSupport((FileObject)p.getProjectDirectory());
            if (jaxWsSupport != null) {
                wsName = this.getUniqueJaxwsName(jaxWsSupport, wsName);
                handle.progress(NbBundle.getMessage(JaxWsServiceCreator.class, (String)"MSG_GEN_WS"), 50);
                if (this.addJaxWsLib) {
                    this.addJaxws21Library(p);
                }
                this.generateJaxWSImplFromTemplate(pkg, wsName, this.projectType);
                handle.finish();
            } else {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(JaxWsServiceCreator.class, (String)"TXT_JaxWsNotSupported"), 0));
                handle.finish();
            }
        } else if (this.serviceType == 1 && ProjectUtil.isJavaEE5orHigher((Project)this.projectInfo.getProject()) && (this.projectType == 1 || this.projectType == 2)) {
            JAXWSSupport jaxWsSupport = JAXWSSupport.getJAXWSSupport((FileObject)p.getProjectDirectory());
            if (jaxWsSupport != null) {
                wsName = this.getUniqueJaxwsName(jaxWsSupport, wsName);
                handle.progress(NbBundle.getMessage(JaxWsServiceCreator.class, (String)"MSG_GEN_SEI_AND_IMPL"), 50);
                Node[] nodes = (Node[])this.wiz.getProperty("delegateToSessionBean");
                this.generateWebServiceFromEJB(wsName, pkg, this.projectInfo, nodes);
                handle.finish();
            } else {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(JaxWsServiceCreator.class, (String)"TXT_JaxWsNotSupported"), 0));
                handle.finish();
            }
        }
    }

    private FileObject generateJaxWSImplFromTemplate(FileObject pkg, String wsName, int projectType) throws Exception {
        DataFolder df = DataFolder.findFolder((FileObject)pkg);
        FileObject template = Templates.getTemplate((WizardDescriptor)this.wiz);
        if (((Boolean)this.wiz.getProperty("endpointAsStatelessBean")).booleanValue()) {
            FileObject templateParent = template.getParent();
            template = templateParent.getFileObject("EjbWebService", "java");
        }
        DataObject dTemplate = DataObject.find((FileObject)template);
        DataObject dobj = dTemplate.createFromTemplate(df, wsName);
        FileObject createdFile = dobj.getPrimaryFile();
        createdFile.setAttribute("jax-ws-service", (Object)Boolean.TRUE);
        dobj.setValid(false);
        dobj = DataObject.find((FileObject)createdFile);
        final JaxWsModel jaxWsModel = (JaxWsModel)this.projectInfo.getProject().getLookup().lookup(JaxWsModel.class);
        if (jaxWsModel != null) {
            ClassPath classPath = this.getClassPathForFile(this.projectInfo.getProject(), createdFile);
            if (classPath != null) {
                String serviceImplPath = classPath.getResourceName(createdFile, '.', false);
                jaxWsModel.addService(wsName, serviceImplPath);
                ProjectManager.mutex().writeAccess(new Runnable(){
                    final /* synthetic */ JaxWsServiceCreator this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        try {
                            jaxWsModel.write();
                        }
                        catch (IOException ex) {
                            ErrorManager.getDefault().notify((Throwable)ex);
                        }
                    }
                });
            }
            JaxWsUtils.openFileInEditor(dobj);
            this.displayDuplicityWarning(createdFile);
        }
        return createdFile;
    }

    private String getUniqueJaxwsName(JAXWSSupport jaxWsSupport, String origName) {
        List webServices = jaxWsSupport.getServices();
        ArrayList<String> serviceNames = new ArrayList<String>(webServices.size());
        for (Object service : webServices) {
            serviceNames.add(((Service)service).getName());
        }
        return this.uniqueWSName(origName, serviceNames);
    }

    private String uniqueWSName(String origName, List<String> names) {
        int uniquifier = 0;
        String truename = origName;
        while (names.contains(truename)) {
            truename = origName + String.valueOf(++uniquifier);
        }
        return truename;
    }

    private void addJaxws21Library(Project project) throws Exception {
        SourceGroup[] sgs = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        if (sgs.length > 0) {
            ClassPath classPath = ClassPath.getClassPath((FileObject)sgs[0].getRootFolder(), (String)"classpath/compile");
            FileObject wsimportFO = classPath.findResource("com/sun/tools/ws/ant/WsImport.class");
            if (wsimportFO != null) {
                return;
            }
            Library jaxws21_ext = LibraryManager.getDefault().getLibrary("jaxws21");
            if (jaxws21_ext != null) {
                try {
                    ProjectClassPathModifier.addLibraries((Library[])new Library[]{jaxws21_ext}, (FileObject)sgs[0].getRootFolder(), (String)"classpath/compile");
                }
                catch (IOException e) {
                    throw new Exception("Unable to add JAXWS 21 Library. " + e.getMessage());
                }
            } else {
                throw new Exception("Unable to add JAXWS 2.1 Library. ProjectClassPathExtender or library not found");
            }
            try {
                FileObject srcRoot = sgs[0].getRootFolder();
                WSUtils.addJaxWsApiEndorsed((Project)project, (FileObject)srcRoot);
            }
            catch (IOException ex) {
                Logger.getLogger(JaxWsServiceCreator.class.getName()).log(Level.FINE, "Cannot add JAX-WS-ENDORSED classpath", ex);
            }
        }
    }

    private void generateWsFromWsdl15(final ProgressHandle handle) throws Exception {
        String wsdlFilePath = (String)this.wiz.getProperty("wsdlFilePath");
        URL wsdlUrl = null;
        if (wsdlFilePath == null) {
            wsdlUrl = new URL((String)this.wiz.getProperty("wsdl_url"));
        } else {
            File normalizedWsdlFilePath = FileUtil.normalizeFile((File)new File(wsdlFilePath));
            wsdlUrl = normalizedWsdlFilePath.toURI().toURL();
        }
        final Project p = this.projectInfo.getProject();
        final URL wsdlURL = wsdlUrl;
        final WsdlService service = (WsdlService)this.wiz.getProperty("wsdlService");
        final Boolean useProvider = (Boolean)this.wiz.getProperty("useProvider");
        if (service == null) {
            FileObject targetFolder = Templates.getTargetFolder((WizardDescriptor)this.wiz);
            String targetName = Templates.getTargetName((WizardDescriptor)this.wiz);
            if (targetFolder != null) {
                GenerationUtils.createClass((FileObject)targetFolder, (String)targetName, null);
            }
            WsdlServiceHandler handler = (WsdlServiceHandler)this.wiz.getProperty("wsdlServiceHandler");
            JaxWsUtils.generateJaxWsArtifacts(p, targetFolder, targetName, wsdlURL, handler.getServiceName(), handler.getPortName());
            WsdlModeler wsdlModeler = (WsdlModeler)this.wiz.getProperty("wsdlModeler");
            if (wsdlModeler != null && wsdlModeler.getCreationException() != null) {
                handle.finish();
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(JaxWsServiceCreator.class, (String)"TXT_CannotGenerateArtifacts", (Object)wsdlModeler.getCreationException().getLocalizedMessage()), 0));
            } else {
                handle.finish();
            }
        } else {
            final WsdlPort port = (WsdlPort)this.wiz.getProperty("wsdlPort");
            final boolean isStatelessSB = (Boolean)this.wiz.getProperty("endpointAsStatelessBean");
            WsdlModeler wsdlModeler = (WsdlModeler)this.wiz.getProperty("wsdlModeler");
            wsdlModeler.generateWsdlModel(new WsdlModelListener(){
                final /* synthetic */ JaxWsServiceCreator this$0;
                {
                    this.this$0 = this$0;
                }

                public void modelCreated(WsdlModel model) {
                    if (model == null) {
                        handle.finish();
                        return;
                    }
                    WsdlService service1 = model.getServiceByName(service.getName());
                    WsdlPort port1 = service1.getPortByName(port.getName());
                    port1.setSOAPVersion(port.getSOAPVersion());
                    FileObject targetFolder = Templates.getTargetFolder((WizardDescriptor)this.this$0.wiz);
                    String targetName = Templates.getTargetName((WizardDescriptor)this.this$0.wiz);
                    try {
                        JaxWsUtils.generateJaxWsImplementationClass(p, targetFolder, targetName, wsdlURL, service1, port1, useProvider, isStatelessSB);
                        handle.finish();
                    }
                    catch (Exception ex) {
                        handle.finish();
                        ErrorManager.getDefault().notify(4096, (Throwable)ex);
                    }
                }
            });
        }
    }

    private void generateWebServiceFromEJB(String wsName, FileObject pkg, ProjectInfo projectInfo, Node[] nodes) throws IOException, ServiceAlreadyExistsExeption, PropertyVetoException {
        EjbReference ejbRef;
        if (nodes != null && nodes.length == 1 && (ejbRef = (EjbReference)nodes[0].getLookup().lookup(EjbReference.class)) != null) {
            DataFolder df = DataFolder.findFolder((FileObject)pkg);
            FileObject template = Templates.getTemplate((WizardDescriptor)this.wiz);
            FileObject templateParent = template.getParent();
            template = (Boolean)this.wiz.getProperty("endpointAsStatelessBean") != false ? templateParent.getFileObject("EjbWebServiceNoOp", "java") : templateParent.getFileObject("WebServiceNoOp", "java");
            DataObject dTemplate = DataObject.find((FileObject)template);
            DataObject dobj = dTemplate.createFromTemplate(df, wsName);
            FileObject createdFile = dobj.getPrimaryFile();
            createdFile.setAttribute("jax-ws-service", (Object)Boolean.TRUE);
            dobj.setValid(false);
            dobj = DataObject.find((FileObject)createdFile);
            ClassPath classPath = this.getClassPathForFile(projectInfo.getProject(), createdFile);
            if (classPath != null) {
                String serviceImplPath = classPath.getResourceName(createdFile, '.', false);
                this.generateDelegateMethods(createdFile, ejbRef);
                final JaxWsModel jaxWsModel = (JaxWsModel)projectInfo.getProject().getLookup().lookup(JaxWsModel.class);
                if (jaxWsModel != null) {
                    jaxWsModel.addService(wsName, serviceImplPath);
                    ProjectManager.mutex().writeAccess(new Runnable(){
                        final /* synthetic */ JaxWsServiceCreator this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void run() {
                            try {
                                jaxWsModel.write();
                            }
                            catch (IOException ex) {
                                ErrorManager.getDefault().notify((Throwable)ex);
                            }
                        }
                    });
                }
            }
            JaxWsUtils.openFileInEditor(dobj);
            this.displayDuplicityWarning(createdFile);
        }
    }

    private void displayDuplicityWarning(final FileObject createdFile) {
        final String serviceName = createdFile.getName() + "Service";
        RequestProcessor.getDefault().post(new Runnable(){
            final /* synthetic */ JaxWsServiceCreator this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                Service serv = JaxWsUtils.findServiceForServiceName(createdFile, serviceName);
                if (serv != null) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(JaxWsServiceCreator.class, (String)"MSG_ServiceNameExists", (Object)serviceName, (Object)serv.getImplementationClass()), 2));
                }
            }
        });
    }

    @SuppressWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private void generateDelegateMethods(final FileObject targetFo, EjbReference ref) throws IOException {
        final JavaSource targetSource = JavaSource.forFileObject((FileObject)targetFo);
        final DelegateMethodTask modificationTask = new DelegateMethodTask(ref);
        ModificationResult result = targetSource.runModificationTask((Task)modificationTask);
        boolean onClassPath = modificationTask.onClassPath();
        String interfaceClass = modificationTask.getInterfaceClass();
        if (modificationTask.isIncomplete() && org.netbeans.api.java.source.SourceUtils.isScanInProgress()) {
            final Runnable runnable = new Runnable(){
                final /* synthetic */ JaxWsServiceCreator this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    try {
                        targetSource.runModificationTask((Task)modificationTask).commit();
                        boolean onClassPath = modificationTask.onClassPath();
                        String interfaceClass = modificationTask.getInterfaceClass();
                        this.this$0.notifyMessage(targetFo, onClassPath, interfaceClass);
                    }
                    catch (IOException e) {
                        Logger.getLogger(JaxWsServiceCreator.class.getName()).log(Level.WARNING, null, e);
                    }
                }
            };
            final Runnable outOfAwt = new Runnable(){
                final /* synthetic */ JaxWsServiceCreator this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    RequestProcessor.getDefault().post(runnable);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                ScanDialog.runWhenScanFinished((Runnable)outOfAwt, (String)NbBundle.getMessage(JaxWsServiceCreator.class, (String)"LBL_GenerateWebService"));
            } else {
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ JaxWsServiceCreator this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        ScanDialog.runWhenScanFinished((Runnable)outOfAwt, (String)NbBundle.getMessage(JaxWsServiceCreator.class, (String)"LBL_GenerateWebService"));
                    }
                });
            }
        } else {
            result.commit();
            this.notifyMessage(targetFo, onClassPath, interfaceClass);
        }
    }

    private void notifyMessage(final FileObject targetFo, boolean onClassPath, final String interfaceClass) {
        if (!onClassPath) {
            RequestProcessor.getDefault().post(new Runnable(){
                final /* synthetic */ JaxWsServiceCreator this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(JaxWsServiceCreator.class, (String)"MSG_EJB_NOT_ON_CLASSPATH", (Object)interfaceClass, (Object)targetFo.getName()), 2));
                }
            });
        }
    }

    private ClassPath getClassPathForFile(Project project, FileObject file) {
        SourceGroup[] srcGroups;
        for (SourceGroup srcGroup : srcGroups = ProjectUtils.getSources((Project)project).getSourceGroups("java")) {
            FileObject srcRoot = srcGroup.getRootFolder();
            if (!FileUtil.isParentOf((FileObject)srcRoot, (FileObject)file)) continue;
            return ClassPath.getClassPath((FileObject)srcRoot, (String)"classpath/source");
        }
        return null;
    }

    private static class DelegateMethodTask
    implements CancellableTask<WorkingCopy> {
        private boolean onClassPath;
        private String interfaceClass;
        private boolean isIncomplete;
        private EjbReference ref;

        DelegateMethodTask(EjbReference ref) {
            this.ref = ref;
        }

        public void run(WorkingCopy workingCopy) throws IOException {
            workingCopy.toPhase(JavaSource.Phase.RESOLVED);
            TreeMaker make = workingCopy.getTreeMaker();
            TypeElement typeElement = SourceUtils.getPublicTopLevelElement((CompilationController)workingCopy);
            if (typeElement != null) {
                VariableTree ejbRefInjection = null;
                this.interfaceClass = this.ref.getLocal();
                if (this.interfaceClass == null) {
                    this.interfaceClass = this.ref.getRemote();
                }
                if (this.interfaceClass == null) {
                    this.interfaceClass = this.ref.getEjbClass();
                }
                ejbRefInjection = this.generateEjbInjection(workingCopy, make);
                if (this.isIncomplete) {
                    return;
                }
                if (ejbRefInjection != null) {
                    String comment1 = "Add business logic below. (Right-click in editor and choose";
                    String comment2 = "\"Insert Code > Add Web Service Operation\")";
                    make.addComment((Tree)ejbRefInjection, Comment.create((Comment.Style)Comment.Style.LINE, (int)0, (int)0, (int)4, (String)comment1), false);
                    make.addComment((Tree)ejbRefInjection, Comment.create((Comment.Style)Comment.Style.LINE, (int)0, (int)0, (int)4, (String)comment2), false);
                    ClassTree javaClass = workingCopy.getTrees().getTree(typeElement);
                    ClassTree modifiedClass = make.insertClassMember(javaClass, 0, (Tree)ejbRefInjection);
                    if (this.onClassPath) {
                        TypeElement beanInterface = workingCopy.getElements().getTypeElement(this.interfaceClass);
                        modifiedClass = this.generateMethods(workingCopy, make, typeElement, modifiedClass, beanInterface);
                        if (this.isIncomplete) {
                            return;
                        }
                    }
                    workingCopy.rewrite((Tree)javaClass, (Tree)modifiedClass);
                }
            }
        }

        public void cancel() {
        }

        public String getInterfaceClass() {
            return this.interfaceClass;
        }

        public boolean onClassPath() {
            return this.onClassPath;
        }

        public boolean isIncomplete() {
            return this.isIncomplete;
        }

        private VariableTree generateEjbInjection(WorkingCopy workingCopy, TreeMaker make) {
            TypeElement ejbAnElement = workingCopy.getElements().getTypeElement("javax.ejb.EJB");
            if (ejbAnElement == null) {
                this.isIncomplete = true;
                return null;
            }
            TypeElement interfaceElement = workingCopy.getElements().getTypeElement(this.interfaceClass);
            if (interfaceElement == null) {
                this.isIncomplete = true;
                return null;
            }
            AnnotationTree ejbAnnotation = make.Annotation((Tree)make.QualIdent((Element)ejbAnElement), Collections.emptyList());
            ModifiersTree methodModifiers = make.Modifiers(Collections.singleton(Modifier.PRIVATE), Collections.singletonList(ejbAnnotation));
            this.onClassPath = interfaceElement != null;
            return make.Variable(methodModifiers, (CharSequence)"ejbRef", this.onClassPath ? make.Type(interfaceElement.asType()) : make.Identifier((CharSequence)this.interfaceClass), null);
        }

        private ClassTree generateMethods(WorkingCopy workingCopy, TreeMaker make, TypeElement classElement, ClassTree modifiedClass, TypeElement beanInterface) throws IOException {
            GeneratorUtilities utils = GeneratorUtilities.get((WorkingCopy)workingCopy);
            TypeElement webMethodEl = workingCopy.getElements().getTypeElement("javax.jws.WebMethod");
            if (webMethodEl == null) {
                this.isIncomplete = true;
                return modifiedClass;
            }
            TypeMirror superclass = beanInterface.getSuperclass();
            boolean hasSuperclass = TypeKind.NONE != superclass.getKind() && !this.isObjectClass((DeclaredType)superclass);
            List<? extends Element> allBeanInterfaceElements = null;
            allBeanInterfaceElements = hasSuperclass ? workingCopy.getElements().getAllMembers(beanInterface) : beanInterface.getEnclosedElements();
            HashSet<String> operationNames = new HashSet<String>();
            for (Element element : allBeanInterfaceElements) {
                Element classEl;
                if (element.getKind() != ElementKind.METHOD || !element.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
                ExecutableElement methodEl = (ExecutableElement)element;
                if (hasSuperclass && (classEl = element.getEnclosingElement()).getKind() == ElementKind.CLASS && this.isObjectClass((TypeElement)classEl)) continue;
                MethodTree method = utils.createMethod((DeclaredType)beanInterface.asType(), methodEl);
                Name methodName = methodEl.getSimpleName();
                boolean isVoid = workingCopy.getTypes().getNoType(TypeKind.VOID) == methodEl.getReturnType();
                String operationName = this.findUniqueOperationName(operationNames, methodName.toString());
                operationNames.add(operationName);
                AssignmentTree opName = make.Assignment((ExpressionTree)make.Identifier((CharSequence)"operationName"), (ExpressionTree)make.Literal((Object)operationName));
                AnnotationTree webMethodAn = make.Annotation((Tree)make.QualIdent((Element)webMethodEl), Collections.singletonList(opName));
                ModifiersTree modifiersTree = make.Modifiers(Collections.singleton(Modifier.PUBLIC), Collections.singletonList(webMethodAn));
                if (!methodName.contentEquals(operationName)) {
                    TypeElement requestWrapperEl = workingCopy.getElements().getTypeElement("javax.xml.ws.RequestWrapper");
                    TypeElement responseWrapperEl = workingCopy.getElements().getTypeElement("javax.xml.ws.ResponseWrapper");
                    if (requestWrapperEl == null || responseWrapperEl == null) {
                        this.isIncomplete = true;
                        return modifiedClass;
                    }
                    AssignmentTree className = make.Assignment((ExpressionTree)make.Identifier((CharSequence)"className"), (ExpressionTree)make.Literal((Object)operationName));
                    AnnotationTree requestWrapperAn = make.Annotation((Tree)make.QualIdent((Element)requestWrapperEl), Collections.singletonList(className));
                    modifiersTree = make.addModifiersAnnotation(modifiersTree, requestWrapperAn);
                    if (!isVoid) {
                        className = make.Assignment((ExpressionTree)make.Identifier((CharSequence)"className"), (ExpressionTree)make.Literal((Object)(operationName + "Response")));
                        AnnotationTree annotationTree = make.Annotation((Tree)make.QualIdent((Element)responseWrapperEl), Collections.singletonList(className));
                        modifiersTree = make.addModifiersAnnotation(modifiersTree, annotationTree);
                    }
                }
                if (isVoid && method.getThrows().isEmpty()) {
                    TypeElement onewayEl = workingCopy.getElements().getTypeElement("javax.jws.Oneway");
                    if (onewayEl == null) {
                        this.isIncomplete = true;
                        return modifiedClass;
                    }
                    AnnotationTree onewayAn = make.Annotation((Tree)make.QualIdent((Element)onewayEl), Collections.emptyList());
                    modifiersTree = make.addModifiersAnnotation(modifiersTree, onewayAn);
                }
                List<? extends VariableTree> params = method.getParameters();
                ArrayList<VariableTree> newParams = new ArrayList<VariableTree>();
                if (params.size() > 0) {
                    TypeElement paramEl = workingCopy.getElements().getTypeElement("javax.jws.WebParam");
                    if (paramEl == null) {
                        this.isIncomplete = true;
                        return modifiedClass;
                    }
                    for (VariableTree variableTree : params) {
                        String paramName = variableTree.getName().toString();
                        AssignmentTree nameAttr = make.Assignment((ExpressionTree)make.Identifier((CharSequence)"name"), (ExpressionTree)make.Literal((Object)paramName));
                        AnnotationTree paramAn = make.Annotation((Tree)make.QualIdent((Element)paramEl), Collections.singletonList(nameAttr));
                        ModifiersTree paramModifierTree = make.addModifiersAnnotation(variableTree.getModifiers(), paramAn);
                        newParams.add(make.Variable(paramModifierTree, (CharSequence)variableTree.getName(), variableTree.getType(), null));
                    }
                }
                ArrayList<IdentifierTree> arguments = new ArrayList<IdentifierTree>();
                for (VariableElement variableElement : methodEl.getParameters()) {
                    arguments.add(make.Identifier((CharSequence)variableElement.getSimpleName()));
                }
                MethodInvocationTree inv = make.MethodInvocation(Collections.emptyList(), (ExpressionTree)make.MemberSelect((ExpressionTree)make.Identifier((CharSequence)"ejbRef"), (CharSequence)methodName), arguments);
                StatementTree statementTree = isVoid ? make.ExpressionStatement((ExpressionTree)inv) : make.Return((ExpressionTree)inv);
                BlockTree body = make.Block(Collections.singletonList(statementTree), false);
                MethodTree delegatingMethod = make.Method(modifiersTree, (CharSequence)method.getName(), method.getReturnType(), method.getTypeParameters(), newParams, method.getThrows(), body, null);
                modifiedClass = make.addClassMember(modifiedClass, (Tree)delegatingMethod);
            }
            return modifiedClass;
        }

        private boolean isObjectClass(DeclaredType classMirror) {
            return this.isObjectClass((TypeElement)classMirror.asElement());
        }

        private boolean isObjectClass(TypeElement classElement) {
            return TypeKind.NONE == classElement.getSuperclass().getKind();
        }

        private String findUniqueOperationName(Set<String> existingNames, String operationName) {
            if (!existingNames.contains(operationName)) {
                return operationName;
            }
            int i = 1;
            String newName = operationName + "_1";
            while (existingNames.contains(newName)) {
                newName = operationName + "_" + String.valueOf(++i);
            }
            return newName;
        }
    }
}

