/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.common.spi;

import java.util.Collection;
import java.util.Objects;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.openide.filesystems.FileObject;
import org.openide.util.Parameters;

public interface ImportantFilesImplementation {
    public Collection<FileInfo> getFiles();

    public void addChangeListener(ChangeListener var1);

    public void removeChangeListener(ChangeListener var1);

    public static final class FileInfo {
        private final FileObject file;
        private final String displayName;
        private final String description;

        public FileInfo(FileObject file) {
            this(file, null, null);
        }

        public FileInfo(FileObject file, @NullAllowed String displayName, @NullAllowed String description) {
            Parameters.notNull((CharSequence)"file", (Object)file);
            if (file.isFolder()) {
                throw new IllegalArgumentException("File cannot be a directory (given: " + file + ")");
            }
            this.file = file;
            this.displayName = displayName;
            this.description = description;
        }

        public FileObject getFile() {
            return this.file;
        }

        @CheckForNull
        public String getDisplayName() {
            return this.displayName;
        }

        @CheckForNull
        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return "FileInfo{file=" + this.file + ", displayName=" + this.displayName + ", description=" + this.description + '}';
        }

        public int hashCode() {
            int hash = 3;
            hash = 71 * hash + Objects.hashCode(this.file);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FileInfo other = (FileInfo)obj;
            return Objects.equals(this.file, other.file);
        }
    }
}

