/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api.condition;

import java.lang.annotation.Annotation;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;

abstract class AbstractOsBasedExecutionCondition<A extends Annotation>
implements ExecutionCondition {
    static final String CURRENT_ARCHITECTURE = System.getProperty("os.arch");
    static final String CURRENT_OS = System.getProperty("os.name");
    private final Class<A> annotationType;

    AbstractOsBasedExecutionCondition(Class<A> annotationType) {
        this.annotationType = annotationType;
    }

    @Override
    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        return AnnotationUtils.findAnnotation(context.getElement(), this.annotationType).map(this::evaluateExecutionCondition).orElseGet(this::enabledByDefault);
    }

    abstract ConditionEvaluationResult evaluateExecutionCondition(A var1);

    String createReason(boolean enabled, boolean osSpecified, boolean archSpecified) {
        StringBuilder reason = new StringBuilder().append(enabled ? "Enabled" : "Disabled").append(osSpecified ? " on operating system: " : " on architecture: ");
        if (osSpecified && archSpecified) {
            reason.append(String.format("%s (%s)", CURRENT_OS, CURRENT_ARCHITECTURE));
        } else if (osSpecified) {
            reason.append(CURRENT_OS);
        } else {
            reason.append(CURRENT_ARCHITECTURE);
        }
        return reason.toString();
    }

    private ConditionEvaluationResult enabledByDefault() {
        String reason = String.format("@%s is not present", this.annotationType.getSimpleName());
        return ConditionEvaluationResult.enabled(reason);
    }
}

