/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.errors.Bundle;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.support.FixFactory;

public final class OverrideWeakerAccess
implements ErrorRule<Void> {
    private static final Set<String> ERROR_CODES = new HashSet<String>(Arrays.asList("compiler.err.override.weaker.access"));
    private static final Set<Modifier> ACCESS_RIGHT_MASK = EnumSet.of(Modifier.PUBLIC, Modifier.PROTECTED, Modifier.PRIVATE);

    public Set<String> getCodes() {
        return ERROR_CODES;
    }

    public List<Fix> run(CompilationInfo info, String diagnosticKey, int offset, TreePath treePath, ErrorRule.Data<Void> data) {
        ArrayList<Fix> result = new ArrayList<Fix>();
        Element ex = info.getTrees().getElement(treePath);
        if (treePath.getLeaf().getKind() == Tree.Kind.METHOD && ex != null && ex.getKind() == ElementKind.METHOD) {
            EnumSet<Modifier> desiredAccess = EnumSet.noneOf(Modifier.class);
            ExecutableElement overridden = info.getElementUtilities().getOverriddenMethod((ExecutableElement)ex);
            if (overridden != null) {
                desiredAccess.addAll(overridden.getModifiers());
                desiredAccess.retainAll(ACCESS_RIGHT_MASK);
            } else {
                desiredAccess.add(Modifier.PUBLIC);
            }
            EnumSet<Modifier> toRemove = EnumSet.noneOf(Modifier.class);
            toRemove.addAll(ex.getModifiers());
            toRemove.retainAll(ACCESS_RIGHT_MASK);
            String name = ex.getSimpleName().toString();
            String modifier = desiredAccess.isEmpty() ? Bundle.FIX_DefaultAccess(name) : Bundle.FIX_ChangeModifiers(name, ((Modifier)((Object)desiredAccess.iterator().next())).name().toLowerCase());
            result.add(FixFactory.changeModifiersFix((CompilationInfo)info, (TreePath)new TreePath(treePath, ((MethodTree)treePath.getLeaf()).getModifiers()), desiredAccess, toRemove, (String)modifier));
        }
        return result;
    }

    public void cancel() {
    }

    public String getId() {
        return OverrideWeakerAccess.class.getName();
    }

    public String getDisplayName() {
        return Bundle.DN_OverrideWeakerAccess();
    }

    public String getDescription() {
        return Bundle.DESC_OverrideWeakerAccess();
    }
}

