/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.codegen.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.rest.codegen.model.EntityResourceModelBuilder;
import org.netbeans.modules.websvc.rest.spi.MiscUtilities;
import org.netbeans.modules.websvc.rest.support.AbstractTask;
import org.netbeans.modules.websvc.rest.support.SourceGroupSupport;
import org.netbeans.modules.websvc.rest.wizard.Util;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class EntityClassInfo {
    private static final String JAVAX_PERSISTENCE = "javax.persistence.";
    private static final String JAKARTA_PERSISTENCE = "jakarta.persistence.";
    private static final String MAPPED_SUPERCLASS = "javax.persistence.MappedSuperclass";
    private static final String MAPPED_SUPERCLASS_JAKARTA = "jakarta.persistence.MappedSuperclass";
    private static final String ENTITY = "javax.persistence.Entity";
    private static final String ENTITY_JAKARTA = "jakarta.persistence.Entity";
    private static final Set<String> LIFECYCLE_ANNOTATIONS = new HashSet<String>(7);
    private EntityResourceModelBuilder builder;
    private final String entityFqn;
    private String name;
    private String type;
    private String packageName;
    private Collection<FieldInfo> fieldInfos;
    private FieldInfo idFieldInfo;
    private ElementHandle<TypeElement> handle;
    private Set<EntityClassInfo> relatedEntities;

    public EntityClassInfo(String entityFqn, ElementHandle<TypeElement> handle, Project project, EntityResourceModelBuilder builder) {
        this.entityFqn = entityFqn;
        this.fieldInfos = new ArrayList<FieldInfo>();
        this.builder = builder;
        this.handle = handle;
        this.extractFields(project);
        if (this.idFieldInfo != null && this.idFieldInfo.isEmbeddedId()) {
            this.extractPKFields(project);
        }
    }

    protected void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected void setType(String type) {
        this.type = type;
    }

    protected void extractFields(Project project) {
        try {
            JavaSource source = this.getJavaSource(project);
            if (source != null) {
                source.runUserActionTask((Task)new AbstractTask<CompilationController>(){

                    public void run(CompilationController controller) throws IOException {
                        controller.toPhase(JavaSource.Phase.RESOLVED);
                        TypeElement classElement = (TypeElement)EntityClassInfo.this.handle.resolve((CompilationInfo)controller);
                        if (classElement == null) {
                            return;
                        }
                        EntityClassInfo.this.packageName = controller.getElements().getPackageOf(classElement).getQualifiedName().toString();
                        EntityClassInfo.this.name = classElement.getSimpleName().toString();
                        EntityClassInfo.this.type = classElement.getQualifiedName().toString();
                        if (EntityClassInfo.this.useFieldAccess(classElement, controller)) {
                            EntityClassInfo.this.extractFields((DeclaredType)classElement.asType(), classElement, controller);
                        } else {
                            EntityClassInfo.this.extractFieldsFromMethods((DeclaredType)classElement.asType(), classElement, controller);
                        }
                    }
                }, true);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    protected void extractFields(DeclaredType originalEntity, TypeElement typeElement, CompilationController controller) {
        List<VariableElement> fields = ElementFilter.fieldsIn(typeElement.getEnclosedElements());
        for (VariableElement field : fields) {
            Set<Modifier> modifiers = field.getModifiers();
            if (modifiers.contains((Object)Modifier.STATIC) || modifiers.contains((Object)Modifier.TRANSIENT) || modifiers.contains((Object)Modifier.VOLATILE) || modifiers.contains((Object)Modifier.FINAL)) continue;
            FieldInfo fieldInfo = new FieldInfo();
            fieldInfo.parseAnnotations(field.getAnnotationMirrors());
            if (!fieldInfo.isPersistent()) continue;
            this.fieldInfos.add(fieldInfo);
            fieldInfo.setName(field.getSimpleName().toString());
            fieldInfo.setType(controller.getTypes().asMemberOf(originalEntity, field), controller);
            if (!fieldInfo.isId() || this.idFieldInfo != null) continue;
            this.idFieldInfo = fieldInfo;
        }
        TypeElement superClass = this.getJPASuperClass(typeElement, controller);
        if (superClass == null) {
            return;
        }
        this.extractFields(originalEntity, superClass, controller);
    }

    protected void extractFieldsFromMethods(DeclaredType originalEntity, TypeElement typeElement, CompilationController controller) {
        List<ExecutableElement> methods = ElementFilter.methodsIn(typeElement.getEnclosedElements());
        for (ExecutableElement method : methods) {
            Set<Modifier> modifiers = method.getModifiers();
            if (modifiers.contains((Object)Modifier.STATIC) || modifiers.contains((Object)Modifier.PRIVATE)) continue;
            FieldInfo fieldInfo = new FieldInfo();
            fieldInfo.parseAnnotations(method.getAnnotationMirrors());
            if (!fieldInfo.isPersistent() || !fieldInfo.hasPersistenceAnnotation()) continue;
            this.fieldInfos.add(fieldInfo);
            String name = method.getSimpleName().toString();
            if (name.startsWith("get")) {
                name = name.substring(3);
                name = Util.lowerFirstChar(name);
            }
            fieldInfo.setName(name);
            TypeMirror methodType = controller.getTypes().asMemberOf(originalEntity, method);
            fieldInfo.setType(((ExecutableType)methodType).getReturnType(), controller);
            if (!fieldInfo.isId()) continue;
            this.idFieldInfo = fieldInfo;
        }
        TypeElement superClass = this.getJPASuperClass(typeElement, controller);
        if (superClass == null) {
            return;
        }
        this.extractFieldsFromMethods(originalEntity, superClass, controller);
    }

    protected void extractPKFields(Project project) {
        FileObject root = MiscUtilities.findSourceRoot((Project)project);
        if (root != null) {
            try {
                ClasspathInfo cpInfo = ClasspathInfo.create((FileObject)root);
                JavaSource pkSource = JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[0]);
                if (pkSource == null) {
                    throw new IllegalArgumentException("No JavaSource object for " + this.idFieldInfo.getType());
                }
                pkSource.runUserActionTask((Task)new AbstractTask<CompilationController>(){

                    public void run(CompilationController controller) throws IOException {
                        controller.toPhase(JavaSource.Phase.RESOLVED);
                        TypeElement classElement = controller.getElements().getTypeElement(EntityClassInfo.this.idFieldInfo.getType());
                        EntityClassInfo.this.extractPKFields(classElement, controller);
                    }
                }, true);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        } else {
            throw new IllegalArgumentException("No source root for " + project.getProjectDirectory().getName());
        }
    }

    protected void extractPKFields(TypeElement typeElement, CompilationController controller) {
        List<VariableElement> fields = ElementFilter.fieldsIn(typeElement.getEnclosedElements());
        for (VariableElement field : fields) {
            Set<Modifier> modifiers = field.getModifiers();
            if (modifiers.contains((Object)Modifier.STATIC) || modifiers.contains((Object)Modifier.TRANSIENT) || modifiers.contains((Object)Modifier.VOLATILE) || modifiers.contains((Object)Modifier.FINAL)) continue;
            FieldInfo fieldInfo = new FieldInfo();
            this.idFieldInfo.addFieldInfo(fieldInfo);
            fieldInfo.setName(field.getSimpleName().toString());
            fieldInfo.setType(field.asType(), controller);
        }
    }

    private TypeElement getJPASuperClass(TypeElement typeElement, CompilationController controller) {
        TypeMirror superclass = typeElement.getSuperclass();
        if (superclass == null) {
            return null;
        }
        Element superElement = controller.getTypes().asElement(superclass);
        if (superElement instanceof TypeElement && this.hasAnnotation(superElement, controller, MAPPED_SUPERCLASS_JAKARTA, ENTITY_JAKARTA, MAPPED_SUPERCLASS, ENTITY)) {
            return (TypeElement)superElement;
        }
        return null;
    }

    private JavaSource getJavaSource(Project project) throws IOException {
        return SourceGroupSupport.getJavaSourceFromClassName(this.entityFqn, project);
    }

    private boolean useFieldAccess(TypeElement typeElement, CompilationController controller) {
        List<VariableElement> fields = ElementFilter.fieldsIn(typeElement.getEnclosedElements());
        for (VariableElement field : fields) {
            Set<Modifier> modifiers = field.getModifiers();
            if (modifiers.contains((Object)Modifier.STATIC) || modifiers.contains((Object)Modifier.TRANSIENT) || modifiers.contains((Object)Modifier.VOLATILE) || modifiers.contains((Object)Modifier.FINAL)) continue;
            FieldInfo fieldInfo = new FieldInfo();
            fieldInfo.parseAnnotations(field.getAnnotationMirrors());
            if (!fieldInfo.isPersistent() || !fieldInfo.hasPersistenceAnnotation()) continue;
            return true;
        }
        TypeElement superClass = this.getJPASuperClass(typeElement, controller);
        if (superClass != null) {
            return this.useFieldAccess(superClass, controller);
        }
        return false;
    }

    public String getEntityFqn() {
        return this.entityFqn;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public FieldInfo getIdFieldInfo() {
        return this.idFieldInfo;
    }

    public Collection<FieldInfo> getFieldInfos() {
        return this.fieldInfos;
    }

    public FieldInfo getFieldInfoByName(String name) {
        for (FieldInfo f : this.fieldInfos) {
            if (!f.getName().equals(name)) continue;
            return f;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntityClassInfo other = (EntityClassInfo)obj;
        if (!(this.name == other.name || this.name != null && this.name.equals(other.name))) {
            return false;
        }
        return this.packageName == other.packageName || this.packageName != null && this.packageName.equals(other.packageName);
    }

    public int hashCode() {
        int hash = 3;
        hash = 47 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 47 * hash + (this.packageName != null ? this.packageName.hashCode() : 0);
        return hash;
    }

    public Set<EntityClassInfo> getEntityClosure(Set<EntityClassInfo> result) {
        if (result.contains(this)) {
            return result;
        }
        result.add(this);
        for (EntityClassInfo info : this.getRelatedEntities()) {
            result.addAll(info.getEntityClosure(result));
        }
        return result;
    }

    public Set<EntityClassInfo> getRelatedEntities() {
        if (this.relatedEntities != null) {
            return this.relatedEntities;
        }
        this.relatedEntities = new HashSet<EntityClassInfo>();
        Set<String> allEntityNames = this.builder.getAllEntityNames();
        for (FieldInfo fi : this.fieldInfos) {
            String type = fi.getType();
            String typeArg = fi.getTypeArg();
            if (type != null && allEntityNames.contains(type)) {
                this.relatedEntities.add(this.builder.getEntityClassInfo(type));
                continue;
            }
            if (typeArg == null || !allEntityNames.contains(typeArg)) continue;
            this.relatedEntities.add(this.builder.getEntityClassInfo(typeArg));
        }
        return this.relatedEntities;
    }

    private boolean hasAnnotation(Element element, CompilationController controller, String ... annotations) {
        List<? extends AnnotationMirror> allAnnotationMirrors = controller.getElements().getAllAnnotationMirrors(element);
        for (AnnotationMirror annotationMirror : allAnnotationMirrors) {
            Element annotationElement = annotationMirror.getAnnotationType().asElement();
            if (!(annotationElement instanceof TypeElement)) continue;
            Name name = ((TypeElement)annotationElement).getQualifiedName();
            for (String annotation : annotations) {
                if (!name.contentEquals(annotation)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        LIFECYCLE_ANNOTATIONS.add("PrePersist");
        LIFECYCLE_ANNOTATIONS.add("PostPersist");
        LIFECYCLE_ANNOTATIONS.add("PreRemove");
        LIFECYCLE_ANNOTATIONS.add("PostRemove");
        LIFECYCLE_ANNOTATIONS.add("PreUpdate");
        LIFECYCLE_ANNOTATIONS.add("PostUpdate");
        LIFECYCLE_ANNOTATIONS.add("PostLoad");
    }

    public static class FieldInfo {
        private String name;
        private String type;
        private String simpleTypeName;
        private String typeArg;
        private String simpleTypeArgName;
        private Relationship relationship;
        private boolean isPersistent = true;
        private boolean hasPersistenceAnnotation = false;
        private boolean isId = false;
        private boolean isEmbeddedId = false;
        private boolean isGeneratedValue = false;
        private String mappedBy = null;
        private Collection<FieldInfo> fieldInfos;
        private StringConverter stringConverter;
        private boolean hasEmptyCtor;
        private String stringConverterClassName;
        private boolean isArray;

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setType(TypeMirror type, CompilationController controller) {
            if (type.getKind() == TypeKind.DECLARED) {
                DeclaredType declType = (DeclaredType)type;
                Element typeElement = declType.asElement();
                this.initTypeElement(type, controller);
                this.setType(typeElement.toString(), controller);
                for (TypeMirror typeMirror : declType.getTypeArguments()) {
                    this.setTypeArg(typeMirror.toString());
                }
            } else if (type.getKind() == TypeKind.ARRAY) {
                this.isArray = true;
                TypeMirror componentType = ((ArrayType)type).getComponentType();
                if (componentType.getKind() == TypeKind.DECLARED) {
                    this.initTypeElement(componentType, controller);
                }
                this.setType(type.toString(), controller);
            } else {
                this.setType(type.toString(), controller);
            }
        }

        public String getType() {
            return this.type;
        }

        public String getSimpleTypeName() {
            return this.simpleTypeName;
        }

        public String getTypeArg() {
            return this.typeArg;
        }

        public String getSimpleTypeArgName() {
            return this.simpleTypeArgName;
        }

        public String getEntityClassName() {
            return this.simpleTypeArgName != null ? this.simpleTypeArgName : this.simpleTypeName;
        }

        public void parseAnnotations(List<? extends AnnotationMirror> annotationMirrors) {
            for (AnnotationMirror annotationMirror : annotationMirrors) {
                String simpleName;
                String annotationType = annotationMirror.getAnnotationType().toString();
                if (annotationType.startsWith(EntityClassInfo.JAKARTA_PERSISTENCE)) {
                    simpleName = annotationType.substring(EntityClassInfo.JAKARTA_PERSISTENCE.length());
                } else {
                    if (!annotationType.startsWith(EntityClassInfo.JAVAX_PERSISTENCE)) continue;
                    simpleName = annotationType.substring(EntityClassInfo.JAVAX_PERSISTENCE.length());
                }
                if (LIFECYCLE_ANNOTATIONS.contains(simpleName)) continue;
                this.hasPersistenceAnnotation = true;
                if (annotationType.contains("EmbeddedId")) {
                    this.isEmbeddedId = true;
                    this.isId = true;
                    continue;
                }
                if (annotationType.contains("Id")) {
                    this.isId = true;
                    continue;
                }
                if (annotationType.contains("OneToOne")) {
                    this.relationship = Relationship.OneToOne;
                    this.parseRelationship(annotationMirror);
                    continue;
                }
                if (annotationType.contains("OneToMany")) {
                    this.relationship = Relationship.OneToMany;
                    this.parseRelationship(annotationMirror);
                    continue;
                }
                if (annotationType.contains("ManyToOne")) {
                    this.relationship = Relationship.ManyToOne;
                    continue;
                }
                if (annotationType.contains("ManyToMany")) {
                    this.relationship = Relationship.ManyToMany;
                    this.parseRelationship(annotationMirror);
                    continue;
                }
                if (annotationType.contains("Transient")) {
                    this.isPersistent = false;
                    continue;
                }
                if (!annotationType.contains("GeneratedValue")) continue;
                this.isGeneratedValue = true;
            }
        }

        private void parseRelationship(AnnotationMirror annotation) {
            Map<? extends ExecutableElement, ? extends AnnotationValue> map = annotation.getElementValues();
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : map.entrySet()) {
                ExecutableElement e = entry.getKey();
                if (!e.getSimpleName().toString().equals("mappedBy")) continue;
                this.mappedBy = entry.getValue().toString();
                return;
            }
        }

        public boolean isPersistent() {
            return this.isPersistent;
        }

        public boolean hasPersistenceAnnotation() {
            return this.hasPersistenceAnnotation;
        }

        public boolean isId() {
            return this.isId;
        }

        public boolean isGeneratedValue() {
            return this.isGeneratedValue;
        }

        public boolean isEmbeddedId() {
            return this.isEmbeddedId;
        }

        public boolean isRelationship() {
            return this.relationship != null;
        }

        public boolean isOneToOne() {
            return this.relationship == Relationship.OneToOne;
        }

        public boolean isOneToMany() {
            return this.relationship == Relationship.OneToMany;
        }

        public boolean isManyToOne() {
            return this.relationship == Relationship.ManyToOne;
        }

        public boolean isManyToMany() {
            return this.relationship == Relationship.ManyToMany;
        }

        public String getMappedByField() {
            return this.mappedBy;
        }

        public void addFieldInfo(FieldInfo info) {
            if (this.fieldInfos == null) {
                this.fieldInfos = new ArrayList<FieldInfo>();
            }
            this.fieldInfos.add(info);
        }

        public Collection<FieldInfo> getFieldInfos() {
            return this.fieldInfos;
        }

        public boolean hasEmptyCtor() {
            return this.hasEmptyCtor;
        }

        public boolean isArray() {
            return this.isArray;
        }

        public String getStringConverterMethod() {
            if (this.stringConverterClassName == null) {
                return null;
            }
            switch (this.stringConverter.ordinal()) {
                case 0: {
                    return "new " + this.stringConverterClassName;
                }
                case 1: {
                    return this.stringConverterClassName + ".valueOf";
                }
                case 2: {
                    return this.stringConverterClassName + ".fromString";
                }
            }
            return null;
        }

        private StringConverter getStringConverter() {
            return this.stringConverter;
        }

        private void initTypeElement(TypeMirror type, CompilationController controller) {
            DeclaredType declType = (DeclaredType)type;
            Element typeElement = declType.asElement();
            List<ExecutableElement> constructors = ElementFilter.constructorsIn(typeElement.getEnclosedElements());
            for (ExecutableElement constructor : constructors) {
                List<? extends VariableElement> parameters = constructor.getParameters();
                if (parameters.size() == 0) {
                    this.hasEmptyCtor = true;
                    continue;
                }
                if (parameters.size() != 1 || !this.hasSingleStringParam(constructor)) continue;
                this.stringConverter = StringConverter.CTOR;
            }
            if (this.stringConverter == null) {
                this.setStringConverter(typeElement);
            }
            if (typeElement instanceof TypeElement) {
                this.stringConverterClassName = ((TypeElement)typeElement).getQualifiedName().toString();
            }
        }

        private void setStringConverter(Element typeElement) {
            List<ExecutableElement> methods = ElementFilter.methodsIn(typeElement.getEnclosedElements());
            for (ExecutableElement method : methods) {
                List<? extends VariableElement> parameters;
                Set<Modifier> modifiers = method.getModifiers();
                if (!modifiers.contains((Object)Modifier.STATIC) || !modifiers.contains((Object)Modifier.PUBLIC) || (parameters = method.getParameters()).size() != 1) continue;
                if (method.getSimpleName().contentEquals("valueOf")) {
                    this.stringConverter = StringConverter.VALUE_OF;
                    continue;
                }
                if (!method.getSimpleName().contentEquals("fromString")) continue;
                this.stringConverter = StringConverter.FROM_STRING;
            }
        }

        private boolean hasSingleStringParam(ExecutableElement method) {
            String fqn;
            Element paramElement;
            List<? extends VariableElement> parameters = method.getParameters();
            if (parameters.size() != 1) {
                return false;
            }
            VariableElement variableElement = parameters.get(0);
            TypeMirror paramType = variableElement.asType();
            return paramType.getKind() == TypeKind.DECLARED && (paramElement = ((DeclaredType)paramType).asElement()) instanceof TypeElement && (fqn = ((TypeElement)paramElement).getQualifiedName().toString()).equals(String.class.getCanonicalName());
        }

        private void setType(String type, CompilationController controller) {
            Class<?> primitiveType = Util.getPrimitiveType(type);
            if (primitiveType != null) {
                this.type = primitiveType.getSimpleName();
                this.simpleTypeName = primitiveType.getSimpleName();
                Class<?> clazz = primitiveType;
                if (primitiveType.isArray()) {
                    this.isArray = true;
                    clazz = primitiveType.getComponentType();
                }
                this.stringConverterClassName = clazz.getCanonicalName();
                TypeElement typeElement = controller.getElements().getTypeElement(this.stringConverterClassName);
                if (typeElement != null) {
                    this.initTypeElement(typeElement.asType(), controller);
                }
            } else {
                this.type = type;
                this.simpleTypeName = type.substring(type.lastIndexOf(".") + 1);
            }
        }

        private void setTypeArg(String typeArg) {
            this.typeArg = typeArg;
            this.simpleTypeArgName = typeArg.substring(typeArg.lastIndexOf(".") + 1);
        }

        private static enum Relationship {
            OneToOne,
            OneToMany,
            ManyToOne,
            ManyToMany;

        }

        private static enum StringConverter {
            CTOR,
            VALUE_OF,
            FROM_STRING;

        }
    }
}

