/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.keymanagement.model.BackupKeyDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class BackupKeyRequest
extends BmcRequest<BackupKeyDetails> {
    private String keyId;
    private String ifMatch;
    private String opcRequestId;
    private String opcRetryToken;
    private BackupKeyDetails backupKeyDetails;

    public String getKeyId() {
        return this.keyId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public BackupKeyDetails getBackupKeyDetails() {
        return this.backupKeyDetails;
    }

    @InternalSdk
    public BackupKeyDetails getBody$() {
        return this.backupKeyDetails;
    }

    public Builder toBuilder() {
        return new Builder().keyId(this.keyId).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken).backupKeyDetails(this.backupKeyDetails);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",keyId=").append(String.valueOf(this.keyId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",backupKeyDetails=").append(String.valueOf((Object)this.backupKeyDetails));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BackupKeyRequest)) {
            return false;
        }
        BackupKeyRequest other = (BackupKeyRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.keyId, other.keyId) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals((Object)this.backupKeyDetails, (Object)other.backupKeyDetails);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.keyId == null ? 43 : this.keyId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.backupKeyDetails == null ? 43 : this.backupKeyDetails.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<BackupKeyRequest, BackupKeyDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String keyId = null;
        private String ifMatch = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;
        private BackupKeyDetails backupKeyDetails = null;

        public Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder backupKeyDetails(BackupKeyDetails backupKeyDetails) {
            this.backupKeyDetails = backupKeyDetails;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(BackupKeyRequest o) {
            this.keyId(o.getKeyId());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.backupKeyDetails(o.getBackupKeyDetails());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public BackupKeyRequest build() {
            BackupKeyRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(BackupKeyDetails body) {
            this.backupKeyDetails(body);
            return this;
        }

        public BackupKeyRequest buildWithoutInvocationCallback() {
            BackupKeyRequest request = new BackupKeyRequest();
            request.keyId = this.keyId;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            request.backupKeyDetails = this.backupKeyDetails;
            return request;
        }
    }
}

