/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.internal;

import com.oracle.bmc.InternalSdk;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;

@InternalSdk
public final class ParamEncoder {
    private static final BitSet QUERY_PARAM_KEEP_SET;
    private static final BitSet PATH_PARAM_KEEP_SET;
    private static final char[] HEX;

    public static String encodeQueryParam(String input) {
        return ParamEncoder.encode(input, QUERY_PARAM_KEEP_SET);
    }

    public static String encodePathParam(String input) {
        return ParamEncoder.encode(input, PATH_PARAM_KEEP_SET);
    }

    private static String encode(String input, BitSet keepSet) {
        boolean needEscape = false;
        for (int i = 0; i < input.length(); ++i) {
            if (keepSet.get(input.charAt(i))) continue;
            needEscape = true;
            break;
        }
        if (!needEscape) {
            return input;
        }
        StringBuilder builder = new StringBuilder();
        int off = 0;
        while (off < input.length()) {
            int cp = input.codePointAt(off);
            off += Character.charCount(cp);
            if (keepSet.get(cp)) {
                builder.appendCodePoint(cp);
                continue;
            }
            if (cp < 128) {
                ParamEncoder.appendPercentEncodedByte(builder, (byte)cp);
                continue;
            }
            ByteBuffer bytes = StandardCharsets.UTF_8.encode(CharBuffer.wrap(Character.toChars(cp)));
            while (bytes.hasRemaining()) {
                ParamEncoder.appendPercentEncodedByte(builder, bytes.get());
            }
        }
        return builder.toString();
    }

    private static boolean isHex(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    private static void appendPercentEncodedByte(StringBuilder builder, byte b) {
        builder.append('%');
        builder.append(HEX[b >> 4 & 0xF]);
        builder.append(HEX[b & 0xF]);
    }

    static {
        HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        BitSet keepSet = new BitSet(256);
        keepSet.set(32, 127);
        keepSet.clear(37);
        keepSet.clear(32);
        keepSet.clear(34);
        keepSet.clear(35);
        keepSet.clear(60);
        keepSet.clear(62);
        keepSet.clear(63);
        keepSet.clear(96);
        keepSet.clear(123);
        keepSet.clear(125);
        PATH_PARAM_KEEP_SET = (BitSet)keepSet.clone();
        PATH_PARAM_KEEP_SET.clear(47);
        keepSet.clear(47);
        keepSet.clear(58);
        keepSet.clear(59);
        keepSet.clear(61);
        keepSet.clear(64);
        keepSet.clear(91, 95);
        keepSet.clear(124);
        keepSet.clear(36, 39);
        keepSet.clear(43);
        keepSet.clear(44);
        keepSet.clear(33);
        keepSet.clear(39, 42);
        keepSet.clear(126);
        keepSet.clear(42);
        QUERY_PARAM_KEEP_SET = keepSet;
    }
}

