/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk;

import java.awt.Color;
import java.net.URL;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.heapwalk.AbstractController;
import org.netbeans.modules.profiler.heapwalk.Bundle;
import org.netbeans.modules.profiler.heapwalk.HeapFragmentWalker;
import org.netbeans.modules.profiler.heapwalk.SummaryController;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsUtils;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;
import org.netbeans.modules.profiler.heapwalk.ui.HintsControllerUI;

public class HintsController
extends AbstractController {
    private static final String CLASS_URL_PREFIX = "file://class/";
    private static final String INSTANCE_URL_PREFIX = "file://instance/";
    private SummaryController summaryController;

    public HintsController(SummaryController summaryController) {
        this.summaryController = summaryController;
    }

    public SummaryController getSummaryController() {
        return this.summaryController;
    }

    public void createNavigationHistoryPoint() {
        this.summaryController.getHeapFragmentWalker().createNavigationHistoryPoint();
    }

    public void showURL(final URL url) {
        BrowserUtils.performTask(new Runnable(){
            final /* synthetic */ HintsController this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                String urls = url.toString();
                final HeapFragmentWalker heapFragmentWalker = this.this$0.summaryController.getHeapFragmentWalker();
                if (urls.startsWith(HintsController.INSTANCE_URL_PREFIX)) {
                    urls = urls.substring(HintsController.INSTANCE_URL_PREFIX.length());
                    final String[] id = urls.split("/");
                    long instanceId = Long.parseLong(id[2]);
                    final Instance i = heapFragmentWalker.getHeapFragment().getInstanceByID(instanceId);
                    SwingUtilities.invokeLater(new Runnable(){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public void run() {
                            if (i != null) {
                                heapFragmentWalker.getClassesController().showInstance(i);
                            } else {
                                ProfilerDialogs.displayError((String)Bundle.AnalysisController_CannotResolveInstanceMsg(id[1], id[0]));
                            }
                        }
                    });
                } else if (urls.startsWith(HintsController.CLASS_URL_PREFIX)) {
                    urls = urls.substring(HintsController.CLASS_URL_PREFIX.length());
                    final String[] id = urls.split("/");
                    long jclsId = Long.parseLong(id[1]);
                    final JavaClass c = heapFragmentWalker.getHeapFragment().getJavaClassByID(jclsId);
                    SwingUtilities.invokeLater(new Runnable(){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public void run() {
                            if (c != null) {
                                heapFragmentWalker.getClassesController().showClass(c);
                            } else {
                                ProfilerDialogs.displayError((String)Bundle.AnalysisController_CannotResolveClassMsg(id[0]));
                            }
                        }
                    });
                }
            }
        });
    }

    public void computeBiggestObjects(final int number) {
        BrowserUtils.performTask(new Runnable(){
            final /* synthetic */ HintsController this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                int retainedSizesState = this.this$0.getSummaryController().getHeapFragmentWalker().computeRetainedSizes(true, true);
                final String result = retainedSizesState == 3 ? this.this$0.findBiggestObjects(number) : Bundle.HintsController_NoData();
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run() {
                        ((HintsControllerUI)((Object)this.this$1.this$0.getPanel())).setResult(result);
                    }
                });
            }
        });
    }

    private String findBiggestObjects(int number) {
        Heap heap = this.getSummaryController().getHeapFragmentWalker().getHeapFragment();
        List bigObjects = heap.getBiggestObjectsByRetainedSize(number);
        StringBuffer output = new StringBuffer();
        JavaClass java_lang_Class = heap.getJavaClassByName(Class.class.getName());
        NumberFormat formatter = NumberFormat.getInstance();
        boolean oddRow = false;
        Color oddRowBackground = UIUtils.getDarker((Color)UIUtils.getProfilerResultsBackground());
        String oddRowBackgroundString = "rgb(" + oddRowBackground.getRed() + "," + oddRowBackground.getGreen() + "," + oddRowBackground.getBlue() + ")";
        output.append("<table border='0' width='100%'>");
        output.append("<tr style='background-color:");
        output.append(oddRowBackgroundString).append(";'>");
        this.addHeading(output, Bundle.HintsController_ClassName());
        this.addHeading(output, Bundle.HintsController_RetainedSize());
        output.append("</tr>");
        for (Instance in : bigObjects) {
            output.append(oddRow ? "<tr style='background-color: " + oddRowBackgroundString + ";'>" : "<tr>");
            if (in.getJavaClass().equals((Object)java_lang_Class)) {
                JavaClass javaClass = heap.getJavaClassByID(in.getInstanceId());
                this.addCell(output, this.printClass(javaClass), false);
            } else {
                this.addCell(output, this.printInstance(in), false);
            }
            this.addCell(output, formatter.format(in.getRetainedSize()), true);
            output.append("</tr>");
            oddRow = !oddRow;
        }
        output.append("</table>");
        return output.toString();
    }

    @Override
    protected AbstractButton createControllerPresenter() {
        return ((HintsControllerUI)((Object)this.getPanel())).getPresenter();
    }

    private void addHeading(StringBuffer output, String text) {
        this.addTag(output, text, "th", false);
    }

    private void addCell(StringBuffer output, String text, boolean ralign) {
        this.addTag(output, text, "td", ralign);
    }

    private void addTag(StringBuffer output, String text, String tag, boolean ralign) {
        output.append("<").append(tag).append(ralign ? " style='text-align: right;'>" : ">");
        output.append(text);
        output.append("</").append(tag).append(">");
    }

    private String printInstance(Instance in) {
        String className = in.getJavaClass().getName();
        return "<a href='file://instance/" + className + "/" + in.getInstanceNumber() + "/" + in.getInstanceId() + "'>" + className + '#' + in.getInstanceNumber() + "</a>";
    }

    private String printClass(JavaClass jcls) {
        String className = jcls.getName();
        return "<a href='file://class/" + className + "/" + jcls.getJavaClassId() + "'>class " + className + "</a>";
    }

    private String printWindow(Instance window, Heap heap) {
        boolean visible = DetailsUtils.getBooleanFieldValue(window, "visible", false);
        if (!visible) {
            return null;
        }
        String string = "&nbsp;&nbsp;&nbsp;&nbsp;";
        string = string + this.printInstance(window);
        String details = DetailsUtils.getInstanceString(window, heap);
        if (details != null) {
            string = string + " - " + details;
        }
        return string;
    }

    private void populateUIPreview() {
        String string;
        Collection frames;
        boolean hasWindows = false;
        StringBuilder sb = new StringBuilder();
        String windowsRes = Icons.getResource((String)"HeapWalkerIcons.Window");
        String hintsCaption = new String("<b><img border='0' align='bottom' src='nbresloc:/" + windowsRes + "'>&nbsp;&nbsp;" + Bundle.HintsController_ApplicationWindowsCaption() + "</b><br><hr>");
        sb.append(hintsCaption);
        Heap heap = this.getSummaryController().getHeapFragmentWalker().getHeapFragment();
        JavaClass frameClass = heap.getJavaClassByName("java.awt.Frame");
        if (frameClass != null) {
            frames = frameClass.getSubClasses();
            for (JavaClass frame : frames) {
                for (Instance f : frame.getInstances()) {
                    string = this.printWindow(f, heap);
                    if (string == null) continue;
                    sb.append(string);
                    sb.append("<br>");
                    hasWindows = true;
                }
            }
        }
        if ((frameClass = heap.getJavaClassByName("java.awt.Dialog")) != null) {
            frames = frameClass.getSubClasses();
            for (JavaClass frame : frames) {
                for (Instance f : frame.getInstances()) {
                    string = this.printWindow(f, heap);
                    if (string == null) continue;
                    sb.append(string);
                    sb.append("<br>");
                    hasWindows = true;
                }
            }
        }
        if (!hasWindows) {
            return;
        }
        sb.append("<br>");
        final String s = sb.toString();
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ HintsController this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                ((HintsControllerUI)((Object)this.this$0.getPanel())).setComponents(s);
            }
        });
    }

    @Override
    protected JPanel createControllerUI() {
        HintsControllerUI ui = new HintsControllerUI(this);
        BrowserUtils.performTask(new Runnable(){

            @Override
            public void run() {
                HintsController.this.populateUIPreview();
            }
        });
        return ui;
    }
}

