/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.project.fxml;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.javafx2.project.fxml.FXMLTemplateWizardIterator;
import org.netbeans.modules.javafx2.project.fxml.SourceGroupSupport;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ConfigureFXMLPanelVisual
extends JPanel
implements ActionListener,
DocumentListener {
    private Panel observer;
    private Project project;
    private SourceGroupSupport support;
    private boolean ignoreRootCombo;
    private RequestProcessor.Task updatePackagesTask;
    private static final ComboBoxModel WAIT_MODEL = SourceGroupSupport.getWaitModel();
    private final boolean isMaven;
    private JLabel fxmlNameLabel;
    private JTextField fxmlNameTextField;
    private JComboBox locationComboBox;
    private JLabel locationLabel;
    private JComboBox packageComboBox;
    private JLabel packageLabel;
    private JLabel projectLabel;
    private JTextField projectTextField;
    private JLabel resultLabel;
    private JTextField resultTextField;

    private ConfigureFXMLPanelVisual(Panel observer, Project project, SourceGroupSupport support, boolean isMaven) {
        this.observer = observer;
        this.project = project;
        this.support = support;
        this.isMaven = isMaven;
        this.setName(NbBundle.getMessage(ConfigureFXMLPanelVisual.class, (String)"TXT_FXMLNameAndLoc"));
        this.initComponents();
        this.initComponents2();
    }

    private void fireChange() {
        this.observer.fireChangeEvent();
    }

    private void initComponents2() {
        this.fxmlNameTextField.getDocument().addDocumentListener(this);
        this.packageComboBox.getEditor().addActionListener(this);
        Component packageEditor = this.packageComboBox.getEditor().getEditorComponent();
        if (packageEditor instanceof JTextField) {
            ((JTextField)packageEditor).getDocument().addDocumentListener(this);
        }
        this.locationComboBox.setRenderer(new SourceGroupSupport.GroupListCellRenderer());
        this.packageComboBox.setRenderer(PackageView.listRenderer());
        this.locationComboBox.addActionListener(this);
    }

    public void initValues(FileObject template, FileObject preselectedFolder) {
        String displayName;
        if (template == null) {
            throw new IllegalArgumentException(NbBundle.getMessage(ConfigureFXMLPanelVisual.class, (String)"MSG_ConfigureFXMLPanel_Template_Error"));
        }
        this.projectTextField.setText(ProjectUtils.getInformation((Project)this.project).getDisplayName());
        try {
            DataObject templateDo = DataObject.find((FileObject)template);
            displayName = templateDo.getNodeDelegate().getDisplayName();
        }
        catch (DataObjectNotFoundException ex) {
            displayName = template.getName();
        }
        this.putClientProperty("NewFileWizard_Title", displayName);
        this.locationComboBox.setModel(new DefaultComboBoxModel<Object>(this.support.getSourceGroups().toArray()));
        SourceGroupSupport.SourceGroupProxy preselectedGroup = SourceGroupSupport.getContainingSourceGroup(this.support, preselectedFolder);
        this.ignoreRootCombo = true;
        this.locationComboBox.setSelectedItem(preselectedGroup);
        this.ignoreRootCombo = false;
        FileObject targetFolder = preselectedFolder;
        if (this.isMaven && this.support.getType().equals("resources")) {
            File f;
            this.packageComboBox.getEditor().setItem("fxml");
            targetFolder = null;
            if (preselectedGroup.isReal() && (f = new File(preselectedGroup.getRootFolder().getPath() + File.separator + "fxml")).exists()) {
                targetFolder = FileUtil.toFileObject((File)f);
            }
        } else {
            Object preselectedPackage = FXMLTemplateWizardIterator.getPreselectedPackage(preselectedGroup, preselectedFolder);
            if (preselectedPackage != null) {
                this.packageComboBox.getEditor().setItem(preselectedPackage);
            }
        }
        if (template != null && this.fxmlNameTextField.getText().trim().length() == 0) {
            String baseName;
            String activeName = baseName = template.getName();
            if (targetFolder != null) {
                FileObject fo;
                int index = 0;
                while ((fo = targetFolder.getFileObject(activeName, "fxml")) != null) {
                    activeName = baseName + ++index;
                }
            }
            this.fxmlNameTextField.setText(activeName);
            this.fxmlNameTextField.selectAll();
        }
        this.updatePackages();
        this.updateText();
    }

    public FileObject getLocationFolder() {
        Object selectedItem = this.locationComboBox.getSelectedItem();
        return selectedItem instanceof SourceGroupSupport.SourceGroupProxy ? ((SourceGroupSupport.SourceGroupProxy)selectedItem).getRootFolder() : null;
    }

    public String getPackageFileName() {
        String packageName = this.packageComboBox.getEditor().getItem().toString();
        return packageName.replace('.', '/');
    }

    String getPackageName() {
        return this.packageComboBox.getEditor().getItem().toString();
    }

    public String getFXMLName() {
        String text = this.fxmlNameTextField.getText().trim();
        return text.length() == 0 ? null : text;
    }

    private void initComponents() {
        this.fxmlNameLabel = new JLabel();
        this.fxmlNameTextField = new JTextField();
        this.projectLabel = new JLabel();
        this.locationLabel = new JLabel();
        this.packageLabel = new JLabel();
        this.resultLabel = new JLabel();
        this.projectTextField = new JTextField();
        this.locationComboBox = new JComboBox();
        this.resultTextField = new JTextField();
        this.packageComboBox = new JComboBox();
        this.setPreferredSize(new Dimension(500, 340));
        this.fxmlNameLabel.setLabelFor(this.fxmlNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.fxmlNameLabel, (String)NbBundle.getMessage(ConfigureFXMLPanelVisual.class, (String)"ConfigureFXMLPanelVisual.fxmlNameLabel.text"));
        this.projectLabel.setLabelFor(this.projectTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectLabel, (String)NbBundle.getMessage(ConfigureFXMLPanelVisual.class, (String)"ConfigureFXMLPanelVisual.projectLabel.text"));
        this.locationLabel.setLabelFor(this.locationComboBox);
        Mnemonics.setLocalizedText((JLabel)this.locationLabel, (String)NbBundle.getMessage(ConfigureFXMLPanelVisual.class, (String)"ConfigureFXMLPanelVisual.locationLabel.text"));
        this.packageLabel.setLabelFor(this.packageComboBox);
        Mnemonics.setLocalizedText((JLabel)this.packageLabel, (String)NbBundle.getMessage(ConfigureFXMLPanelVisual.class, (String)"ConfigureFXMLPanelVisual.packageLabel.text"));
        this.resultLabel.setLabelFor(this.resultTextField);
        Mnemonics.setLocalizedText((JLabel)this.resultLabel, (String)NbBundle.getMessage(ConfigureFXMLPanelVisual.class, (String)"ConfigureFXMLPanelVisual.resultLabel.text"));
        this.projectTextField.setEditable(false);
        this.projectTextField.setEnabled(false);
        this.resultTextField.setEditable(false);
        this.resultTextField.setEnabled(false);
        this.packageComboBox.setEditable(true);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.projectLabel, -1, -1, Short.MAX_VALUE).addComponent(this.locationLabel, -1, -1, Short.MAX_VALUE).addComponent(this.packageLabel, -1, -1, Short.MAX_VALUE).addComponent(this.resultLabel)).addComponent(this.fxmlNameLabel, -2, 73, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fxmlNameTextField).addComponent(this.projectTextField).addComponent(this.locationComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.resultTextField).addComponent(this.packageComboBox, 0, 409, Short.MAX_VALUE))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fxmlNameLabel).addComponent(this.fxmlNameTextField, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectLabel).addComponent(this.projectTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.locationComboBox, -2, -1, -2).addComponent(this.locationLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.packageLabel).addComponent(this.packageComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.resultLabel).addComponent(this.resultTextField, -2, -1, -2)).addContainerGap(204, Short.MAX_VALUE)));
        this.fxmlNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureFXMLPanelVisual.class, (String)"ConfigureFXMLPanelVisual.fxmlNameLabel.AccessibleContext.accessibleDescription"));
        this.projectLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureFXMLPanelVisual.class, (String)"ConfigureFXMLPanelVisual.projectLabel.AccessibleContext.accessibleDescription"));
        this.locationLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureFXMLPanelVisual.class, (String)"ConfigureFXMLPanelVisual.locationLabel.AccessibleContext.accessibleDescription"));
        this.packageLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureFXMLPanelVisual.class, (String)"ConfigureFXMLPanelVisual.packageLabel.AccessibleContext.accessibleDescription"));
        this.resultLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureFXMLPanelVisual.class, (String)"ConfigureFXMLPanelVisual.resultLabel.AccessibleContext.accessibleDescription"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.locationComboBox == e.getSource()) {
            if (!this.ignoreRootCombo) {
                this.updatePackages();
            }
            this.updateText();
            this.fireChange();
        } else if (this.packageComboBox == e.getSource()) {
            this.updateText();
            this.fireChange();
        } else if (this.packageComboBox.getEditor() == e.getSource()) {
            this.updateText();
            this.fireChange();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateText();
        this.fireChange();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    private void updatePackages() {
        final Object item = this.locationComboBox.getSelectedItem();
        if (!(item instanceof SourceGroupSupport.SourceGroupProxy)) {
            return;
        }
        WAIT_MODEL.setSelectedItem(this.packageComboBox.getEditor().getItem());
        this.packageComboBox.setModel(WAIT_MODEL);
        if (this.updatePackagesTask != null) {
            this.updatePackagesTask.cancel();
        }
        this.updatePackagesTask = new RequestProcessor("ComboUpdatePackages").post(new Runnable(){
            final /* synthetic */ ConfigureFXMLPanelVisual this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                final ComboBoxModel model = ((SourceGroupSupport.SourceGroupProxy)item).getPackagesComboBoxModel();
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run() {
                        model.setSelectedItem(this.this$1.this$0.packageComboBox.getEditor().getItem());
                        this.this$1.this$0.packageComboBox.setModel(model);
                    }
                });
            }
        });
    }

    private void updateText() {
        String createdFileName;
        Object selectedItem = this.locationComboBox.getSelectedItem();
        if (selectedItem instanceof SourceGroupSupport.SourceGroupProxy) {
            String path;
            SourceGroupSupport.SourceGroupProxy g = (SourceGroupSupport.SourceGroupProxy)selectedItem;
            String packageName = this.getPackageName();
            String fxmlName = this.getFXMLName();
            this.support.setCurrentSourceGroup(g);
            this.support.setCurrentPackageName(packageName);
            this.support.setCurrentFileName(fxmlName);
            if (fxmlName != null && fxmlName.length() > 0) {
                fxmlName = fxmlName + ".fxml";
            }
            createdFileName = (path = this.support.getCurrentPackagePath()) == null ? "" : path.replace(".", "/") + fxmlName;
        } else {
            createdFileName = "";
        }
        this.resultTextField.setText(createdFileName.replace('/', File.separatorChar));
    }

    static class Panel
    implements WizardDescriptor.Panel<WizardDescriptor>,
    WizardDescriptor.FinishablePanel<WizardDescriptor> {
        private ConfigureFXMLPanelVisual component;
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
        private WizardDescriptor settings;
        SourceGroupSupport support;

        public Panel(Project project, SourceGroupSupport support, boolean isMaven) {
            this.support = support;
            this.component = new ConfigureFXMLPanelVisual(this, project, support, isMaven);
        }

        public Component getComponent() {
            return this.component;
        }

        public HelpCtx getHelp() {
            return null;
        }

        public void readSettings(WizardDescriptor settings) {
            this.settings = settings;
            FileObject preselectedFolder = Templates.getTargetFolder((WizardDescriptor)settings);
            this.component.initValues(Templates.getTemplate((WizardDescriptor)settings), preselectedFolder);
            Object substitute = this.component.getClientProperty("NewFileWizard_Title");
            if (substitute != null) {
                settings.putProperty("NewFileWizard_Title", substitute);
            }
        }

        public void storeSettings(WizardDescriptor settings) {
            Object value = settings.getValue();
            if (WizardDescriptor.PREVIOUS_OPTION.equals(value) || WizardDescriptor.CANCEL_OPTION.equals(value) || WizardDescriptor.CLOSED_OPTION.equals(value)) {
                return;
            }
            settings.putProperty("NewFileWizard_Title", null);
        }

        public boolean isValid() {
            if (this.component.getFXMLName() == null) {
                FXMLTemplateWizardIterator.setInfoMessage("WARN_ConfigureFXMLPanel_Provide_FXML_Name", this.settings);
                return false;
            }
            if (!FXMLTemplateWizardIterator.isValidPackageName(this.component.getPackageName())) {
                FXMLTemplateWizardIterator.setErrorMessage("WARN_ConfigureFXMLPanel_Provide_Package_Name", this.settings);
                return false;
            }
            if (!FXMLTemplateWizardIterator.isValidPackage(this.component.getLocationFolder(), this.component.getPackageName())) {
                FXMLTemplateWizardIterator.setErrorMessage("WARN_ConfigureFXMLPanel_Package_Invalid", this.settings);
                return false;
            }
            if (!FXMLTemplateWizardIterator.validFileName(this.component.getFXMLName())) {
                FXMLTemplateWizardIterator.setErrorMessage("MSG_invalid_file_name", this.settings);
                return false;
            }
            FileObject rootFolder = this.component.getLocationFolder();
            String errorMessage = FXMLTemplateWizardIterator.canUseFileName(rootFolder, this.component.getPackageFileName(), this.component.getFXMLName(), "fxml");
            this.settings.getNotificationLineSupport().setErrorMessage(errorMessage);
            return errorMessage == null;
        }

        public void addChangeListener(ChangeListener l) {
            this.changeSupport.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.changeSupport.removeChangeListener(l);
        }

        private void fireChangeEvent() {
            this.changeSupport.fireChange();
        }

        public boolean isFinishPanel() {
            return true;
        }
    }
}

