/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.v2.features;

import javax.swing.JPanel;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.ui.components.ProfilerToolbar;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.v2.ProfilerFeature;
import org.netbeans.modules.profiler.v2.ProfilerSession;
import org.netbeans.modules.profiler.v2.features.Bundle;
import org.netbeans.modules.profiler.v2.features.ThreadsFeatureUI;

final class ThreadsFeature
extends ProfilerFeature.Basic {
    private ThreadsFeatureUI ui;

    private ThreadsFeature(ProfilerSession session) {
        super(Icons.getIcon((String)"ProfilerIcons.WindowThreads"), Bundle.ThreadsFeature_name(), Bundle.ThreadsFeature_description(), 15, session);
    }

    @Override
    public void configureSettings(ProfilingSettings settings) {
        settings.setThreadsMonitoringEnabled(true);
    }

    @Override
    public JPanel getResultsUI() {
        return this.getUI().getResultsUI();
    }

    @Override
    public ProfilerToolbar getToolbar() {
        return this.getUI().getToolbar();
    }

    private ThreadsFeatureUI getUI() {
        if (this.ui == null) {
            this.ui = new ThreadsFeatureUI(){

                @Override
                int getSessionState() {
                    return ThreadsFeature.this.getSessionState();
                }

                @Override
                Profiler getProfiler() {
                    return ThreadsFeature.this.getSession().getProfiler();
                }
            };
        }
        return this.ui;
    }

    @Override
    public void notifyActivated() {
        this.getSession().getProfiler().getThreadsManager().resetStates();
    }

    @Override
    public void notifyDeactivated() {
        this.getSession().getProfiler().getThreadsManager().resetStates();
        if (this.ui != null) {
            this.ui.cleanup();
            this.ui = null;
        }
    }

    @Override
    protected void profilingStateChanged(int oldState, int newState) {
        if (newState == 2) {
            this.getSession().getProfiler().getThreadsManager().reset();
        }
        if (this.ui != null) {
            this.ui.sessionStateChanged(this.getSessionState());
        }
    }

    public static final class Provider
    extends ProfilerFeature.Provider {
        @Override
        public ProfilerFeature getFeature(ProfilerSession session) {
            return new ThreadsFeature(session);
        }
    }
}

