/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rdf.turtle.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.formats.TurtleDocumentFormat;
import org.semanticweb.owlapi.formats.TurtleDocumentFormatFactory;
import org.semanticweb.owlapi.io.AbstractOWLParser;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLDocumentFormatFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.PrefixManager;
import org.semanticweb.owlapi.rdf.turtle.parser.ConsoleTripleHandler;
import org.semanticweb.owlapi.rdf.turtle.parser.OWLRDFConsumerAdapter;
import org.semanticweb.owlapi.rdf.turtle.parser.ParseException;
import org.semanticweb.owlapi.rdf.turtle.parser.TripleHandler;
import org.semanticweb.owlapi.rdf.turtle.parser.TurtleParser;
import org.semanticweb.owlapi.rdf.turtle.parser.TurtleParserException;

public class TurtleOntologyParser
extends AbstractOWLParser {
    private static final long serialVersionUID = 40000L;

    @Override
    @Nonnull
    public String getName() {
        return "TurtleOntologyParser";
    }

    @Override
    public OWLDocumentFormatFactory getSupportedFormat() {
        return new TurtleDocumentFormatFactory();
    }

    @Override
    public OWLDocumentFormat parse(OWLOntologyDocumentSource documentSource, OWLOntology ontology, OWLOntologyLoaderConfiguration configuration) throws IOException {
        Reader reader = null;
        InputStream is = null;
        try {
            TurtleParser parser;
            if (documentSource.isReaderAvailable()) {
                reader = documentSource.getReader();
                parser = new TurtleParser(reader, (TripleHandler)new ConsoleTripleHandler(), documentSource.getDocumentIRI());
            } else if (documentSource.isInputStreamAvailable()) {
                is = documentSource.getInputStream();
                parser = new TurtleParser(is, (TripleHandler)new ConsoleTripleHandler(), documentSource.getDocumentIRI());
            } else {
                if (documentSource.getDocumentIRI().getNamespace().startsWith("jar:")) {
                    if (documentSource.getDocumentIRI().getNamespace().startsWith("jar:!")) {
                        String name = documentSource.getDocumentIRI().toString().substring(5);
                        if (!name.startsWith("/")) {
                            name = "/" + name;
                        }
                        is = this.getClass().getResourceAsStream(name);
                    } else {
                        try {
                            is = ((JarURLConnection)new URL(documentSource.getDocumentIRI().toString()).openConnection()).getInputStream();
                        }
                        catch (IOException e) {
                            throw new OWLParserException(e);
                        }
                    }
                } else {
                    Optional<String> headers = documentSource.getAcceptHeaders();
                    is = headers.isPresent() ? this.getInputStream(documentSource.getDocumentIRI(), configuration, headers.get()) : this.getInputStream(documentSource.getDocumentIRI(), configuration, "application/rdf+xml, application/xml; q=0.7, text/xml; q=0.6, text/plain; q=0.1, */*; q=0.09");
                }
                parser = new TurtleParser(is, (TripleHandler)new ConsoleTripleHandler(), documentSource.getDocumentIRI());
            }
            OWLRDFConsumerAdapter consumer = new OWLRDFConsumerAdapter(ontology, configuration);
            TurtleDocumentFormat format = new TurtleDocumentFormat();
            consumer.setOntologyFormat(format);
            consumer.startModel(documentSource.getDocumentIRI());
            parser.setTripleHandler(consumer);
            parser.parseDocument();
            PrefixManager prefixManager = parser.getPrefixManager();
            for (String prefixName : prefixManager.getPrefixNames()) {
                format.setPrefix(prefixName, prefixManager.getPrefix(prefixName));
            }
            TurtleDocumentFormat turtleDocumentFormat = format;
            return turtleDocumentFormat;
        }
        catch (ParseException e) {
            throw new TurtleParserException(e);
        }
        catch (IOException e) {
            throw new TurtleParserException(e);
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (reader != null) {
                reader.close();
            }
        }
    }
}

