/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.poetry;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.python.pyproject.psi.UtilKt;
import com.jetbrains.python.poetry.PoetryTomlTable;
import com.jetbrains.python.poetry.PsiExtKt;
import com.jetbrains.python.requirements.PackageUtilsKt;
import com.jetbrains.python.requirements.RequirementsCompletionUtilKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.toml.lang.psi.TomlKeyValue;
import org.toml.lang.psi.TomlLiteral;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/jetbrains/python/poetry/PoetryDependencyVersionCompletionContributor;", "Lcom/intellij/codeInsight/completion/CompletionContributor;", "<init>", "()V", "fillCompletionVariants", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "intellij.python.community.impl"})
public final class PoetryDependencyVersionCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        PsiFile psiFile = parameters.getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getOriginalFile(...)");
        if (!UtilKt.isPyProjectToml((PsiFile)psiFile)) {
            return;
        }
        PsiElement psiElement = parameters.getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPosition(...)");
        PoetryTomlTable poetryTomlTable = PsiExtKt.getPoetryTomlTable(psiElement);
        if (poetryTomlTable == null) {
            return;
        }
        PoetryTomlTable poetryTomlTable2 = poetryTomlTable;
        if (!StringsKt.endsWith$default((String)poetryTomlTable2.getHeader(), (String)"dependencies", (boolean)false, (int)2, null)) {
            return;
        }
        PsiElement parent = parameters.getPosition().getParent();
        if (parent instanceof TomlKeyValue) {
            pair = TuplesKt.to((Object)((TomlKeyValue)parent).getKey().getText(), (Object)true);
        } else if (parent instanceof TomlLiteral) {
            TomlKeyValue tomlKeyValue = (TomlKeyValue)PsiTreeUtil.getParentOfType((PsiElement)parent, TomlKeyValue.class);
            pair = TuplesKt.to((Object)(tomlKeyValue != null && (tomlKeyValue = tomlKeyValue.getKey()) != null ? tomlKeyValue.getText() : null), (Object)false);
        } else {
            return;
        }
        Pair pair2 = pair;
        String packageName = (String)pair2.component1();
        boolean addQuotes = (Boolean)pair2.component2();
        PsiFile psiFile2 = parameters.getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getOriginalFile(...)");
        Sdk sdk2 = PackageUtilsKt.getPythonSdk(psiFile2);
        if (sdk2 == null) {
            return;
        }
        Sdk sdk3 = sdk2;
        Intrinsics.checkNotNull((Object)packageName);
        Project project = parameters.getPosition().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        RequirementsCompletionUtilKt.completeVersions(packageName, project, sdk3, result2, addQuotes);
    }
}

