/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.tomcat.util.http.ConcurrentDateFormat;

public final class FastHttpDateFormat {
    private static final int CACHE_SIZE = Integer.getInteger("org.apache.tomcat.util.http.FastHttpDateFormat.CACHE_SIZE", 1000);
    @Deprecated
    public static final String RFC1123_DATE = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private static final String DATE_RFC5322 = "EEE, dd MMM yyyy HH:mm:ss z";
    private static final String DATE_OBSOLETE_RFC850 = "EEEEEE, dd-MMM-yy HH:mm:ss zzz";
    private static final String DATE_OBSOLETE_ASCTIME = "EEE MMMM d HH:mm:ss yyyy";
    private static final ConcurrentDateFormat FORMAT_RFC5322;
    private static final ConcurrentDateFormat FORMAT_OBSOLETE_RFC850;
    private static final ConcurrentDateFormat FORMAT_OBSOLETE_ASCTIME;
    private static final ConcurrentDateFormat[] httpParseFormats;
    private static volatile long currentDateGeneratedInSeconds;
    private static String currentDate;
    private static final ConcurrentHashMap<Long, String> formatCache;
    private static final Map<String, Long> parseCache;

    public static String getCurrentDate() {
        long l = System.currentTimeMillis() / 1000L;
        if (l != currentDateGeneratedInSeconds) {
            currentDate = FORMAT_RFC5322.format(new Date(l * 1000L));
            currentDateGeneratedInSeconds = l;
        }
        return currentDate;
    }

    @Deprecated
    public static String formatDate(long l, DateFormat dateFormat) {
        return FastHttpDateFormat.formatDate(l);
    }

    public static String formatDate(long l) {
        Long l2 = l;
        String string = formatCache.get(l2);
        if (string != null) {
            return string;
        }
        String string2 = FORMAT_RFC5322.format(new Date(l));
        FastHttpDateFormat.updateFormatCache(l2, string2);
        return string2;
    }

    @Deprecated
    public static long parseDate(String string, DateFormat[] dateFormatArray) {
        return FastHttpDateFormat.parseDate(string);
    }

    public static long parseDate(String string) {
        Long l = parseCache.get(string);
        if (l != null) {
            return l;
        }
        long l2 = -1L;
        for (int i = 0; l2 == -1L && i < httpParseFormats.length; ++i) {
            try {
                l2 = httpParseFormats[i].parse(string).getTime();
                FastHttpDateFormat.updateParseCache(string, l2);
                continue;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return l2;
    }

    private static void updateFormatCache(Long l, String string) {
        if (string == null) {
            return;
        }
        if (formatCache.size() > CACHE_SIZE) {
            formatCache.clear();
        }
        formatCache.put(l, string);
    }

    private static void updateParseCache(String string, Long l) {
        if (l == null) {
            return;
        }
        if (parseCache.size() > CACHE_SIZE) {
            parseCache.clear();
        }
        parseCache.put(string, l);
    }

    static {
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        FORMAT_RFC5322 = new ConcurrentDateFormat(DATE_RFC5322, Locale.US, timeZone);
        FORMAT_OBSOLETE_RFC850 = new ConcurrentDateFormat(DATE_OBSOLETE_RFC850, Locale.US, timeZone);
        FORMAT_OBSOLETE_ASCTIME = new ConcurrentDateFormat(DATE_OBSOLETE_ASCTIME, Locale.US, timeZone);
        httpParseFormats = new ConcurrentDateFormat[]{FORMAT_RFC5322, FORMAT_OBSOLETE_RFC850, FORMAT_OBSOLETE_ASCTIME};
        currentDateGeneratedInSeconds = 0L;
        currentDate = null;
        formatCache = new ConcurrentHashMap(CACHE_SIZE);
        parseCache = new ConcurrentHashMap<String, Long>(CACHE_SIZE);
    }
}

