# Print Debian packages providing given GStreamer decoders list.
# USAGE: dependencies_gstreamer_list_debian $dependencies_gstreamer
dependencies_gstreamer_list_debian() {
	local dependencies_gstreamer
	dependencies_gstreamer="$1"

	local dependency_gstreamer
	while read -r dependency_gstreamer; do
		dependencies_gstreamer_single_debian "$dependency_gstreamer"
	done <<- EOL
	$(printf '%s' "$dependencies_gstreamer")
	EOL
}

# Print Debian packages providing given single GStreamer decoder.
# USAGE: debian_dependency_providing_gstreamer_plugin $dependency_gstreamer
dependencies_gstreamer_single_debian() {
	local dependency_gstreamer
	dependency_gstreamer="$1"

	local package_names
	case "$dependency_gstreamer" in
		('audioconvert')
			package_names='
			gstreamer1.0-plugins-base'
		;;
		('avidemux')
			package_names='
			gstreamer1.0-plugins-good'
		;;
		('decodebin')
			package_names='
			gstreamer1.0-plugins-base'
		;;
		('deinterlace')
			package_names='
			gstreamer1.0-plugins-good'
		;;
		('application/x-id3')
			package_names='
			gstreamer1.0-plugins-good'
		;;
		('audio/mpeg, mpegversion=(int)1, layer=(int)3')
			package_names='
			gstreamer1.0-plugins-good'
		;;
		( \
			'audio/x-wma' | \
			'audio/x-wma, wmaversion=(int)1' \
		)
			package_names='
			gstreamer1.0-libav'
		;;
		('video/mpeg, systemstream=(boolean)true, mpegversion=(int)1')
			package_names='
			gstreamer1.0-plugins-ugly
			gstreamer1.0-plugins-bad'
		;;
		('video/quicktime, variant=(string)iso')
			package_names='
			gstreamer1.0-plugins-good
			gstreamer1.0-libav'
		;;
		('video/x-ms-asf')
			package_names='
			gstreamer1.0-plugins-ugly
			gstreamer1.0-libav'
		;;
		('video/x-msvideo')
			package_names='
			gstreamer1.0-plugins-good
			gstreamer1.0-libav'
		;;
		( \
			'video/x-wmv' | \
			'video/x-wmv, wmvversion=(int)1' \
		)
			package_names='
			gstreamer1.0-libav'
		;;
		(*)
			dependencies_unknown_gstreamer_media_formats_add "$dependency_gstreamer"
			return 0
		;;
	esac

	printf '%s\n' "$package_names"
}

