[TODO]

Do not use `sudo` if you cannot properly configure it.

**Notice:** This wiki is not complete yet.

Using `sudo` is not recommended. If not properly configured to not ask for password it may cause permission issues when running commands from the cronjob (like renew), resulting in some or all of your certificates not being renewed and eventually will expire.


If you need root,  please `su` to root first, and then install acme.sh and use it.

```sh

#uninstall for current user
acme.sh --uninstall

#change to root
sudo su

#install again for root user
curl https://get.acme.sh | sh -s email=my@example.com

#use it
bash
acme.sh --issue -d .....

```


Now, if you are completely sure of the issues and the possibilities with the usage of `sudo` and still want to use it, you can pass the `--force` parameter to work with sudo.

# Process
YMMV based on Linux distribution and method of installing acme.sh

## create non-root account
For this example, we use "acme" but you can use whatever you'd like.
```
sudo useradd -d  /etc/acme-sh/ -s /sbin/nologin -c "acme-sh service account" acme
sudo chown acme:mail /etc/acme-sh/
```

## define crontab for non-root account
```
sudo su - -s /bin/bash acme
crontab -e
```

Adjust path to your acme.sh installation script, insert into your non-root crontab
```
12 0 * * * /usr/share/acme.sh/acme.sh --cron --home "/etc/acme-sh" > /dev/null
```

## Webserver issue method
When using the webserver method, you need to define the directories acme.sh writes to and adjust ownership to our non-root account. While monitoring the issue event logs, you might observer additional file structure permission errors when ran as non-root. From our experiences, those can be ignored as the script does not hard fail as the important directories and files creation is functional. Maybe this is where the --force should be used?
```
sudo mkdir -p /var/www/EXAMPLE.COM/htdocs/.well-known/acme-challenge
sudo chown acme:acme /var/www/EXAMPLE.com/htdocs/.well-known/acme-challenge
```

## nginx config
You probably already have a web daemon configuration file for your application. If you are running a mail server, you need a basic http port 80 server for acme.sh

```
sudo $EDITOR /etc/nginx/conf.d/example.com.conf 
```

```
server {
    listen [::]:80;
    listen 80;
    server_name EXAMPLE.COM;

    access_log /var/log/nginx/EXAMPLE.COM.access_log main;
    error_log /var/log/nginx/EXAMPLE.COM.error_log info;

    root /var/www/EXAMPLE.COM/htdocs;
}
```

## Register and Issue
There are more detailed instructions within the documentation and wiki for this process. This is a brief example.

```
acme.sh --register-account -m admin@example.com
acme.sh --debug --issue -d mail.example.com -d foo.example.com -d -d bar.example.com -w /var/www/EXAMPLE.COM/htdocs
```

## visudo
This grants our non-root service account super user rights to restart services during certificate renewals.
```
sudo visudo
````

Insert this line, adjust to your deployment use-cases and sudo version
```
acme ALL=(ALL:ALL) NOPASSWD: /etc/init.d/postfix restart, /etc/init.d/dovecot restart
```

## Install
Create a new directory which our non-root account can write certificates into.

```
sudo mkdir /etc/ssl/acme
sudo chown acme:acme /etc/ssl/acme
```

These restart commands should match what you defined in visudo above
```
acme.sh --installcert -d mail.example.com --keypath  /etc/ssl/acme/example.com.key --capath /etc/ssl/acme/example.com.ca --fullchainpath /etc/ssl/acme/example.com.crt --reloadcmd  "sudo /etc/init.d/postfix restart && sudo /etc/init.d/dovecot restart"
```

## cleanup (optional)
Your distro might place a global bashrc script. This is not needed.

```
sudo rm /etc/bash/bashrc.d/acme.sh
```
