#ifndef AVIFILE_READSTREAM_H
#define AVIFILE_READSTREAM_H

#include "ReadHandlers.h"

AVM_BEGIN_NAMESPACE;

class AviReadFile;

class ReadStream : public IReadStream
{
    friend class AviReadFile;
public:
    ReadStream(IMediaReadStream* stream);
    virtual ~ReadStream();
    virtual size_t GetBuffering(size_t*) const { return 0; }
    virtual StreamType GetType() const;
    virtual size_t GetHeader(void* pheader = 0, size_t size = 0) const;
    virtual size_t GetAudioFormat(void* format = 0, size_t size = 0) const;
    virtual size_t GetVideoFormat(void* format = 0, size_t size = 0) const;
    virtual IAudioDecoder* GetAudioDecoder() const;
    virtual IVideoDecoder* GetVideoDecoder() const;
    //Size of stream and one frame
    virtual framepos_t GetLength() const;
    virtual double GetLengthTime() const;
    virtual int GetFrameFlags(int* flags) const;
    virtual double GetFrameTime() const;
    virtual framepos_t GetPos() const;
    virtual StreamInfo* GetStreamInfo() const;
    virtual double GetTime(framepos_t frame = ERR) const;
    //Positioning in stream
    virtual int Seek(framepos_t pos);
    virtual int SeekTime(double pos);
    virtual framepos_t SeekToKeyFrame(framepos_t pos);
    virtual double SeekTimeToKeyFrame(double pos);
    virtual int SkipFrame();
    virtual int SkipTo(double pos);

    //Reading decompressed data
    virtual int SetDirection(bool d) { return -1; }
    virtual int SetBuffering(size_t maxsz = 1, IImageAllocator* ia = 0) { return -1; }
    virtual int SetOutputFormat(void* bi, size_t size);
    virtual int ReadFrame(bool render = true);
    virtual CImage* GetFrame(bool readframe = false);
    virtual size_t GetFrameSize() const;

    virtual int ReadFrames(void* buffer, size_t bufsize, size_t samples,
			   size_t& samples_read, size_t& bytes_read);
    virtual int ReadDirect(void* buffer, size_t bufsize, size_t samples,
			   size_t& samples_read, size_t& bytes_read,
			   int* flags = 0);

    virtual framepos_t GetNextKeyFrame(framepos_t frame = ERR) const;
    virtual framepos_t GetPrevKeyFrame(framepos_t frame = ERR) const;

    virtual framepos_t SeekToNextKeyFrame();
    virtual framepos_t SeekToPrevKeyFrame();

    virtual bool Eof() const;

    virtual double CacheSize() const { return m_pStream->CacheSize(); }

protected:
    StreamPacket* ReadPacket();
    virtual void Flush();

    static const size_t PADDING = 128;  // padding after local buffer for decommpress

    IMediaReadStream* m_pStream;
    StreamPacket* m_pPacket;
    union {
	char* m_pFormat;
	WAVEFORMATEX* m_WF;
	MPEGLAYER3WAVEFORMAT* m_MP3WF;
    };
    size_t m_uiFormatSize;
    int m_iEof;
    avm::vector<uint8_t> rem_buffer;
    size_t rem_size;
    size_t rem_local;
    size_t rem_limit;
    int rem_flags;
    framepos_t m_uiLastPos;
    double m_dLastTime;
};

AVM_END_NAMESPACE;

#endif  // AVIPLAY_READSTREAM_H
