/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.binpack;

import com.kreative.binpack.BitInputStream;
import com.kreative.binpack.BitOutputStream;
import com.kreative.binpack.DFExpression;
import java.util.Map;

public class DFTernaryExpression
implements DFExpression {
    private Operation op;
    private DFExpression det;
    private DFExpression left;
    private DFExpression right;

    public DFTernaryExpression(Operation op, DFExpression det, DFExpression left, DFExpression right) {
        this.op = op;
        this.det = det;
        this.left = left;
        this.right = right;
    }

    @Override
    public int evaluate() {
        int dv = this.det.evaluate();
        switch (this.op) {
            case CONDITIONAL: {
                return dv != 0 ? this.left.evaluate() : this.right.evaluate();
            }
            case BETWEEN_INCLUSIVE: {
                return this.left.evaluate() <= dv && dv <= this.right.evaluate() ? 1 : 0;
            }
            case BETWEEN_LEFT_INCLUSIVE: {
                return this.left.evaluate() <= dv && dv < this.right.evaluate() ? 1 : 0;
            }
            case BETWEEN_RIGHT_INCLUSIVE: {
                return this.left.evaluate() < dv && dv <= this.right.evaluate() ? 1 : 0;
            }
            case BETWEEN_EXCLUSIVE: {
                return this.left.evaluate() < dv && dv < this.right.evaluate() ? 1 : 0;
            }
            case NOT_BETWEEN_INCLUSIVE: {
                return this.left.evaluate() <= dv && dv <= this.right.evaluate() ? 0 : 1;
            }
            case NOT_BETWEEN_LEFT_INCLUSIVE: {
                return this.left.evaluate() <= dv && dv < this.right.evaluate() ? 0 : 1;
            }
            case NOT_BETWEEN_RIGHT_INCLUSIVE: {
                return this.left.evaluate() < dv && dv <= this.right.evaluate() ? 0 : 1;
            }
            case NOT_BETWEEN_EXCLUSIVE: {
                return this.left.evaluate() < dv && dv < this.right.evaluate() ? 0 : 1;
            }
        }
        return 0;
    }

    @Override
    public int evaluate(Map<?, ?> fieldValues, BitInputStream in, long length) {
        int dv = this.det.evaluate(fieldValues, in, length);
        switch (this.op) {
            case CONDITIONAL: {
                return dv != 0 ? this.left.evaluate(fieldValues, in, length) : this.right.evaluate(fieldValues, in, length);
            }
            case BETWEEN_INCLUSIVE: {
                return this.left.evaluate(fieldValues, in, length) <= dv && dv <= this.right.evaluate(fieldValues, in, length) ? 1 : 0;
            }
            case BETWEEN_LEFT_INCLUSIVE: {
                return this.left.evaluate(fieldValues, in, length) <= dv && dv < this.right.evaluate(fieldValues, in, length) ? 1 : 0;
            }
            case BETWEEN_RIGHT_INCLUSIVE: {
                return this.left.evaluate(fieldValues, in, length) < dv && dv <= this.right.evaluate(fieldValues, in, length) ? 1 : 0;
            }
            case BETWEEN_EXCLUSIVE: {
                return this.left.evaluate(fieldValues, in, length) < dv && dv < this.right.evaluate(fieldValues, in, length) ? 1 : 0;
            }
            case NOT_BETWEEN_INCLUSIVE: {
                return this.left.evaluate(fieldValues, in, length) <= dv && dv <= this.right.evaluate(fieldValues, in, length) ? 0 : 1;
            }
            case NOT_BETWEEN_LEFT_INCLUSIVE: {
                return this.left.evaluate(fieldValues, in, length) <= dv && dv < this.right.evaluate(fieldValues, in, length) ? 0 : 1;
            }
            case NOT_BETWEEN_RIGHT_INCLUSIVE: {
                return this.left.evaluate(fieldValues, in, length) < dv && dv <= this.right.evaluate(fieldValues, in, length) ? 0 : 1;
            }
            case NOT_BETWEEN_EXCLUSIVE: {
                return this.left.evaluate(fieldValues, in, length) < dv && dv < this.right.evaluate(fieldValues, in, length) ? 0 : 1;
            }
        }
        return 0;
    }

    @Override
    public int evaluate(Map<?, ?> fieldValues, BitOutputStream out) {
        int dv = this.det.evaluate(fieldValues, out);
        switch (this.op) {
            case CONDITIONAL: {
                return dv != 0 ? this.left.evaluate(fieldValues, out) : this.right.evaluate(fieldValues, out);
            }
            case BETWEEN_INCLUSIVE: {
                return this.left.evaluate(fieldValues, out) <= dv && dv <= this.right.evaluate(fieldValues, out) ? 1 : 0;
            }
            case BETWEEN_LEFT_INCLUSIVE: {
                return this.left.evaluate(fieldValues, out) <= dv && dv < this.right.evaluate(fieldValues, out) ? 1 : 0;
            }
            case BETWEEN_RIGHT_INCLUSIVE: {
                return this.left.evaluate(fieldValues, out) < dv && dv <= this.right.evaluate(fieldValues, out) ? 1 : 0;
            }
            case BETWEEN_EXCLUSIVE: {
                return this.left.evaluate(fieldValues, out) < dv && dv < this.right.evaluate(fieldValues, out) ? 1 : 0;
            }
            case NOT_BETWEEN_INCLUSIVE: {
                return this.left.evaluate(fieldValues, out) <= dv && dv <= this.right.evaluate(fieldValues, out) ? 0 : 1;
            }
            case NOT_BETWEEN_LEFT_INCLUSIVE: {
                return this.left.evaluate(fieldValues, out) <= dv && dv < this.right.evaluate(fieldValues, out) ? 0 : 1;
            }
            case NOT_BETWEEN_RIGHT_INCLUSIVE: {
                return this.left.evaluate(fieldValues, out) < dv && dv <= this.right.evaluate(fieldValues, out) ? 0 : 1;
            }
            case NOT_BETWEEN_EXCLUSIVE: {
                return this.left.evaluate(fieldValues, out) < dv && dv < this.right.evaluate(fieldValues, out) ? 0 : 1;
            }
        }
        return 0;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("(");
        s.append(this.det.toString());
        switch (this.op) {
            case CONDITIONAL: {
                s.append("?");
                break;
            }
            default: {
                s.append("<" + this.op.name().toLowerCase() + ">");
            }
        }
        s.append(this.left.toString());
        s.append(":");
        s.append(this.right.toString());
        s.append(")");
        return s.toString();
    }

    public static enum Operation {
        CONDITIONAL,
        BETWEEN_INCLUSIVE,
        BETWEEN_LEFT_INCLUSIVE,
        BETWEEN_RIGHT_INCLUSIVE,
        BETWEEN_EXCLUSIVE,
        NOT_BETWEEN_INCLUSIVE,
        NOT_BETWEEN_LEFT_INCLUSIVE,
        NOT_BETWEEN_RIGHT_INCLUSIVE,
        NOT_BETWEEN_EXCLUSIVE;

    }
}

