/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.rsrc;

import com.kreative.ksfl.KSFLUtilities;
import com.kreative.rsrc.MacResource;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.io.UnsupportedEncodingException;

public class FontResource
extends MacResource {
    public static final int RESOURCE_TYPE = 1313230420;
    public static final int RESOURCE_TYPE_OLD = 1179602516;
    public static final short FLAG_HAS_IMAGE_HEIGHT_TABLE = 1;
    public static final short FLAG_HAS_GLYPH_WIDTH_TABLE = 2;
    public static final short FLAG_BIT_DEPTH = 12;
    public static final short FLAG_BIT_DEPTH_1BIT = 0;
    public static final short FLAG_BIT_DEPTH_2BIT = 4;
    public static final short FLAG_BIT_DEPTH_4BIT = 8;
    public static final short FLAG_BIT_DEPTH_8BIT = 12;
    public static final short FLAG_HAS_FONT_COLOR_TABLE = 128;
    public static final short FLAG_IS_SYNTHETIC = 256;
    public static final short FLAG_HAS_COLOR = 512;
    public static final short FLAG_RESERVED_SET_BIT = 4096;
    public static final short FLAG_FIXED_WIDTH = 8192;
    public static final short FLAG_DONT_MAKE_SYNTHETIC = 16384;

    public static boolean isMyType(int type) {
        return type == 1313230420 || type == 1179602516;
    }

    public FontResource(short id, byte[] data) {
        super(1313230420, id, data);
    }

    public FontResource(short id, String name, byte[] data) {
        super(1313230420, id, name, data);
    }

    public FontResource(short id, byte attr, byte[] data) {
        super(1313230420, id, attr, data);
    }

    public FontResource(short id, byte attr, String name, byte[] data) {
        super(1313230420, id, attr, name, data);
    }

    public FontResource(int type, short id, byte[] data) {
        super(type, id, data);
    }

    public FontResource(int type, short id, String name, byte[] data) {
        super(type, id, name, data);
    }

    public FontResource(int type, short id, byte attr, byte[] data) {
        super(type, id, attr, data);
    }

    public FontResource(int type, short id, byte attr, String name, byte[] data) {
        super(type, id, attr, name, data);
    }

    public short getFlags() {
        return KSFLUtilities.getShort(this.data, 0);
    }

    public char getFirstChar() {
        return (char)KSFLUtilities.getShort(this.data, 2);
    }

    public char getLastChar() {
        return (char)KSFLUtilities.getShort(this.data, 4);
    }

    public short getMaxCharWidth() {
        return KSFLUtilities.getShort(this.data, 6);
    }

    public short getKerning() {
        return KSFLUtilities.getShort(this.data, 8);
    }

    public short getNDescent() {
        return KSFLUtilities.getShort(this.data, 10);
    }

    public short getRectWidth() {
        return KSFLUtilities.getShort(this.data, 12);
    }

    public short getHeight() {
        return KSFLUtilities.getShort(this.data, 14);
    }

    public short getRawOffsetToWidthOffsetTable() {
        return KSFLUtilities.getShort(this.data, 16);
    }

    public int getOffsetToWidthOffsetTable() {
        return KSFLUtilities.getShort(this.data, 16) * 2 + 16;
    }

    public short getAscent() {
        return KSFLUtilities.getShort(this.data, 18);
    }

    public short getDescent() {
        return KSFLUtilities.getShort(this.data, 20);
    }

    public short getLeading() {
        return KSFLUtilities.getShort(this.data, 22);
    }

    public short getRowBytes() {
        return KSFLUtilities.getShort(this.data, 24);
    }

    public int getBitmapOffset() {
        return 26;
    }

    public int getBitmapLength() {
        return KSFLUtilities.getShort(this.data, 14) * (KSFLUtilities.getShort(this.data, 24) * 2);
    }

    public int getBitmapHeight() {
        return KSFLUtilities.getShort(this.data, 14);
    }

    public int getBitmapWidth() {
        return KSFLUtilities.getShort(this.data, 24) * 16;
    }

    public byte[] getBitmap() {
        return KSFLUtilities.copy(this.data, 26, KSFLUtilities.getShort(this.data, 14) * (KSFLUtilities.getShort(this.data, 24) * 2));
    }

    public Image getBitmapImage() {
        return Toolkit.getDefaultToolkit().createImage(new BitmapImageSource(this.getBitmapWidth(), this.getBitmapHeight(), this.getBitmap(), 0, this.getRowBytes() * 2));
    }

    public Image getBitmapImage(Color bgColor, Color fgColor) {
        return Toolkit.getDefaultToolkit().createImage(new BitmapImageSource(this.getBitmapWidth(), this.getBitmapHeight(), this.getBitmap(), 0, this.getRowBytes() * 2, bgColor, fgColor));
    }

    public int getBOTOffset() {
        return this.getBitmapOffset() + this.getBitmapLength();
    }

    public int getBOTLength() {
        return (KSFLUtilities.getShort(this.data, 4) - KSFLUtilities.getShort(this.data, 2) + 3) * 2;
    }

    public int getWOTOffset() {
        return this.getBOTOffset() + this.getBOTLength();
    }

    public int getWOTLength() {
        return (KSFLUtilities.getShort(this.data, 4) - KSFLUtilities.getShort(this.data, 2) + 2) * 2;
    }

    public int getGWTOffset() {
        return this.getWOTOffset() + this.getWOTLength();
    }

    public int getGWTLength() {
        return (KSFLUtilities.getShort(this.data, 0) & 2) != 0 ? (KSFLUtilities.getShort(this.data, 4) - KSFLUtilities.getShort(this.data, 2) + 2) * 2 : 0;
    }

    public int charValueToIndex(int ch) {
        char fc = this.getFirstChar();
        char lc = this.getLastChar();
        int b = this.getWOTOffset();
        int offset = this.data[b + (ch - fc) * 2] & 0xFF;
        int width = this.data[b + (ch - fc) * 2 + 1] & 0xFF;
        if (ch < fc || ch > lc || width < 0 || offset < 0) {
            return lc + '\u0001' - fc;
        }
        return ch - fc;
    }

    public int indexToCharValue(int idx) {
        return this.getFirstChar() + idx;
    }

    public FontInfo getInfo() {
        return new FontInfo();
    }

    private static class BitmapImageSource
    extends MemoryImageSource {
        private static int[] makePixels(byte[] bmp, int bgColor, int fgColor) {
            int[] pix = new int[bmp.length * 8];
            int s = 0;
            int d = 0;
            while (s < bmp.length && d < pix.length) {
                int k = 0;
                int b = bmp[s] & 0xFF;
                while (k < 8) {
                    pix[d + k] = (b & 0x80) != 0 ? fgColor : bgColor;
                    ++k;
                    b <<= 1;
                }
                ++s;
                d += 8;
            }
            return pix;
        }

        public BitmapImageSource(int w, int h, byte[] bmp, int off, int scan) {
            super(w, h, BitmapImageSource.makePixels(bmp, -1, -16777216), off * 8, scan * 8);
        }

        public BitmapImageSource(int w, int h, byte[] bmp, int off, int scan, int bgColor, int fgColor) {
            super(w, h, BitmapImageSource.makePixels(bmp, bgColor, fgColor), off * 8, scan * 8);
        }

        public BitmapImageSource(int w, int h, byte[] bmp, int off, int scan, Color bgColor, Color fgColor) {
            super(w, h, BitmapImageSource.makePixels(bmp, bgColor.getRGB(), fgColor.getRGB()), off * 8, scan * 8);
        }
    }

    public class FontInfo {
        public short flags;
        public char firstChar;
        public char lastChar;
        public short maxCharWidth;
        public short kerning;
        public short nDescent;
        public short rectWidth;
        public short height;
        public short rawOffsetToWidthOffsetTable;
        public short ascent;
        public short descent;
        public short leading;
        public short rowBytes;
        public byte[] bitmap;
        public Image bitmapImg;
        public int[] bitmapLoc;
        public int[] offset;
        public int[] width;
        public float[] widthx;

        public FontInfo() {
            this.flags = KSFLUtilities.getShort(FontResource.this.data, 0);
            this.firstChar = (char)KSFLUtilities.getShort(FontResource.this.data, 2);
            this.lastChar = (char)KSFLUtilities.getShort(FontResource.this.data, 4);
            this.maxCharWidth = KSFLUtilities.getShort(FontResource.this.data, 6);
            this.kerning = KSFLUtilities.getShort(FontResource.this.data, 8);
            this.nDescent = KSFLUtilities.getShort(FontResource.this.data, 10);
            this.rectWidth = KSFLUtilities.getShort(FontResource.this.data, 12);
            this.height = KSFLUtilities.getShort(FontResource.this.data, 14);
            this.rawOffsetToWidthOffsetTable = KSFLUtilities.getShort(FontResource.this.data, 16);
            this.ascent = KSFLUtilities.getShort(FontResource.this.data, 18);
            this.descent = KSFLUtilities.getShort(FontResource.this.data, 20);
            this.leading = KSFLUtilities.getShort(FontResource.this.data, 22);
            this.rowBytes = KSFLUtilities.getShort(FontResource.this.data, 24);
            int p = 26;
            this.bitmap = KSFLUtilities.copy(FontResource.this.data, p, this.height * this.rowBytes * 2);
            p += this.height * this.rowBytes * 2;
            this.bitmapImg = Toolkit.getDefaultToolkit().createImage(new BitmapImageSource(this.rowBytes * 16, (int)this.height, this.bitmap, 0, this.rowBytes * 2));
            this.bitmapLoc = new int[this.lastChar - this.firstChar + 3];
            int i = 0;
            while (i < this.bitmapLoc.length) {
                this.bitmapLoc[i] = KSFLUtilities.getShort(FontResource.this.data, p) & 0xFFFF;
                p += 2;
                ++i;
            }
            this.offset = new int[this.lastChar - this.firstChar + 2];
            this.width = new int[this.lastChar - this.firstChar + 2];
            i = 0;
            while (i < this.offset.length && i < this.width.length) {
                this.offset[i] = FontResource.this.data[p] == -1 ? -1 : FontResource.this.data[p] & 0xFF;
                this.width[i] = FontResource.this.data[++p] == -1 ? -1 : FontResource.this.data[p] & 0xFF;
                ++p;
                ++i;
            }
            if ((this.flags & 2) != 0) {
                this.widthx = new float[this.lastChar - this.firstChar + 2];
                i = 0;
                while (i < this.widthx.length) {
                    this.widthx[i] = (float)(KSFLUtilities.getShort(FontResource.this.data, p) & 0xFFFF) / 256.0f;
                    p += 2;
                    ++i;
                }
            } else {
                this.widthx = null;
            }
        }

        public Image getBitmapImage() {
            return Toolkit.getDefaultToolkit().createImage(new BitmapImageSource(this.rowBytes * 16, (int)this.height, this.bitmap, 0, this.rowBytes * 2, -1, -16777216));
        }

        public Image getBitmapImage(Graphics g) {
            return Toolkit.getDefaultToolkit().createImage(new BitmapImageSource(this.rowBytes * 16, (int)this.height, this.bitmap, 0, this.rowBytes * 2, 0, g.getColor().getRGB()));
        }

        public Image getBitmapImage(int bgColor, int fgColor) {
            return Toolkit.getDefaultToolkit().createImage(new BitmapImageSource(this.rowBytes * 16, (int)this.height, this.bitmap, 0, this.rowBytes * 2, bgColor, fgColor));
        }

        public Image getBitmapImage(Color bgColor, Color fgColor) {
            return Toolkit.getDefaultToolkit().createImage(new BitmapImageSource(this.rowBytes * 16, (int)this.height, this.bitmap, 0, this.rowBytes * 2, bgColor, fgColor));
        }

        public int charValueToIndex(int ch) {
            if (ch < this.firstChar || ch > this.lastChar || this.width[ch - this.firstChar] < 0 || this.offset[ch - this.firstChar] < 0) {
                return this.lastChar + '\u0001' - this.firstChar;
            }
            return ch - this.firstChar;
        }

        public int indexToCharValue(int idx) {
            return this.firstChar + idx;
        }

        public int drawCharacter(Graphics g, int x, int y, int ch) {
            return this.drawCharacter(g, x, y, ch, this.getBitmapImage(g));
        }

        public int drawCharacter(Graphics g, int x, int y, int ch, int bg, int fg) {
            return this.drawCharacter(g, x, y, ch, this.getBitmapImage(bg, fg));
        }

        public int drawCharacter(Graphics g, int x, int y, int ch, Color bg, Color fg) {
            return this.drawCharacter(g, x, y, ch, this.getBitmapImage(bg, fg));
        }

        private int drawCharacter(Graphics g, int x, int y, int ch, Image bmp) {
            ch = this.charValueToIndex(ch);
            int off = this.offset[ch];
            int wid = this.width[ch];
            int bx1 = this.bitmapLoc[ch];
            int bx2 = this.bitmapLoc[ch + 1];
            g.drawImage(bmp, x + off + this.kerning, y - this.ascent, x + off + this.kerning + (bx2 - bx1), y - this.ascent + this.height, bx1, 0, bx2, this.height, null);
            return wid;
        }

        public void drawAlphabet(Graphics g, int x, int y, int w) {
            this.drawAlphabet(g, x, y, w, this.getBitmapImage(g));
        }

        public void drawAlphabet(Graphics g, int x, int y, int w, int bg, int fg) {
            this.drawAlphabet(g, x, y, w, this.getBitmapImage(bg, fg));
        }

        public void drawAlphabet(Graphics g, int x, int y, int w, Color bg, Color fg) {
            this.drawAlphabet(g, x, y, w, this.getBitmapImage(bg, fg));
        }

        private void drawAlphabet(Graphics g, int x, int y, int w, Image bmp) {
            int cx = x;
            int cy = y;
            int i = 0;
            while (i <= this.lastChar - this.firstChar + 1) {
                if (this.offset[i] >= 0 && this.width[i] >= 0) {
                    int off = this.offset[i];
                    int wid = this.width[i];
                    int bx1 = this.bitmapLoc[i];
                    int bx2 = this.bitmapLoc[i + 1];
                    if (cx + wid >= w) {
                        cx = x;
                        cy += this.ascent + this.descent + this.leading;
                    }
                    g.drawImage(bmp, cx + off + this.kerning, cy - this.ascent, cx + off + this.kerning + (bx2 - bx1), cy - this.ascent + this.height, bx1, 0, bx2, this.height, null);
                    cx += wid;
                }
                ++i;
            }
        }

        public int getStringWidth(String s, String te) {
            byte[] b;
            int w = 0;
            try {
                b = s.getBytes(te);
            }
            catch (UnsupportedEncodingException uee) {
                b = s.getBytes();
            }
            byte[] byArray = b;
            int n = b.length;
            int n2 = 0;
            while (n2 < n) {
                int ch = byArray[n2];
                switch (ch &= 0xFF) {
                    case 9: {
                        w -= w % 36;
                        w += 36;
                        break;
                    }
                    default: {
                        ch = this.charValueToIndex(ch);
                        w += this.width[ch];
                    }
                }
                ++n2;
            }
            return w;
        }

        public int getStringHeight(String s, String te, int w) {
            byte[] b;
            int cx = 0;
            int h = this.ascent + this.descent + this.leading;
            try {
                b = s.getBytes(te);
            }
            catch (UnsupportedEncodingException uee) {
                b = s.getBytes();
            }
            byte[] byArray = b;
            int n = b.length;
            int n2 = 0;
            while (n2 < n) {
                int ch = byArray[n2];
                switch (ch &= 0xFF) {
                    case 9: {
                        cx -= cx % 36;
                        cx += 36;
                        break;
                    }
                    case 10: 
                    case 13: {
                        cx = 0;
                        h += this.ascent + this.descent + this.leading;
                        break;
                    }
                    default: {
                        ch = this.charValueToIndex(ch);
                        int wid = this.width[ch];
                        if (cx + wid >= w) {
                            cx = 0;
                            h += this.ascent + this.descent + this.leading;
                        }
                        cx += wid;
                    }
                }
                ++n2;
            }
            return h;
        }

        public void drawString(Graphics g, int x, int y, String s, String te, int w) {
            this.drawString(g, x, y, s, te, w, this.getBitmapImage(g));
        }

        public void drawString(Graphics g, int x, int y, String s, String te, int w, int bg, int fg) {
            this.drawString(g, x, y, s, te, w, this.getBitmapImage(bg, fg));
        }

        public void drawString(Graphics g, int x, int y, String s, String te, int w, Color bg, Color fg) {
            this.drawString(g, x, y, s, te, w, this.getBitmapImage(bg, fg));
        }

        private void drawString(Graphics g, int x, int y, String s, String te, int w, Image bmp) {
            byte[] b;
            int cx = x;
            int cy = y;
            try {
                b = s.getBytes(te);
            }
            catch (UnsupportedEncodingException uee) {
                b = s.getBytes();
            }
            byte[] byArray = b;
            int n = b.length;
            int n2 = 0;
            while (n2 < n) {
                int ch = byArray[n2];
                switch (ch &= 0xFF) {
                    case 9: {
                        cx -= (cx - x) % 36;
                        cx += 36;
                        break;
                    }
                    case 10: 
                    case 13: {
                        cx = x;
                        cy += this.ascent + this.descent + this.leading;
                        break;
                    }
                    default: {
                        ch = this.charValueToIndex(ch);
                        int off = this.offset[ch];
                        int wid = this.width[ch];
                        int bx1 = this.bitmapLoc[ch];
                        int bx2 = this.bitmapLoc[ch + 1];
                        if (cx + wid >= w) {
                            cx = x;
                            cy += this.ascent + this.descent + this.leading;
                        }
                        g.drawImage(bmp, cx + off + this.kerning, cy - this.ascent, cx + off + this.kerning + (bx2 - bx1), cy - this.ascent + this.height, bx1, 0, bx2, this.height, null);
                        cx += wid;
                    }
                }
                ++n2;
            }
        }
    }
}

