/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.rsrc;

import com.kreative.ksfl.KSFLUtilities;
import com.kreative.rsrc.MacResource;
import com.kreative.rsrc.pict.PICTGraphics;
import com.kreative.rsrc.pict.PICTInputStream;
import com.kreative.rsrc.pict.PICTInstruction;
import com.kreative.rsrc.pict.Rect;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class PictureResource
extends MacResource {
    public static final int RESOURCE_TYPE = 1346978644;

    public static boolean isMyType(int type) {
        return type == 1346978644;
    }

    public PictureResource(short id, byte[] data) {
        super(1346978644, id, data);
    }

    public PictureResource(short id, String name, byte[] data) {
        super(1346978644, id, name, data);
    }

    public PictureResource(short id, byte attr, byte[] data) {
        super(1346978644, id, attr, data);
    }

    public PictureResource(short id, byte attr, String name, byte[] data) {
        super(1346978644, id, attr, name, data);
    }

    public PictureResource(int type, short id, byte[] data) {
        super(type, id, data);
    }

    public PictureResource(int type, short id, String name, byte[] data) {
        super(type, id, name, data);
    }

    public PictureResource(int type, short id, byte attr, byte[] data) {
        super(type, id, attr, data);
    }

    public PictureResource(int type, short id, byte attr, String name, byte[] data) {
        super(type, id, attr, name, data);
    }

    public Rectangle getBoundingRect() {
        return KSFLUtilities.getRect(this.data, 2);
    }

    public PICTInputStream getPICTInputStream() {
        return new PICTInputStream(new ByteArrayInputStream(this.data));
    }

    public boolean draw(Graphics2D g, int x, int y) {
        try {
            PICTInstruction inst;
            PICTInputStream in = new PICTInputStream(new ByteArrayInputStream(this.data));
            in.readUnsignedShort();
            Rect bounds = in.readRect();
            AffineTransform tx = g.getTransform();
            g.translate(-bounds.left + x, -bounds.top + y);
            PICTGraphics pg = new PICTGraphics(g);
            do {
                inst = in.readInstruction();
                pg.executeInstruction(inst);
            } while (!(inst instanceof PICTInstruction.OpEndPic));
            g.setTransform(tx);
            return true;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public Image toImage() {
        try {
            PICTInstruction inst;
            PICTInputStream in = new PICTInputStream(new ByteArrayInputStream(this.data));
            in.readUnsignedShort();
            Rect bounds = in.readRect();
            BufferedImage bi = new BufferedImage(bounds.right - bounds.left, bounds.bottom - bounds.top, 2);
            Graphics2D bg = bi.createGraphics();
            bg.translate(-bounds.left, -bounds.top);
            PICTGraphics pg = new PICTGraphics(bg);
            do {
                inst = in.readInstruction();
                pg.executeInstruction(inst);
            } while (!(inst instanceof PICTInstruction.OpEndPic));
            bg.dispose();
            return bi;
        }
        catch (IOException ioe) {
            return null;
        }
    }
}

