//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/coregui/Models/GUIExamplesFactory.h
//! @brief     Defines class GUIExamplesFactory
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_COREGUI_MODELS_GUIEXAMPLESFACTORY_H
#define BORNAGAIN_GUI_COREGUI_MODELS_GUIEXAMPLESFACTORY_H

#include <QMap>

class SessionItem;
class SampleModel;
class MaterialModel;

//! Class that generates GUI model from
class GUIExamplesFactory {
public:
    static bool isValidExampleName(const QString& name);

    static SessionItem* createSampleItems(const QString& name, SampleModel* sampleModel,
                                          MaterialModel* materialModel);

private:
    static QMap<QString, QString> m_name_to_registry;
    //!< correspondence of GUI example name and name from StandardSamples registry
};

#endif // BORNAGAIN_GUI_COREGUI_MODELS_GUIEXAMPLESFACTORY_H
